### Files, includes and libraries ###
SERVER_OBJS=server.o listener.o sscl_dim.o sscl_lit.o sscl_wsh.o sscl_prj.o litServerLib.o wshServerLib.o prjServerLib.o litClientLib.o fileio.o
CLIENT_OBJS=client.o listener.o litClientLib.o wshClientLib.o wshHandlerLib.o litHandlerLib.o prjClientLib.o fileio.o ProjectorClient.o LightingClient.o WasherClient.o
MANAGER_OBJS=manager.o fileio.o

CUSTOM_OUTPUT_FILES+=server$(EXE_EXT) client$(EXE_EXT) manager$(EXE_EXT)

all: prerequisites server$(EXE_EXT) client$(EXE_EXT) manager$(EXE_EXT)

server$(EXE_EXT): $(SERVER_OBJS) $(STATIC_DEPS) $(SHARED_DEPS)
		$(CC) $(CMFLAGS) -o server$(EXE_EXT) $(SERVER_OBJS) $(LDFLAGS) $(LIBS)

client$(EXE_EXT): $(CLIENT_OBJS) $(STATIC_DEPS) $(SHARED_DEPS)
		$(CC) $(CMFLAGS) -o client$(EXE_EXT) $(CLIENT_OBJS) $(LDFLAGS) $(LIBS)

manager$(EXE_EXT): $(MANAGER_OBJS) $(STATIC_DEPS) $(SHARED_DEPS)
		$(CC) $(CMFLAGS) -o manager$(EXE_EXT) $(MANAGER_OBJS) $(LDFLAGS) $(LIBS)

litStub.h litServerLib.c litClientLib.c lit.nsmap: Lighting.gsoap $(SOAPCPP)
		$(SOAPCPP) $(SOAPCPP_FLAGS) -2ucn -plit Lighting.gsoap

wshStub.h wshServerLib.c wshClientLib.c wsh.nsmap: WashingMachine.gsoap $(SOAPCPP)
		$(SOAPCPP) $(SOAPCPP_FLAGS) -2ucn -pwsh WashingMachine.gsoap

prjStub.h prjServerLib.c prjClientLib.c prj.nsmap: Projector.gsoap $(SOAPCPP)
		$(SOAPCPP) $(SOAPCPP_FLAGS) -2ucn -pprj Projector.gsoap
