/*============================================================================*\
|                                                                              |
|         SOA4D Devices Profile for Web Services C Toolkit (DPWSCore)          |
|                                                                              |
|               ->> Copyright 2007 Schneider Electric SA <<-                   |
|                                                                              |
|                                                                              |
|       + File info:                                                           |
|                     $Revision: 1.4 $
|                     $Date: 2008/02/11 07:57:02 $
\*============================================================================*/
/******************************************************************************\
 *              AL persistence implemention on C standard library             *
\******************************************************************************/
#include "al_stor.h"

/*----------------------------------------------------------------------------*\
 *                               Implementation                               *
\*----------------------------------------------------------------------------*/

int al_stream_init(al_stream_t * stream, const char * id, int flag)
{
	switch (flag)
	{
	case AL_STREAM_READ:
		stream->fd = fopen(id, "r");
		break;
	case AL_STREAM_WRITE_OVERWRITE:
		stream->fd = (id ? fopen(id, "w") : stdout);
		break;
	case AL_STREAM_WRITE_APPEND:
		stream->fd = (id ? fopen(id, "a") : stdout);
		break;
	default:
		return AL_EOPTION;
	}
	return stream->fd ? AL_SUCCESS : AL_ERROR;
}

int al_stream_read(al_stream_t * in_stream, char * buf, unsigned long * size)
{
	size_t wlen = (size_t)*size;
	
	*size = (unsigned long)fread((void *)buf, 1, wlen, in_stream->fd);
	if (*size == wlen)
		return AL_SUCCESS;
	else
		return feof(in_stream->fd) ? AL_EEOS : AL_ERROR;
}

int al_stream_write(al_stream_t * out_stream, const char * buf, unsigned long * size)
{
	int ret = AL_SUCCESS;
	size_t wlen;
	
	wlen = *size;
		
	if (wlen > 0) {
		*size = (unsigned long)fwrite((void *)buf, 1, wlen, out_stream->fd);
		if (*size != wlen)
			ret = AL_EEOS;
	}
	return ret;
}

int al_stream_error(al_stream_t * stream)
{
	return feof(stream->fd) ? AL_EEOS : ferror(stream->fd);
}

int al_stream_close(al_stream_t * stream)
{
	return fclose(stream->fd) ? AL_ERROR : AL_SUCCESS;
}

int al_stream_seek(al_stream_t * stream, unsigned long offset, int origin)
{
  return fseek(stream->fd, offset, origin) ? AL_ERROR : AL_SUCCESS;
}

int al_stream_remove(char * filename)
{
	return remove(filename) ? AL_ERROR : AL_SUCCESS;
}

unsigned long al_stream_tell(al_stream_t * stream)
{
		return ftell(stream->fd);
}

void al_stream_rewind(al_stream_t * stream)
{
		rewind(stream->fd);
}

// Block API not implemented
