/*============================================================================*\
|                                                                              |
|                          SOA4D Abstraction Layer                             |
|                                                                              |
|               ->>  Copyright 2008 Schneider Electric SA <<-                  |
|                                                                              |
|                                                                              |
|       + File info:                                                           |
|                     $Revision: 1.5 $
|                     $Date: 2008/02/05 18:06:16 $
\*============================================================================*/
/*******************************************************************************
*               Network configuration access for win32 platforms               *
*******************************************************************************/
#include "al_net.h"
#include "al_mem.h"
#include <IpHlpApi.h>

static al_netif_info_t * nifs = NULL;
static int nb_nifs = 0;

// WARNING assertion is made that AL_SOCKADDR_FULL_OPAQUE is set

#ifndef AL_HAVE_IPV6
static void build_netif_info(al_netif_info_t * netif, PIP_ADAPTER_INFO adapter)
{
	PIP_ADDR_STRING w_addr;
	int i = 0;

	memcpy(netif->mac_address, adapter->Address, 6);

	// count
	for (w_addr = &adapter->IpAddressList; w_addr; w_addr = w_addr->Next)
		i++;
	netif->addr_nb = i;
	netif->addrs = AL_MALLOC(netif->addr_nb * sizeof(al_sockaddr_t));
	netif->name = strdup(adapter->AdapterName);	// beware: an UUID. How the user is supposed to retrieve it.
	netif->interface_selector = adapter->IfIndex;
	// fill
	i = 0;
	for (w_addr = &adapter->IpAddressList; w_addr; w_addr = w_addr->Next)
	{
		al_sockaddr_in_t * ipv4_addr = (al_sockaddr_in_t *)(netif->addrs + i);
		ipv4_addr->sin_family = AF_INET;
		al_inet_aton(w_addr->IpAddress.String, &ipv4_addr->sin_addr.addr);
		ipv4_addr->sin_port = 0;
		i++;
	}
}

int al_get_netif_info(al_netif_info_t * netifs[], int * nb_netifs)
{
    IP_ADAPTER_INFO AdapterInfo;
	PIP_ADAPTER_INFO AdInfoBuf = &AdapterInfo, wAdapterInfo;
	DWORD dwLen;
	DWORD dwStatus;	// deprecated since XP (use GetAdaptersAddresses)
	int i = 0, ret = AL_SUCCESS;
	uint32_t addr;

	if (nifs)
		goto exit;

	dwLen = sizeof(AdapterInfo);
	dwStatus = GetAdaptersInfo(&AdapterInfo, &dwLen);// deprecated since XP (use GetAdaptersAddresses)
	if (dwStatus == ERROR_BUFFER_OVERFLOW)
	{
		AdInfoBuf = AL_MALLOC(dwLen);
		dwStatus = GetAdaptersInfo(AdInfoBuf, &dwLen);
		if (dwStatus != ERROR_SUCCESS) {
			ret = AL_ERROR;
			goto exit;
		}
	}
	else if (dwStatus != ERROR_SUCCESS) {
		ret = AL_ERROR;
		goto exit;
	}

	// Count eligible adapters
	for (wAdapterInfo = AdInfoBuf; wAdapterInfo; wAdapterInfo = wAdapterInfo->Next) {
		if (!al_inet_aton(wAdapterInfo->IpAddressList.IpAddress.String, &addr) && addr != 0)
			nb_nifs++;
	}

	// Browse eligible adapters
    nifs = AL_MALLOC(nb_nifs * sizeof(al_netif_info_t));
	for (wAdapterInfo = AdInfoBuf; wAdapterInfo; wAdapterInfo = wAdapterInfo->Next)
	{
		if (!al_inet_aton(wAdapterInfo->IpAddressList.IpAddress.String, &addr) && addr != 0)
			build_netif_info(nifs + i++, wAdapterInfo);
	}

exit:
	if (AdInfoBuf != &AdapterInfo)
	    AL_FREE(AdInfoBuf);
	*netifs = nifs;
	*nb_netifs = nb_nifs;
	return ret;
}
#else
static void build_netif_info(al_netif_info_t * netif, PIP_ADAPTER_ADDRESSES adapter)
{
	PIP_ADAPTER_UNICAST_ADDRESS w_addr;
	int i = 0;

	memcpy(netif->mac_address, adapter->PhysicalAddress, 6);

	// count
	for (w_addr = adapter->FirstUnicastAddress; w_addr; w_addr = w_addr->Next)
		i++;
	netif->addr_nb = i;
	netif->addrs = AL_MALLOC(netif->addr_nb * sizeof(al_sockaddr_t));
	netif->name = strdup(adapter->AdapterName);
	netif->interface_selector = adapter->Ipv6IfIndex ? adapter->Ipv6IfIndex : adapter->IfIndex;	// NULL for IPV4 addresses
	// fill
	i = 0;
	for (w_addr = adapter->FirstUnicastAddress; w_addr; w_addr = w_addr->Next)
	{
		al_sockaddr_t * ip_addr = &netif->addrs[i];
		if (w_addr->Address.iSockaddrLength <= sizeof(al_sockaddr_t)) {
			memcpy(ip_addr, w_addr->Address.lpSockaddr, w_addr->Address.iSockaddrLength);
			i++;
		}
	}
}

static int is_valid_netif(PIP_ADAPTER_ADDRESSES pAddresses) {
	return (pAddresses->IfType == IF_TYPE_ETHERNET_CSMACD
#ifdef IF_TYPE_IEEE80211
		|| pAddresses->IfType == IF_TYPE_IEEE80211
#endif
		)
		&& (pAddresses->OperStatus == IfOperStatusUp)
		&& (pAddresses->FirstUnicastAddress != NULL)
		&& (pAddresses->PhysicalAddressLength == 6);
}

int al_get_netif_info(al_netif_info_t * netifs[], int * nb_netifs)
{
    PIP_ADAPTER_ADDRESSES pAddresses = NULL;
    PIP_ADAPTER_ADDRESSES pCurrAddresses = NULL;
	ULONG outBufLen = 0;
	ULONG family = AF_UNSPEC;
	ULONG flags = GAA_FLAG_SKIP_ANYCAST | GAA_FLAG_SKIP_MULTICAST;
	DWORD dwStatus;
	int i = 0, ret = AL_SUCCESS;

	if (nifs)
		goto exit;

	outBufLen = sizeof(IP_ADAPTER_ADDRESSES);
	pAddresses = (IP_ADAPTER_ADDRESSES *) AL_MALLOC(outBufLen);
	if (pAddresses == NULL) {
		ret = AL_ENOMEM;
		goto exit;
	}
	dwStatus = GetAdaptersAddresses(family, flags, NULL, pAddresses, &outBufLen);
	if (dwStatus == ERROR_BUFFER_OVERFLOW)
	{
		AL_FREE(pAddresses);
		pAddresses = (IP_ADAPTER_ADDRESSES *) AL_MALLOC(outBufLen);
		if (pAddresses == NULL) {
			ret = AL_ENOMEM;
			goto exit;
		}
		dwStatus = GetAdaptersAddresses(family, flags, NULL, pAddresses, &outBufLen);
		if (dwStatus != ERROR_SUCCESS) {
			ret = AL_ERROR;
			goto exit;
		}
	}
	else if (dwStatus != ERROR_SUCCESS) {
		ret = AL_ERROR;
		goto exit;
	}

	// Count eligible adapters
	for (pCurrAddresses = pAddresses; pCurrAddresses; pCurrAddresses = pCurrAddresses->Next) {
		if (is_valid_netif(pCurrAddresses))
			nb_nifs++;
	}

	// Browse eligible adapters
    nifs = (al_netif_info_t *) AL_MALLOC(nb_nifs * sizeof(al_netif_info_t));
	for (pCurrAddresses = pAddresses; pCurrAddresses; pCurrAddresses = pCurrAddresses->Next) {
		if (is_valid_netif(pCurrAddresses))
			build_netif_info(&nifs[i++], pCurrAddresses);
	}

exit:
	if (pAddresses != NULL)
	    AL_FREE(pAddresses);
	*netifs = nifs;
	*nb_netifs = nb_nifs;
	return ret;
}
#endif

void al_release_netif_info()
{
	int i;
	if (nifs) {
		for(i = 0; i < nb_nifs; i++) {
			AL_FREE(nifs[i].name);
			AL_FREE(nifs[i].addrs);
		}
		AL_FREE(nifs);
		nifs = NULL;
		nb_nifs = 0;
	}
}
