/*============================================================================*\
|                                                                              |
|                          SOA4D Abstraction Layer                             |
|                                                                              |
|               ->>  Copyright 2008 Schneider Electric SA <<-                  |
|                                                                              |
|                                                                              |
|       + File info:                                                           |
|                     $Revision: 1.3 $
|                     $Date: 2008/01/29 18:31:41 $
\*============================================================================*/
/*******************************************************************************
*                    Missing stdlib features implementation                    *
*******************************************************************************/
#ifndef AL_STDLIB_H_
#define AL_STDLIB_H_

/** \file
    Abstract Layer (AL): STDLIB features.
    <em>Note</em>: This API is almost empty since it is mainly designed to let
    platforms implement missing features.
*/

#include "al_common.h"

#include <stdlib.h>
#include <stdio.h>	// May not exist on some platforms (PALM)
#include <string.h>

#if defined AL_RTOS_FREE_RTOS
# include "al_stdlib_free_rtos.h" 
#elif defined AL_RTOS_POSIX
//# include "al_stdlib_posix.h" 
#elif defined AL_RTOS_WIN32 || defined AL_RTOS_WINCE
# include "alLIBC_Win32.h" 
#elif defined AL_RTOS_ANDERSEN
# include "alLIBC_Andersen.h"
#elif defined AL_COMP_ARDS
#include "alLIBC_Ards.h"
#else
# error "No OS defined ..."
#endif

/**
 * Returns the last stdlib error status.
 * Error codes returned are native (no translation), so they can only be used
 * for informative purposes or with native macro definitions. Note that
 * separating error code retrieval from the API responsible for the error is
 * not thread-safe which may not be a problem in a RTOS context (depending on
 * the preemption scheme).
 * @return A native STDLIB error code.
 */
int al_stdlib_error(void);

#endif /*AL_STDLIB_H_*/
