/*============================================================================*\
|                                                                              |
|                          SOA4D Abstraction Layer                             |
|                                                                              |
|               ->>  Copyright 2008 Schneider Electric SA <<-                  |
|                                                                              |
|                                                                              |
|       + File info:                                                           |
|                     $Revision: 1.8 $
|                     $Date: 2008/01/28 18:15:59 $
\*============================================================================*/
/*******************************************************************************
*                              Common features                                 *
*******************************************************************************/
#ifndef AL_COMMON_H_
#define AL_COMMON_H_

/** \file
    Abstract Layer (AL) common definitions.
*/

#include <stdint.h>
#include <stddef.h>
/**
 * Platform specific definitions include.
 */
#include <al_target.h>

/*----------------------------------------------------------------------------*\
 *                             Platform detection                             *
\*----------------------------------------------------------------------------*/
#if defined(__vxworks) || defined(__VXWORKS__) || defined(FC)
# ifndef AL_RTOS_VXWORKS
#  define AL_RTOS_VXWORKS
# endif
#elif defined( __ghs__)
# ifndef AL_STDLIB_GHS
#  define AL_STDLIB_GHS
# endif
#elif defined(__THREADX) || defined(TR_RTOS_THREADX)
# ifndef AL_RTOS_THREADX
#  define AL_RTOS_THREADX
# endif
#elif defined(_WIN32_WCE)
# ifndef AL_RTOS_WINCE
#  define AL_RTOS_WINCE
# endif
# ifndef AL_STACK_WINSOCK_CE
#  define AL_STACK_WINSOCK_CE
# endif
#elif defined(_WIN32) || defined(__WIN32__)
# ifndef AL_RTOS_WIN32
#  define AL_RTOS_WIN32
# endif
# ifndef AL_STACK_WINSOCK
#  define AL_STACK_WINSOCK
# endif
#elif defined(__CYGWIN__) || defined(__linux__)
# ifndef AL_RTOS_POSIX
#  define AL_RTOS_POSIX
# endif
# ifndef AL_STACK_BSD
#  define AL_STACK_BSD
# endif
#endif

/*----------------------------------------------------------------------------*\
 *                             General error codes                            *
\*----------------------------------------------------------------------------*/

/** \name AL general purpose error codes.
 *  These error codes can be produced by any of the AL interfaces including the
 *  IP one. These codes are expected to be returned directly by the functions
 *  without calling any error retrieval API.
 */
/*@{*/

#define AL_SUCCESS		0  	/**< No error */
#define AL_ERROR		-1  /**< Generic error: see implementation error code */
#define AL_ENOMEM		-2	/**< No memory */
#define AL_EOPTION		-3	/**< Flag/option not supported by the implementation */
#define AL_ENORES		-4	/**< The resource does not exist */
#define AL_EEOS			-5	/**< End of stream */
#define AL_EACCES		-6	/**< Permission denied */
#define AL_EINVAL		-7	/**< Invalid argument */
#define AL_EIMPL		-8  /**< Not supported by the implementation */
#define AL_EINTR		-9  /**< Operation was interrupted */
#define AL_EAGAIN		-10	/**< Operation would block, try again later */
#define AL_EINTERNAL	-11	/**< Non-recoverable internal error */

/*@}*/

/*----------------------------------------------------------------------------*\
 *                              IP API error codes                            *
\*----------------------------------------------------------------------------*/

/** \name AL IP API error codes
 * These error codes are produced by the BSD-like socket API and are direct
 * translations of the BSD standard codes. They are retrieved using al_ip_error().
 */
/*@{*/

#define AL_EIO				-101	/**< Input/output error */
#define AL_EBADF			-102	/**< Bad descriptor */
#define AL_EFAULT			-103	/**< Bad address */
#define AL_EMFILE			-104	/**< Out of descriptors */
#define AL_EINPROGRESS		-105	/**< Operation now in progress */
#define AL_EALREADY			-106	/**< Operation already in progress */
#define AL_ENOTSOCK			-107	/**< Not a socket descriptor */
#define AL_EDESTADDRREQ		-108	/**< Destination address required */
#define AL_EMSGSIZE			-109	/**< Message too big */
#define AL_EPROTOTYPE		-110	/**< Wrong protocol type */
#define AL_ENOPROTOOPT		-111	/**< Not a valid protocol option */
#define AL_EPROTONOSUPPORT	-112	/**< Protocol not supported */
#define AL_ESOCKTNOSUPPORT	-113	/**< Socket type not supported */
#define AL_EOPNOTSUPP		-114	/**< Operation not supported */
#define AL_EPFNOSUPPORT		-115	/**< Protocol family not supported */
#define AL_EAFNOSUPPORT		-116	/**< Address family not supported */
#define AL_EADDRINUSE		-117	/**< Address already in use */
#define AL_EADDRNOTAVAIL	-118	/**< Address not available from this host */
#define AL_ENETDOWN			-119	/**< Network down */
#define AL_ENETUNREACH		-120	/**< Network unreachable */
#define AL_ENETRESET		-121	/**< Network dropped connection on reset */
#define AL_ECONNABORTED		-122	/**< Connection aborted by user */
#define AL_ECONNRESET		-123	/**< Connection reseted by peer */
#define AL_ENOBUFS			-124	/**< Out of resources */
#define AL_EISCONN			-125	/**< Already connected */
#define AL_ENOTCONN			-126	/**< Socket not connected */
#define AL_ESHUTDOWN		-127	/**< Can't send after shutdown */
#define AL_ETOOMANYREFS		-128	/**< Too many references */
#define AL_ETIMEDOUT		-129	/**< Connection timed out */
#define AL_ECONNREFUSED		-130	/**< Connection refused */
#define AL_ELOOP			-131	/**< Too many levels of symbolic links */
#define AL_ENAMETOOLONG		-132	/**< Component of the path name too long */
#define AL_EHOSTDOWN		-133	/**< Host down */
#define AL_EHOSTUNREACH		-134	/**< Host unreachable */
#define AL_ENOTEMPTY		-135	/**< Directory not empty */
#define AL_ENXIO			-136	/**< Device not configured */
#define AL_EHOSTNOTFOUND	-137	/**< Host not found */
#define AL_ENODATA			-138	/**< No data for the entry */
#define AL_ENOSPC			-139	/**< No enough space in the supplied buffer */

/*@}*/

/*----------------------------------------------------------------------------*\
 *                             General constants definitions                  *
\*----------------------------------------------------------------------------*/
/** \name AL general definitions.
 *  These values and types can be used in any of the AL interfaces
 */
/*@{*/

#define AL_BOOL 			int			/**< Booleans definitions */
#define AL_TRUE 			1
#define AL_FALSE 			0
/*@}*/

#endif /*AL_COMMON_H_*/
