/*============================================================================*\
|                                                                              |
|                          SOA4D DPWSCore Samples                              |
|                                                                              |
|           ->>  Copyright 2004-2009 Schneider Electric SA <<-                 |
|                                                                              |
|                                                                              |
|        + File info:                                                          |
|                     $Revision: 2173 $
|                     $Date: 2009-03-06 18:45:37 +0100 (ven, 06 mar 2009) $
\*============================================================================*/
#include "fileio.h"
#include <stdio.h>
#include <string.h>

#define BYTESCHUNK 4096

size_t readfile(const char* filename, unsigned char* bytes) {
	FILE* f = fopen(filename, "rb");
	size_t res = 0, nread;
	if (!f) return -1;
	while ((nread = fread(bytes+res, 1, BYTESCHUNK, f)) == BYTESCHUNK) {
		res += nread;
	}
	if (nread >= 0 && feof(f))
		res += nread;
	else res = -1;
	fclose(f);
	return res;
}

int writefile(const char* filename, unsigned char* bytes, size_t len) {
	FILE* f = fopen(filename, "wb");
	size_t nwritten = 0;
	if (!f) return -1;
	while (1) {
		size_t n = len - nwritten;
		if (n > BYTESCHUNK) {
			fwrite(bytes+nwritten, 1, BYTESCHUNK, f);
			nwritten += BYTESCHUNK;
		} else {
			fwrite(bytes+nwritten, 1, n, f);
			fclose(f);
			return 0;
		}
	}
}
