/*============================================================================*\
|                                                                              |
|                          SOA4D DPWSCore Samples                              |
|                                                                              |
|           ->>  Copyright 2004-2009 Schneider Electric SA <<-                 |
|                                                                              |
|                                                                              |
|        + File info:                                                          |
|                     $Revision: 2135 $
|                     $Date: 2009-02-28 23:53:25 +0100 (sam, 28 fév 2009) $
\*============================================================================*/

#include "dc/dc_Dpws.h"	// Main DPWSCore API include file.

#include "prjStub.h"	// Generated stub & skeleton include file.
#include "prj.nsmap"	// Generated namespace table include file.

#include "fileio.h"	// File utilities.

#define HOMECINEMA_NS "http://www.soa4d.org/DPWS/Samples/DynHome/HomeCinema"	// The namespace used to qualify port types (copy from wsdl file).
#define DISPLAY_TYPE "Display"	// The local name of the port type supported by the service (defined in the wsdl file).


/*
 *  Utilities
 */

// Variables for menu processing.
static char command[32], param1[32];
static int status, nbParams;

static unsigned char buffer[1000000];	/* Image buffer */

/* Function printing error message. */
static void print_error(char * msg, struct dpws * dpws) {
	fprintf(stderr, "\nError occured : %s.\n%s\n\n", msg, dpws_get_error_msg(dpws));
}

/* Function to get the projector service proxy for a given device proxy. */
static short getServiceProxy(struct dpws *dpws, short device_proxy)
{
	int nb_services = 1;	// One service required.
	short hService = -1;

	// The dpws_get_services retrieves one or several service proxies hosted by
	// a remote device using a type filtering (other APIs are available).
	// It will look for proxy available into the local cache or generate a
	// WS_Transfer/WS-MetadataExchange message if necessary.
	short * service_proxies = dpws_get_services(dpws, device_proxy, HOMECINEMA_NS, DISPLAY_TYPE, &nb_services);

	/* The program searches a single service. */
	if (nb_services != 1) {
		if (nb_services == 0)
			printf("No service endpoint found, please check the port type specifications.\n");
		else
			print_error("Could not execute dpws_get_services", dpws);
		goto exit;
	}

	// Make sure the service proxy will not be erased from the cache for instance
	// because of a bye message.
	if (dpws_pin_proxy(service_proxies[0]) != DPWS_OK) {
		print_error("Could not execute dpws_pin_proxy", dpws);
		goto exit;
	}
	hService = service_proxies[0];

exit:
	// Clears structures and free dynamically allocated memory used for request processing.
	if (dpws_end(dpws) != DPWS_OK)
		print_error("Could not execute dpws_end", dpws);

	return hService;
}

void projectorClient(struct dpws *dpws, short device_proxy)
{
	short service_proxy;
	struct wsa_endpoint_ref * servEndPt;

	/* Projector client program description (service invocation) */
	// 1. Set the MTOM mode.
	// 2. Find service proxy of the service to be invoked.
	// 3. Invocation loop
	//  3.1 Get the default invocation endpoint reference.
	//	3.2 Invoke the service.
	//  3.3 Free message processing memory.
	// 4. Release service proxy.

	/* 1. Set the MTOM mode. */
	soap_set_mode(&dpws->soap, SOAP_ENC_MTOM);

	/* 2. Find service proxy of the service to be invoked. */
	service_proxy = getServiceProxy(dpws, device_proxy);
	if (service_proxy < 0)
		return;

	/* 3. Invocation loop */
	printf("\nProjector device type commands (Q to quit this menu):\n\n");
	printf("\n Display <jpeg image name>\n");
	printf("\n\tDisplays a specified jpeg image.\n");
	printf("\t<jpeg image name> indicates name of the file containing the jpeg image.\n");
	printf("\tOne can provide any file in the working directory (not displayed).\n");

	for (;;)
	{
		printf ("\nEnter command:\n");
		nbParams = scanf("%32s", command);
		if (nbParams == 0) {
			printf("Type mismatch !\n");
			continue;
		}

		/* 3.1 Get the default invocation endpoint reference. */

		// Retrieves the service proxy default endpoint reference (EPR) used for
		// invocation.
		// Several endpoints may be available and dpws_get_default_endpoint_ref
		// returns the first one. This is why one may have to use dpws_get_endpoint_refs
		// especially if the 1st EPR is not reachable.
		servEndPt = dpws_get_default_endpoint_reference(dpws, service_proxy);	// This is done every time because dpws_end has been called.
		if (!servEndPt) {
			print_error("Could not find default endpoint reference", dpws);
			return;
		}

		/* 3.2 Invoke the service. */

		// Command parsing & switch
		if (!strcasecmp(command, "Display"))	// Display image on the projector
		{
			nbParams = scanf("%32s", param1);
			if (nbParams != 1)
				printf("Bad parameter count !\n");
			else {	// prepare and send image as an attachment
				struct prj__AttachmentType image;
				/*
				NOTE:
					The xop member has been added to this structure allowing MTOM
					attachment use because a custom 'wsdl2h' mapping has been defined
					in typemap.dat.
				*/
			  	image.Param.__ptr = buffer;
			  	image.Param.__size = (int)readfile(param1, image.Param.__ptr);
				if (image.Param.__size > 0) {
			  		image.Param.id = NULL;
			  		image.Param.type = "image/jpeg";
			  		image.Param.options = NULL;
					printf("<-- Displaying image of file %s\n", param1);
					status = dpws_send___prj__DisplayImage(dpws, servEndPt, &image);
					if (status)
						printf("Could not display image : %s.\n", dpws_get_error_msg(dpws));
				}
				else
					printf("Could not read file for attachment.\n");
			}
		}
		else if (!strcasecmp(command, "Q"))	// Exit menu
		{
			printf("Exiting projector menu...\n");
			break;
		}
		else
			printf("Unknown command.\n");

		if (status)
			fprintf(stderr, dpws_get_error_msg(dpws));

		/* 3.3 Free message processing memory. */
		if (dpws_end(dpws) != DPWS_OK)
			print_error("Could not execute dpws_end", dpws);
	}

	/* 4. Release service proxy. */
	if (dpws_release_proxy(service_proxy) != DPWS_OK)
		print_error("Could not execute dpws_release_proxy", dpws);
}
