/*============================================================================*\
|                                                                              |
|                      SOA4D DPWSCore (C DPWS toolkit)                         |
|                                                                              |
|           ->>  Copyright 2004-2009 Schneider Electric SA <<-                 |
|                                                                              |
|   This program is free software; you can redistribute it and/or modify it    |
|   under the terms of the GNU Lesser General Public License as published by   |
|   the Free Software Foundation; either version 2.1 of the License, or (at    |
|   your option) any later version.                                            |
|                                                                              |
|   This program is distributed in the hope that it will be useful, but        |
|   WITHOUT ANY WARRANTY; without even the implied warranty of                 |
|   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser    |
|   General Public License for more details.                                   |
|                                                                              |
|   You should have received a copy of the GNU Lesser General Public License   |
|   along with this program; if not, write to the Free Software Foundation,    |
|   Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307. You can also get  |
|   it at http://www.gnu.org/licenses/lgpl.html                                |
|                                                                              |
|       + File info:                                                           |
|                     $Revision: 2154 $
|                     $Date: 2009-03-05 17:38:15 +0100 (jeu, 05 mar 2009) $
\*============================================================================*/

/***************************************************************************//**
* \file
* XML utilities.
*******************************************************************************/

#ifndef XMLUTILS_H_
#define XMLUTILS_H_

#include "dc/dc_Types.h"

#ifndef DC_RT_FMAC1	/* runtime functions declaration prefix */
# define DC_RT_FMAC1
#endif

#ifdef __cplusplus
extern "C" {
#endif

/** Converts an XML duration into an integer.
 * @param[in,out] p The XML duration. Note that this string may be modified during the
 * call. Do not call if the string must not be modified.
 * @return The duration in seconds or 0 if XML duration is invalid.
 */
DC_RT_FMAC1 int32_t dcxml_xmlduration2duration(char *p);

/** Converts an integer duration into an XML duration.
 * @param[out] dest the destination buffer. Must be DURATION_MAX_SIZE at least.
 * @param duration The duration in seconds to convert.
 * @return The modified buffer filled with an XML duration string.
 */
DC_RT_FMAC1 char * dcxml_duration2xmlduration(char * dest, int32_t duration);

#ifdef __cplusplus
}
#endif

#endif /*XMLUTILS_H_*/
