/*============================================================================*\
|                                                                              |
|                      SOA4D DPWSCore (C DPWS toolkit)                         |
|                                                                              |
|           ->>  Copyright 2004-2009 Schneider Electric SA <<-                 |
|                                                                              |
|   This program is free software; you can redistribute it and/or modify it    |
|   under the terms of the GNU Lesser General Public License as published by   |
|   the Free Software Foundation; either version 2.1 of the License, or (at    |
|   your option) any later version.                                            |
|                                                                              |
|   This program is distributed in the hope that it will be useful, but        |
|   WITHOUT ANY WARRANTY; without even the implied warranty of                 |
|   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser    |
|   General Public License for more details.                                   |
|                                                                              |
|   You should have received a copy of the GNU Lesser General Public License   |
|   along with this program; if not, write to the Free Software Foundation,    |
|   Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307. You can also get  |
|   it at http://www.gnu.org/licenses/lgpl.html                                |
|                                                                              |
|       + File info:                                                           |
|                     $Revision: 2154 $
|                     $Date: 2009-03-05 17:38:15 +0100 (jeu, 05 mar 2009) $
\*============================================================================*/

/***************************************************************************//**
* \file
* Persistence layer.
* Although it could be used implemented on other implementations than regular
* files the Storage UNit layer is implemented by default on 'stdio'.
*******************************************************************************/

#ifndef SUN_H_
#define SUN_H_

#define SUN_OK			0	/**< No error */
#define SUN_EOS			1	/**< End of stream */
#define SUN_IMPL_ERROR	2	/**< Implementation-specific */
#define SUN_NO_RESOURCE	3	/**< Resource not found */

#ifndef DC_RT_FMAC1	/* runtime functions declaration prefix */
# define DC_RT_FMAC1
#endif

#ifdef __cplusplus
extern "C" {
#endif

/** Prepares a storage unit for stream writing.
 * If the id is not known by the implementation, a new storage unit is created,
 * else it is overwritten. A fixed size can be asked for the storage unit.
 * @param implementation A pointer on the SUN implementation. Reserved for later
 * use (using NULL will select the default implementation on top of the stdio
 * lib meaning that \a sun_id will stand for a filename).
 * @param sun_id Storage unit implementation-dependent unique id.
 * @param len If specified, a fixed-length storage unit is required and the
 * granted length is returned. If NULL is supplied, an unspecified length is
 * required.
 * @return An implementation-dependent processing context if the implementation
 * was able to provide the requested storage unit, named the SUN stream.
 */
DC_RT_FMAC1 void * sun_write_init(void * implementation, const char * sun_id, unsigned long * len);

/** Prepares an existing storage unit for stream reading.
 * @param implementation A pointer on the SUN implementation. Reserved for later
 * use (using NULL will select the default implementation on top of the stdio
 * lib meaning that \a sun_id will stand for a filename).
 * @param sun_id Storage unit implementation-dependent unique id.
 * @return An implementation-dependent processing context if the storage unit
 * could be found and can be processed, named the SUN stream.
 */
DC_RT_FMAC1 void * sun_read_init(void * implementation, const char * sun_id);

/** Performs a stream reading operation.
 * Reads bytes from the storage unit from the position it has been stopped by
 * the previous read operation and if possible the number or requested bytes.
 * @param in_stream A SUN input stream.
 * @param buf The byte buffer where the read data is copied.
 * @param[in,out] size The size of the buffer is initially passed and the actual
 * read data is returned.
 * @return SUN_OK or any SUN error code like SUN_MAX_LIMIT if the end of
 * the storage unit is reached (which does not mean the data has not been
 * read).
 */
DC_RT_FMAC1 int sun_stream_read(void * in_stream, char * buf, unsigned long * size);

/** Performs a stream writing operation.
 * Writes bytes contained in the passed buffer after the bytes passed the
 * previous read operation and if possible the number or requested bytes.
 * @param out_stream A SUN output stream.
 * @param buf The byte buffer where the data to write is stored.
 * @param[in,out] size The size of the buffer is initially passed and the actual
 * written data is returned.
 * @return SUN_OK or any SUN error code like SUN_MAX_LIMIT if the end of
 * the storage unit is reached (which does not mean the data has not been
 * stored).
 */
DC_RT_FMAC1 int sun_stream_write(void * out_stream, const char * buf, unsigned long * size);

/** Retrieves an implementation-dependent error code.
 * To use after an SUN_IMPL_ERROR error code has been returned by a SUN API.
 * @param stream A SUN stream.
 * @return The mplementation-dependent error code.
 */
DC_RT_FMAC1 int sun_get_error(void * stream);

/** Close a reading or writing context.
 * @param stream A SUN stream.
 * @return SUN_OK or any SUN error code.
 */
DC_RT_FMAC1 int sun_close(void * stream);

#ifdef __cplusplus
}
#endif

#endif /*SUN_H_*/
