/*============================================================================*\
|                                                                              |
|                      SOA4D DPWSCore (C DPWS toolkit)                         |
|                                                                              |
|           ->>  Copyright 2004-2009 Schneider Electric SA <<-                 |
|                                                                              |
|   This program is free software; you can redistribute it and/or modify it    |
|   under the terms of the GNU Lesser General Public License as published by   |
|   the Free Software Foundation; either version 2.1 of the License, or (at    |
|   your option) any later version.                                            |
|                                                                              |
|   This program is distributed in the hope that it will be useful, but        |
|   WITHOUT ANY WARRANTY; without even the implied warranty of                 |
|   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser    |
|   General Public License for more details.                                   |
|                                                                              |
|   You should have received a copy of the GNU Lesser General Public License   |
|   along with this program; if not, write to the Free Software Foundation,    |
|   Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307. You can also get  |
|   it at http://www.gnu.org/licenses/lgpl.html                                |
|                                                                              |
|       + File info:                                                           |
|                     $Revision: 2154 $
|                     $Date: 2009-03-05 17:38:15 +0100 (jeu, 05 mar 2009) $
\*============================================================================*/

/***************************************************************************//**
* \file
* Runtime API used by the generated code.
* There is no real reason why the user should use directly use these functions.
*******************************************************************************/

#ifndef DCRUNTIME_H
# define DCRUNTIME_H

#include "dc/dc_Dpws.h"
#include "dc/dc_Constants.h"

#ifndef DC_RT_FMAC1	/* runtime functions declaration prefix */
# define DC_RT_FMAC1
#endif

#ifdef __cplusplus
extern "C" {
#endif

#ifndef WITH_NONAMESPACES
extern struct Namespace snd_namespaces[];
#endif

/** Serializes the DPWS headers in the SOAP message headers.
 * @param dpws The DPWS runtime structure containing the serialization context
 * and header information.
 * @return A DPWS/gSOAP error code.
 */
DC_RT_FMAC1 int dpws_headers_out(struct dpws* dpws);

/** Parses the DPWS headers in the current SOAP message.
 * @param dpws The DPWS runtime structure containing the parsing context and
 * header information.
 * @return A DPWS/gSOAP error code.
 */
DC_RT_FMAC1 int dpws_header_in(struct dpws* dpws);

/** Initializes the DPWS headers before receiving a response.
 * @param dpws The DPWS runtime structure containing the serialization context
 * and header information.
 * @return A DPWS/gSOAP error code.
 */
DC_RT_FMAC1 void dpws_init_headers(struct dpws* dpws);

/** Initializes the DPWS headers and protocol version.
 * @param dpws The DPWS runtime structure containing the serialization context
 * and header information.
 * @return A DPWS/gSOAP error code.
 */
DC_RT_FMAC1 void dpws_init_headers_and_version(struct dpws* dpws);

/** Check expected DPWS headers during message reception when WSI Basic Profile
 * 1.1 compatibility is turned off.
 * @param dpws The DPWS runtime structure containing the parsing context and
 * header information.
 * @return A DPWS/gSOAP error code.
 */
DC_RT_FMAC1 int dpws_check_headers(struct dpws * dpws);

/** Set request DPWS headers in a two-way invocation.
 * @param dpws The DPWS runtime structure containing the serialization context
 * and header information.
 * @param to Destination endpoint reference.
 * @param reply_to Reply endpoint reference.
 * @param wsa_action The action URI defined by WS-Addressing defining the invoked
 * operation through the identification of the input message.
 * @return A DPWS/gSOAP error code.
 */
DC_RT_FMAC1 int dpws_set_call_headers(struct dpws * dpws, struct wsa_endpoint_ref *to, struct wsa_endpoint_ref *reply_to, char *wsa_action);

/** Set request DPWS headers in a one-way invocation.
 * @param dpws The DPWS runtime structure containing the serialization context
 * and header information.
 * @param to Destination endpoint reference.
 * @param wsa_action The action URI defined by WS-Addressing defining the invoked
 * operation through the identification of the input message.
 * @return A DPWS/gSOAP error code.
 */
DC_RT_FMAC1 void dpws_set_oneway_headers(struct dpws* dpws, struct wsa_endpoint_ref *to, char *wsa_action);

/** Set response DPWS headers in a two-way invocation.
 * @param dpws The DPWS runtime structure containing the serialization context
 * and header information.
 * @param wsa_action The action URI defined by WS-Addressing for the response
 * message.
 * @return A DPWS/gSOAP error code.
 */
DC_RT_FMAC1 void dpws_set_reply_headers(struct dpws* dpws, char *wsa_action);

/** Tests if a response is expected on the same connection for a two-way
 * invocation and if the server must send an empty response to the sender and
 * open a new connection for the response.
 * @param dpws The request context.
 * @return A non-0 value if the server must open a new connection.
 */
DC_RT_FMAC1 int dpws_is_asynchronous(struct dpws* dpws);

/** Sends a SOAP fault to the sender.
 * @param dpws The request context.
 * @return A DPWS/gSOAP error code.
 */
DC_RT_FMAC1 int dpws_send_fault(struct dpws* dpws);

/** Prepares the SOAP response.
 * Sets the HTTP status and opens a connection for the response if required.
 * @param dpws The request context.
 * @param status The HTTP status.
 * @return A DPWS/gSOAP error code.
 */
DC_RT_FMAC1 int dpws_response(struct dpws *dpws, int status);

/** Sets the namespace table for sending or receiving a message.
 * The namespace table is generated along with the stub & skeleton code.
 * @param dpws The request context.
 * @param ns_tab The namespace table in the gSOAP format.
 * @return A DPWS/gSOAP error code.
 */
DC_RT_FMAC1 void dpws_set_namespaces(struct dpws * dpws, struct Namespace *ns_tab);

/** Open a connection for a given address to send a message.
 * @param dpws The request context.
 * @param address The destination address. For instance an URL if the transport
 * is HTTP.
 * @param action The SOAP action that can be embedded in HTTP headers for
 * instance, for compatibility with pre-WS-Addressing SOAP engines.
 * @return A DPWS/gSOAP error code.
 */
DC_RT_FMAC1 int dpws_connect(struct dpws* dpws, const char* address, const char* action);

/** Returns WS-Eventing subscriptors endpoint references for a local event source service.
 * @param dpws The request context.
 * @param event_source The handle reference of the service endpoint sending the events.
 * @param action The action of the event message to be sent that will be used
 * for filtering event sinks.
 * @return A NULL-terminated array of endpoint references for retrieved subscriptors.
 */
DC_RT_FMAC1 struct wsa_endpoint_ref** dpws_get_subscriptors(struct dpws* dpws, short event_source, char* action);

/** The subscription handling function that will be added to every generated
 * service dispatch function when the service is an event source.
 * @param dpws The request context.
 * @return A DPWS/gSOAP error code.
 */
DC_RT_FMAC1 int dpws_serve_subscribe(struct dpws* dpws);

/** Function that will try to invalidate a device in the cache when the stub
 * detects a connection error.
 * @param dpws The request context.
 * @param device The endpoint reference that failed.
 */
DC_RT_FMAC1 void dpws_invalidate(struct dpws* dpws, struct wsa_endpoint_ref* device);

/** Receives one way or asynchronous empty response.
 * May be used only if a client wants to block waiting for and empty response.
 * @param dpws A pointer on a dpws runtime data structure.
 * @return DPWS_OK, if no error occurred. A DPWS or gSOAP error code otherwise.
 */
DC_RT_FMAC1 int dpws_receive_empty_response(struct dpws* dpws);

/** Sets the protocol version used in the current dpws struct to the one associated to
 * the endpoint.
 * @param dpws A pointer to a dpws runtime data structure.
 * @param to The destination endpoint.
 * @return DPWS_OK if no error occured, a DPWS or gSOAP error code otherwise.
 */
DC_RT_FMAC1 int dpws_check_endpoint(struct dpws * dpws, struct wsa_endpoint_ref * to);

/** Checks if the action URI is a supported WS-Eventing Subscribe action and
 * sets the associated DPWS protocol version
 * @param dpws A pointer to a dpws runtime data structure.
 * @param subscribe_action The message action.
 * @return 1 if true, 0 if false.
 */
DC_RT_FMAC1 int dpws_is_subscribe_action(struct dpws * dpws, const char * subscribe_action);

#ifdef __cplusplus
}
#endif

#endif
