/*============================================================================*\
|                                                                              |
|                      SOA4D DPWSCore (C DPWS toolkit)                         |
|                                                                              |
|           ->>  Copyright 2004-2009 Schneider Electric SA <<-                 |
|                                                                              |
|   This program is free software; you can redistribute it and/or modify it    |
|   under the terms of the GNU Lesser General Public License as published by   |
|   the Free Software Foundation; either version 2.1 of the License, or (at    |
|   your option) any later version.                                            |
|                                                                              |
|   This program is distributed in the hope that it will be useful, but        |
|   WITHOUT ANY WARRANTY; without even the implied warranty of                 |
|   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser    |
|   General Public License for more details.                                   |
|                                                                              |
|   You should have received a copy of the GNU Lesser General Public License   |
|   along with this program; if not, write to the Free Software Foundation,    |
|   Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307. You can also get  |
|   it at http://www.gnu.org/licenses/lgpl.html                                |
|                                                                              |
|       + File info:                                                           |
|                     $Revision: 2154 $
|                     $Date: 2009-03-05 17:38:15 +0100 (jeu, 05 mar 2009) $
\*============================================================================*/

/***************************************************************************//**
* \file
* DPWSCore constants used by the stack implementation.
* Are used internally and that may be used by the user for some specific usage
* or for information purpose.
*******************************************************************************/

#ifndef DC_CONSTANTS_H_
#define DC_CONSTANTS_H_


/* DC Sizing Constants */
#define DISCOVERY_ALLOC_INCREMENT		10
#define EVENT_ALLOC_INCREMENT			5
#define UUID_CACHE_SIZE					10
#define DURATION_MAX_SIZE				32
#define MAX_SERVICES_PER_DEVICE			512
#define DISCOVERY_HANDLE_POOL_SIZE		10

/* Default configuration */
#define HTTP_PORT_DEFAULT				80
#define HTTP_BACKLOG_DEFAULT			10
#define MAX_SUBSC_DURATION_DEFAULT		86400 // "P1D"

/* DPWS Constants */
#define DPWS_APP_MAX_DELAY			2500 //(ms) WS-Discovery (superseded by DPWS -> 2500)
#define APP_MAX_DELAY				DPWS_APP_MAX_DELAY //(ms)
#define WSD_MATCH_TIMEOUT 			(APP_MAX_DELAY + 100) // (ms) WS-Discovery use for client lookup
#define MATCH_TIMEOUT				10000 // (ms) DPWS
#define DP_MAX_TIMEOUT				5000  // (ms) WS-Discovery
#define DISCOVERY_PORT				3702 // WS-Discovery
#define DISCOVERY_MULTICAST_ADDR	"239.255.255.250" // WS-Discovery
#define DISCOVERY_MULTICAST_ADDRV6	"FF02::C" // WS-Discovery
#define MAX_ENVELOPE_SIZE			32767 // (octets) DPWS
#define MAX_FIELD_SIZE				256 // (Unicode characters) DPWS
#define MAX_URI_SIZE				2048 // (octets) DPWS
#define SOAP_UDP_SCHEME				"soap.udp" // SOAP-over-UDP
#define MULTICAST_UDP_REPEAT		2 // SOAP-over-UDP (superseded by DPWS)
#define UDP_MAX_DELAY				250 // (ms) SOAP-over-UDP
#define UDP_MIN_DELAY				50 // (ms) SOAP-over-UDP
#define UDP_UPPER_DELAY				450 // (ms) SOAP-over-UDP (superseded by DPWS)
#define UNICAST_UDP_REPEAT			2 // SOAP-over-UDP
#define WAKE_UP_DATAGRAM			"<WAKE/>" // start with '<' not to be considered as an HTTP header (blocks)
#define SHUTDOWN_DELAY				200 // (ms) time to send the last bye.
#define SHUTDOWN_DELAY_MAX_REPEAT	10 // Number of times to wait until servers have sent scheduled messages.

#define SOAP_ENV_URI "http://www.w3.org/2003/05/soap-envelope"
#define SOAP_ENV_PREFIX "SOAP-ENV"
#define SOAP_ENV_WILDCARD "http://schemas.xmlsoap.org/soap/envelope/"	// For BP 1.1 support.
#define SOAP_ENC_URI "http://www.w3.org/2003/05/soap-encoding"
#define SOAP_ENC_PREFIX "SOAP-ENC"
#define SOAP_ENC_WILDCARD "http://schemas.xmlsoap.org/soap/encoding/"	// For BP 1.1 support.
#define XSI_URI "http://www.w3.org/2001/XMLSchema-instance"
#define XSI_PREFIX "xsi"
#define XSI_WILDCARD "http://www.w3.org/*/XMLSchema-instance"
#define XSD_URI "http://www.w3.org/2001/XMLSchema"
#define XSD_PREFIX "xsd"
#define XSD_WILDCARD "http://www.w3.org/*/XMLSchema"
#define WSDL_URI "http://schemas.xmlsoap.org/wsdl"

#define DPWS10_VERSION 1
#define DPWS11_VERSION 2
#define DPWS_DEFAULT_VERSION DPWS10_VERSION
#define N_DPWS_VERSIONS 2

#define WSA_PREFIX "wsa"
#define WSA_WILDCARD "http://www.w3.org/*/addressing"

#define WSA_200408_URI "http://schemas.xmlsoap.org/ws/2004/08/addressing"
#define WSA_200408_ANONYMOUS_ENDPOINT_REF_URI "http://schemas.xmlsoap.org/ws/2004/08/addressing/role/anonymous"
#define WSA_200408_SOAP_FAULT_URI "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault"

#define WSA_200508_URI "http://www.w3.org/2005/08/addressing"
#define WSA_200508_ANONYMOUS_ENDPOINT_REF_URI "http://www.w3.org/2005/08/addressing/role/anonymous"
#define WSA_200508_SOAP_FAULT_URI "http://www.w3.org/2005/08/addressing/fault"

#define WDP_PREFIX "wdp"
#define WDP_WILDCARD "http://docs.oasis-open.org/ws-dd/ns/dpws/*"

#define DPWS10_WDP_URI "http://schemas.xmlsoap.org/ws/2006/02/devprof"
#define DPWS10_WDP_MODEL_URI "http://schemas.xmlsoap.org/ws/2006/02/devprof/ThisModel"
#define DPWS10_WDP_DEVICE_URI "http://schemas.xmlsoap.org/ws/2006/02/devprof/ThisDevice"
#define DPWS10_WDP_HOSTING_URI "http://schemas.xmlsoap.org/ws/2006/02/devprof/Relationship"
#define DPWS10_WDP_RELATIONSHIP_HOST_TYPE_URI "http://schemas.xmlsoap.org/ws/2006/02/devprof/host"
#define DPWS10_WSE_FILTERING_DIALECT "http://schemas.xmlsoap.org/ws/2006/02/devprof/Action"

#define DPWS11_WDP_URI "http://docs.oasis-open.org/ws-dd/ns/dpws/2009/01"
#define DPWS11_WDP_MODEL_URI "http://docs.oasis-open.org/ws-dd/ns/dpws/2009/01/ThisModel"
#define DPWS11_WDP_DEVICE_URI "http://docs.oasis-open.org/ws-dd/ns/dpws/2009/01/ThisDevice"
#define DPWS11_WDP_HOSTING_URI "http://docs.oasis-open.org/ws-dd/ns/dpws/2009/01/Relationship"
#define DPWS11_WDP_RELATIONSHIP_HOST_TYPE_URI "http://docs.oasis-open.org/ws-dd/ns/dpws/2009/01/host"
#define DPWS11_WSE_FILTERING_DIALECT "http://docs.oasis-open.org/ws-dd/ns/dpws/2009/01/Action"

#define WSD_PREFIX "wsd"
#define WSD_WILDCARD "http://docs.oasis-open.org/ws-dd/ns/discovery/*"

#define DPWS10_WSD_URN "urn:schemas-xmlsoap-org:ws:2005:04:discovery"
#define DPWS10_WSD_URI "http://schemas.xmlsoap.org/ws/2005/04/discovery"
#define DPWS10_WSD_HELLO_ACTION			"http://schemas.xmlsoap.org/ws/2005/04/discovery/Hello"
#define DPWS10_WSD_BYE_ACTION				"http://schemas.xmlsoap.org/ws/2005/04/discovery/Bye"
#define DPWS10_WSD_PROBE_ACTION			"http://schemas.xmlsoap.org/ws/2005/04/discovery/Probe"
#define DPWS10_WSD_RESOLVE_ACTION			"http://schemas.xmlsoap.org/ws/2005/04/discovery/Resolve"
#define DPWS10_WSD_PROBEMATCHES_ACTION		"http://schemas.xmlsoap.org/ws/2005/04/discovery/ProbeMatches"
#define DPWS10_WSD_RESOLVEMATCHES_ACTION	"http://schemas.xmlsoap.org/ws/2005/04/discovery/ResolveMatches"
#define DPWS10_WSD_MATCH_BY_RFC2396_URI	"http://schemas.xmlsoap.org/ws/2005/04/discovery/rfc2396"
#define DPWS10_WSD_MATCH_BY_UUID_URI		"http://schemas.xmlsoap.org/ws/2005/04/discovery/uuid"
#define DPWS10_WSD_MATCH_BY_LDAP_URI		"http://schemas.xmlsoap.org/ws/2005/04/discovery/ldap"
#define DPWS10_WSD_MATCH_BY_STRCMP_URI		"http://schemas.xmlsoap.org/ws/2005/04/discovery/strcmp0"

#define DPWS11_WSD_URN "urn:docs-oasis-open-org:ws-dd:ns:discovery:2009:01"
#define DPWS11_WSD_URI "http://docs.oasis-open.org/ws-dd/ns/discovery/2009/01"
#define DPWS11_WSD_HELLO_ACTION			"http://docs.oasis-open.org/ws-dd/ns/discovery/2009/01/Hello"
#define DPWS11_WSD_BYE_ACTION				"http://docs.oasis-open.org/ws-dd/ns/discovery/2009/01/Bye"
#define DPWS11_WSD_PROBE_ACTION			"http://docs.oasis-open.org/ws-dd/ns/discovery/2009/01/Probe"
#define DPWS11_WSD_RESOLVE_ACTION			"http://docs.oasis-open.org/ws-dd/ns/discovery/2009/01/Resolve"
#define DPWS11_WSD_PROBEMATCHES_ACTION		"http://docs.oasis-open.org/ws-dd/ns/discovery/2009/01/ProbeMatches"
#define DPWS11_WSD_RESOLVEMATCHES_ACTION	"http://docs.oasis-open.org/ws-dd/ns/discovery/2009/01/ResolveMatches"
#define DPWS11_WSD_MATCH_BY_RFC2396_URI	"http://docs.oasis-open.org/ws-dd/ns/discovery/2009/01/rfc3986"
#define DPWS11_WSD_MATCH_BY_UUID_URI		"http://docs.oasis-open.org/ws-dd/ns/discovery/2009/01/uuid"
#define DPWS11_WSD_MATCH_BY_LDAP_URI		"http://docs.oasis-open.org/ws-dd/ns/discovery/2009/01/ldap"
#define DPWS11_WSD_MATCH_BY_STRCMP_URI		"http://docs.oasis-open.org/ws-dd/ns/discovery/2009/01/strcmp0"

#define WSP_URI "http://schemas.xmlsoap.org/ws/2004/09/policy"

#define WSM_PREFIX "wsm"
#define WSM_WILDCARD "http://schemas.xmlsoap.org/ws/*/mex"
#define WSM_URI "http://schemas.xmlsoap.org/ws/2004/09/mex"

#define WST_PREFIX "wst"
#define WST_WILDCARD "http://schemas.xmlsoap.org/ws/*/transfer"
#define WST_URI "http://schemas.xmlsoap.org/ws/2004/09/transfer"
#define WST_GET_ACTION "http://schemas.xmlsoap.org/ws/2004/09/transfer/Get"
#define WST_GET_RESPONSE_ACTION "http://schemas.xmlsoap.org/ws/2004/09/transfer/GetResponse"

#define WSE_PREFIX "wse"
#define WSE_WILDCARD "http://schemas.xmlsoap.org/ws/*/eventing"
#define WSE_URI "http://schemas.xmlsoap.org/ws/2004/08/eventing"
#define WSE_MODE_PUSH "http://schemas.xmlsoap.org/ws/2004/08/eventing/DeliveryModes/Push"
#define WSE_SUBSCRIBE_ACTION				"http://schemas.xmlsoap.org/ws/2004/08/eventing/Subscribe"
#define WSE_SUBSCRIBE_RESPONSE_ACTION				"http://schemas.xmlsoap.org/ws/2004/08/eventing/SubscribeResponse"
#define WSE_SUBSCRIPTION_END_ACTION				"http://schemas.xmlsoap.org/ws/2004/08/eventing/SubscriptionEnd"
#define WSE_RENEW_ACTION				"http://schemas.xmlsoap.org/ws/2004/08/eventing/Renew"
#define WSE_RENEW_RESPONSE_ACTION				"http://schemas.xmlsoap.org/ws/2004/08/eventing/RenewResponse"
#define WSE_GET_STATUS_ACTION				"http://schemas.xmlsoap.org/ws/2004/08/eventing/GetStatus"
#define WSE_GET_STATUS_RESPONSE_ACTION				"http://schemas.xmlsoap.org/ws/2004/08/eventing/GetStatusResponse"
#define WSE_UNSUBSCRIBE_ACTION				"http://schemas.xmlsoap.org/ws/2004/08/eventing/Unsubscribe"
#define WSE_UNSUBSCRIBE_RESPONSE_ACTION				"http://schemas.xmlsoap.org/ws/2004/08/eventing/UnsubscribeResponse"
#define WSE_SUBSCRIPTION_END_REASON		"Commanded device shutdown"
#define DPWS_EVENT_SUBSCRIBE_ACTION  WSE_SUBSCRIBE_ACTION

#ifdef WITH_WSMAN
# define WSMAN_URI "http://schemas.dmtf.org/wbem/wsman/1/wsman.xsd"
# define WSMAN_PREFIX "wsman"
# define WSMAN_WILDCARD "http://schemas.dmtf.org/wbem/wsman/*"
#endif

#define DISC_PROXY_PORT_TYPE "DiscoveryProxy"
#define TGS_PORT_TYPE "TargetService"
#define WSM_PORT_TYPE "MetadataExchange"
#define WDP_DEVICE_TYPE "Device"

#define SCHEME_UUID_STRING_SIZE			46
#define UUID_STRING_SIZE				37

#define MIN_CONF_HANDLE		-3

#define DPWS_HEADERS	0x10000000

#endif /*DC_CONSTANTS_H_*/
