#include "stdafx.h"
#include "cunit/cunit_.h"
#include "FileReader.h"
#include "FileWriter.h"

using namespace docmi;

static DWORD g_start_time;

int testFileWriter_init(void) {
	/*
	 * eXgEO[v̏
	 */
	g_start_time = GetTickCount();

	return 0;
}

int testFileWriter_term(void) {
	/*
	* eXgEO[v̌n
	*/
	printf( "\n%dmsec\n", GetTickCount() - g_start_time );

	return 0;
}

/*
 * eXg
 */

/** IVR GSPSt@Cǂݍ݁ÖٓIVRŕۑēǂݍ
 *
 */
void testFileWriter_01(void)
{
	docmi::DicomData temp;
	docmi::FileReader reader;
	docmi::FileWriter writer;
	try{
		reader.open( temp, "../test_data/gspstest.pre" );
	} catch( Exception& x ){
		printf( "[O] %s\n", x.message().c_str() );
		AssertTrue( 0 );
	}

	try{
		writer.save( temp, "../test_data/gspstest_save.pre" );
	} catch( Exception& x ){
		printf( "[O] %s\n", x.message().c_str() );
		AssertTrue( 0 );
	}

	temp.clear();

	docmi::DicomData file_data;
	try{
		reader.open( file_data, "../test_data/gspstest_save.pre" );
	} catch( Exception& x ){
		printf( "[O] %s\n", x.message().c_str() );
		AssertTrue( 0 );
	}

	AssertStringEqual( file_data.getTransferSyntaxUid(), "1.2.840.10008.1.2" );
	AssertNstringEqual( file_data.getMediaStorageSopClassUid(), "1.2.840.10008.5.1.4.1.1.11.1", 28 );

	const Element* e = file_data.search( 0x0018, 0x1600 );
	AssertNstringEqual( e->data(), "RECTANGULAR ", 12 );
	AssertEqual( e->groupID(), 0x0018 );
	AssertEqual( e->elementID(), 0x1600 );

	// V[PX\̗vf擾
	e = file_data.search( 0x0008, 0x1115 );
	const Sequence* s = e->getSequence( 0 );
	AssertPtrNotNull( s );
	e = s->search( 0x0020, 0x000e );
	AssertNstringEqual( e->data(), "3285862275359441965518310819367381011862462274320", 49 );

	// vf擾
	e = file_data.search( 0x1234, 0x5678 );
	AssertPtrNull( e );

	const Element* e2 = file_data.search( 0x0002, 0x0002 );
	AssertPtrEqual( e2, NULL );

	e2 = file_data.search( 0x0018, 0x1600 );
	AssertNstringEqual( e2->data(), "RECTANGULAR ", 12 );
	AssertEqual( e2->groupID(), 0x0018 );
	AssertEqual( e2->elementID(), 0x1600 );

	// V[PX\̗vf擾
	e2 = file_data.search( 0x0008, 0x1115 );
	s = e2->getSequence( 0 );
	AssertPtrNotNull( s );
	e2 = s->search( 0x0020, 0x000e );
	AssertNstringEqual( e2->data(), "3285862275359441965518310819367381011862462274320", 49 );

	// vf
	AssertEqual( file_data.getElements()->size(), 38 );

	// VR̔
	AssertTrue( file_data.search( 0x0008, 0x0016 )->isStringVR() );
	AssertFalse( file_data.search( 0x0018, 0x1622 )->isStringVR() );
}

/** IVR GSPSt@Cǂݍ݁IVRŕۑēǂݍ
 *
 */
void testFileWriter_02(void)
{
	docmi::DicomData temp;
	docmi::FileReader reader;
	docmi::FileWriter writer;
	try{
		reader.open( temp, "../test_data/gspstest.pre" );
	} catch( Exception& x ){
		printf( "[O] %s\n", x.message().c_str() );
		AssertTrue( 0 );
	}

	try{
		writer.setFileType( docmi::FileWriter::TYPE_EXPLICIT_LITTLE );
		writer.setTransferSyntax( "1.2.840.10008.1.2.1" );
		writer.setImplementationClassUid( "987.654.321" );
		writer.setImplementationVersionName( "DOCMITEST" );
		
		writer.save( temp, "../test_data/gspstest_save_ex.pre" );
	} catch( Exception& x ){
		printf( "[O] %s\n", x.message().c_str() );
		AssertTrue( 0 );
	}

	temp.clear();

	docmi::DicomData file_data;
	try{
		reader.open( file_data, "../test_data/gspstest_save_ex.pre" );
	} catch( Exception& x ){
		printf( "[O] %s\n", x.message().c_str() );
		AssertTrue( 0 );
	}

	AssertStringEqual( file_data.getTransferSyntaxUid(), "1.2.840.10008.1.2.1" );
	AssertStringEqual( file_data.getImplementationClassUid(), "987.654.321" );
	AssertStringEqual( file_data.getImplementationVersionName(), "DOCMITEST " );

	AssertNstringEqual( file_data.getMediaStorageSopClassUid(), "1.2.840.10008.5.1.4.1.1.11.1", 28 );

	const Element* e = file_data.search( 0x0018, 0x1600 );
	AssertNstringEqual( e->data(), "RECTANGULAR ", 12 );
	AssertEqual( e->groupID(), 0x0018 );
	AssertEqual( e->elementID(), 0x1600 );

	// V[PX\̗vf擾
	e = file_data.search( 0x0008, 0x1115 );
	const Sequence* s = e->getSequence( 0 );
	AssertPtrNotNull( s );
	e = s->search( 0x0020, 0x000e );
	AssertNstringEqual( e->data(), "3285862275359441965518310819367381011862462274320", 49 );

	// vf擾
	e = file_data.search( 0x1234, 0x5678 );
	AssertPtrNull( e );

	const Element* e2 = file_data.search( 0x0002, 0x0002 );
	AssertPtrEqual( e2, NULL );

	e2 = file_data.search( 0x0018, 0x1600 );
	AssertNstringEqual( e2->data(), "RECTANGULAR ", 12 );
	AssertEqual( e2->groupID(), 0x0018 );
	AssertEqual( e2->elementID(), 0x1600 );

	// V[PX\̗vf擾
	e2 = file_data.search( 0x0008, 0x1115 );
	s = e2->getSequence( 0 );
	AssertPtrNotNull( s );
	e2 = s->search( 0x0020, 0x000e );
	AssertNstringEqual( e2->data(), "3285862275359441965518310819367381011862462274320", 49 );

	// vf
	AssertEqual( file_data.getElements()->size(), 38 );

	// VR̔
	AssertTrue( file_data.search( 0x0008, 0x0016 )->isStringVR() );
	AssertFalse( file_data.search( 0x0018, 0x1622 )->isStringVR() );
}

// O[vvZeXg
void testFileWriter_03(void)
{
	ConcreteSequence temp;
	docmi::FileWriter writer;

	int grouplen = 0;
	temp.modifyElement( ConcreteElement( 0x0002, 0x0000, (uchar*)&grouplen, 4 ) );

	AssertEqual( 0, writer.calcGroupLen( 0x0002, false, &temp ) );

	uchar infover[2] = { 0, 1 };
	temp.modifyElement( ConcreteElement( 0x0002, 0x0001, (uchar*)&infover, 2 ) );

	AssertEqual( 10, writer.calcGroupLen( 0x0002, false, &temp ) );
	AssertEqual( 14, writer.calcGroupLen( 0x0002, true, &temp ) );

	temp.modifyElement( ConcreteElement( 0x0002, 0x0010, (uchar*)"1.2.840.10008.1.2", 18 ) );
	AssertEqual( 36, writer.calcGroupLen( 0x0002, false, &temp ) );
	AssertEqual( 40, writer.calcGroupLen( 0x0002, true, &temp ) );
	AssertEqual( 52, writer.calcGroupLen( 0xFFFF, true, &temp ) );

	// V[PX\̃eXg
	AssertEqual( 0, writer.calcGroupLen( 0x0008, false, &temp ) );
	AssertEqual( 0, writer.calcGroupLen( 0x0008, true, &temp ) );

	uchar studydate[] = "20050627";
	temp.modifyElement( ConcreteElement( 0x0008, 0x0020, studydate, 8 ) );

	AssertEqual( 16, writer.calcGroupLen( 0x0008, false, &temp ) );
	AssertEqual( 16, writer.calcGroupLen( 0x0008, true, &temp ) );

	ConcreteElement e( 0x0008, 0x0082, NULL, 0 );

	{
		ConcreteSequence inner_sq;
		uchar name[] = "Tanaka^Ichiro ";
		inner_sq.modifyElement( ConcreteElement( 0x0010, 0x0010, name, 14 ) );
		uchar id[] = "0001";
		inner_sq.modifyElement( ConcreteElement( 0x0010, 0x0020, id, 4 ) );

		e.addSequence( inner_sq );
	}

	{
		ConcreteSequence inner_sq;
		uchar name[] = "Suzuki^Hana ";
		inner_sq.modifyElement( ConcreteElement( 0x0010, 0x0010, name, 12 ) );
		uchar id[] = "0002";
		inner_sq.modifyElement( ConcreteElement( 0x0010, 0x0020, id, 4 ) );

		e.addSequence( inner_sq );
	}
	temp.modifyElement( e );

	AssertEqual( 130, writer.calcGroupLen( 0x0008, false, &temp ) );
	AssertEqual( 134, writer.calcGroupLen( 0x0008, true, &temp ) );

	// JvZf[^̃eXg
	e.clear();
	e.setGroupID( 0x7fe0 );
	e.setElementID( 0x0010 );
	unsigned char image[256];
	for( int i=0; i < sizeof( image ); i++ ){
		image[i] = i;
	}

	e.addSequence( ConcreteSequence( image, 32 ) );
	e.addSequence( ConcreteSequence( image, 16 ) );
	e.addSequence( ConcreteSequence( image, 20 ) );

	temp.modifyElement( e );

	AssertEqual( 132, writer.calcGroupLen( 0x7fe0, false, &temp ) );
	AssertEqual( 136, writer.calcGroupLen( 0x7fe0, true, &temp ) );
}


/** ÖٓIVRt@Cǂݍ݃eXg
 */
void testFileWriter_04(void)
{
	docmi::DicomData temp;
	docmi::FileReader reader;
	docmi::FileWriter writer;
	try{
		reader.open( temp, "../test_data/MR.6779.1.dcm" );
	} catch( Exception& x ){
		printf( "[O] %s\n", x.message().c_str() );
		AssertTrue( 0 );
	}

	try{
		writer.save( temp, "../test_data/MR.6779.1_save.dcm" );
	} catch( Exception& x ){
		printf( "[O] %s\n", x.message().c_str() );
		AssertTrue( 0 );
	}

	temp.clear();

	docmi::DicomData data;
	try{
		reader.open( data, "../test_data/MR.6779.1_save.dcm" );
	} catch( Exception& x ){
		printf( "[O] %s\n", x.message().c_str() );
		AssertTrue( 0 );
	}
}

/** JvZ\t@CÖٓIVRŕۑ(DICOMᔽ)
 */
void testFileWriter_05(void)
{
	docmi::DicomData temp;
	docmi::FileReader reader;
	docmi::FileWriter writer;
	try{
		reader.open( temp, "../test_data/data/XA000115" );
	} catch( Exception& x ){
		printf( "[O] %s\n", x.message().c_str() );
		AssertTrue( 0 );
	}

	try{
		writer.setImplementationClassUid( "987.654.321" );
		writer.save( temp, "../test_data/data/XA000115_save" );
	} catch( Exception& x ){
		printf( "[O] %s\n", x.message().c_str() );
		AssertTrue( 0 );
	}

	temp.clear();

	docmi::DicomData data;
	try{
		reader.open( data, "../test_data/data/XA000115_save" );
	} catch( Exception& x ){
		printf( "[O] %s\n", x.message().c_str() );
		AssertTrue( 0 );
	}

	// ^
	AssertStringEqual( data.getMediaStorageSopClassUid(), "1.2.840.10008.5.1.4.1.1.12.1" );
	AssertStringEqual( data.getMediaStorageSopInstanceUid(), "387603395610544201041881281124" );
	AssertStringEqual( data.getTransferSyntaxUid(), "1.2.840.10008.1.2" );
	AssertStringEqual( data.getImplementationClassUid(), "987.654.321" );

	const Element* e = data.search( 0x7fe0, 0x0010 );
	AssertEqual( e->getSequences()->size(), 120 );

	AssertStringEqual( data.getString( 0x0008, 0x0070 ), "Manufacturer  " );

	uchar buf[30];

	//AssertNstringEqual( data.getString( 0x0008, 0x1050 ), "Ver", 3 );

	e = data.search( 0x0008, 0x1050 );
	AssertEqual( e->length(), 10 );
	AssertEqual( e->size(), 10 );
	AssertEqual( e->getPart( buf, 0, 3 ), 3 );
	AssertNstringEqual( buf, "Per", 3 );
	AssertEqual( e->getPart( buf, 9, 3 ), 1 );
	AssertNstringEqual( buf, " ", 1 );
	AssertEqual( e->getPart( buf, 10, 5 ), 0 );
	AssertEqual( e->getPart( buf, 30, 1 ), 0 );
	AssertEqual( e->getPart( buf, -1, 3 ), 0 );

	e = data.search( 0x7fe0, 0x0010 );
	AssertEqual( (*e->getSequences())[1]->getPart( buf, 0, 10 ), 10 );
	uchar expect_data[] = { 0xFF, 0xD8, 0xFF, 0xC3, 0x00, 0x0B, 0x08, 0x02, 0x00, 0x02 };
	AssertNstringEqual( buf, expect_data, 10 );

	AssertEqual( (*e->getSequences())[0]->getPart( buf, 473, 3 ), 3 );
	AssertEqual( (*e->getSequences())[0]->getPart( buf, 474, 3 ), 2 );
	AssertEqual( (*e->getSequences())[0]->getPart( buf, 475, 3 ), 1 );
	AssertEqual( (*e->getSequences())[0]->getPart( buf, 476, 3 ), 0 );
	AssertEqual( (*e->getSequences())[0]->getPart( buf, 500, 1 ), 0 );
	AssertEqual( (*e->getSequences())[0]->getPart( buf, -1, 3 ), 0 );

	// ̐
	AssertStringEqual( e->getExplanation(), "Pixel Data" );

	
}

/** JvZ\t@C𖾎IVRŕۑ
 */
void testFileWriter_06(void)
{
	docmi::DicomData temp;
	docmi::FileReader reader;
	docmi::FileWriter writer;
	try{
		reader.open( temp, "../test_data/data/XA000115" );
	} catch( Exception& x ){
		printf( "[O] %s\n", x.message().c_str() );
		AssertTrue( 0 );
	}

	try{
		writer.setFileType( docmi::FileWriter::TYPE_EXPLICIT_LITTLE );
		writer.setTransferSyntax( "1.2.840.10008.1.2.4.70" );
		writer.setImplementationClassUid( "987.654.321" );
		writer.setImplementationVersionName( "DOCMITEST" );
		writer.save( temp, "../test_data/data/XA000115_save_ex" );
	} catch( Exception& x ){
		printf( "[O] %s\n", x.message().c_str() );
		AssertTrue( 0 );
	}

	temp.clear();

	docmi::DicomData data;
	try{
		reader.open( data, "../test_data/data/XA000115_save_ex" );
	} catch( Exception& x ){
		printf( "[O] %s\n", x.message().c_str() );
		AssertTrue( 0 );
	}

	// ^
	AssertStringEqual( data.getMediaStorageSopClassUid(), "1.2.840.10008.5.1.4.1.1.12.1" );
	AssertStringEqual( data.getMediaStorageSopInstanceUid(), "387603395610544201041881281124" );
	AssertStringEqual( data.getTransferSyntaxUid(), "1.2.840.10008.1.2.4.70" );
	AssertStringEqual( data.getImplementationClassUid(), "987.654.321" );



	const Element* e = data.search( 0x7fe0, 0x0010 );
	AssertEqual( e->getSequences()->size(), 120 );

	AssertStringEqual( data.getString( 0x0008, 0x0070 ), "Manufacturer  " );

	uchar buf[30];

	//AssertNstringEqual( data.getString( 0x0008, 0x1050 ), "Ver", 3 );

	e = data.search( 0x0008, 0x1050 );
	AssertEqual( e->length(), 10 );
	AssertEqual( e->size(), 10 );
	AssertEqual( e->getPart( buf, 0, 3 ), 3 );
	AssertNstringEqual( buf, "Per", 3 );
	AssertEqual( e->getPart( buf, 9, 3 ), 1 );
	AssertNstringEqual( buf, " ", 1 );
	AssertEqual( e->getPart( buf, 10, 5 ), 0 );
	AssertEqual( e->getPart( buf, 30, 1 ), 0 );
	AssertEqual( e->getPart( buf, -1, 3 ), 0 );

	e = data.search( 0x7fe0, 0x0010 );
	AssertEqual( (*e->getSequences())[1]->getPart( buf, 0, 10 ), 10 );
	uchar expect_data[] = { 0xFF, 0xD8, 0xFF, 0xC3, 0x00, 0x0B, 0x08, 0x02, 0x00, 0x02 };
	AssertNstringEqual( buf, expect_data, 10 );

	AssertEqual( (*e->getSequences())[0]->getPart( buf, 473, 3 ), 3 );
	AssertEqual( (*e->getSequences())[0]->getPart( buf, 474, 3 ), 2 );
	AssertEqual( (*e->getSequences())[0]->getPart( buf, 475, 3 ), 1 );
	AssertEqual( (*e->getSequences())[0]->getPart( buf, 476, 3 ), 0 );
	AssertEqual( (*e->getSequences())[0]->getPart( buf, 500, 1 ), 0 );
	AssertEqual( (*e->getSequences())[0]->getPart( buf, -1, 3 ), 0 );

	// ̐
	AssertStringEqual( e->getExplanation(), "Pixel Data" );

	
}

/** IVR GSPSt@Cǂݍ݁lύXÖٓIVRŕۑēǂݍ
 *
 */
void testFileWriter_07(void)
{
	docmi::DicomData temp;
	docmi::FileReader reader;
	docmi::FileWriter writer;
	try{
		reader.open( temp, "../test_data/gspstest.pre" );
	} catch( Exception& x ){
		printf( "[O] %s\n", x.message().c_str() );
		AssertTrue( 0 );
	}

	AssertStringEqual( temp.getString( 0x0008, 0x0020 ), "20050909" );
	AssertStringEqual( temp.getString( 0x0008, 0x0030 ), "000000" );

	Element* e = temp.search( 0x0008, 0x0020 );
	e->setSpaceendString( "20050628" );

	temp.modifyElement( ConcreteElement( 0x0008, 0x0030, (uchar*)"154900", 6 ) );

	unsigned char image[256];
	// JvZf[^̃eXg
	{
		ConcreteElement e;
		e.setGroupID( 0x7fe0 );
		e.setElementID( 0x0010 );
		
		for( int i=0; i < sizeof( image ); i++ ){
			image[i] = i;
		}

		e.addSequence( ConcreteSequence( image, 32 ) );
		e.addSequence( ConcreteSequence() );
		temp.modifyElement( e );
	}

	e = temp.search( 0x7fe0, 0x0010 );
	Sequence* s = e->getSequence( 1 );
	s->setData( image, 16 );
	e->addSequence( ConcreteSequence( image, 23 ) );

	try{
		writer.save( temp, "../test_data/gspstest_save_1.pre" );
	} catch( Exception& x ){
		printf( "[O] %s\n", x.message().c_str() );
		AssertTrue( 0 );
	}

	temp.clear();

	docmi::DicomData file_data;
	try{
		reader.open( file_data, "../test_data/gspstest_save_1.pre" );
	} catch( Exception& x ){
		printf( "[O] %s\n", x.message().c_str() );
		AssertTrue( 0 );
	}

	AssertStringEqual( file_data.getString( 0x0008, 0x0020 ), "20050628" );
	AssertStringEqual( file_data.getString( 0x0008, 0x0030 ), "154900" );
	
	
	const Element* ce = file_data.search( 0x7fe0, 0x0010 );
	const Sequence* cs = ce->getSequence( 0 );
	AssertEqual( cs->length(), 32 );
	AssertTrue( memcmp( cs->data(), &image, 32 ) == 0 );
	cs = ce->getSequence( 1 );
	AssertEqual( cs->length(), 16 );
	AssertTrue( memcmp( cs->data(), &image, 16 ) == 0 );
	cs = ce->getSequence( 2 );
	AssertEqual( cs->length(), 24 );
	AssertTrue( memcmp( cs->data(), &image, 23 ) == 0 );
	AssertTrue( memcmp( cs->data(), &image, 24 ) != 0 );
}


/** J[f[^ۑ
 */
void testFileWriter_08(void)
{
	docmi::DicomData temp;
	docmi::FileReader reader;
	docmi::FileWriter writer;
	try{
		reader.open( temp, "../test_data/color.dcm" );
	} catch( Exception& x ){
		printf( "[O] %s\n", x.message().c_str() );
		AssertTrue( 0 );
	}

	try{
		writer.save( temp, "../test_data/color_implicit_save.dcm" );

		writer.setFileType( docmi::FileWriter::TYPE_EXPLICIT_LITTLE );
		writer.setTransferSyntax( "1.2.840.10008.1.2.1" );
		writer.save( temp, "../test_data/color_explicit_save.dcm" );
	} catch( Exception& x ){
		printf( "[O] %s\n", x.message().c_str() );
		AssertTrue( 0 );
	}

	docmi::DicomData file_data;
	try{
		reader.open( file_data, "../test_data/color_implicit_save.dcm" );
		reader.open( file_data, "../test_data/color_explicit_save.dcm" );
	} catch( Exception& x ){
		printf( "[O] %s", x.message() );
		AssertTrue( 0 );
	}
}


/*
 * eXgEO[v̓o^
 */
void testFileWriter_register()
{
	CU_Suite* pGroup = NULL;
	CU_Test*  pTest = NULL;

	pGroup = CU_add_suite("testFileWriter", testFileWriter_init, testFileWriter_term);

	CU_add_test(pGroup, "test_01", testFileWriter_01); // ÖٓIVRŕۑ
	CU_add_test(pGroup, "test_02", testFileWriter_02); // IVRŕۑ
	CU_add_test(pGroup, "test_03", testFileWriter_03); // O[vvZ
	CU_add_test(pGroup, "test_04", testFileWriter_04); // ʂMR摜ۑ
	CU_add_test(pGroup, "test_05", testFileWriter_05); // JvZꂽ摜ÖٓIVRŕۑ
	CU_add_test(pGroup, "test_06", testFileWriter_06); // JvZꂽ摜𖾎IVRŕۑ
	CU_add_test(pGroup, "test_07", testFileWriter_07); // lύXĕۑ
	CU_add_test(pGroup, "test_08", testFileWriter_08); // J[f[^

	
}
