/*
 * Test-group 'testOnDemandRead'
 */
#include "stdafx.h"
#include "cunit/cunit_.h"
#include "OnDemandFileReader.h"
#include "OnDemandDicomData.h"

using namespace docmi;

static DWORD g_start_time;


class DocmiOpenStrategy {
public:
	virtual docmi::DicomData* open( const char* path ) = 0;
};

class FileDocmiOpen : public DocmiOpenStrategy {
public:
	virtual docmi::DicomData* open( const char* path )
	{
		docmi::DicomData* file_data = new docmi::DicomData;
		docmi::FileReader reader;
		try{
			reader.open( *file_data, path );
			return file_data;
		} catch( Exception& x ){
			printf( "[O] %s\n", x.message().c_str() );
			delete file_data;
			return NULL;
		}
	}
};

class OnDemandDocmiOpen : public DocmiOpenStrategy {
public:
	virtual docmi::DicomData* open( const char* path )
	{
		docmi::OnDemandDicomData* file_data = new docmi::OnDemandDicomData;
		docmi::OnDemandFileReader reader;
		try{
			reader.open( *file_data, path );
			return file_data;
		} catch( Exception& x ){
			printf( "[O] %s\n", x.message().c_str() );
			delete file_data;
			return NULL;
		}
	}
};

static DocmiOpenStrategy* opener;

int testFileRead_init(void) {
	opener = new FileDocmiOpen;
	g_start_time = GetTickCount();
	return 0;
}

int testFileRead_term(void) {
	printf( "\n%dmsec\n", GetTickCount() - g_start_time );
	delete opener;
	opener = NULL;
	return 0;
}

int testOnDemandRead_init(void) {
	opener = new OnDemandDocmiOpen;
	g_start_time = GetTickCount();
	return 0;
}

int testOnDemandRead_term(void) {
	printf( "\n%dmsec\n", GetTickCount() - g_start_time );
	delete opener;
	opener = NULL;
	return 0;
}


/*
 * eXg
 */

/** IVR GSPSt@Cǂݍ݃eXg
 *
 */
void testRead_01(void)
{
	docmi::DicomData* data = opener->open( "../test_data/gspstest.pre" );
	if( !data ){ AssertTrue( 0 ); }

	AssertNstringEqual( data->getMediaStorageSopClassUid(), "1.2.840.10008.5.1.4.1.1.11.1", 28 );

	const Element* e = data->search( 0x0018, 0x1600 );
	AssertNstringEqual( e->data(), "RECTANGULAR ", 12 );
	AssertEqual( e->groupID(), 0x0018 );
	AssertEqual( e->elementID(), 0x1600 );

	// V[PX\̗vf擾
	e = data->search( 0x0008, 0x1115 );
	const Sequence* s = e->getSequence( 0 );
	AssertPtrNotNull( s );
	e = s->search( 0x0020, 0x000e );
	AssertNstringEqual( e->data(), "3285862275359441965518310819367381011862462274320", 49 );

	// vf擾
	e = data->search( 0x1234, 0x5678 );
	AssertPtrNull( e );

	const Element* e2 = data->search( 0x0002, 0x0002 );
	AssertPtrEqual( e2, NULL );

	e2 = data->search( 0x0018, 0x1600 );
	AssertNstringEqual( e2->data(), "RECTANGULAR ", 12 );
	AssertEqual( e2->groupID(), 0x0018 );
	AssertEqual( e2->elementID(), 0x1600 );

	// V[PX\̗vf擾
	e2 = data->search( 0x0008, 0x1115 );
	s = e2->getSequence( 0 );
	AssertPtrNotNull( s );
	e2 = s->search( 0x0020, 0x000e );
	AssertNstringEqual( e2->data(), "3285862275359441965518310819367381011862462274320", 49 );

	// vf
	AssertEqual( data->getElements()->size(), 38 );

	// VR̔
	AssertTrue( data->search( 0x0008, 0x0016 )->isStringVR() );
	AssertFalse( data->search( 0x0018, 0x1622 )->isStringVR() );

	delete data;
}

/** 擾eXg
 *
 */
void testRead_02(void)
{
	docmi::DicomData* data = opener->open( "../test_data/gspstest.pre" );
	if( !data ){ AssertTrue( 0 ); }

	//const Element* e = data->search( 0x0002, 0x0002 );
	AssertStringEqual( data->getMediaStorageSopClassUid(), "1.2.840.10008.5.1.4.1.1.11.1" );

	const Element* e = data->search( 0x0018, 0x1600 );
	AssertStringEqual( e->getString(), "RECTANGULAR " );
	AssertStringEqual( data->getString( 0x0018, 0x1600 ), "RECTANGULAR " );

	// V[PX\̗vf擾
	e = data->search( 0x0008, 0x1115 );
	AssertStringEqual( e->getSequence( 0 )->getString( 0x0020, 0x000e ), "3285862275359441965518310819367381011862462274320" );
	const Sequence* s = e->getSequence( 0 );
	AssertPtrNotNull( s );
	e = s->search( 0x0020, 0x000e );
	AssertStringEqual( e->getString(), "3285862275359441965518310819367381011862462274320" );

	// vf擾
	e = data->search( 0x1234, 0x5678 );
	AssertPtrNull( e );
	//Element e2 = data->search_copy( 0x0002, 0x0002 );
	//AssertStringEqual( e2.getString(), "1.2.840.10008.5.1.4.1.1.11.1" );
	AssertStringEqual( data->getMediaStorageSopClassUid(), "1.2.840.10008.5.1.4.1.1.11.1" );
	const Element* e2 = data->search( 0x0018, 0x1600 );
	AssertStringEqual( e2->getString(), "RECTANGULAR " );

	// V[PX\̗vf擾
	e2 = data->search( 0x0008, 0x1115 );
	s = e2->getSequence( 0 );
	AssertStringEqual( e2->getSequence( 0 )->getString( 0x0020, 0x000e ), "3285862275359441965518310819367381011862462274320" );

	AssertStringEqual( data->getString( 0x0008, 0x0013 ), "000000" );

	delete data;
}

/** ÖٓIVRt@Cǂݍ݃eXg
 */
void testRead_03(void)
{
	docmi::DicomData* data = opener->open( "../test_data/MR.6779.1.dcm" );
	if( !data ){ AssertTrue( 0 ); }
	delete data;

	data = opener->open( "../test_data/ikeda_implicit.pre" );
	if( !data ){ AssertTrue( 0 ); }
	delete data;

	data = opener->open( "../test_data/implicit_len.pre" );
	if( !data ){ AssertTrue( 0 ); }

	AssertStringEqual( data->search( 0x0008, 0x1115 )->getSequence( 0 )->search( 0x0008, 0x1140 )->getSequence( 0 )->getString( 0x0008, 0x1155 ),
		                 "1.2.276.0.7230010.3.1.4.1508893268.2496.1065762015.41" );

	delete data;

	data = opener->open( "../test_data/annotation.pre" );
	if( !data ){ AssertTrue( 0 ); }

	const Element* e = data->search( 0x0070, 0x0001 )->getSequence( 0 )->search( 0x0070, 0x0009 );
	AssertStringEqual( e->getSequence( 3 )->getString( 0x0070, 0x0023 ),
		                 "CIRCLE" );

	AssertStringEqual( e->getSequence( 1 )->getString( 0x0070, 0x0023 ),
		                 "POLYLINE" );

	delete data;
}

/** getString()eXg
 */
void testRead_04(void)
{
	docmi::DicomData* data = opener->open( "../test_data/MR.6779.1.dcm" );
	if( !data ){ AssertTrue( 0 ); }

	// UL
	//AssertStringEqual( data->getString( 0x0002, 0x0000 ), "172" );

	delete data;
}

/** JvZ\t@C
 */
void testRead_05(void)
{
	docmi::DicomData* data = opener->open( "../test_data/data/XA000115" );
	if( !data ){ AssertTrue( 0 ); }

	const Element* e = data->search( 0x7fe0, 0x0010 );
	AssertEqual( e->getSequences()->size(), 120 );

	AssertStringEqual( data->getString( 0x0008, 0x0070 ), "Manufacturer  " );

	uchar buf[30];

	//AssertNstringEqual( data->getString( 0x0008, 0x1050 ), "Ver", 3 );

	e = data->search( 0x0008, 0x1050 );
	AssertEqual( e->length(), 10 );
	AssertEqual( e->size(), 10 );
	AssertEqual( e->getPart( buf, 0, 3 ), 3 );
	AssertNstringEqual( buf, "Per", 3 );
	AssertEqual( e->getPart( buf, 9, 3 ), 1 );
	AssertNstringEqual( buf, " ", 1 );
	AssertEqual( e->getPart( buf, 10, 5 ), 0 );
	AssertEqual( e->getPart( buf, 30, 1 ), 0 );
	AssertEqual( e->getPart( buf, -1, 3 ), 0 );

	e = data->search( 0x7fe0, 0x0010 );
	AssertEqual( (*e->getSequences())[1]->getPart( buf, 0, 10 ), 10 );
	uchar expect_data[] = { 0xFF, 0xD8, 0xFF, 0xC3, 0x00, 0x0B, 0x08, 0x02, 0x00, 0x02 };
	AssertNstringEqual( buf, expect_data, 10 );

	AssertEqual( (*e->getSequences())[0]->getPart( buf, 473, 3 ), 3 );
	AssertEqual( (*e->getSequences())[0]->getPart( buf, 474, 3 ), 2 );
	AssertEqual( (*e->getSequences())[0]->getPart( buf, 475, 3 ), 1 );
	AssertEqual( (*e->getSequences())[0]->getPart( buf, 476, 3 ), 0 );
	AssertEqual( (*e->getSequences())[0]->getPart( buf, 500, 1 ), 0 );
	AssertEqual( (*e->getSequences())[0]->getPart( buf, -1, 3 ), 0 );

	// ̐
	AssertStringEqual( e->getExplanation(), "Pixel Data" );

	// ^
	AssertStringEqual( data->getMediaStorageSopClassUid(), "1.2.840.10008.5.1.4.1.1.12.1" );
	AssertStringEqual( data->getMediaStorageSopInstanceUid(), "387603395610544201041881281124" );
	AssertStringEqual( data->getTransferSyntaxUid(), "1.2.840.10008.1.2.4.70" );
	AssertStringEqual( data->getImplementationClassUid(), "998.998" );

	delete data;
}

/** DICOMt@CȂt@C
 */
void testRead_06(void)
{
	docmi::DicomData* data = opener->open( "../test_data/data/dump.txt" );
	if( data ){ // ǂݍ݂Ɏs͂
		delete data;
		AssertTrue( 0 );
	}

	data = opener->open( "" );
	if( data ){ // ǂݍ݂Ɏs͂
		delete data;
		AssertTrue( 0 );
	}
}



/*
 * eXgEO[v̓o^
 */
void testFileReader_register()
{
	CU_Suite* pGroup = NULL;
	CU_Test*  pTest = NULL;

	pGroup = CU_add_suite("testFileRead", testFileRead_init, testFileRead_term);
	pTest = CU_add_test(pGroup, "test_01", testRead_01);
	pTest = CU_add_test(pGroup, "test_02", testRead_02);
	pTest = CU_add_test(pGroup, "test_03", testRead_03);
	pTest = CU_add_test(pGroup, "test_04", testRead_04);
	pTest = CU_add_test(pGroup, "test_05", testRead_05);
	pTest = CU_add_test(pGroup, "test_06", testRead_06);


	pGroup = CU_add_suite("testOnDemandRead", testOnDemandRead_init, testOnDemandRead_term);
	pTest = CU_add_test(pGroup, "test_01", testRead_01);
	pTest = CU_add_test(pGroup, "test_02", testRead_02);
	pTest = CU_add_test(pGroup, "test_03", testRead_03);
	pTest = CU_add_test(pGroup, "test_04", testRead_04);
	pTest = CU_add_test(pGroup, "test_05", testRead_05);
	pTest = CU_add_test(pGroup, "test_06", testRead_06);
}
