#include "stdafx.h"
#include "cunit/cunit_.h"
#include "OnDemandFileReader.h"
#include "OnDemandDicomData.h"

using namespace docmi;

int testElementManipulation_init(){
	return 0;
}

int testElementManipulation_term(){
	return 0;
}

static void test_01(void)
{
	ConcreteSequence root;

	// Elementǉ
	root.modifyElement( ConcreteElement( 0x0008, 0x0020 ) );
	Element* e = root.search( 0x0008, 0x0020 );
	AssertPtrNotNull( e );

	// V[PXǉ
	e->addSequence( ConcreteSequence() );
	e->addSequence( ConcreteSequence() );
	e->addSequence( ConcreteSequence() );
	AssertEqual( e->getSequenceCount(), 3 );

	// V[PX폜
	e->deleteSequence( 1 );
	AssertEqual( e->getSequenceCount(), 2 );

	// Element폜
	root.deleteElement( 0x0008, 0x0020 );
	AssertPtrNull( root.search( 0x0008, 0x0020 ) );

}

/*
 * eXgEO[v̓o^
 */
void testElementManipulation_register()
{
	CU_Suite* pGroup = NULL;
	CU_Test*  pTest = NULL;

	pGroup = CU_add_suite("testElementManipulation", testElementManipulation_init, testElementManipulation_term );
	pTest = CU_add_test(pGroup, "test_01", test_01);
}
