#ifndef INCLUDE_DOCMI_ONDEMAND_FILE_READER_H
#define INCLUDE_DOCMI_ONDEMAND_FILE_READER_H

#include "FileReader.h"
#include "OnDemandDicomData.h"

namespace docmi {

class OnDemandFileReader : FileReader
{
	FileInputController* m_file_input;

public:

	/** DICOMt@CJ
	 *
	 *  throw Exception
	 */
	void open( OnDemandDicomData& data, const char* path ){
		m_path = path;
		data.clear();
		data.setPath( path );
		data.open();
		m_file_len = GetFileSize( path );

		try{
			m_input = &data.getInput();
			m_file_input = &data.getInput();

			doLoad( data );
		} catch( Exception& x ){
			data.close();
			throw x;
		}

		data.close();
	}

protected:

	virtual void setData2Sequence( ConcreteSequence& s, int& sequence_length, int data_length )
	{
		s.setFileOffset( m_file_input, m_file_input->getOffset(), data_length );
		sequence_length += data_length;
		m_file_input->seek_cur( data_length );
	}


	virtual void setData2Element( ConcreteElement& e, int& element_length, int data_length )
	{
#if 0
		// SvfKvɂȂ܂œǂݍ܂Ȃ
		e.setFileOffset( m_file_input, m_file_input->getOffset(), data_length );
		m_file_input->seek_cur( data_length );
		element_length += data_length;
#else

		// 摜̂ݕKvɂȂ܂œǂݍ܂Ȃ
		if( e.groupID() == 0x7fe0 && e.elementID() == 0x0010 ){
			e.setFileOffset( m_file_input, m_file_input->getOffset(), data_length );
			m_file_input->seek_cur( data_length );
			element_length += data_length;
		} else {
			uchar* data = new uchar[data_length];
			readFile( data, data_length );
			element_length += data_length;
			e.setData( data, data_length );
			delete [] data;
		}
#endif
	}

};

} // namespace docmi

#endif
