#ifndef INCLUDE_DOCMI_ELEMENT_H
#define INCLUDE_DOCMI_ELEMENT_H

#include "Base.h"
#include <vector>
#include <list>
#include <string>
#include "Dictionary.h"

namespace docmi{

class Sequence;
typedef std::vector<Sequence*> Sequences;

// DICOMvf
class Element
{
protected:
	ushort m_group_id;
	ushort m_element_id;
	Sequences m_sequences;
	Dictionary* m_dictionary;

private:
	void copy( const Element& rhs );
public:

	virtual Element* clone() const = 0;

protected:

	// RXgN^
	Element( ushort group_id = 0, ushort element_id = 0 ){
		m_group_id = group_id;
		m_element_id = element_id;
		m_dictionary = Dictionary::Create();
	}

	Element( const Element& rhs ){
		copy( rhs );
		m_dictionary = Dictionary::Create();
	}

public:

	virtual ~Element(){
		clear();
		m_dictionary->Release();
	}

	ushort groupID() const{ return m_group_id; }
	ushort elementID() const{ return m_element_id; }
	

	void setGroupID( ushort group_id ){
		m_group_id = group_id;
	}

	void setElementID( ushort element_id ){
		m_element_id = element_id;
	}

	// f[^
	virtual void clear();

	virtual int length() const = 0;
	int size() const { return length(); }
	virtual void setData( const uchar* data, int length ) = 0;
	void setSpaceendString( const char* str );
	void setNullendString( const char* str );

	virtual const uchar* data() const = 0;
	// ^OɊ܂܂f[^̈ꕔԂB
	virtual int getPart( uchar* buf, int start, int request_size ) const = 0;

	String getString() const;

	// V[PXǉ
	void addSequence( Sequence& s );

	// V[PX擾
	Sequences* getSequences(){ return &m_sequences; }
	const Sequences* getSequences() const { return &m_sequences; }
	Sequence* getSequence( uint index );
	const Sequence* getSequence( uint index ) const;
	int getSequenceCount(){ return m_sequences.size(); }
	void deleteSequence( uint index );

	// vf?
	bool isStringVR() const;
	bool isStringVR( const char* vr ) const;
	// SQvfH
	bool isSQVR() const;
	// 4oCgVRH
	bool is4ByteLengthVR() const;
	// vfVRԂ
	String getVR() const;
	// vf̐Ԃ
	String getExplanation() const;

private:
	Element& operator=( const Element& rhs );

};

} // namespace docmi

#include "sequence.h"

#endif // !defined(AFX_DICOMFILE_H__001044AA_534E_4FE8_91B8_2B222288D3F6__INCLUDED_)
