#include "element.h"

using namespace docmi;

Dictionary* Dictionary::m_instance = NULL;
int Dictionary::m_counter = 0;

struct VrDictionary
{
	ushort groupID;
	ushort elementID;
	char    vr[4];
	char    explanation[255];
};

static VrDictionary g_dic[] =
{
    {0x0002, 0x0000, "UL", "Group Length" },
    {0x0002, 0x0001, "OB", "File Meta Information Version" },
    {0x0002, 0x0002, "UI", "Media Storage SOP Class UID" },
    {0x0002, 0x0003, "UI", "Media Storage SOP Instance UID" },
    {0x0002, 0x0010, "UI", "Transfer Syntax UID" },
    {0x0002, 0x0012, "UI", "Implementation Class UID" },
    {0x0002, 0x0013, "SH", "Implementation Version Name" },
    {0x0002, 0x0016, "AE", "Source Application Entity Title" },
    {0x0002, 0x0100, "UI", "Private Information Creator UID" },
    {0x0002, 0x0102, "OB", "Private Information" },
    {0x0004, 0x0000, "UL", "Group Length" },
    {0x0004, 0x1130, "CS", "File-set ID" },
    {0x0004, 0x1141, "CS", "File-set Descriptor File ID" },
    {0x0004, 0x1142, "CS", "Specific Character Set of File-set Descriptor File" },
    {0x0004, 0x1200, "UL", "Offset of the First Directory Record of the Root Directory Entity" },
    {0x0004, 0x1202, "UL", "Offset of the Last Directory Record of the Root Directory Entity" },
    {0x0004, 0x1212, "US", "File-set Consistency Flag" },
    {0x0004, 0x1220, "SQ", "Directory Record Sequence" },
    {0x0004, 0x1400, "UL", "Offset of the Next Directory Record" },
    {0x0004, 0x1410, "US", "Record In-use Flag" },
    {0x0004, 0x1420, "UL", "Offset of Referenced Lower-Level Directory Entity" },
    {0x0004, 0x1430, "CS", "Directory Record Type" },
    {0x0004, 0x1432, "UI", "Private Record UID" },
    {0x0004, 0x1500, "CS", "Referenced File ID" },
    {0x0004, 0x1504, "UL", "MRDR Directory Record Offset" },
    {0x0004, 0x1510, "UI", "Referenced SOP Class UID in File" },
    {0x0004, 0x1511, "UI", "Referenced SOP Instance UID in File" },
    {0x0004, 0x1512, "UI", "Referenced Transfer Syntax UID in File" },
    {0x0004, 0x151A, "UI", "Referenced Related General SOP Class UID in File" },
    {0x0004, 0x1600, "UL", "Number of References" },
    {0x0008, 0x0005, "CS", "Specific Character Set" },
    {0x0008, 0x0008, "CS", "Image Type" },
    {0x0008, 0x0012, "DA", "Instance Creation Date" },
    {0x0008, 0x0013, "TM", "Instance Creation Time" },
    {0x0008, 0x0014, "UI", "Instance Creator UID" },
    {0x0008, 0x0016, "UI", "SOP Class UID" },
    {0x0008, 0x0018, "UI", "SOP Instance UID" },
    {0x0008, 0x001A, "UI", "Related General SOP Class UID" },
    {0x0008, 0x001B, "UI", "Original Specialized SOP Class UID" },
    {0x0008, 0x0020, "DA", "Study Date" },
    {0x0008, 0x0021, "DA", "Series Date" },
    {0x0008, 0x0022, "DA", "Acquisition Date" },
    {0x0008, 0x0023, "DA", "Content Date" },
    {0x0008, 0x0024, "DA", "Overlay Date" },
    {0x0008, 0x0025, "DA", "Curve Date" },
    {0x0008, 0x002A, "DT", "Acquisition Datetime" },
    {0x0008, 0x0030, "TM", "Study Time" },
    {0x0008, 0x0031, "TM", "Series Time" },
    {0x0008, 0x0032, "TM", "Acquisition Time" },
    {0x0008, 0x0033, "TM", "Content Time" },
    {0x0008, 0x0034, "TM", "Overlay Time" },
    {0x0008, 0x0035, "TM", "Curve Time" },
    {0x0008, 0x0042, "CS", "Nuclear Medicine Series Type" },
    {0x0008, 0x0050, "SH", "Accession Number" },
    {0x0008, 0x0052, "CS", "Query/Retrieve Level" },
    {0x0008, 0x0054, "AE", "Retrieve AE Title" },
    {0x0008, 0x0056, "CS", "Instance Availability" },
    {0x0008, 0x0058, "UI", "Failed SOP Instance UID List" },
    {0x0008, 0x0060, "CS", "Modality" },
    {0x0008, 0x0061, "CS", "Modalities in Study" },
    {0x0008, 0x0062, "UI", "SOP Classes in Study" },
    {0x0008, 0x0064, "CS", "Conversion Type" },
    {0x0008, 0x0068, "CS", "Presentation Intent Type" },
    {0x0008, 0x0070, "LO", "Manufacturer" },
    {0x0008, 0x0080, "LO", "Institution Name" },
    {0x0008, 0x0081, "ST", "Institution Address" },
    {0x0008, 0x0082, "SQ", "Institution Code Sequence" },
    {0x0008, 0x0090, "PN", "Referring Physicianfs Name" },
    {0x0008, 0x0092, "ST", "Referring Physician's Address" },
    {0x0008, 0x0094, "SH", "Referring Physicianfs Telephone Numbers" },
    {0x0008, 0x0096, "SQ", "Referring Physician Identification Sequence" },
    {0x0008, 0x0100, "SH", "Code Value" },
    {0x0008, 0x0102, "SH", "Coding Scheme Designator" },
    {0x0008, 0x0103, "SH", "Coding Scheme Version" },
    {0x0008, 0x0104, "LO", "Code Meaning" },
    {0x0008, 0x0105, "CS", "Mapping Resource" },
    {0x0008, 0x0106, "DT", "Context Group Version" },
    {0x0008, 0x0107, "DT", "Context Group Local Version" },
    {0x0008, 0x010B, "CS", "Context Group Extension Flag" },
    {0x0008, 0x010C, "UI", "Coding Scheme UID" },
    {0x0008, 0x010D, "UI", "Context Group Extension Creator UID" },
    {0x0008, 0x010F, "CS", "Context Identifier" },
    {0x0008, 0x0110, "SQ", "Coding Scheme Identification Sequence" },
    {0x0008, 0x0112, "LO", "Coding Scheme Registry" },
    {0x0008, 0x0114, "ST", "Coding Scheme External ID" },
    {0x0008, 0x0115, "ST", "Coding Scheme Name" },
    {0x0008, 0x0116, "ST", "Responsible Organization" },
    {0x0008, 0x0201, "SH", "Timezone Offset From UTC" },
    {0x0008, 0x1010, "SH", "Station Name" },
    {0x0008, 0x1030, "LO", "Study Description" },
    {0x0008, 0x1032, "SQ", "Procedure Code Sequence" },
    {0x0008, 0x103E, "LO", "Series Description" },
    {0x0008, 0x1040, "LO", "Institutional Department Name" },
    {0x0008, 0x1048, "PN", "Physician(s) of Record" },
    {0x0008, 0x1049, "SQ", "Physician(s) of Record Identification Sequence" },
    {0x0008, 0x1050, "PN", "Performing Physicianfs Name" },
    {0x0008, 0x1052, "SQ", "Performing Physician Identification Sequence" },
    {0x0008, 0x1060, "PN", "Name of Physician(s) Reading Study" },
    {0x0008, 0x1062, "SQ", "Physician(s) Reading Study Identification Sequence" },
    {0x0008, 0x1070, "PN", "Operatorsf Name" },
    {0x0008, 0x1072, "SQ", "Operator Identification Sequence" },
    {0x0008, 0x1080, "LO", "Admitting Diagnoses Description" },
    {0x0008, 0x1084, "SQ", "Admitting Diagnoses Code Sequence" },
    {0x0008, 0x1090, "LO", "Manufacturerfs Model Name" },
    {0x0008, 0x1100, "SQ", "Referenced Results Sequence" },
    {0x0008, 0x1110, "SQ", "Referenced Study Sequence" },
    {0x0008, 0x1111, "SQ", "Referenced Performed Procedure Step Sequence" },
    {0x0008, 0x1115, "SQ", "Referenced Series Sequence" },
    {0x0008, 0x1120, "SQ", "Referenced Patient Sequence" },
    {0x0008, 0x1125, "SQ", "Referenced Visit Sequence" },
    {0x0008, 0x1130, "SQ", "Referenced Overlay Sequence" },
    {0x0008, 0x113A, "SQ", "Referenced Waveform Sequence" },
    {0x0008, 0x1140, "SQ", "Referenced Image Sequence" },
    {0x0008, 0x1145, "SQ", "Referenced Curve Sequence" },
    {0x0008, 0x114A, "SQ", "Referenced Instance Sequence" },
    {0x0008, 0x1150, "UI", "Referenced SOP Class UID" },
    {0x0008, 0x1155, "UI", "Referenced SOP Instance UID" },
    {0x0008, 0x115A, "UI", "SOP Classes Supported" },
    {0x0008, 0x1160, "IS", "Referenced Frame Number" },
    {0x0008, 0x1195, "UI", "Transaction UID" },
    {0x0008, 0x1197, "US", "Failure Reason" },
    {0x0008, 0x1198, "SQ", "Failed SOP Sequence" },
    {0x0008, 0x1199, "SQ", "Referenced SOP Sequence" },
    {0x0008, 0x1200, "SQ", "Studies Containing Other Referenced Instances Sequence" },
    {0x0008, 0x1250, "SQ", "Related Series Sequence" },
    {0x0008, 0x2110, "CS", "Lossy Image Compression" },
    {0x0008, 0x2111, "ST", "Derivation Description" },
    {0x0008, 0x2112, "SQ", "Source Image Sequence" },
    {0x0008, 0x2120, "SH", "Stage Name" },
    {0x0008, 0x2122, "IS", "Stage Number" },
    {0x0008, 0x2124, "IS", "Number of Stages" },
    {0x0008, 0x2127, "SH", "View Name" },
    {0x0008, 0x2128, "IS", "View Number" },
    {0x0008, 0x2129, "IS", "Number of Event Timers" },
    {0x0008, 0x212A, "IS", "Number of Views in Stage" },
    {0x0008, 0x2130, "DS", "Event Elapsed Time(s)" },
    {0x0008, 0x2132, "LO", "Event Timer Name(s)" },
    {0x0008, 0x2142, "IS", "Start Trim" },
    {0x0008, 0x2143, "IS", "Stop Trim" },
    {0x0008, 0x2144, "IS", "Recommended Display Frame Rate" },
    {0x0008, 0x2200, "CS", "Transducer Position" },
    {0x0008, 0x2204, "CS", "Transducer Orientation" },
    {0x0008, 0x2208, "CS", "Anatomic Structure" },
    {0x0008, 0x2218, "SQ", "Anatomic Region Sequence" },
    {0x0008, 0x2220, "SQ", "Anatomic Region Modifier Sequence" },
    {0x0008, 0x2228, "SQ", "Primary Anatomic Structure Sequence" },
    {0x0008, 0x2229, "SQ", "Anatomic Structure, Space or Region Sequence" },
    {0x0008, 0x2230, "SQ", "Primary Anatomic Structure Modifier Sequence" },
    {0x0008, 0x2240, "SQ", "Transducer Position Sequence" },
    {0x0008, 0x2242, "SQ", "Transducer Position Modifier Sequence" },
    {0x0008, 0x2244, "SQ", "Transducer Orientation Sequence" },
    {0x0008, 0x2246, "SQ", "Transducer Orientation Modifier Sequence" },
    {0x0008, 0x3001, "SQ", "Alternate Representation Sequence" },
    {0x0008, 0x9007, "CS", "Frame Type" },
    {0x0008, 0x9092, "SQ", "Referenced Image Evidence Sequence" },
    {0x0008, 0x9121, "SQ", "Referenced Raw Data Sequence" },
    {0x0008, 0x9123, "UI", "Creator-Version UID" },
    {0x0008, 0x9124, "SQ", "Derivation Image Sequence" },
    {0x0008, 0x9154, "SQ", "Source Image Evidence Sequence" },
    {0x0008, 0x9205, "CS", "Pixel Presentation" },
    {0x0008, 0x9206, "CS", "Volumetric Properties" },
    {0x0008, 0x9207, "CS", "Volume Based Calculation Technique" },
    {0x0008, 0x9208, "CS", "Complex Image Component" },
    {0x0008, 0x9209, "CS", "Acquisition Contrast" },
    {0x0008, 0x9215, "SQ", "Derivation Code Sequence" },
    {0x0008, 0x9237, "SQ", "Referenced Grayscale Presentation State Sequence" },
    {0x0010, 0x0010, "PN", "Patientfs Name" },
    {0x0010, 0x0020, "LO", "Patient ID" },
    {0x0010, 0x0021, "LO", "Issuer of Patient ID" },
    {0x0010, 0x0030, "DA", "Patient's Birth Date" },
    {0x0010, 0x0032, "TM", "Patient's Birth Time" },
    {0x0010, 0x0040, "CS", "Patient's Sex" },
    {0x0010, 0x0050, "SQ", "Patient's Insurance Plan Code Sequence" },
    {0x0010, 0x0101, "SQ", "Patientfs Primary Language Code Sequence" },
    {0x0010, 0x0102, "SQ", "Patientfs Primary Language Code Modifier Sequence" },
    {0x0010, 0x1000, "LO", "Other Patient IDs" },
    {0x0010, 0x1001, "PN", "Other Patient Names" },
    {0x0010, 0x1005, "PN", "Patient's Birth Name" },
    {0x0010, 0x1010, "AS", "Patient's Age" },
    {0x0010, 0x1020, "DS", "Patient's Size" },
    {0x0010, 0x1030, "DS", "Patient's Weight" },
    {0x0010, 0x1040, "LO", "Patient's Address" },
    {0x0010, 0x1060, "PN", "Patient's Mother's Birth Name" },
    {0x0010, 0x1080, "LO", "Military Rank" },
    {0x0010, 0x1081, "LO", "Branch of Service" },
    {0x0010, 0x1090, "LO", "Medical Record Locator" },
    {0x0010, 0x2000, "LO", "Medical Alerts" },
    {0x0010, 0x2110, "LO", "Contrast Allergies" },
    {0x0010, 0x2150, "LO", "Country of Residence" },
    {0x0010, 0x2152, "LO", "Region of Residence" },
    {0x0010, 0x2154, "SH", "Patientfs Telephone Numbers" },
    {0x0010, 0x2160, "SH", "Ethnic Group" },
    {0x0010, 0x2180, "SH", "Occupation" },
    {0x0010, 0x21A0, "CS", "Smoking Status" },
    {0x0010, 0x21B0, "LT", "Additional Patient History" },
    {0x0010, 0x21C0, "US", "Pregnancy Status" },
    {0x0010, 0x21D0, "DA", "Last Menstrual Date" },
    {0x0010, 0x21F0, "LO", "Patient's Religious Preference" },
    {0x0010, 0x4000, "LT", "Patient Comments" },
    {0x0012, 0x0010, "LO", "Clinical Trial Sponsor Name" },
    {0x0012, 0x0020, "LO", "Clinical Trial Protocol ID" },
    {0x0012, 0x0021, "LO", "Clinical Trial Protocol Name" },
    {0x0012, 0x0030, "LO", "Clinical Trial Site ID" },
    {0x0012, 0x0031, "LO", "Clinical Trial Site Name" },
    {0x0012, 0x0040, "LO", "Clinical Trial Subject ID" },
    {0x0012, 0x0042, "LO", "Clinical Trial Subject Reading ID" },
    {0x0012, 0x0050, "LO", "Clinical Trial Time Point ID" },
    {0x0012, 0x0051, "ST", "Clinical Trial Time Point Description" },
    {0x0012, 0x0060, "LO", "Clinical Trial Coordinating Center Name" },
    {0x0018, 0x0010, "LO", "Contrast/Bolus Agent" },
    {0x0018, 0x0012, "SQ", "Contrast/Bolus Agent Sequence" },
    {0x0018, 0x0014, "SQ", "Contrast/Bolus Administration Route Sequence" },
    {0x0018, 0x0015, "CS", "Body Part Examined" },
    {0x0018, 0x0020, "CS", "Scanning Sequence" },
    {0x0018, 0x0021, "CS", "Sequence Variant" },
    {0x0018, 0x0022, "CS", "Scan Options" },
    {0x0018, 0x0023, "CS", "MR Acquisition Type" },
    {0x0018, 0x0024, "SH", "Sequence Name" },
    {0x0018, 0x0025, "CS", "Angio Flag" },
    {0x0018, 0x0026, "SQ", "Intervention Drug Information Sequence" },
    {0x0018, 0x0027, "TM", "Intervention Drug Stop Time" },
    {0x0018, 0x0028, "DS", "Intervention Drug Dose" },
    {0x0018, 0x0029, "SQ", "Intervention Drug Sequence" },
    {0x0018, 0x002A, "SQ", "Additional Drug Sequence" },
    {0x0018, 0x0030, "LO", "Radionuclide" },
    {0x0018, 0x0031, "LO", "Radiopharmaceutical" },
    {0x0018, 0x0032, "DS", "Energy Window Centerline" },
    {0x0018, 0x0033, "DS", "Energy Window Total Width" },
    {0x0018, 0x0034, "LO", "Intervention Drug Name" },
    {0x0018, 0x0035, "TM", "Intervention Drug Start Time" },
    {0x0018, 0x0036, "SQ", "Intervention Sequence" },
    {0x0018, 0x0037, "CS", "Therapy Type" },
    {0x0018, 0x0038, "CS", "Intervention Status" },
    {0x0018, 0x0039, "CS", "Therapy Description" },
    {0x0018, 0x003A, "ST", "Intervention Description" },
    {0x0018, 0x0040, "IS", "Cine Rate" },
    {0x0018, 0x0050, "DS", "Slice Thickness" },
    {0x0018, 0x0060, "DS", "KVP" },
    {0x0018, 0x0070, "IS", "Counts Accumulated" },
    {0x0018, 0x0071, "CS", "Acquisition Termination Condition" },
    {0x0018, 0x0072, "DS", "Effective Duration" },
    {0x0018, 0x0073, "CS", "Acquisition Start Condition" },
    {0x0018, 0x0074, "IS", "Acquisition Start Condition Data" },
    {0x0018, 0x0075, "IS", "Acquisition Termination Condition Data" },
    {0x0018, 0x0080, "DS", "Repetition Time" },
    {0x0018, 0x0081, "DS", "Echo Time" },
    {0x0018, 0x0082, "DS", "Inversion Time" },
    {0x0018, 0x0083, "DS", "Number of Averages" },
    {0x0018, 0x0084, "DS", "Imaging Frequency" },
    {0x0018, 0x0085, "SH", "Imaged Nucleus" },
    {0x0018, 0x0086, "IS", "Echo Number(s)" },
    {0x0018, 0x0087, "DS", "Magnetic Field Strength" },
    {0x0018, 0x0088, "DS", "Spacing Between Slices" },
    {0x0018, 0x0089, "IS", "Number of Phase Encoding Steps" },
    {0x0018, 0x0090, "DS", "Data Collection Diameter" },
    {0x0018, 0x0091, "IS", "Echo Train Length" },
    {0x0018, 0x0093, "DS", "Percent Sampling" },
    {0x0018, 0x0094, "DS", "Percent Phase Field of View" },
    {0x0018, 0x0095, "DS", "Pixel Bandwidth" },
    {0x0018, 0x1000, "LO", "Device Serial Number" },
    {0x0018, 0x1004, "LO", "Plate ID" },
    {0x0018, 0x1010, "LO", "Secondary Capture Device ID" },
    {0x0018, 0x1011, "LO", "Hardcopy Creation Device ID" },
    {0x0018, 0x1012, "DA", "Date of Secondary Capture" },
    {0x0018, 0x1014, "TM", "Time of Secondary Capture" },
    {0x0018, 0x1016, "LO", "Secondary Capture Device Manufacturer" },
    {0x0018, 0x1017, "LO", "Hardcopy Device Manufacturer" },
    {0x0018, 0x1018, "LO", "Secondary Capture Device Manufacturerfs Model Name" },
    {0x0018, 0x1019, "LO", "Secondary Capture Device Software Version(s)" },
    {0x0018, 0x101A, "LO", "Hardcopy Device Software Version" },
    {0x0018, 0x101B, "LO", "Hardcopy Device Manfuacturer's Model Name" },
    {0x0018, 0x1020, "LO", "Software Version(s)" },
    {0x0018, 0x1022, "SH", "Video Image Format Acquired" },
    {0x0018, 0x1023, "LO", "Digital Image Format Acquired" },
    {0x0018, 0x1030, "LO", "Protocol Name" },
    {0x0018, 0x1040, "LO", "Contrast/Bolus Route" },
    {0x0018, 0x1041, "DS", "Contrast/Bolus Volume" },
    {0x0018, 0x1042, "TM", "Contrast/Bolus Start Time" },
    {0x0018, 0x1043, "TM", "Contrast/Bolus Stop Time" },
    {0x0018, 0x1044, "DS", "Contrast/Bolus Total Dose" },
    {0x0018, 0x1045, "IS", "Syringe Counts" },
    {0x0018, 0x1046, "DS", "Contrast Flow Rate" },
    {0x0018, 0x1047, "DS", "Contrast Flow Duration" },
    {0x0018, 0x1048, "CS", "Contrast/Bolus Ingredient" },
    {0x0018, 0x1049, "DS", "Contrast/Bolus Ingredient Concentration" },
    {0x0018, 0x1050, "DS", "Spatial Resolution" },
    {0x0018, 0x1060, "DS", "Trigger Time" },
    {0x0018, 0x1061, "LO", "Trigger Source or Type" },
    {0x0018, 0x1062, "IS", "Nominal Interval" },
    {0x0018, 0x1063, "DS", "Frame Time" },
    {0x0018, 0x1064, "LO", "Framing Type" },
    {0x0018, 0x1065, "DS", "Frame Time Vector" },
    {0x0018, 0x1066, "DS", "Frame Delay" },
    {0x0018, 0x1067, "DS", "Image Trigger Delay" },
    {0x0018, 0x1068, "DS", "Multiplex Group Time Offset" },
    {0x0018, 0x1069, "DS", "Trigger Time Offset" },
    {0x0018, 0x106A, "CS", "Synchronization Trigger" },
    {0x0018, 0x106C, "US", "Synchronization Channel" },
    {0x0018, 0x106E, "UL", "Trigger Sample Position" },
    {0x0018, 0x1070, "LO", "Radiopharmaceutical Route" },
    {0x0018, 0x1071, "DS", "Radiopharmaceutical Volume" },
    {0x0018, 0x1072, "TM", "Radiopharmaceutical Start Time" },
    {0x0018, 0x1073, "TM", "Radiopharmaceutical Stop Time" },
    {0x0018, 0x1074, "DS", "Radionuclide Total Dose" },
    {0x0018, 0x1075, "DS", "Radionuclide Half Life" },
    {0x0018, 0x1076, "DS", "Radionuclide Positron Fraction" },
    {0x0018, 0x1077, "DS", "Radiopharmaceutical Specific Activity" },
    {0x0018, 0x1080, "CS", "Beat Rejection Flag" },
    {0x0018, 0x1081, "IS", "Low R-R Value" },
    {0x0018, 0x1082, "IS", "High R-R Value" },
    {0x0018, 0x1083, "IS", "Intervals Acquired" },
    {0x0018, 0x1084, "IS", "Intervals Rejected" },
    {0x0018, 0x1085, "LO", "PVC Rejection" },
    {0x0018, 0x1086, "IS", "Skip Beats" },
    {0x0018, 0x1088, "IS", "Heart Rate" },
    {0x0018, 0x1090, "IS", "Cardiac Number of Images" },
    {0x0018, 0x1094, "IS", "Trigger Window" },
    {0x0018, 0x1100, "DS", "Reconstruction Diameter" },
    {0x0018, 0x1110, "DS", "Distance Source to Detector" },
    {0x0018, 0x1111, "DS", "Distance Source to Patient" },
    {0x0018, 0x1114, "DS", "Estimated Radiographic Magnification Factor" },
    {0x0018, 0x1120, "DS", "Gantry/Detector Tilt" },
    {0x0018, 0x1121, "DS", "Gantry/Detector Slew" },
    {0x0018, 0x1130, "DS", "Table Height" },
    {0x0018, 0x1131, "DS", "Table Traverse" },
    {0x0018, 0x1134, "CS", "Table Motion" },
    {0x0018, 0x1135, "DS", "Table Vertical Increment" },
    {0x0018, 0x1136, "DS", "Table Lateral Increment" },
    {0x0018, 0x1137, "DS", "Table Longitudinal Increment" },
    {0x0018, 0x1138, "DS", "Table Angle" },
    {0x0018, 0x113A, "CS", "Table Type" },
    {0x0018, 0x1140, "CS", "Rotation Direction" },
    {0x0018, 0x1141, "DS", "Angular Position" },
    {0x0018, 0x1142, "DS", "Radial Position" },
    {0x0018, 0x1143, "DS", "Scan Arc" },
    {0x0018, 0x1144, "DS", "Angular Step" },
    {0x0018, 0x1145, "DS", "Center of Rotation Offset" },
    {0x0018, 0x1146, "DS", "Rotation Offset" },
    {0x0018, 0x1147, "CS", "Field of View Shape" },
    {0x0018, 0x1149, "IS", "Field of View Dimension(s)" },
    {0x0018, 0x1150, "IS", "Exposure Time" },
    {0x0018, 0x1151, "IS", "X-ray Tube Current" },
    {0x0018, 0x1152, "IS", "Exposure" },
    {0x0018, 0x1153, "IS", "Exposure in uAs" },
    {0x0018, 0x1154, "DS", "Average Pulse Width" },
    {0x0018, 0x1155, "CS", "Radiation Setting" },
    {0x0018, 0x1156, "CS", "Rectification Type" },
    {0x0018, 0x115A, "CS", "Radiation Mode" },
    {0x0018, 0x115E, "DS", "Image Area Dose Product" },
    {0x0018, 0x1160, "SH", "Filter Type" },
    {0x0018, 0x1161, "LO", "Type of Filters" },
    {0x0018, 0x1162, "DS", "Intensifier Size" },
    {0x0018, 0x1164, "DS", "Imager Pixel Spacing" },
    {0x0018, 0x1166, "CS", "Grid" },
    {0x0018, 0x1170, "IS", "Generator Power" },
    {0x0018, 0x1180, "SH", "Collimator/grid Name" },
    {0x0018, 0x1181, "CS", "Collimator Type" },
    {0x0018, 0x1182, "IS", "Focal Distance" },
    {0x0018, 0x1183, "DS", "X Focus Center" },
    {0x0018, 0x1184, "DS", "Y Focus Center" },
    {0x0018, 0x1190, "DS", "Focal Spot(s)" },
    {0x0018, 0x1191, "CS", "Anode Target Material" },
    {0x0018, 0x11A0, "DS", "Body Part Thickness" },
    {0x0018, 0x11A2, "DS", "Compression Force" },
    {0x0018, 0x1200, "DA", "Date of Last Calibration" },
    {0x0018, 0x1201, "TM", "Time of Last Calibration" },
    {0x0018, 0x1210, "SH", "Convolution Kernel" },
    {0x0018, 0x1242, "IS", "Actual Frame Duration" },
    {0x0018, 0x1243, "IS", "Count Rate" },
    {0x0018, 0x1244, "US", "Preferred Playback Sequencing" },
    {0x0018, 0x1250, "SH", "Receive Coil Name" },
    {0x0018, 0x1251, "SH", "Transmit Coil Name" },
    {0x0018, 0x1260, "SH", "Plate Type" },
    {0x0018, 0x1261, "LO", "Phosphor Type" },
    {0x0018, 0x1300, "DS", "Scan Velocity" },
    {0x0018, 0x1301, "CS", "Whole Body Technique" },
    {0x0018, 0x1302, "IS", "Scan Length" },
    {0x0018, 0x1310, "US", "Acquisition Matrix" },
    {0x0018, 0x1312, "CS", "In-plane Phase Encoding Direction" },
    {0x0018, 0x1314, "DS", "Flip Angle" },
    {0x0018, 0x1315, "CS", "Variable Flip Angle Flag" },
    {0x0018, 0x1316, "DS", "SAR" },
    {0x0018, 0x1318, "DS", "dB/dt" },
    {0x0018, 0x1400, "LO", "Acquisition Device Processing Description" },
    {0x0018, 0x1401, "LO", "Acquisition Device Processing Code" },
    {0x0018, 0x1402, "CS", "Cassette Orientation" },
    {0x0018, 0x1403, "CS", "Cassette Size" },
    {0x0018, 0x1404, "US", "Exposures on Plate" },
    {0x0018, 0x1405, "IS", "Relative X-ray Exposure" },
    {0x0018, 0x1450, "DS", "Column Angulation" },
    {0x0018, 0x1460, "DS", "Tomo Layer Height" },
    {0x0018, 0x1470, "DS", "Tomo Angle" },
    {0x0018, 0x1480, "DS", "Tomo Time" },
    {0x0018, 0x1490, "CS", "Tomo Type" },
    {0x0018, 0x1491, "CS", "Tomo Class" },
    {0x0018, 0x1495, "IS", "Number of Tomosynthesis Source Images" },
    {0x0018, 0x1500, "CS", "Positioner Motion" },
    {0x0018, 0x1508, "CS", "Positioner Type" },
    {0x0018, 0x1510, "DS", "Positioner Primary Angle" },
    {0x0018, 0x1511, "DS", "Positioner Secondary Angle" },
    {0x0018, 0x1520, "DS", "Positioner Primary Angle Increment" },
    {0x0018, 0x1521, "DS", "Positioner Secondary Angle Increment" },
    {0x0018, 0x1530, "DS", "Detector Primary Angle" },
    {0x0018, 0x1531, "DS", "Detector Secondary Angle" },
    {0x0018, 0x1600, "CS", "Shutter Shape" },
    {0x0018, 0x1602, "IS", "Shutter Left Vertical Edge" },
    {0x0018, 0x1604, "IS", "Shutter Right Vertical Edge" },
    {0x0018, 0x1606, "IS", "Shutter Upper Horizontal Edge" },
    {0x0018, 0x1608, "IS", "Shutter Lower Horizontal Edge" },
    {0x0018, 0x1610, "IS", "Center of Circular Shutter" },
    {0x0018, 0x1612, "IS", "Radius of Circular Shutter" },
    {0x0018, 0x1620, "IS", "Vertices of the Polygonal Shutter" },
    {0x0018, 0x1622, "US", "Shutter Presentation Value" },
    {0x0018, 0x1623, "US", "Shutter Overlay Group" },
    {0x0018, 0x1700, "CS", "Collimator Shape" },
    {0x0018, 0x1702, "IS", "Collimator Left Vertical Edge" },
    {0x0018, 0x1704, "IS", "Collimator Right Vertical Edge" },
    {0x0018, 0x1706, "IS", "Collimator Upper Horizontal Edge" },
    {0x0018, 0x1708, "IS", "Collimator Lower Horizontal Edge" },
    {0x0018, 0x1710, "IS", "Center of Circular Collimator" },
    {0x0018, 0x1712, "IS", "Radius of Circular Collimator" },
    {0x0018, 0x1720, "IS", "Vertices of the Polygonal Collimator" },
    {0x0018, 0x1800, "CS", "Acquisition Time Synchronized" },
    {0x0018, 0x1801, "SH", "Time Source" },
    {0x0018, 0x1802, "CS", "Time Distribution Protocol" },
    {0x0018, 0x1803, "LO", "NTP Source Address" },
    {0x0018, 0x2001, "IS", "Page Number Vector" },
    {0x0018, 0x2002, "SH", "Frame Label Vector" },
    {0x0018, 0x2003, "DS", "Frame Primary Angle Vector" },
    {0x0018, 0x2004, "DS", "Frame Secondary Angle Vector" },
    {0x0018, 0x2005, "DS", "Slice Location Vector" },
    {0x0018, 0x2006, "SH", "Display Window Label Vector" },
    {0x0018, 0x2010, "DS", "Nominal Scanned Pixel Spacing" },
    {0x0018, 0x2020, "CS", "Digitizing Device Transport Direction" },
    {0x0018, 0x2030, "DS", "Rotation of Scanned Film" },
    {0x0018, 0x3100, "CS", "IVUS Acquisition" },
    {0x0018, 0x3101, "DS", "IVUS Pullback Rate" },
    {0x0018, 0x3102, "DS", "IVUS Gated Rate" },
    {0x0018, 0x3103, "IS", "IVUS Pullback Start Frame Number" },
    {0x0018, 0x3104, "IS", "IVUS Pullback Stop Frame Number" },
    {0x0018, 0x3105, "IS", "Lesion Number" },
    {0x0018, 0x5000, "SH", "Output Power" },
    {0x0018, 0x5010, "LO", "Transducer Data" },
    {0x0018, 0x5012, "DS", "Focus Depth" },
    {0x0018, 0x5020, "LO", "Processing Function" },
    {0x0018, 0x5021, "LO", "Postprocessing Function" },
    {0x0018, 0x5022, "DS", "Mechanical Index" },
    {0x0018, 0x5024, "DS", "Bone Thermal Index" },
    {0x0018, 0x5026, "DS", "Cranial Thermal Index" },
    {0x0018, 0x5027, "DS", "Soft Tissue Thermal Index" },
    {0x0018, 0x5028, "DS", "Soft Tissue-focus Thermal Index" },
    {0x0018, 0x5029, "DS", "Soft Tissue-surface Thermal Index" },
    {0x0018, 0x5050, "IS", "Depth of Scan Field" },
    {0x0018, 0x5100, "CS", "Patient Position" },
    {0x0018, 0x5101, "CS", "View Position" },
    {0x0018, 0x5104, "SQ", "Projection Eponymous Name Code Sequence" },
    {0x0018, 0x5210, "DS", "Image Transformation Matrix" },
    {0x0018, 0x5212, "DS", "Image Translation Vector" },
    {0x0018, 0x6000, "DS", "Sensitivity" },
    {0x0018, 0x6011, "SQ", "Sequence of Ultrasound Regions" },
    {0x0018, 0x6012, "US", "Region Spatial Format" },
    {0x0018, 0x6014, "US", "Region Data Type" },
    {0x0018, 0x6016, "UL", "Region Flags" },
    {0x0018, 0x6018, "UL", "Region Location Min X0" },
    {0x0018, 0x601A, "UL", "Region Location Min Y0" },
    {0x0018, 0x601C, "UL", "Region Location Max X1" },
    {0x0018, 0x601E, "UL", "Region Location Max Y1" },
    {0x0018, 0x6020, "SL", "Reference Pixel X0" },
    {0x0018, 0x6022, "SL", "Reference Pixel Y0" },
    {0x0018, 0x6024, "US", "Physical Units X Direction" },
    {0x0018, 0x6026, "US", "Physical Units Y Direction" },
    {0x0018, 0x6028, "FD", "Reference Pixel Physical Value X" },
    {0x0018, 0x602A, "FD", "Reference Pixel Physical Value Y" },
    {0x0018, 0x602C, "FD", "Physical Delta X" },
    {0x0018, 0x602E, "FD", "Physical Delta Y" },
    {0x0018, 0x6030, "UL", "Transducer Frequency" },
    {0x0018, 0x6031, "CS", "Transducer Type" },
    {0x0018, 0x6032, "UL", "Pulse Repetition Frequency" },
    {0x0018, 0x6034, "FD", "Doppler Correction Angle" },
    {0x0018, 0x6036, "FD", "Steering Angle" },
    {0x0018, 0x6038, "UL", "Doppler Sample Volume X Position" },
    {0x0018, 0x6039, "SL", "Doppler Sample Volume X Position" },
    {0x0018, 0x603A, "UL", "Doppler Sample Volume Y Position" },
    {0x0018, 0x603B, "SL", "Doppler Sample Volume Y Position" },
    {0x0018, 0x603C, "UL", "TM-Line Position X0" },
    {0x0018, 0x603D, "SL", "TM-Line Position X0" },
    {0x0018, 0x603E, "UL", "TM-Line Position Y0" },
    {0x0018, 0x603F, "SL", "TM-Line Position Y0" },
    {0x0018, 0x6040, "UL", "TM-Line Position X1" },
    {0x0018, 0x6041, "SL", "TM-Line Position X1" },
    {0x0018, 0x6042, "UL", "TM-Line Position Y1" },
    {0x0018, 0x6043, "SL", "TM-Line Position Y1" },
    {0x0018, 0x6044, "US", "Pixel Component Organization" },
    {0x0018, 0x6046, "UL", "Pixel Component Mask" },
    {0x0018, 0x6048, "UL", "Pixel Component Range Start" },
    {0x0018, 0x604A, "UL", "Pixel Component Range Stop" },
    {0x0018, 0x604C, "US", "Pixel Component Physical Units" },
    {0x0018, 0x604E, "US", "Pixel Component Data Type" },
    {0x0018, 0x6050, "UL", "Number of Table Break Points" },
    {0x0018, 0x6052, "UL", "Table of X Break Points" },
    {0x0018, 0x6054, "FD", "Table of Y Break Points" },
    {0x0018, 0x6056, "UL", "Number of Table Entries" },
    {0x0018, 0x6058, "UL", "Table of Pixel Values" },
    {0x0018, 0x605A, "FL", "Table of Parameter Values" },
    {0x0018, 0x6060, "FL", "R Wave Time Vector" },
    {0x0018, 0x7000, "CS", "Detector Conditions Nominal Flag" },
    {0x0018, 0x7001, "DS", "Detector Temperature" },
    {0x0018, 0x7004, "CS", "Detector Type" },
    {0x0018, 0x7005, "CS", "Detector Configuration" },
    {0x0018, 0x7006, "LT", "Detector Description" },
    {0x0018, 0x7008, "LT", "Detector Mode" },
    {0x0018, 0x700A, "SH", "Detector ID" },
    {0x0018, 0x700C, "DA", "Date of Last Detector Calibration" },
    {0x0018, 0x700E, "TM", "Time of Last Detector Calibration" },
    {0x0018, 0x7010, "IS", "Exposures on Detector Since Last Calibration" },
    {0x0018, 0x7011, "IS", "Exposures on Detector Since Manufactured" },
    {0x0018, 0x7012, "DS", "Detector Time Since Last Exposure" },
    {0x0018, 0x7014, "DS", "Detector Active Time" },
    {0x0018, 0x7016, "DS", "Detector Activation Offset From Exposure" },
    {0x0018, 0x701A, "DS", "Detector Binning" },
    {0x0018, 0x7020, "DS", "Detector Element Physical Size" },
    {0x0018, 0x7022, "DS", "Detector Element Spacing" },
    {0x0018, 0x7024, "CS", "Detector Active Shape" },
    {0x0018, 0x7026, "DS", "Detector Active Dimension(s)" },
    {0x0018, 0x7028, "DS", "Detector Active Origin" },
    {0x0018, 0x702A, "LO", "Detector Manufacturer Name" },
    {0x0018, 0x702B, "LO", "Detector Manufacturerfs Model Name" },
    {0x0018, 0x7030, "DS", "Field of View Origin" },
    {0x0018, 0x7032, "DS", "Field of View Rotation" },
    {0x0018, 0x7034, "CS", "Field of View Horizontal Flip" },
    {0x0018, 0x7040, "LT", "Grid Absorbing Material" },
    {0x0018, 0x7041, "LT", "Grid Spacing Material" },
    {0x0018, 0x7042, "DS", "Grid Thickness" },
    {0x0018, 0x7044, "DS", "Grid Pitch" },
    {0x0018, 0x7046, "IS", "Grid Aspect Ratio" },
    {0x0018, 0x7048, "DS", "Grid Period" },
    {0x0018, 0x704C, "DS", "Grid Focal Distance" },
    {0x0018, 0x7050, "CS", "Filter Material" },
    {0x0018, 0x7052, "DS", "Filter Thickness Minimum" },
    {0x0018, 0x7054, "DS", "Filter Thickness Maximum" },
    {0x0018, 0x7060, "CS", "Exposure Control Mode" },
    {0x0018, 0x7062, "LT", "Exposure Control Mode Description" },
    {0x0018, 0x7064, "CS", "Exposure Status" },
    {0x0018, 0x7065, "DS", "Phototimer Setting" },
    {0x0018, 0x8150, "DS", "Exposure Time in S" },
    {0x0018, 0x8151, "DS", "X-Ray Tube Current in A" },
    {0x0018, 0x9004, "CS", "Content Qualification" },
    {0x0018, 0x9005, "SH", "Pulse Sequence Name" },
    {0x0018, 0x9006, "SQ", "MR Imaging Modifier Sequence" },
    {0x0018, 0x9008, "CS", "Echo Pulse Sequence" },
    {0x0018, 0x9009, "CS", "Inversion Recovery" },
    {0x0018, 0x9010, "CS", "Flow Compensation" },
    {0x0018, 0x9011, "CS", "Multiple Spin Echo" },
    {0x0018, 0x9012, "CS", "Multi-planar Excitation" },
    {0x0018, 0x9014, "CS", "Phase Contrast" },
    {0x0018, 0x9015, "CS", "Time of Flight Contrast" },
    {0x0018, 0x9016, "CS", "Spoiling" },
    {0x0018, 0x9017, "CS", "Steady State Pulse Sequence" },
    {0x0018, 0x9018, "CS", "Echo Planar Pulse Sequence" },
    {0x0018, 0x9019, "FD", "Tag Angle First Axis" },
    {0x0018, 0x9020, "CS", "Magnetization Transfer" },
    {0x0018, 0x9021, "CS", "T2 Preparation" },
    {0x0018, 0x9022, "CS", "Blood Signal Nulling" },
    {0x0018, 0x9022, "CS", "Blood Signal Nulling" },
    {0x0018, 0x9024, "CS", "Saturation Recovery" },
    {0x0018, 0x9025, "CS", "Spectrally Selected Suppression" },
    {0x0018, 0x9026, "CS", "Spectrally Selected Excitation" },
    {0x0018, 0x9027, "CS", "Spatial Pre-saturation" },
    {0x0018, 0x9028, "CS", "Tagging" },
    {0x0018, 0x9029, "CS", "Oversampling Phase" },
    {0x0018, 0x9030, "FD", "Tag Spacing First Dimension" },
    {0x0018, 0x9032, "CS", "Geometry of k-Space Traversal" },
    {0x0018, 0x9033, "CS", "Segmented k-Space Traversal" },
    {0x0018, 0x9034, "CS", "Rectilinear Phase Encode Reordering" },
    {0x0018, 0x9035, "FD", "Tag Thickness" },
    {0x0018, 0x9036, "CS", "Partial Fourier Direction" },
    {0x0018, 0x9037, "CS", "Cardiac Synchronization Technique" },
    {0x0018, 0x9041, "LO", "Receive Coil Manufacturer Name" },
    {0x0018, 0x9042, "SQ", "MR Receive Coil Sequence" },
    {0x0018, 0x9043, "CS", "Receive Coil Type" },
    {0x0018, 0x9044, "CS", "Quadrature Receive Coil" },
    {0x0018, 0x9045, "SQ", "Multi-Coil Definition Sequence" },
    {0x0018, 0x9046, "LO", "Multi-Coil Configuration" },
    {0x0018, 0x9047, "SH", "Multi-Coil Element Name" },
    {0x0018, 0x9048, "CS", "Multi-Coil Element Used" },
    {0x0018, 0x9049, "SQ", "MR Transmit Coil Sequence" },
    {0x0018, 0x9050, "LO", "Transmit Coil Manufacturer Name" },
    {0x0018, 0x9051, "CS", "Transmit Coil Type" },
    {0x0018, 0x9052, "FD", "Spectral Width" },
    {0x0018, 0x9053, "FD", "Chemical Shift Reference" },
    {0x0018, 0x9054, "CS", "Volume Localization Technique" },
    {0x0018, 0x9058, "US", "MR Acquisition Frequency Encoding Steps" },
    {0x0018, 0x9059, "CS", "De-coupling" },
    {0x0018, 0x9060, "CS", "De-coupled Nucleus" },
    {0x0018, 0x9061, "FD", "De-coupling Frequency" },
    {0x0018, 0x9062, "CS", "De-coupling Method" },
    {0x0018, 0x9063, "FD", "De-coupling Chemical Shift Reference" },
    {0x0018, 0x9064, "CS", "k-space Filtering" },
    {0x0018, 0x9065, "CS", "Time Domain Filtering" },
    {0x0018, 0x9066, "US", "Number of Zero fills" },
    {0x0018, 0x9067, "CS", "Baseline Correction" },
    {0x0018, 0x9069, "FD", "Parallel Reduction Factor In-plane" },
    {0x0018, 0x9070, "FD", "Cardiac R-R Interval Specified" },
    {0x0018, 0x9073, "FD", "Acquisition Duration" },
    {0x0018, 0x9074, "DT", "Frame Acquisition Datetime" },
    {0x0018, 0x9075, "CS", "Diffusion Directionality" },
    {0x0018, 0x9076, "SQ", "Diffusion Gradient Direction Sequence" },
    {0x0018, 0x9077, "CS", "Parallel Acquisition" },
    {0x0018, 0x9078, "CS", "Parallel Acquisition Technique" },
    {0x0018, 0x9079, "FD", "Inversion Times" },
    {0x0018, 0x9080, "ST", "Metabolite Map Description" },
    {0x0018, 0x9081, "CS", "Partial Fourier" },
    {0x0018, 0x9082, "FD", "Effective Echo Time" },
    {0x0018, 0x9083, "SQ", "Metabolite Map Code Sequence" },
    {0x0018, 0x9084, "SQ", "Chemical Shift Sequence" },
    {0x0018, 0x9085, "CS", "Cardiac Signal Source" },
    {0x0018, 0x9087, "FD", "Diffusion b-value" },
    {0x0018, 0x9089, "FD", "Diffusion Gradient Orientation" },
    {0x0018, 0x9090, "FD", "Velocity Encoding Direction" },
    {0x0018, 0x9091, "FD", "Velocity Encoding Minimum Value" },
    {0x0018, 0x9093, "US", "Number of k-Space Trajectories" },
    {0x0018, 0x9094, "CS", "Coverage of k-Space" },
    {0x0018, 0x9095, "UL", "Spectroscopy Acquisition Phase Rows" },
    {0x0018, 0x9098, "FD", "Transmitter Frequency" },
    {0x0018, 0x9100, "CS", "Resonant Nucleus" },
    {0x0018, 0x9101, "CS", "Frequency Correction" },
    {0x0018, 0x9103, "SQ", "MR Spectroscopy FOV/Geometry Sequence" },
    {0x0018, 0x9104, "FD", "Slab Thickness" },
    {0x0018, 0x9105, "FD", "Slab Orientation" },
    {0x0018, 0x9106, "FD", "Mid Slab Position" },
    {0x0018, 0x9107, "SQ", "MR Spatial Saturation Sequence" },
    {0x0018, 0x9112, "SQ", "MR Timing and Related Parameters Sequence" },
    {0x0018, 0x9114, "SQ", "MR Echo Sequence" },
    {0x0018, 0x9115, "SQ", "MR Modifier Sequence" },
    {0x0018, 0x9117, "SQ", "MR Diffusion Sequence" },
    {0x0018, 0x9118, "SQ", "Cardiac Trigger Sequence" },
    {0x0018, 0x9119, "SQ", "MR Averages Sequence" },
    {0x0018, 0x9125, "SQ", "MR FOV/Geometry Sequence" },
    {0x0018, 0x9126, "SQ", "Volume Localization Sequence" },
    {0x0018, 0x9127, "UL", "Spectroscopy Acquisition Data Columns" },
    {0x0018, 0x9147, "CS", "Diffusion Anisotropy Type" },
    {0x0018, 0x9151, "DT", "Frame Reference Datetime" },
    {0x0018, 0x9152, "SQ", "MR Metabolite Map Sequence" },
    {0x0018, 0x9155, "FD", "Parallel Reduction Factor out-of-plane" },
    {0x0018, 0x9159, "UL", "Spectroscopy Acquisition Out-of-plane Phase Steps" },
    {0x0018, 0x9166, "CS", "Bulk Motion Status" },
    {0x0018, 0x9168, "FD", "Parallel Reduction Factor Second In-plane" },
    {0x0018, 0x9169, "CS", "Cardiac Beat Rejection Technique" },
    {0x0018, 0x9170, "CS", "Respiratory Motion Compensation Technique" },
    {0x0018, 0x9171, "CS", "Respiratory Signal Source" },
    {0x0018, 0x9172, "CS", "Bulk Motion Compensation Technique" },
    {0x0018, 0x9173, "CS", "Bulk Motion Signal Source" },
    {0x0018, 0x9174, "CS", "Applicable Safety Standard Agency" },
    {0x0018, 0x9175, "LO", "Applicable Safety Standard Description" },
    {0x0018, 0x9176, "SQ", "Operating Mode Sequence" },
    {0x0018, 0x9177, "CS", "Operating Mode Type" },
    {0x0018, 0x9178, "CS", "Operating Mode" },
    {0x0018, 0x9179, "CS", "Specific Absorption Rate Definition" },
    {0x0018, 0x9180, "CS", "Gradient Output Type" },
    {0x0018, 0x9181, "FD", "Specific Absorption Rate Value" },
    {0x0018, 0x9182, "FD", "Gradient Output" },
    {0x0018, 0x9183, "CS", "Flow Compensation Direction" },
    {0x0018, 0x9184, "FD", "Tagging Delay" },
    {0x0018, 0x9197, "SQ", "MR Velocity Encoding Sequence" },
    {0x0018, 0x9198, "CS", "First Order Phase Correction" },
    {0x0018, 0x9199, "CS", "Water Referenced Phase Correction" },
    {0x0018, 0x9200, "CS", "MR Spectroscopy Acquisition Type" },
    {0x0018, 0x9214, "CS", "Respiratory Cycle Position" },
    {0x0018, 0x9217, "FD", "Velocity Encoding Maximum Value" },
    {0x0018, 0x9218, "FD", "Tag Spacing Second Dimension" },
    {0x0018, 0x9219, "SS", "Tag Angle Second Axis" },
    {0x0018, 0x9220, "FD", "Frame Acquisition Duration" },
    {0x0018, 0x9226, "SQ", "MR Image Frame Type Sequence" },
    {0x0018, 0x9227, "SQ", "MR Spectroscopy Frame Type Sequence" },
    {0x0018, 0x9231, "US", "MR Acquisition Phase Encoding Steps in-plane" },
    {0x0018, 0x9232, "US", "MR Acquisition Phase Encoding Steps out-of-plane" },
    {0x0018, 0x9234, "UL", "Spectroscopy Acquisition Phase Columns" },
    {0x0018, 0x9236, "CS", "Cardiac Cycle Position" },
    {0x0018, 0x9239, "SQ", "Specific Absorption Rate Sequence" },
    {0x0018, 0x9240, "US", "RF Echo Train Length" },
    {0x0018, 0x9241, "US", "Gradient Echo Train Length" },
    {0x0018, 0x9295, "FD", "Chemical Shifts Minimum Integration Limit in ppm" },
    {0x0018, 0x9296, "FD", "Chemical Shifts Maximum Integration Limit in ppm" },
    {0x0018, 0x9301, "SQ", "CT Acquisition Type Sequence" },
    {0x0018, 0x9302, "CS", "Acquisition Type" },
    {0x0018, 0x9303, "FD", "Tube Angle" },
    {0x0018, 0x9304, "SQ", "CT Acquisition Details Sequence" },
    {0x0018, 0x9305, "FD", "Revolution Time" },
    {0x0018, 0x9306, "FD", "Single Collimation Width" },
    {0x0018, 0x9307, "FD", "Total Collimation Width" },
    {0x0018, 0x9308, "SQ", "CT Table Dynamics Sequence" },
    {0x0018, 0x9309, "FD", "Table Speed" },
    {0x0018, 0x9310, "FD", "Table Feed per Rotation" },
    {0x0018, 0x9311, "FD", "Spiral Pitch Factor" },
    {0x0018, 0x9312, "SQ", "CT Geometry Sequence" },
    {0x0018, 0x9313, "FD", "Data Collection Center (Patient)" },
    {0x0018, 0x9314, "SQ", "CT Reconstruction Sequence" },
    {0x0018, 0x9315, "CS", "Reconstruction Algorithm" },
    {0x0018, 0x9316, "CS", "Convolution Kernel Group" },
    {0x0018, 0x9317, "FD", "Reconstruction Field of View" },
    {0x0018, 0x9318, "FD", "Reconstruction Target Center (Patient)" },
    {0x0018, 0x9319, "FD", "Reconstruction Angle" },
    {0x0018, 0x9320, "SH", "Image Filter" },
    {0x0018, 0x9321, "SQ", "CT Exposure Sequence" },
    {0x0018, 0x9322, "FD", "Reconstruction Pixel Spacing" },
    {0x0018, 0x9323, "CS", "Exposure Modulation Type" },
    {0x0018, 0x9324, "FD", "Estimated Dose Saving" },
    {0x0018, 0x9325, "SQ", "CT X-ray Details Sequence" },
    {0x0018, 0x9326, "SQ", "CT Position Sequence" },
    {0x0018, 0x9327, "FD", "Table Position" },
    {0x0018, 0x9328, "FD", "Exposure Time in ms" },
    {0x0018, 0x9329, "SQ", "CT Image Frame Type Sequence" },
    {0x0018, 0x9330, "FD", "X-Ray Tube Current in mA" },
    {0x0018, 0x9332, "FD", "Exposure in mAs" },
    {0x0018, 0x9333, "CS", "Constant Volume Flag" },
    {0x0018, 0x9334, "CS", "Fluoroscopy Flag" },
    {0x0018, 0x9335, "FD", "Distance Source to Data Collection Center" },
    {0x0018, 0x9337, "US", "Contrast/Bolus Agent Number" },
    {0x0018, 0x9338, "SQ", "Contrast/Bolus Ingredient Code Sequence" },
    {0x0018, 0x9340, "SQ", "Contrast Administration Profile Sequence" },
    {0x0018, 0x9341, "SQ", "Contrast/Bolus Usage Sequence" },
    {0x0018, 0x9342, "CS", "Contrast/Bolus Agent Administered" },
    {0x0018, 0x9343, "CS", "Contrast/Bolus Agent Detected" },
    {0x0018, 0x9344, "CS", "Contrast/Bolus Agent Phase" },
    {0x0018, 0x9345, "FD", "CTDIvol" },
    {0x0018, 0xA001, "SQ", "Contributing Equipment Sequence" },
    {0x0018, 0xA002, "DT", "Contribution DateTime" },
    {0x0018, 0xA003, "ST", "Contribution Description" },
    {0x0020, 0x000D, "UI", "Study Instance UID" },
    {0x0020, 0x000E, "UI", "Series Instance UID" },
    {0x0020, 0x0010, "SH", "Study ID" },
    {0x0020, 0x0011, "IS", "Series Number" },
    {0x0020, 0x0012, "IS", "Acquisition Number" },
    {0x0020, 0x0013, "IS", "Instance Number" },
    {0x0020, 0x0014, "IS", "Isotope Number" },
    {0x0020, 0x0015, "IS", "Phase Number" },
    {0x0020, 0x0016, "IS", "Interval Number" },
    {0x0020, 0x0017, "IS", "Time Slot Number" },
    {0x0020, 0x0018, "IS", "Angle Number" },
    {0x0020, 0x0019, "IS", "Item Number" },
    {0x0020, 0x0020, "CS", "Patient Orientation" },
    {0x0020, 0x0022, "IS", "Overlay Number" },
    {0x0020, 0x0024, "IS", "Curve Number" },
    {0x0020, 0x0026, "IS", "Lookup Table Number" },
    {0x0020, 0x0032, "DS", "Image Position (Patient)" },
    {0x0020, 0x0037, "DS", "Image Orientation (Patient)" },
    {0x0020, 0x0052, "UI", "Frame of Reference UID" },
    {0x0020, 0x0060, "CS", "Laterality" },
    {0x0020, 0x0062, "CS", "Image Laterality" },
    {0x0020, 0x0100, "IS", "Temporal Position Identifier" },
    {0x0020, 0x0105, "IS", "Number of Temporal Positions" },
    {0x0020, 0x0110, "DS", "Temporal Resolution" },
    {0x0020, 0x0200, "UI", "Synchronization Frame of Reference UID" },
    {0x0020, 0x1000, "IS", "Series in Study" },
    {0x0020, 0x1002, "IS", "Images in Acquisition" },
    {0x0020, 0x1004, "IS", "Acquisitions in Study" },
    {0x0020, 0x1040, "LO", "Position Reference Indicator" },
    {0x0020, 0x1041, "DS", "Slice Location" },
    {0x0020, 0x1070, "IS", "Other Study Numbers" },
    {0x0020, 0x1200, "IS", "Number of Patient Related Studies" },
    {0x0020, 0x1202, "IS", "Number of Patient Related Series" },
    {0x0020, 0x1204, "IS", "Number of Patient Related Instances" },
    {0x0020, 0x1206, "IS", "Number of Study Related Series" },
    {0x0020, 0x1208, "IS", "Number of Study Related Instances" },
    {0x0020, 0x1209, "IS", "Number of Series Related Instances" },
    {0x0020, 0x4000, "LT", "Image Comments" },
    {0x0020, 0x9056, "SH", "Stack ID" },
    {0x0020, 0x9057, "UL", "In-Stack Position Number" },
    {0x0020, 0x9071, "SQ", "Frame Anatomy Sequence" },
    {0x0020, 0x9072, "CS", "Frame Laterality" },
    {0x0020, 0x9111, "SQ", "Frame Content Sequence" },
    {0x0020, 0x9113, "SQ", "Plane Position Sequence" },
    {0x0020, 0x9116, "SQ", "Plane Orientation Sequence" },
    {0x0020, 0x9128, "UL", "Temporal Position Index" },
    {0x0020, 0x9153, "FD", "Trigger Delay Time" },
    {0x0020, 0x9156, "US", "Frame Acquisition Number" },
    {0x0020, 0x9157, "UL", "Dimension Index Values" },
    {0x0020, 0x9158, "LT", "Frame Comments" },
    {0x0020, 0x9161, "UI", "Concatenation UID" },
    {0x0020, 0x9162, "US", "In-concatenation Number" },
    {0x0020, 0x9163, "US", "In-concatenation Total Number" },
    {0x0020, 0x9164, "UI", "Dimension Organization UID" },
    {0x0020, 0x9165, "AT", "Dimension Index Pointer" },
    {0x0020, 0x9167, "AT", "Functional Group Pointer" },
    {0x0020, 0x9213, "LO", "Dimension Index Private Creator" },
    {0x0020, 0x9221, "SQ", "Dimension Organization Sequence" },
    {0x0020, 0x9222, "SQ", "Dimension Index Sequence" },
    {0x0020, 0x9228, "UL", "Concatenation Frame Offset Number" },
    {0x0020, 0x9238, "LO", "Functional Group Private Creator" },
    {0x0022, 0x0001, "US", "Light Path Filter Pass-Through Wavelength" },
    {0x0022, 0x0002, "US", "Light Path Filter Pass Band" },
    {0x0022, 0x0003, "US", "Image Path Filter Pass-Through Wavelength" },
    {0x0022, 0x0004, "US", "Image Path Filter Pass Band" },
    {0x0022, 0x0005, "CS", "Patient Eye Movement Commanded" },
    {0x0022, 0x0006, "SQ", "Patient Eye Movement Command Code Sequence" },
    {0x0022, 0x0007, "FL", "Spherical Lens Power" },
    {0x0022, 0x0008, "FL", "Cylinder Lens Power" },
    {0x0022, 0x0009, "FL", "Cylinder Axis" },
    {0x0022, 0x000A, "FL", "Emmetropic Magnification" },
    {0x0022, 0x000B, "FL", "Intra Ocular Pressure" },
    {0x0022, 0x000C, "FL", "Horizontal Field of View" },
    {0x0022, 0x000D, "CS", "Pupil Dilated" },
    {0x0022, 0x000E, "FL", "Degree of Dilation" },
    {0x0022, 0x0010, "FL", "Stereo Baseline Angle" },
    {0x0022, 0x0011, "FL", "Stereo Baseline Displacement" },
    {0x0022, 0x0012, "FL", "Stereo Horizontal Pixel Offset" },
    {0x0022, 0x0013, "FL", "Stereo Vertical Pixel Offset" },
    {0x0022, 0x0014, "FL", "Stereo Rotation" },
    {0x0022, 0x0015, "SQ", "Acquisition Device Type Code Sequence" },
    {0x0022, 0x0016, "SQ", "Illumination Type Code Sequence" },
    {0x0022, 0x0017, "SQ", "Light Path Filter Type Stack Code Sequence" },
    {0x0022, 0x0018, "SQ", "Image Path Filter Type Stack Code Sequence" },
    {0x0022, 0x0019, "SQ", "Lenses Code Sequence" },
    {0x0022, 0x001A, "SQ", "Channel Description Code Sequence" },
    {0x0022, 0x001B, "SQ", "Refractive State Sequence" },
    {0x0022, 0x001C, "SQ", "Mydriatic Agent Code Sequence" },
    {0x0022, 0x001D, "SQ", "Relative Image Position Code Sequence" },
    {0x0022, 0x0020, "SQ", "Stereo Pairs Sequence" },
    {0x0022, 0x0021, "SQ", "Left Image Sequence" },
    {0x0022, 0x0022, "SQ", "Right Image Sequence" },
    {0x0028, 0x0002, "US", "Samples per Pixel" },
    {0x0028, 0x0003, "US", "Samples per Pixel Used" },
    {0x0028, 0x0004, "CS", "Photometric Interpretation" },
    {0x0028, 0x0006, "US", "Planar Configuration" },
    {0x0028, 0x0008, "IS", "Number of Frames" },
    {0x0028, 0x0009, "AT", "Frame Increment Pointer" },
    {0x0028, 0x000A, "AT", "Frame Dimension Pointer" },
    {0x0028, 0x0010, "US", "Rows" },
    {0x0028, 0x0011, "US", "Columns" },
    {0x0028, 0x0012, "US", "Planes" },
    {0x0028, 0x0014, "US", "Ultrasound Color Data Present" },
    {0x0028, 0x0030, "DS", "Pixel Spacing" },
    {0x0028, 0x0031, "DS", "Zoom Factor" },
    {0x0028, 0x0032, "DS", "Zoom Center" },
    {0x0028, 0x0034, "IS", "Pixel Aspect Ratio" },
    {0x0028, 0x0051, "CS", "Corrected Image" },
    {0x0028, 0x0100, "US", "Bits Allocated" },
    {0x0028, 0x0101, "US", "Bits Stored" },
    {0x0028, 0x0102, "US", "High Bit" },
    {0x0028, 0x0103, "US", "Pixel Representation" },
    {0x0028, 0x0106, "SS", "Smallest Image Pixel Value" },
    {0x0028, 0x0107, "SS", "Largest Image Pixel Value" },
    {0x0028, 0x0108, "SS", "Smallest Pixel Value in Series" },
    {0x0028, 0x0109, "SS", "Largest Pixel Value in Series" },
    {0x0028, 0x0110, "SS", "Smallest Image Pixel Value in Plane" },
    {0x0028, 0x0111, "SS", "Largest Image Pixel Value in Plane" },
    {0x0028, 0x0120, "SS", "Pixel Padding Value" },
    {0x0028, 0x0300, "CS", "Quality Control Image" },
    {0x0028, 0x0301, "CS", "Burned In Annotation" },
    {0x0028, 0x1040, "CS", "Pixel Intensity Relationship" },
    {0x0028, 0x1041, "SS", "Pixel Intensity Relationship Sign" },
    {0x0028, 0x1050, "DS", "Window Center" },
    {0x0028, 0x1051, "DS", "Window Width" },
    {0x0028, 0x1052, "DS", "Rescale Intercept" },
    {0x0028, 0x1053, "DS", "Rescale Slope" },
    {0x0028, 0x1054, "LO", "Rescale Type" },
    {0x0028, 0x1055, "LO", "Window Center & Width Explanation" },
    {0x0028, 0x1090, "CS", "Recommended Viewing Mode" },
    {0x0028, 0x1101, "SS", "Red Palette Color Lookup Table Descriptor" },
    {0x0028, 0x1102, "SS", "Green Palette Color Lookup Table Descriptor" },
    {0x0028, 0x1103, "SS", "Blue Palette Color Lookup Table Descriptor" },
    {0x0028, 0x1199, "UI", "Palette Color Lookup Table UID" },
    {0x0028, 0x1201, "OW", "Red Palette Color Lookup Table Data" },
    {0x0028, 0x1202, "OW", "Green Palette Color Lookup Table Data" },
    {0x0028, 0x1203, "OW", "Blue Palette Color Lookup Table Data" },
    {0x0028, 0x1221, "OW", "Segmented Red Palette Color Lookup Table Data" },
    {0x0028, 0x1222, "OW", "Segmented Green Palette Color Lookup Table Data" },
    {0x0028, 0x1223, "OW", "Segmented Blue Palette Color Lookup Table Data" },
    {0x0028, 0x1300, "CS", "Implant Present" },
    {0x0028, 0x1350, "CS", "Partial View" },
    {0x0028, 0x1351, "ST", "Partial View Description" },
    {0x0028, 0x2110, "CS", "Lossy Image Compression" },
    {0x0028, 0x2112, "DS", "Lossy Image Compression Ratio" },
    {0x0028, 0x2114, "CS", "Lossy Image Compression Method" },
    {0x0028, 0x3000, "SQ", "Modality LUT Sequence" },
    {0x0028, 0x3002, "SS", "LUT Descriptor" },
    {0x0028, 0x3003, "LO", "LUT Explanation" },
    {0x0028, 0x3004, "LO", "Modality LUT Type" },
    {0x0028, 0x3006, "OW", "LUT Data US or" },
    {0x0028, 0x3010, "SQ", "VOI LUT Sequence" },
    {0x0028, 0x3110, "SQ", "Softcopy VOI LUT Sequence" },
    {0x0028, 0x5000, "SQ", "Bi-Plane Acquisition Sequence" },
    {0x0028, 0x6010, "US", "Representative Frame Number" },
    {0x0028, 0x6020, "US", "Frame Numbers of Interest (FOI)" },
    {0x0028, 0x6022, "LO", "Frame(s) of Interest Description" },
    {0x0028, 0x6023, "CS", "Frame of Interest Type" },
    {0x0028, 0x6030, "US", "Mask Pointer(s)" },
    {0x0028, 0x6040, "US", "R Wave Pointer" },
    {0x0028, 0x6100, "SQ", "Mask Subtraction Sequence" },
    {0x0028, 0x6101, "CS", "Mask Operation" },
    {0x0028, 0x6102, "US", "Applicable Frame Range" },
    {0x0028, 0x6110, "US", "Mask Frame Numbers" },
    {0x0028, 0x6112, "US", "Contrast Frame Averaging" },
    {0x0028, 0x6114, "FL", "Mask Sub-pixel Shift" },
    {0x0028, 0x6120, "SS", "TID Offset" },
    {0x0028, 0x6190, "ST", "Mask Operation Explanation" },
    {0x0028, 0x9001, "UL", "Data Point Rows" },
    {0x0028, 0x9002, "UL", "Data Point Columns" },
    {0x0028, 0x9003, "CS", "Signal Domain Columns" },
    {0x0028, 0x9108, "CS", "Data Representation" },
    {0x0028, 0x9110, "SQ", "Pixel Measures Sequence" },
    {0x0028, 0x9132, "SQ", "Frame VOI LUT Sequence" },
    {0x0028, 0x9145, "SQ", "Pixel Value Transformation Sequence" },
    {0x0028, 0x9235, "CS", "Signal Domain Rows" },
    {0x0032, 0x000A, "CS", "Study Status ID" },
    {0x0032, 0x000C, "CS", "Study Priority ID" },
    {0x0032, 0x0012, "LO", "Study ID Issuer" },
    {0x0032, 0x0032, "DA", "Study Verified Date" },
    {0x0032, 0x0033, "TM", "Study Verified Time" },
    {0x0032, 0x0034, "DA", "Study Read Date" },
    {0x0032, 0x0035, "TM", "Study Read Time" },
    {0x0032, 0x1000, "DA", "Scheduled Study Start Date" },
    {0x0032, 0x1001, "TM", "Scheduled Study Start Time" },
    {0x0032, 0x1010, "DA", "Scheduled Study Stop Date" },
    {0x0032, 0x1011, "TM", "Scheduled Study Stop Time" },
    {0x0032, 0x1020, "LO", "Scheduled Study Location" },
    {0x0032, 0x1021, "AE", "Scheduled Study Location AE Title(s)" },
    {0x0032, 0x1030, "LO", "Reason for Study" },
    {0x0032, 0x1031, "SQ", "Requesting Physician Identification Sequence" },
    {0x0032, 0x1032, "PN", "Requesting Physician" },
    {0x0032, 0x1033, "LO", "Requesting Service" },
    {0x0032, 0x1040, "DA", "Study Arrival Date" },
    {0x0032, 0x1041, "TM", "Study Arrival Time" },
    {0x0032, 0x1050, "DA", "Study Completion Date" },
    {0x0032, 0x1051, "TM", "Study Completion Time" },
    {0x0032, 0x1055, "CS", "Study Component Status ID" },
    {0x0032, 0x1060, "LO", "Requested Procedure Description" },
    {0x0032, 0x1064, "SQ", "Requested Procedure Code Sequence" },
    {0x0032, 0x1070, "LO", "Requested Contrast Agent" },
    {0x0032, 0x4000, "LT", "Study Comments" },
    {0x0038, 0x0004, "SQ", "Referenced Patient Alias Sequence" },
    {0x0038, 0x0008, "CS", "Visit Status ID" },
    {0x0038, 0x0010, "LO", "Admission ID" },
    {0x0038, 0x0011, "LO", "Issuer of Admission ID" },
    {0x0038, 0x0016, "LO", "Route of Admissions" },
    {0x0038, 0x001A, "DA", "Scheduled Admission Date" },
    {0x0038, 0x001B, "TM", "Scheduled Admission Time" },
    {0x0038, 0x001C, "DA", "Scheduled Discharge Date" },
    {0x0038, 0x001D, "TM", "Scheduled Discharge Time" },
    {0x0038, 0x001E, "LO", "Scheduled Patient Institution Residence" },
    {0x0038, 0x0020, "DA", "Admitting Date" },
    {0x0038, 0x0021, "TM", "Admitting Time" },
    {0x0038, 0x0030, "DA", "Discharge Date" },
    {0x0038, 0x0032, "TM", "Discharge Time" },
    {0x0038, 0x0040, "LO", "Discharge Diagnosis Description" },
    {0x0038, 0x0044, "SQ", "Discharge Diagnosis Code Sequence" },
    {0x0038, 0x0050, "LO", "Special Needs" },
    {0x0038, 0x0300, "LO", "Current Patient Location" },
    {0x0038, 0x0400, "LO", "Patientfs Institution Residence" },
    {0x0038, 0x0500, "LO", "Patient State" },
    {0x0038, 0x4000, "LT", "Visit Comments" },
    {0x003A, 0x0004, "CS", "Waveform Originality" },
    {0x003A, 0x0005, "US", "Number of Waveform Channels" },
    {0x003A, 0x0010, "UL", "Number of Waveform Samples" },
    {0x003A, 0x001A, "DS", "Sampling Frequency" },
    {0x003A, 0x0020, "SH", "Multiplex Group Label" },
    {0x003A, 0x0200, "SQ", "Channel Definition Sequence" },
    {0x003A, 0x0202, "IS", "Waveform Channel Number" },
    {0x003A, 0x0203, "SH", "Channel Label" },
    {0x003A, 0x0205, "CS", "Channel Status" },
    {0x003A, 0x0208, "SQ", "Channel Source Sequence" },
    {0x003A, 0x0209, "SQ", "Channel Source Modifiers Sequence" },
    {0x003A, 0x020A, "SQ", "Source Waveform Sequence" },
    {0x003A, 0x020C, "LO", "Channel Derivation Description" },
    {0x003A, 0x0210, "DS", "Channel Sensitivity" },
    {0x003A, 0x0211, "SQ", "Channel Sensitivity Units Sequence" },
    {0x003A, 0x0212, "DS", "Channel Sensitivity Correction Factor" },
    {0x003A, 0x0213, "DS", "Channel Baseline" },
    {0x003A, 0x0214, "DS", "Channel Time Skew" },
    {0x003A, 0x0215, "DS", "Channel Sample Skew" },
    {0x003A, 0x0218, "DS", "Channel Offset" },
    {0x003A, 0x021A, "US", "Waveform Bits Stored" },
    {0x003A, 0x0220, "DS", "Filter Low Frequency" },
    {0x003A, 0x0221, "DS", "Filter High Frequency" },
    {0x003A, 0x0222, "DS", "Notch Filter Frequency" },
    {0x003A, 0x0223, "DS", "Notch Filter Bandwidth" },
    {0x003A, 0x0300, "SQ", "Multiplexed Audio Channels Description Code Sequence" },
    {0x003A, 0x0301, "IS", "Channel Identification Code" },
    {0x003A, 0x0302, "CS", "Channel Mode" },
    {0x0040, 0x0001, "AE", "Scheduled Station AE Title" },
    {0x0040, 0x0002, "DA", "Scheduled Procedure Step Start Date" },
    {0x0040, 0x0003, "TM", "Scheduled Procedure Step Start Time" },
    {0x0040, 0x0004, "DA", "Scheduled Procedure Step End Date" },
    {0x0040, 0x0005, "TM", "Scheduled Procedure Step End Time" },
    {0x0040, 0x0006, "PN", "Scheduled Performing Physicianfs Name" },
    {0x0040, 0x0007, "LO", "Scheduled Procedure Step Description" },
    {0x0040, 0x0008, "SQ", "Scheduled Protocol Code Sequence" },
    {0x0040, 0x0009, "SH", "Scheduled Procedure Step ID" },
    {0x0040, 0x000A, "SQ", "Stage Code Sequence" },
    {0x0040, 0x000B, "SQ", "Scheduled Performing Physician Identification Sequence" },
    {0x0040, 0x0010, "SH", "Scheduled Station Name" },
    {0x0040, 0x0011, "SH", "Scheduled Procedure Step Location" },
    {0x0040, 0x0012, "LO", "Pre-Medication" },
    {0x0040, 0x0020, "CS", "Scheduled Procedure Step Status" },
    {0x0040, 0x0100, "SQ", "Scheduled Procedure Step Sequence" },
    {0x0040, 0x0220, "SQ", "Referenced Non-Image Composite SOP Instance Sequence" },
    {0x0040, 0x0241, "AE", "Performed Station AE Title" },
    {0x0040, 0x0242, "SH", "Performed Station Name" },
    {0x0040, 0x0243, "SH", "Performed Location" },
    {0x0040, 0x0244, "DA", "Performed Procedure Step Start Date" },
    {0x0040, 0x0245, "TM", "Performed Procedure Step Start Time" },
    {0x0040, 0x0250, "DA", "Performed Procedure Step End Date" },
    {0x0040, 0x0251, "TM", "Performed Procedure Step End Time" },
    {0x0040, 0x0252, "CS", "Performed Procedure Step Status" },
    {0x0040, 0x0253, "SH", "Performed Procedure Step ID" },
    {0x0040, 0x0254, "LO", "Performed Procedure Step Description" },
    {0x0040, 0x0255, "LO", "Performed Procedure Type Description" },
    {0x0040, 0x0260, "SQ", "Performed Protocol Code Sequence" },
    {0x0040, 0x0270, "SQ", "Scheduled Step Attributes Sequence" },
    {0x0040, 0x0275, "SQ", "Request Attributes Sequence" },
    {0x0040, 0x0280, "ST", "Comments on the Performed Procedure Step" },
    {0x0040, 0x0281, "SQ", "Performed Procedure Step Discontinuation Reason Code Sequence" },
    {0x0040, 0x0293, "SQ", "Quantity Sequence" },
    {0x0040, 0x0294, "DS", "Quantity" },
    {0x0040, 0x0295, "SQ", "Measuring Units Sequence" },
    {0x0040, 0x0296, "SQ", "Billing Item Sequence" },
    {0x0040, 0x0300, "US", "Total Time of Fluoroscopy" },
    {0x0040, 0x0301, "US", "Total Number of Exposures" },
    {0x0040, 0x0302, "US", "Entrance Dose" },
    {0x0040, 0x0303, "US", "Exposed Area" },
    {0x0040, 0x0306, "DS", "Distance Source to Entrance" },
    {0x0040, 0x0307, "DS", "Distance Source to Support" },
    {0x0040, 0x030E, "SQ", "Exposure Dose Sequence" },
    {0x0040, 0x0310, "ST", "Comments on Radiation Dose" },
    {0x0040, 0x0312, "DS", "X-Ray Output" },
    {0x0040, 0x0314, "DS", "Half Value Layer" },
    {0x0040, 0x0316, "DS", "Organ Dose" },
    {0x0040, 0x0318, "CS", "Organ Exposed" },
    {0x0040, 0x0320, "SQ", "Billing Procedure Step Sequence" },
    {0x0040, 0x0321, "SQ", "Film Consumption Sequence" },
    {0x0040, 0x0324, "SQ", "Billing Supplies and Devices Sequence" },
    {0x0040, 0x0330, "SQ", "Referenced Procedure Step Sequence" },
    {0x0040, 0x0340, "SQ", "Performed Series Sequence" },
    {0x0040, 0x0400, "LT", "Comments on the Scheduled Procedure Step" },
    {0x0040, 0x0440, "SQ", "Protocol Context Sequence" },
    {0x0040, 0x0441, "SQ", "Content Item Modifier Sequence" },
    {0x0040, 0x050A, "LO", "Specimen Accession Number" },
    {0x0040, 0x0550, "SQ", "Specimen Sequence" },
    {0x0040, 0x0551, "LO", "Specimen Identifier" },
    {0x0040, 0x0555, "SQ", "Acquisition Context Sequence" },
    {0x0040, 0x0556, "ST", "Acquisition Context Description" },
    {0x0040, 0x059A, "SQ", "Specimen Type Code Sequence" },
    {0x0040, 0x06FA, "LO", "Slide Identifier" },
    {0x0040, 0x071A, "SQ", "Image Center Point Coordinates Sequence" },
    {0x0040, 0x072A, "DS", "X offset in Slide Coordinate System" },
    {0x0040, 0x073A, "DS", "Y offset in Slide Coordinate System" },
    {0x0040, 0x074A, "DS", "Z offset in Slide Coordinate System" },
    {0x0040, 0x08D8, "SQ", "Pixel Spacing Sequence" },
    {0x0040, 0x08DA, "SQ", "Coordinate System Axis Code Sequence" },
    {0x0040, 0x08EA, "SQ", "Measurement Units Code Sequence" },
    {0x0040, 0x1001, "SH", "Requested Procedure ID" },
    {0x0040, 0x1002, "LO", "Reason for the Requested Procedure" },
    {0x0040, 0x1003, "SH", "Requested Procedure Priority" },
    {0x0040, 0x1004, "LO", "Patient Transport Arrangements" },
    {0x0040, 0x1005, "LO", "Requested Procedure Location" },
    {0x0040, 0x1006, "SH", "Placer Order Number / Procedure" },
    {0x0040, 0x1007, "SH", "Filler Order Number / Procedure" },
    {0x0040, 0x1008, "LO", "Confidentiality Code" },
    {0x0040, 0x1009, "SH", "Reporting Priority" },
    {0x0040, 0x100A, "SQ", "Reason for Requested Procedure Code Sequence" },
    {0x0040, 0x1010, "PN", "Names of Intended Recipients of Results" },
    {0x0040, 0x1011, "SQ", "Intended Recipients of Results Identification Sequence" },
    {0x0040, 0x1101, "SQ", "Person Identification Code Sequence" },
    {0x0040, 0x1102, "ST", "Personfs Address" },
    {0x0040, 0x1103, "LO", "Personfs Telephone Numbers" },
    {0x0040, 0x1400, "LT", "Requested Procedure Comments" },
    {0x0040, 0x2001, "LO", "Reason for the Imaging Service Request" },
    {0x0040, 0x2004, "DA", "Issue Date of Imaging Service Request" },
    {0x0040, 0x2005, "TM", "Issue Time of Imaging Service Request" },
    {0x0040, 0x2006, "SH", "Placer Order Number / Imaging Service Request" },
    {0x0040, 0x2007, "SH", "Filler Order Number / Imaging Service Request" },
    {0x0040, 0x2008, "PN", "Order Entered By" },
    {0x0040, 0x2009, "SH", "Order Entererfs Location" },
    {0x0040, 0x2010, "SH", "Order Callback Phone Number" },
    {0x0040, 0x2016, "LO", "Placer Order Number / Imaging Service Request" },
    {0x0040, 0x2017, "LO", "Filler Order Number / Imaging Service Request" },
    {0x0040, 0x2400, "LT", "Imaging Service Request Comments" },
    {0x0040, 0x3001, "LO", "Confidentiality Constraint on Patient Data Description" },
    {0x0040, 0x4001, "CS", "General Purpose Scheduled Procedure Step Status" },
    {0x0040, 0x4002, "CS", "General Purpose Performed Procedure Step Status" },
    {0x0040, 0x4003, "CS", "General Purpose Scheduled Procedure Step Priority" },
    {0x0040, 0x4004, "SQ", "Scheduled Processing Applications Code Sequence" },
    {0x0040, 0x4005, "DT", "Scheduled Procedure Step Start Date and Time" },
    {0x0040, 0x4006, "CS", "Multiple Copies Flag" },
    {0x0040, 0x4007, "SQ", "Performed Processing Applications Code Sequence" },
    {0x0040, 0x4009, "SQ", "Human Performer Code Sequence" },
    {0x0040, 0x4010, "DT", "Scheduled Procedure Step Modification Date and Time" },
    {0x0040, 0x4011, "DT", "Expected Completion Date and Time" },
    {0x0040, 0x4015, "SQ", "Resulting General Purpose Performed Procedure Steps Sequence" },
    {0x0040, 0x4016, "SQ", "Referenced General Purpose Scheduled Procedure Step Sequence" },
    {0x0040, 0x4018, "SQ", "Scheduled Workitem Code Sequence" },
    {0x0040, 0x4019, "SQ", "Performed Workitem Code Sequence" },
    {0x0040, 0x4020, "CS", "Input Availability Flag" },
    {0x0040, 0x4021, "SQ", "Input InformationSequence" },
    {0x0040, 0x4022, "SQ", "Relevant Information Sequence" },
    {0x0040, 0x4023, "UI", "Referenced General Purpose Scheduled Procedure Step Transaction UID" },
    {0x0040, 0x4025, "SQ", "Scheduled Station Name Code Sequence" },
    {0x0040, 0x4026, "SQ", "Scheduled Station Class Code Sequence" },
    {0x0040, 0x4027, "SQ", "Scheduled Station Geographic Location Code Sequence" },
    {0x0040, 0x4028, "SQ", "Performed Station Name Code Sequence" },
    {0x0040, 0x4029, "SQ", "Performed Station Class Code Sequence" },
    {0x0040, 0x4030, "SQ", "Performed Station Geographic Location Code Sequence" },
    {0x0040, 0x4031, "SQ", "Requested Subsequent Workitem Code Sequence" },
    {0x0040, 0x4032, "SQ", "Non-DICOM Output Code Sequence" },
    {0x0040, 0x4033, "SQ", "Output Information Sequence" },
    {0x0040, 0x4034, "SQ", "Scheduled Human Performers Sequence" },
    {0x0040, 0x4035, "SQ", "Actual Human Performers Sequence" },
    {0x0040, 0x4036, "LO", "Human Performerfs Organization" },
    {0x0040, 0x4037, "PN", "Human Performerfs Name" },
    {0x0040, 0x8302, "DS", "Entrance Dose in mGy" },
    {0x0040, 0x9096, "SQ", "Real World Value Mapping Sequence" },
    {0x0040, 0x9210, "SH", "LUT Label" },
    {0x0040, 0x9212, "FD", "Real World Value LUT Data" },
    {0x0040, 0x9224, "FD", "Real World Value Intercept" },
    {0x0040, 0x9225, "FD", "Real World Value Slope" },
    {0x0040, 0xA010, "CS", "Relationship Type" },
    {0x0040, 0xA027, "LO", "Verifying Organization" },
    {0x0040, 0xA030, "DT", "Verification DateTime" },
    {0x0040, 0xA032, "DT", "Observation DateTime" },
    {0x0040, 0xA040, "CS", "Value Type" },
    {0x0040, 0xA043, "SQ", "Concept Name Code Sequence" },
    {0x0040, 0xA050, "CS", "Continuity Of Content" },
    {0x0040, 0xA073, "SQ", "Verifying Observer Sequence" },
    {0x0040, 0xA075, "PN", "Verifying Observer Name" },
    {0x0040, 0xA088, "SQ", "Verifying Observer Identification Code Sequence" },
    {0x0040, 0xA0B0, "US", "Referenced Waveform Channels" },
    {0x0040, 0xA120, "DT", "DateTime" },
    {0x0040, 0xA121, "DA", "Date" },
    {0x0040, 0xA122, "TM", "Time" },
    {0x0040, 0xA123, "PN", "Person Name" },
    {0x0040, 0xA124, "UI", "UID" },
    {0x0040, 0xA130, "CS", "Temporal Range Type" },
    {0x0040, 0xA132, "UL", "Referenced Sample Positions" },
    {0x0040, 0xA136, "US", "Referenced Frame Numbers" },
    {0x0040, 0xA138, "DS", "Referenced Time Offsets" },
    {0x0040, 0xA13A, "DT", "Referenced Datetime" },
    {0x0040, 0xA160, "UT", "Text Value" },
    {0x0040, 0xA168, "SQ", "Concept Code Sequence" },
    {0x0040, 0xA170, "SQ", "Purpose of Reference Code Sequence" },
    {0x0040, 0xA180, "US", "Annotation Group Number" },
    {0x0040, 0xA195, "SQ", "Modifier Code Sequence" },
    {0x0040, 0xA300, "SQ", "Measured Value Sequence" },
    {0x0040, 0xA301, "SQ", "Numeric Value Qualifier Code Sequence" },
    {0x0040, 0xA30A, "DS", "Numeric Value" },
    {0x0040, 0xA360, "SQ", "Predecessor Documents Sequence" },
    {0x0040, 0xA370, "SQ", "Referenced Request Sequence" },
    {0x0040, 0xA372, "SQ", "Performed Procedure Code Sequence" },
    {0x0040, 0xA375, "SQ", "Current Requested Procedure Evidence Sequence" },
    {0x0040, 0xA385, "SQ", "Pertinent Other Evidence Sequence" },
    {0x0040, 0xA491, "CS", "Completion Flag" },
    {0x0040, 0xA492, "LO", "Completion Flag Description" },
    {0x0040, 0xA493, "CS", "Verification Flag" },
    {0x0040, 0xA504, "SQ", "Content Template Sequence" },
    {0x0040, 0xA525, "SQ", "Identical Documents Sequence" },
    {0x0040, 0xA730, "SQ", "Content Sequence" },
    {0x0040, 0xB020, "SQ", "Annotation Sequence" },
    {0x0040, 0xDB00, "CS", "Template Identifier" },
    {0x0040, 0xDB06, "DT", "Template Version" },
    {0x0040, 0xDB07, "DT", "Template Local Version" },
    {0x0040, 0xDB0B, "CS", "Template Extension Flag" },
    {0x0040, 0xDB0C, "UI", "Template Extension Organization UID" },
    {0x0040, 0xDB0D, "UI", "Template Extension Creator UID" },
    {0x0040, 0xDB73, "UL", "Referenced Content Item Identifier" },
    {0x0050, 0x0004, "CS", "Calibration Image" },
    {0x0050, 0x0010, "SQ", "Device Sequence" },
    {0x0050, 0x0014, "DS", "Device Length" },
    {0x0050, 0x0016, "DS", "Device Diameter" },
    {0x0050, 0x0017, "CS", "Device Diameter Units" },
    {0x0050, 0x0018, "DS", "Device Volume" },
    {0x0050, 0x0019, "DS", "Inter-marker Distance" },
    {0x0050, 0x0020, "LO", "Device Description" },
    {0x0054, 0x0010, "US", "Energy Window Vector" },
    {0x0054, 0x0011, "US", "Number of Energy Windows" },
    {0x0054, 0x0012, "SQ", "Energy Window Information Sequence" },
    {0x0054, 0x0013, "SQ", "Energy Window Range Sequence" },
    {0x0054, 0x0014, "DS", "Energy Window Lower Limit" },
    {0x0054, 0x0015, "DS", "Energy Window Upper Limit" },
    {0x0054, 0x0016, "SQ", "Radiopharmaceutical Information Sequence" },
    {0x0054, 0x0017, "IS", "Residual Syringe Counts" },
    {0x0054, 0x0018, "SH", "Energy Window Name" },
    {0x0054, 0x0020, "US", "Detector Vector" },
    {0x0054, 0x0021, "US", "Number of Detectors" },
    {0x0054, 0x0022, "SQ", "Detector Information Sequence" },
    {0x0054, 0x0030, "US", "Phase Vector" },
    {0x0054, 0x0031, "US", "Number of Phases" },
    {0x0054, 0x0032, "SQ", "Phase Information Sequence" },
    {0x0054, 0x0033, "US", "Number of Frames in Phase" },
    {0x0054, 0x0036, "IS", "Phase Delay" },
    {0x0054, 0x0038, "IS", "Pause Between Frames" },
    {0x0054, 0x0039, "CS", "Phase Description" },
    {0x0054, 0x0050, "US", "Rotation Vector" },
    {0x0054, 0x0051, "US", "Number of Rotations" },
    {0x0054, 0x0052, "SQ", "Rotation Information Sequence" },
    {0x0054, 0x0053, "US", "Number of Frames in Rotation" },
    {0x0054, 0x0060, "US", "R-R Interval Vector" },
    {0x0054, 0x0061, "US", "Number of R-R Intervals" },
    {0x0054, 0x0062, "SQ", "Gated Information Sequence" },
    {0x0054, 0x0063, "SQ", "Data Information Sequence" },
    {0x0054, 0x0070, "US", "Time Slot Vector" },
    {0x0054, 0x0071, "US", "Number of Time Slots" },
    {0x0054, 0x0072, "SQ", "Time Slot Information Sequence" },
    {0x0054, 0x0073, "DS", "Time Slot Time" },
    {0x0054, 0x0080, "US", "Slice Vector" },
    {0x0054, 0x0081, "US", "Number of Slices" },
    {0x0054, 0x0090, "US", "Angular View Vector" },
    {0x0054, 0x0100, "US", "Time Slice Vector" },
    {0x0054, 0x0101, "US", "Number of Time Slices" },
    {0x0054, 0x0200, "DS", "Start Angle" },
    {0x0054, 0x0202, "CS", "Type of Detector Motion" },
    {0x0054, 0x0210, "IS", "Trigger Vector" },
    {0x0054, 0x0211, "US", "Number of Triggers in Phase" },
    {0x0054, 0x0220, "SQ", "View Code Sequence" },
    {0x0054, 0x0222, "SQ", "View Modifier Code Sequence" },
    {0x0054, 0x0300, "SQ", "Radionuclide Code Sequence" },
    {0x0054, 0x0302, "SQ", "Administration Route Code Sequence" },
    {0x0054, 0x0304, "SQ", "Radiopharmaceutical Code Sequence" },
    {0x0054, 0x0306, "SQ", "Calibration Data Sequence" },
    {0x0054, 0x0308, "US", "Energy Window Number" },
    {0x0054, 0x0400, "SH", "Image ID" },
    {0x0054, 0x0410, "SQ", "Patient Orientation Code Sequence" },
    {0x0054, 0x0412, "SQ", "Patient Orientation Modifier Code Sequence" },
    {0x0054, 0x0414, "SQ", "Patient Gantry Relationship Code Sequence" },
    {0x0054, 0x0500, "CS", "Slice Progression Direction" },
    {0x0054, 0x1000, "CS", "Series Type" },
    {0x0054, 0x1001, "CS", "Units" },
    {0x0054, 0x1002, "CS", "Counts Source" },
    {0x0054, 0x1004, "CS", "Reprojection Method" },
    {0x0054, 0x1100, "CS", "Randoms Correction Method" },
    {0x0054, 0x1101, "LO", "Attenuation Correction Method" },
    {0x0054, 0x1102, "CS", "Decay Correction" },
    {0x0054, 0x1103, "LO", "Reconstruction Method" },
    {0x0054, 0x1104, "LO", "Detector Lines of Response Used" },
    {0x0054, 0x1105, "LO", "Scatter Correction Method" },
    {0x0054, 0x1200, "DS", "Axial Acceptance" },
    {0x0054, 0x1201, "IS", "Axial Mash" },
    {0x0054, 0x1202, "IS", "Transverse Mash" },
    {0x0054, 0x1203, "DS", "Detector Element Size" },
    {0x0054, 0x1210, "DS", "Coincidence Window Width" },
    {0x0054, 0x1220, "CS", "Secondary Counts Type" },
    {0x0054, 0x1300, "DS", "Frame Reference Time" },
    {0x0054, 0x1310, "IS", "Primary (Prompts) Counts Accumulated" },
    {0x0054, 0x1311, "IS", "Secondary Counts Accumulated" },
    {0x0054, 0x1320, "DS", "Slice Sensitivity Factor" },
    {0x0054, 0x1321, "DS", "Decay Factor" },
    {0x0054, 0x1322, "DS", "Dose Calibration Factor" },
    {0x0054, 0x1323, "DS", "Scatter Fraction Factor" },
    {0x0054, 0x1324, "DS", "Dead Time Factor" },
    {0x0054, 0x1330, "US", "Image Index" },
    {0x0054, 0x1400, "CS", "Counts Included" },
    {0x0054, 0x1401, "CS", "Dead Time Correction Flag" },
    {0x0060, 0x3000, "SQ", "Histogram Sequence" },
    {0x0060, 0x3002, "US", "Histogram Number of Bins" },
    {0x0060, 0x3004, "SS", "Histogram First Bin Value" },
    {0x0060, 0x3006, "SS", "Histogram Last Bin Value" },
    {0x0060, 0x3008, "US", "Histogram Bin Width" },
    {0x0060, 0x3010, "LO", "Histogram Explanation" },
    {0x0060, 0x3020, "UL", "Histogram Data" },
    {0x0070, 0x0001, "SQ", "Graphic Annotation Sequence" },
    {0x0070, 0x0002, "CS", "Graphic Layer" },
    {0x0070, 0x0003, "CS", "Bounding Box Annotation Units" },
    {0x0070, 0x0004, "CS", "Anchor Point Annotation Units" },
    {0x0070, 0x0005, "CS", "Graphic Annotation Units" },
    {0x0070, 0x0006, "ST", "Unformatted Text Value" },
    {0x0070, 0x0008, "SQ", "Text Object Sequence" },
    {0x0070, 0x0009, "SQ", "Graphic Object Sequence" },
    {0x0070, 0x0010, "FL", "Bounding Box Top Left Hand Corner" },
    {0x0070, 0x0011, "FL", "Bounding Box Bottom Right Hand Corner" },
    {0x0070, 0x0012, "CS", "Bounding Box Text Horizontal Justification" },
    {0x0070, 0x0014, "FL", "Anchor Point" },
    {0x0070, 0x0015, "CS", "Anchor Point Visibility" },
    {0x0070, 0x0020, "US", "Graphic Dimensions" },
    {0x0070, 0x0021, "US", "Number of Graphic Points" },
    {0x0070, 0x0022, "FL", "Graphic Data" },
    {0x0070, 0x0023, "CS", "Graphic Type" },
    {0x0070, 0x0024, "CS", "Graphic Filled" },
    {0x0070, 0x0041, "CS", "Image Horizontal Flip" },
    {0x0070, 0x0042, "US", "Image Rotation" },
    {0x0070, 0x0052, "SL", "Displayed Area Top Left Hand Corner" },
    {0x0070, 0x0053, "SL", "Displayed Area Bottom Right Hand Corner" },
    {0x0070, 0x005A, "SQ", "Displayed Area Selection Sequence" },
    {0x0070, 0x0060, "SQ", "Graphic Layer Sequence" },
    {0x0070, 0x0062, "IS", "Graphic Layer Order" },
    {0x0070, 0x0066, "US", "Graphic Layer Recommended Display Grayscale Value" },
    {0x0070, 0x0067, "US", "Graphic Layer Recommended Display RGB Value" },
    {0x0070, 0x0068, "LO", "Graphic Layer Description" },
    {0x0070, 0x0080, "CS", "Content Label" },
    {0x0070, 0x0081, "LO", "Content Description" },
    {0x0070, 0x0082, "DA", "Presentation Creation Date" },
    {0x0070, 0x0083, "TM", "Presentation Creation Time" },
    {0x0070, 0x0084, "PN", "Content Creatorfs Name" },
    {0x0070, 0x0100, "CS", "Presentation Size Mode" },
    {0x0070, 0x0101, "DS", "Presentation Pixel Spacing" },
    {0x0070, 0x0102, "IS", "Presentation Pixel Aspect Ratio" },
    {0x0070, 0x0103, "FL", "Presentation Pixel Magnification Ratio" },
    {0x0070, 0x0306, "CS", "Shape Type" },
    {0x0070, 0x0308, "SQ", "Registration Sequence" },
    {0x0070, 0x0309, "SQ", "Matrix Registration Sequence" },
    {0x0070, 0x030A, "SQ", "Matrix Sequence" },
    {0x0070, 0x030C, "CS", "Frame of Reference Transformation Matrix Type" },
    {0x0070, 0x030D, "SQ", "Registration Type Code Sequence" },
    {0x0070, 0x030F, "ST", "Fiducial Description" },
    {0x0070, 0x0310, "SH", "Fiducial Identifier" },
    {0x0070, 0x0311, "SQ", "Fiducial Identifier Code Sequence" },
    {0x0070, 0x0312, "FD", "Contour Uncertainty Radius" },
    {0x0070, 0x0314, "SQ", "Used Fiducials Sequence" },
    {0x0070, 0x0318, "SQ", "Graphic Coordinates Data Sequence" },
    {0x0070, 0x031A, "UI", "Fiducial UID" },
    {0x0070, 0x031C, "SQ", "Fiducial Set Sequence" },
    {0x0070, 0x031E, "SQ", "Fiducial Sequence" },
    {0x0088, 0x0130, "SH", "Storage Media File-set ID" },
    {0x0088, 0x0140, "UI", "Storage Media File-set UID" },
    {0x0088, 0x0200, "SQ", "Icon Image Sequence" },
    {0x0088, 0x0904, "LO", "Topic Title" },
    {0x0088, 0x0906, "ST", "Topic Subject" },
    {0x0088, 0x0910, "LO", "Topic Author" },
    {0x0088, 0x0912, "LO", "Topic Key Words" },
    {0x0100, 0x0410, "CS", "SOP Instance Status" },
    {0x0100, 0x0420, "DT", "SOP Authorization Date and Time" },
    {0x0100, 0x0424, "LT", "SOP Authorization Comment" },
    {0x0100, 0x0426, "LO", "Authorization Equipment Certification Number" },
    {0x0400, 0x0005, "US", "MAC ID Number" },
    {0x0400, 0x0010, "UI", "MAC Calculation Transfer Syntax UID" },
    {0x0400, 0x0015, "CS", "MAC Algorithm" },
    {0x0400, 0x0020, "AT", "Data Elements Signed" },
    {0x0400, 0x0100, "UI", "Digital Signature UID" },
    {0x0400, 0x0105, "DT", "Digital Signature DateTime" },
    {0x0400, 0x0110, "CS", "Certificate Type" },
    {0x0400, 0x0115, "OB", "Certificate of Signer" },
    {0x0400, 0x0120, "OB", "Signature" },
    {0x0400, 0x0305, "CS", "Certified Timestamp Type" },
    {0x0400, 0x0310, "OB", "Certified Timestamp" },
    {0x0400, 0x0500, "SQ", "Encrypted Attributes Sequence" },
    {0x0400, 0x0510, "UI", "Encrypted Content Transfer Syntax UID" },
    {0x0400, 0x0520, "OB", "Encrypted Content" },
    {0x0400, 0x0550, "SQ", "Modified Attributes Sequence" },
    {0x2000, 0x0010, "IS", "Number of Copies" },
    {0x2000, 0x001E, "SQ", "Printer Configuration Sequence" },
    {0x2000, 0x0020, "CS", "Print Priority" },
    {0x2000, 0x0030, "CS", "Medium Type" },
    {0x2000, 0x0040, "CS", "Film Destination" },
    {0x2000, 0x0050, "LO", "Film Session Label" },
    {0x2000, 0x0060, "IS", "Memory Allocation" },
    {0x2000, 0x0061, "IS", "Maximum Memory Allocation" },
    {0x2000, 0x0062, "CS", "Color Image Printing Flag" },
    {0x2000, 0x0063, "CS", "Collation Flag" },
    {0x2000, 0x0065, "CS", "Annotation Flag" },
    {0x2000, 0x0067, "CS", "Image Overlay Flag" },
    {0x2000, 0x0069, "CS", "Presentation LUT Flag" },
    {0x2000, 0x006A, "CS", "Image Box Presentation LUT Flag" },
    {0x2000, 0x00A0, "US", "Memory Bit Depth" },
    {0x2000, 0x00A1, "US", "Printing Bit Depth" },
    {0x2000, 0x00A2, "SQ", "Media Installed Sequence" },
    {0x2000, 0x00A4, "SQ", "Other Media Available Sequence" },
    {0x2000, 0x00A8, "SQ", "Supported Image Display Formats Sequence" },
    {0x2000, 0x0500, "SQ", "Referenced Film Box Sequence" },
    {0x2000, 0x0510, "SQ", "Referenced Stored Print Sequence" },
    {0x2010, 0x0010, "ST", "Image Display Format" },
    {0x2010, 0x0030, "CS", "Annotation Display Format ID" },
    {0x2010, 0x0040, "CS", "Film Orientation" },
    {0x2010, 0x0050, "CS", "Film Size ID" },
    {0x2010, 0x0052, "CS", "Printer Resolution ID" },
    {0x2010, 0x0054, "CS", "Default Printer Resolution ID" },
    {0x2010, 0x0060, "CS", "Magnification Type" },
    {0x2010, 0x0080, "CS", "Smoothing Type" },
    {0x2010, 0x00A6, "CS", "Default Magnification Type" },
    {0x2010, 0x00A7, "CS", "Other Magnification Types Available" },
    {0x2010, 0x00A8, "CS", "Default Smoothing Type" },
    {0x2010, 0x00A9, "CS", "Other Smoothing Types Available" },
    {0x2010, 0x0100, "CS", "Border Density" },
    {0x2010, 0x0110, "CS", "Empty Image Density" },
    {0x2010, 0x0120, "US", "Min Density" },
    {0x2010, 0x0130, "US", "Max Density" },
    {0x2010, 0x0140, "CS", "Trim" },
    {0x2010, 0x0150, "ST", "Configuration Information" },
    {0x2010, 0x0152, "LT", "Configuration Information Description" },
    {0x2010, 0x0154, "IS", "Maximum Collated Films" },
    {0x2010, 0x015E, "US", "Illumination" },
    {0x2010, 0x0160, "US", "Reflected Ambient Light" },
    {0x2010, 0x0376, "DS", "Printer Pixel Spacing" },
    {0x2010, 0x0500, "SQ", "Referenced Film Session Sequence" },
    {0x2010, 0x0510, "SQ", "Referenced Image Box Sequence" },
    {0x2010, 0x0520, "SQ", "Referenced Basic Annotation Box Sequence" },
    {0x2020, 0x0010, "US", "Image Position" },
    {0x2020, 0x0020, "CS", "Polarity" },
    {0x2020, 0x0030, "DS", "Requested Image Size" },
    {0x2020, 0x0040, "CS", "Requested Decimate/Crop Behavior" },
    {0x2020, 0x0050, "CS", "Requested Resolution ID" },
    {0x2020, 0x00A0, "CS", "Requested Image Size Flag" },
    {0x2020, 0x00A2, "CS", "Decimate/Crop Result" },
    {0x2020, 0x0110, "SQ", "Basic Grayscale Image Sequence" },
    {0x2020, 0x0111, "SQ", "Basic Color Image Sequence" },
    {0x2020, 0x0130, "SQ", "Referenced Image Overlay Box Sequence" },
    {0x2020, 0x0140, "SQ", "Referenced VOI LUT Box Sequence" },
    {0x2030, 0x0010, "US", "Annotation Position" },
    {0x2030, 0x0020, "LO", "Text String" },
    {0x2040, 0x0010, "SQ", "Referenced Overlay Plane Sequence" },
    {0x2040, 0x0011, "US", "Referenced Overlay Plane Groups" },
    {0x2040, 0x0020, "SQ", "Overlay Pixel Data Sequence" },
    {0x2040, 0x0060, "CS", "Overlay Magnification Type" },
    {0x2040, 0x0070, "CS", "Overlay Smoothing Type" },
    {0x2040, 0x0072, "CS", "Overlay or Image Magnification" },
    {0x2040, 0x0074, "US", "Magnify to Number of Columns" },
    {0x2040, 0x0080, "CS", "Overlay Foreground Density" },
    {0x2040, 0x0082, "CS", "Overlay Background Density" },
    {0x2040, 0x0090, "CS", "Overlay Mode" },
    {0x2040, 0x0100, "CS", "Threshold Density" },
    {0x2040, 0x0500, "SQ", "Referenced Image Box Sequence" },
    {0x2050, 0x0010, "SQ", "Presentation LUT Sequence" },
    {0x2050, 0x0020, "CS", "Presentation LUT Shape" },
    {0x2050, 0x0500, "SQ", "Referenced Presentation LUT Sequence" },
    {0x2100, 0x0010, "SH", "Print Job ID" },
    {0x2100, 0x0020, "CS", "Execution Status" },
    {0x2100, 0x0030, "CS", "Execution Status Info" },
    {0x2100, 0x0040, "DA", "Creation Date" },
    {0x2100, 0x0050, "TM", "Creation Time" },
    {0x2100, 0x0070, "AE", "Originator" },
    {0x2100, 0x0140, "AE", "Destination AE" },
    {0x2100, 0x0160, "SH", "Owner ID" },
    {0x2100, 0x0170, "IS", "Number of Films" },
    {0x2100, 0x0500, "SQ", "Referenced Print Job Sequence" },
    {0x2110, 0x0010, "CS", "Printer Status" },
    {0x2110, 0x0020, "CS", "Printer Status Info" },
    {0x2110, 0x0030, "LO", "Printer Name" },
    {0x2110, 0x0099, "SH", "Print Queue ID" },
    {0x2120, 0x0010, "CS", "Queue Status" },
    {0x2120, 0x0050, "SQ", "Print Job Description Sequence" },
    {0x2120, 0x0070, "SQ", "Referenced Print Job Sequence" },
    {0x2130, 0x0010, "SQ", "Print Management Capabilities Sequence" },
    {0x2130, 0x0015, "SQ", "Printer Characteristics Sequence" },
    {0x2130, 0x0030, "SQ", "Film Box Content Sequence" },
    {0x2130, 0x0040, "SQ", "Image Box Content Sequence" },
    {0x2130, 0x0050, "SQ", "Annotation Content Sequence" },
    {0x2130, 0x0060, "SQ", "Image Overlay Box Content Sequence" },
    {0x2130, 0x0080, "SQ", "Presentation LUT Content Sequence" },
    {0x2130, 0x00A0, "SQ", "Proposed Study Sequence" },
    {0x2130, 0x00C0, "SQ", "Original Image Sequence" },
    {0x2200, 0x0001, "CS", "Label Using Information Extracted From Instances" },
    {0x2200, 0x0002, "UT", "Label Text" },
    {0x2200, 0x0003, "CS", "Label Style Selection" },
    {0x2200, 0x0004, "LT", "Media Disposition" },
    {0x2200, 0x0005, "LT", "Barcode Value" },
    {0x2200, 0x0006, "CS", "Barcode Symbology" },
    {0x2200, 0x0007, "CS", "Allow Media Splitting" },
    {0x2200, 0x0008, "CS", "Include Non-DICOM Objects" },
    {0x2200, 0x0009, "CS", "Include Display Application" },
    {0x2200, 0x000A, "CS", "Preserve Composite Instances After Media Creation" },
    {0x2200, 0x000B, "US", "Total Number of Pieces of Media Created" },
    {0x2200, 0x000C, "LO", "Requested Media Application Profile" },
    {0x2200, 0x000D, "SQ", "Referenced Storage Media Sequence" },
    {0x2200, 0x000E, "AT", "Failure Attributes" },
    {0x2200, 0x000F, "CS", "Allow Lossy Compression" },
    {0x2200, 0x0020, "CS", "Request Priority" },
    {0x3002, 0x0002, "SH", "RT Image Label" },
    {0x3002, 0x0003, "LO", "RT Image Name" },
    {0x3002, 0x0004, "ST", "RT Image Description" },
    {0x3002, 0x000A, "CS", "Reported Values Origin" },
    {0x3002, 0x000C, "CS", "RT Image Plane" },
    {0x3002, 0x000D, "DS", "X-Ray Image Receptor Translation" },
    {0x3002, 0x000E, "DS", "X-Ray Image Receptor Angle" },
    {0x3002, 0x0010, "DS", "RT Image Orientation" },
    {0x3002, 0x0011, "DS", "Image Plane Pixel Spacing" },
    {0x3002, 0x0012, "DS", "RT Image Position" },
    {0x3002, 0x0020, "SH", "Radiation Machine Name" },
    {0x3002, 0x0022, "DS", "Radiation Machine SAD" },
    {0x3002, 0x0024, "DS", "Radiation Machine SSD" },
    {0x3002, 0x0026, "DS", "RT Image SID" },
    {0x3002, 0x0028, "DS", "Source to Reference Object Distance" },
    {0x3002, 0x0029, "IS", "Fraction Number" },
    {0x3002, 0x0030, "SQ", "Exposure Sequence" },
    {0x3002, 0x0032, "DS", "Meterset Exposure" },
    {0x3002, 0x0034, "DS", "Diaphragm Position" },
    {0x3002, 0x0040, "SQ", "Fluence Map Sequence" },
    {0x3002, 0x0041, "CS", "Fluence Data Source" },
    {0x3002, 0x0042, "DS", "Fluence Data Scale" },
    {0x3004, 0x0001, "CS", "DVH Type" },
    {0x3004, 0x0002, "CS", "Dose Units" },
    {0x3004, 0x0004, "CS", "Dose Type" },
    {0x3004, 0x0006, "LO", "Dose Comment" },
    {0x3004, 0x0008, "DS", "Normalization Point" },
    {0x3004, 0x000A, "CS", "Dose Summation Type" },
    {0x3004, 0x000C, "DS", "Grid Frame Offset Vector" },
    {0x3004, 0x000E, "DS", "Dose Grid Scaling" },
    {0x3004, 0x0010, "SQ", "RT Dose ROI Sequence" },
    {0x3004, 0x0012, "DS", "Dose Value" },
    {0x3004, 0x0014, "CS", "Tissue Heterogeneity Correction" },
    {0x3004, 0x0040, "DS", "DVH Normalization Point" },
    {0x3004, 0x0042, "DS", "DVH Normalization Dose Value" },
    {0x3004, 0x0050, "SQ", "DVH Sequence" },
    {0x3004, 0x0052, "DS", "DVH Dose Scaling" },
    {0x3004, 0x0054, "CS", "DVH Volume Units" },
    {0x3004, 0x0056, "IS", "DVH Number of Bins" },
    {0x3004, 0x0058, "DS", "DVH Data" },
    {0x3004, 0x0060, "SQ", "DVH Referenced ROI Sequence" },
    {0x3004, 0x0062, "CS", "DVH ROI Contribution Type" },
    {0x3004, 0x0070, "DS", "DVH Minimum Dose" },
    {0x3004, 0x0072, "DS", "DVH Maximum Dose" },
    {0x3004, 0x0074, "DS", "DVH Mean Dose" },
    {0x3006, 0x0002, "SH", "Structure Set Label" },
    {0x3006, 0x0004, "LO", "Structure Set Name" },
    {0x3006, 0x0006, "ST", "Structure Set Description" },
    {0x3006, 0x0008, "DA", "Structure Set Date" },
    {0x3006, 0x0009, "TM", "Structure Set Time" },
    {0x3006, 0x0010, "SQ", "Referenced Frame of Reference Sequence" },
    {0x3006, 0x0012, "SQ", "RT Referenced Study Sequence" },
    {0x3006, 0x0014, "SQ", "RT Referenced Series Sequence" },
    {0x3006, 0x0016, "SQ", "Contour Image Sequence" },
    {0x3006, 0x0020, "SQ", "Structure Set ROI Sequence" },
    {0x3006, 0x0022, "IS", "ROI Number" },
    {0x3006, 0x0024, "UI", "Referenced Frame of Reference UID" },
    {0x3006, 0x0026, "LO", "ROI Name" },
    {0x3006, 0x0028, "ST", "ROI Description" },
    {0x3006, 0x002A, "IS", "ROI Display Color" },
    {0x3006, 0x002C, "DS", "ROI Volume" },
    {0x3006, 0x0030, "SQ", "RT Related ROI Sequence" },
    {0x3006, 0x0033, "CS", "RT ROI Relationship" },
    {0x3006, 0x0036, "CS", "ROI Generation Algorithm" },
    {0x3006, 0x0038, "LO", "ROI Generation Description" },
    {0x3006, 0x0039, "SQ", "ROI Contour Sequence" },
    {0x3006, 0x0040, "SQ", "Contour Sequence" },
    {0x3006, 0x0042, "CS", "Contour Geometric Type" },
    {0x3006, 0x0044, "DS", "Contour Slab Thickness" },
    {0x3006, 0x0045, "DS", "Contour Offset Vector" },
    {0x3006, 0x0046, "IS", "Number of Contour Points" },
    {0x3006, 0x0048, "IS", "Contour Number" },
    {0x3006, 0x0049, "IS", "Attached Contours" },
    {0x3006, 0x0050, "DS", "Contour Data" },
    {0x3006, 0x0080, "SQ", "RT ROI Observations Sequence" },
    {0x3006, 0x0082, "IS", "Observation Number" },
    {0x3006, 0x0084, "IS", "Referenced ROI Number" },
    {0x3006, 0x0085, "SH", "ROI Observation Label" },
    {0x3006, 0x0086, "SQ", "RT ROI Identification Code Sequence" },
    {0x3006, 0x0088, "ST", "ROI Observation Description" },
    {0x3006, 0x00A0, "SQ", "Related RT ROI Observations Sequence" },
    {0x3006, 0x00A4, "CS", "RT ROI Interpreted Type" },
    {0x3006, 0x00A6, "PN", "ROI Interpreter" },
    {0x3006, 0x00B0, "SQ", "ROI Physical Properties Sequence" },
    {0x3006, 0x00B2, "CS", "ROI Physical Property" },
    {0x3006, 0x00B4, "DS", "ROI Physical Property Value" },
    {0x3006, 0x00C0, "SQ", "Frame of Reference Relationship Sequence" },
    {0x3006, 0x00C2, "UI", "Related Frame of Reference UID" },
    {0x3006, 0x00C4, "CS", "Frame of Reference Transformation Type" },
    {0x3006, 0x00C6, "DS", "Frame of Reference Transformation Matrix" },
    {0x3006, 0x00C8, "LO", "Frame of Reference Transformation Comment" },
    {0x3008, 0x0010, "SQ", "Measured Dose Reference Sequence" },
    {0x3008, 0x0012, "ST", "Measured Dose Description" },
    {0x3008, 0x0014, "CS", "Measured Dose Type" },
    {0x3008, 0x0016, "DS", "Measured Dose Value" },
    {0x3008, 0x0020, "SQ", "Treatment Session Beam Sequence" },
    {0x3008, 0x0022, "IS", "Current Fraction Number" },
    {0x3008, 0x0024, "DA", "Treatment Control Point Date" },
    {0x3008, 0x0025, "TM", "Treatment Control Point Time" },
    {0x3008, 0x002A, "CS", "Treatment Termination Status" },
    {0x3008, 0x002B, "SH", "Treatment Termination Code" },
    {0x3008, 0x002C, "CS", "Treatment Verification Status" },
    {0x3008, 0x0030, "SQ", "Referenced Treatment Record Sequence" },
    {0x3008, 0x0032, "DS", "Specified Primary Meterset" },
    {0x3008, 0x0033, "DS", "Specified Secondary Meterset" },
    {0x3008, 0x0036, "DS", "Delivered Primary Meterset" },
    {0x3008, 0x0037, "DS", "Delivered Secondary Meterset" },
    {0x3008, 0x003A, "DS", "Specified Treatment Time" },
    {0x3008, 0x003B, "DS", "Delivered Treatment Time" },
    {0x3008, 0x0040, "SQ", "Control Point Delivery Sequence" },
    {0x3008, 0x0042, "DS", "Specified Meterset" },
    {0x3008, 0x0044, "DS", "Delivered Meterset" },
    {0x3008, 0x0048, "DS", "Dose Rate Delivered" },
    {0x3008, 0x0050, "SQ", "Treatment Summary Calculated Dose Reference Sequence" },
    {0x3008, 0x0052, "DS", "Cumulative Dose to Dose Reference" },
    {0x3008, 0x0054, "DA", "First Treatment Date" },
    {0x3008, 0x0056, "DA", "Most Recent Treatment Date" },
    {0x3008, 0x005A, "IS", "Number of Fractions Delivered" },
    {0x3008, 0x0060, "SQ", "Override Sequence" },
    {0x3008, 0x0062, "AT", "Override Parameter Pointer" },
    {0x3008, 0x0064, "IS", "Measured Dose Reference Number" },
    {0x3008, 0x0066, "ST", "Override Reason" },
    {0x3008, 0x0070, "SQ", "Calculated Dose Reference Sequence" },
    {0x3008, 0x0072, "IS", "Calculated Dose Reference Number" },
    {0x3008, 0x0074, "ST", "Calculated Dose Reference Description" },
    {0x3008, 0x0076, "DS", "Calculated Dose Reference Dose Value" },
    {0x3008, 0x0078, "DS", "Start Meterset" },
    {0x3008, 0x007A, "DS", "End Meterset" },
    {0x3008, 0x0080, "SQ", "Referenced Measured Dose Reference Sequence" },
    {0x3008, 0x0082, "IS", "Referenced Measured Dose Reference Number" },
    {0x3008, 0x0090, "SQ", "Referenced Calculated Dose Reference Sequence" },
    {0x3008, 0x0092, "IS", "Referenced Calculated Dose Reference Number" },
    {0x3008, 0x00A0, "SQ", "Beam Limiting Device Leaf Pairs Sequence" },
    {0x3008, 0x00B0, "SQ", "Recorded Wedge Sequence" },
    {0x3008, 0x00C0, "SQ", "Recorded Compensator Sequence" },
    {0x3008, 0x00D0, "SQ", "Recorded Block Sequence" },
    {0x3008, 0x00E0, "SQ", "Treatment Summary Measured Dose Reference Sequence" },
    {0x3008, 0x0100, "SQ", "Recorded Source Sequence" },
    {0x3008, 0x0105, "LO", "Source Serial Number" },
    {0x3008, 0x0110, "SQ", "Treatment Session Application Setup Sequence" },
    {0x3008, 0x0116, "CS", "Application Setup Check" },
    {0x3008, 0x0120, "SQ", "Recorded Brachy Accessory Device Sequence" },
    {0x3008, 0x0122, "IS", "Referenced Brachy Accessory Device Number" },
    {0x3008, 0x0130, "SQ", "Recorded Channel Sequence" },
    {0x3008, 0x0132, "DS", "Specified Channel Total Time" },
    {0x3008, 0x0134, "DS", "Delivered Channel Total Time" },
    {0x3008, 0x0136, "IS", "Specified Number of Pulses" },
    {0x3008, 0x0138, "IS", "Delivered Number of Pulses" },
    {0x3008, 0x013A, "DS", "Specified Pulse Repetition Interval" },
    {0x3008, 0x013C, "DS", "Delivered Pulse Repetition Interval" },
    {0x3008, 0x0140, "SQ", "Recorded Source Applicator Sequence" },
    {0x3008, 0x0142, "IS", "Referenced Source Applicator Number" },
    {0x3008, 0x0150, "SQ", "Recorded Channel Shield Sequence" },
    {0x3008, 0x0152, "IS", "Referenced Channel Shield Number" },
    {0x3008, 0x0160, "SQ", "Brachy Control Point Delivered Sequence" },
    {0x3008, 0x0162, "DA", "Safe Position Exit Date" },
    {0x3008, 0x0164, "TM", "Safe Position Exit Time" },
    {0x3008, 0x0166, "DA", "Safe Position Return Date" },
    {0x3008, 0x0168, "TM", "Safe Position Return Time" },
    {0x3008, 0x0200, "CS", "Current Treatment Status" },
    {0x3008, 0x0202, "ST", "Treatment Status Comment" },
    {0x3008, 0x0220, "SQ", "Fraction Group Summary Sequence" },
    {0x3008, 0x0223, "IS", "Referenced Fraction Number" },
    {0x3008, 0x0224, "CS", "Fraction Group Type" },
    {0x3008, 0x0230, "CS", "Beam Stopper Position" },
    {0x3008, 0x0240, "SQ", "Fraction Status Summary Sequence" },
    {0x3008, 0x0250, "DA", "Treatment Date" },
    {0x3008, 0x0251, "TM", "Treatment Time" },
    {0x300A, 0x0002, "SH", "RT Plan Label" },
    {0x300A, 0x0003, "LO", "RT Plan Name" },
    {0x300A, 0x0004, "ST", "RT Plan Description" },
    {0x300A, 0x0006, "DA", "RT Plan Date" },
    {0x300A, 0x0007, "TM", "RT Plan Time" },
    {0x300A, 0x0009, "LO", "Treatment Protocols" },
    {0x300A, 0x000A, "CS", "Treatment Intent" },
    {0x300A, 0x000B, "LO", "Treatment Sites" },
    {0x300A, 0x000C, "CS", "RT Plan Geometry" },
    {0x300A, 0x000E, "ST", "Prescription Description" },
    {0x300A, 0x0010, "SQ", "Dose Reference Sequence" },
    {0x300A, 0x0012, "IS", "Dose Reference Number" },
    {0x300A, 0x0013, "UI", "Dose Reference UID" },
    {0x300A, 0x0014, "CS", "Dose Reference Structure Type" },
    {0x300A, 0x0015, "CS", "Nominal Beam Energy Unit" },
    {0x300A, 0x0016, "LO", "Dose Reference Description" },
    {0x300A, 0x0018, "DS", "Dose Reference Point Coordinates" },
    {0x300A, 0x001A, "DS", "Nominal Prior Dose" },
    {0x300A, 0x0020, "CS", "Dose Reference Type" },
    {0x300A, 0x0021, "DS", "Constraint Weight" },
    {0x300A, 0x0022, "DS", "Delivery Warning Dose" },
    {0x300A, 0x0023, "DS", "Delivery Maximum Dose" },
    {0x300A, 0x0025, "DS", "Target Minimum Dose" },
    {0x300A, 0x0026, "DS", "Target Prescription Dose" },
    {0x300A, 0x0027, "DS", "Target Maximum Dose" },
    {0x300A, 0x0028, "DS", "Target Underdose Volume Fraction" },
    {0x300A, 0x002A, "DS", "Organ at Risk Full-volume Dose" },
    {0x300A, 0x002B, "DS", "Organ at Risk Limit Dose" },
    {0x300A, 0x002C, "DS", "Organ at Risk Maximum Dose" },
    {0x300A, 0x002D, "DS", "Organ at Risk Overdose Volume Fraction" },
    {0x300A, 0x0040, "SQ", "Tolerance Table Sequence" },
    {0x300A, 0x0042, "IS", "Tolerance Table Number" },
    {0x300A, 0x0043, "SH", "Tolerance Table Label" },
    {0x300A, 0x0044, "DS", "Gantry Angle Tolerance" },
    {0x300A, 0x0046, "DS", "Beam Limiting Device Angle Tolerance" },
    {0x300A, 0x0048, "SQ", "Beam Limiting Device Tolerance Sequence" },
    {0x300A, 0x004A, "DS", "Beam Limiting Device Position Tolerance" },
    {0x300A, 0x004C, "DS", "Patient Support Angle Tolerance" },
    {0x300A, 0x004E, "DS", "Table Top Eccentric Angle Tolerance" },
    {0x300A, 0x0051, "DS", "Table Top Vertical Position Tolerance" },
    {0x300A, 0x0052, "DS", "Table Top Longitudinal Position Tolerance" },
    {0x300A, 0x0053, "DS", "Table Top Lateral Position Tolerance" },
    {0x300A, 0x0055, "CS", "RT Plan Relationship" },
    {0x300A, 0x0070, "SQ", "Fraction Group Sequence" },
    {0x300A, 0x0071, "IS", "Fraction Group Number" },
    {0x300A, 0x0072, "LO", "Fraction Group Description" },
    {0x300A, 0x0078, "IS", "Number of Fractions Planned" },
    {0x300A, 0x0079, "IS", "Number of Fraction Pattern Digits Per Day" },
    {0x300A, 0x007A, "IS", "Repeat Fraction Cycle Length" },
    {0x300A, 0x007B, "LT", "Fraction Pattern" },
    {0x300A, 0x0080, "IS", "Number of Beams" },
    {0x300A, 0x0082, "DS", "Beam Dose Specification Point" },
    {0x300A, 0x0084, "DS", "Beam Dose" },
    {0x300A, 0x0086, "DS", "Beam Meterset" },
    {0x300A, 0x00A0, "IS", "Number of Brachy Application Setups" },
    {0x300A, 0x00A2, "DS", "Brachy Application Setup Dose Specification Point" },
    {0x300A, 0x00A4, "DS", "Brachy Application Setup Dose" },
    {0x300A, 0x00B0, "SQ", "Beam Sequence" },
    {0x300A, 0x00B2, "SH", "Treatment Machine Name" },
    {0x300A, 0x00B3, "CS", "Primary Dosimeter Unit" },
    {0x300A, 0x00B4, "DS", "Source-Axis Distance" },
    {0x300A, 0x00B6, "SQ", "Beam Limiting Device Sequence" },
    {0x300A, 0x00B8, "CS", "RT Beam Limiting Device Type" },
    {0x300A, 0x00BA, "DS", "Source to Beam Limiting Device Distance" },
    {0x300A, 0x00BC, "IS", "Number of Leaf/Jaw Pairs" },
    {0x300A, 0x00BE, "DS", "Leaf Position Boundaries" },
    {0x300A, 0x00C0, "IS", "Beam Number" },
    {0x300A, 0x00C2, "LO", "Beam Name" },
    {0x300A, 0x00C3, "ST", "Beam Description" },
    {0x300A, 0x00C4, "CS", "Beam Type" },
    {0x300A, 0x00C6, "CS", "Radiation Type" },
    {0x300A, 0x00C7, "CS", "High-Dose Technique Type" },
    {0x300A, 0x00C8, "IS", "Reference Image Number" },
    {0x300A, 0x00CA, "SQ", "Planned Verification Image Sequence" },
    {0x300A, 0x00CC, "LO", "Imaging Device-Specific Acquisition Parameters" },
    {0x300A, 0x00CE, "CS", "Treatment Delivery Type" },
    {0x300A, 0x00D0, "IS", "Number of Wedges" },
    {0x300A, 0x00D1, "SQ", "Wedge Sequence" },
    {0x300A, 0x00D2, "IS", "Wedge Number" },
    {0x300A, 0x00D3, "CS", "Wedge Type" },
    {0x300A, 0x00D4, "SH", "Wedge ID" },
    {0x300A, 0x00D5, "IS", "Wedge Angle" },
    {0x300A, 0x00D6, "DS", "Wedge Factor" },
    {0x300A, 0x00D8, "DS", "Wedge Orientation" },
    {0x300A, 0x00DA, "DS", "Source to Wedge Tray Distance" },
    {0x300A, 0x00E0, "IS", "Number of Compensators" },
    {0x300A, 0x00E1, "SH", "Material ID" },
    {0x300A, 0x00E2, "DS", "Total Compensator Tray Factor" },
    {0x300A, 0x00E3, "SQ", "Compensator Sequence" },
    {0x300A, 0x00E4, "IS", "Compensator Number" },
    {0x300A, 0x00E5, "SH", "Compensator ID" },
    {0x300A, 0x00E6, "DS", "Source to Compensator Tray Distance" },
    {0x300A, 0x00E7, "IS", "Compensator Rows" },
    {0x300A, 0x00E8, "IS", "Compensator Columns" },
    {0x300A, 0x00E9, "DS", "Compensator Pixel Spacing" },
    {0x300A, 0x00EA, "DS", "Compensator Position" },
    {0x300A, 0x00EB, "DS", "Compensator Transmission Data" },
    {0x300A, 0x00EC, "DS", "Compensator Thickness Data" },
    {0x300A, 0x00ED, "IS", "Number of Boli" },
    {0x300A, 0x00EE, "CS", "Compensator Type" },
    {0x300A, 0x00F0, "IS", "Number of Blocks" },
    {0x300A, 0x00F2, "DS", "Total Block Tray Factor" },
    {0x300A, 0x00F4, "SQ", "Block Sequence" },
    {0x300A, 0x00F5, "SH", "Block Tray ID" },
    {0x300A, 0x00F6, "DS", "Source to Block Tray Distance" },
    {0x300A, 0x00F8, "CS", "Block Type" },
    {0x300A, 0x00F9, "LO", "Accessory Code" },
    {0x300A, 0x00FA, "CS", "Block Divergence" },
    {0x300A, 0x00FB, "CS", "Block Mounting Position" },
    {0x300A, 0x00FC, "IS", "Block Number" },
    {0x300A, 0x00FE, "LO", "Block Name" },
    {0x300A, 0x0100, "DS", "Block Thickness" },
    {0x300A, 0x0102, "DS", "Block Transmission" },
    {0x300A, 0x0104, "IS", "Block Number of Points" },
    {0x300A, 0x0106, "DS", "Block Data" },
    {0x300A, 0x0107, "SQ", "Applicator Sequence" },
    {0x300A, 0x0108, "SH", "Applicator ID" },
    {0x300A, 0x0109, "CS", "Applicator Type" },
    {0x300A, 0x010A, "LO", "Applicator Description" },
    {0x300A, 0x010C, "DS", "Cumulative Dose Reference Coefficient" },
    {0x300A, 0x010E, "DS", "Final Cumulative Meterset Weight" },
    {0x300A, 0x0110, "IS", "Number of Control Points" },
    {0x300A, 0x0111, "SQ", "Control Point Sequence" },
    {0x300A, 0x0112, "IS", "Control Point Index" },
    {0x300A, 0x0114, "DS", "Nominal Beam Energy" },
    {0x300A, 0x0115, "DS", "Dose Rate Set" },
    {0x300A, 0x0116, "SQ", "Wedge Position Sequence" },
    {0x300A, 0x0118, "CS", "Wedge Position" },
    {0x300A, 0x011A, "SQ", "Beam Limiting Device Position Sequence" },
    {0x300A, 0x011C, "DS", "Leaf/Jaw Positions" },
    {0x300A, 0x011E, "DS", "Gantry Angle" },
    {0x300A, 0x011F, "CS", "Gantry Rotation Direction" },
    {0x300A, 0x0120, "DS", "Beam Limiting Device Angle" },
    {0x300A, 0x0121, "CS", "Beam Limiting Device Rotation Direction" },
    {0x300A, 0x0122, "DS", "Patient Support Angle" },
    {0x300A, 0x0123, "CS", "Patient Support Rotation Direction" },
    {0x300A, 0x0124, "DS", "Table Top Eccentric Axis Distance" },
    {0x300A, 0x0125, "DS", "Table Top Eccentric Angle" },
    {0x300A, 0x0126, "CS", "Table Top Eccentric Rotation Direction" },
    {0x300A, 0x0128, "DS", "Table Top Vertical Position" },
    {0x300A, 0x0129, "DS", "Table Top Longitudinal Position" },
    {0x300A, 0x012A, "DS", "Table Top Lateral Position" },
    {0x300A, 0x012C, "DS", "Isocenter Position" },
    {0x300A, 0x012E, "DS", "Surface Entry Point" },
    {0x300A, 0x0130, "DS", "Source to Surface Distance" },
    {0x300A, 0x0134, "DS", "Cumulative Meterset Weight" },
    {0x300A, 0x0180, "SQ", "Patient Setup Sequence" },
    {0x300A, 0x0182, "IS", "Patient Setup Number" },
    {0x300A, 0x0184, "LO", "Patient Additional Position" },
    {0x300A, 0x0190, "SQ", "Fixation Device Sequence" },
    {0x300A, 0x0192, "CS", "Fixation Device Type" },
    {0x300A, 0x0194, "SH", "Fixation Device Label" },
    {0x300A, 0x0196, "ST", "Fixation Device Description" },
    {0x300A, 0x0198, "SH", "Fixation Device Position" },
    {0x300A, 0x01A0, "SQ", "Shielding Device Sequence" },
    {0x300A, 0x01A2, "CS", "Shielding Device Type" },
    {0x300A, 0x01A4, "SH", "Shielding Device Label" },
    {0x300A, 0x01A6, "ST", "Shielding Device Description" },
    {0x300A, 0x01A8, "SH", "Shielding Device Position" },
    {0x300A, 0x01B0, "CS", "Setup Technique" },
    {0x300A, 0x01B2, "ST", "Setup Technique Description" },
    {0x300A, 0x01B4, "SQ", "Setup Device Sequence" },
    {0x300A, 0x01B6, "CS", "Setup Device Type" },
    {0x300A, 0x01B8, "SH", "Setup Device Label" },
    {0x300A, 0x01BA, "ST", "Setup Device Description" },
    {0x300A, 0x01BC, "DS", "Setup Device Parameter" },
    {0x300A, 0x01D0, "ST", "Setup Reference Description" },
    {0x300A, 0x01D2, "DS", "Table Top Vertical Setup Displacement" },
    {0x300A, 0x01D4, "DS", "Table Top Longitudinal Setup Displacement" },
    {0x300A, 0x01D6, "DS", "Table Top Lateral Setup Displacement" },
    {0x300A, 0x0200, "CS", "Brachy Treatment Technique" },
    {0x300A, 0x0202, "CS", "Brachy Treatment Type" },
    {0x300A, 0x0206, "SQ", "Treatment Machine Sequence" },
    {0x300A, 0x0210, "SQ", "Source Sequence" },
    {0x300A, 0x0212, "IS", "Source Number" },
    {0x300A, 0x0214, "CS", "Source Type" },
    {0x300A, 0x0216, "LO", "Source Manufacturer" },
    {0x300A, 0x0218, "DS", "Active Source Diameter" },
    {0x300A, 0x021A, "DS", "Active Source Length" },
    {0x300A, 0x0222, "DS", "Source Encapsulation Nominal Thickness" },
    {0x300A, 0x0224, "DS", "Source Encapsulation Nominal Transmission" },
    {0x300A, 0x0226, "LO", "Source Isotope Name" },
    {0x300A, 0x0228, "DS", "Source Isotope Half Life" },
    {0x300A, 0x022A, "DS", "Reference Air Kerma Rate" },
    {0x300A, 0x022C, "DA", "Air Kerma Rate Reference Date" },
    {0x300A, 0x022E, "TM", "Air Kerma Rate Reference Time" },
    {0x300A, 0x0230, "SQ", "Application Setup Sequence" },
    {0x300A, 0x0232, "CS", "Application Setup Type" },
    {0x300A, 0x0234, "IS", "Application Setup Number" },
    {0x300A, 0x0236, "LO", "Application Setup Name" },
    {0x300A, 0x0238, "LO", "Application Setup Manufacturer" },
    {0x300A, 0x0240, "IS", "Template Number" },
    {0x300A, 0x0242, "SH", "Template Type" },
    {0x300A, 0x0244, "LO", "Template Name" },
    {0x300A, 0x0250, "DS", "Total Reference Air Kerma" },
    {0x300A, 0x0260, "SQ", "Brachy Accessory Device Sequence" },
    {0x300A, 0x0262, "IS", "Brachy Accessory Device Number" },
    {0x300A, 0x0263, "SH", "Brachy Accessory Device ID" },
    {0x300A, 0x0264, "CS", "Brachy Accessory Device Type" },
    {0x300A, 0x0266, "LO", "Brachy Accessory Device Name" },
    {0x300A, 0x026A, "DS", "Brachy Accessory Device Nominal Thickness" },
    {0x300A, 0x026C, "DS", "Brachy Accessory Device Nominal Transmission" },
    {0x300A, 0x0280, "SQ", "Channel Sequence" },
    {0x300A, 0x0282, "IS", "Channel Number" },
    {0x300A, 0x0284, "DS", "Channel Length" },
    {0x300A, 0x0286, "DS", "Channel Total Time" },
    {0x300A, 0x0288, "CS", "Source Movement Type" },
    {0x300A, 0x028A, "IS", "Number of Pulses" },
    {0x300A, 0x028C, "DS", "Pulse Repetition Interval" },
    {0x300A, 0x0290, "IS", "Source Applicator Number" },
    {0x300A, 0x0291, "SH", "Source Applicator ID" },
    {0x300A, 0x0292, "CS", "Source Applicator Type" },
    {0x300A, 0x0294, "LO", "Source Applicator Name" },
    {0x300A, 0x0296, "DS", "Source Applicator Length" },
    {0x300A, 0x0298, "LO", "Source Applicator Manufacturer" },
    {0x300A, 0x029C, "DS", "Source Applicator Wall Nominal Thickness" },
    {0x300A, 0x029E, "DS", "Source Applicator Wall Nominal Transmission" },
    {0x300A, 0x02A0, "DS", "Source Applicator Step Size" },
    {0x300A, 0x02A2, "IS", "Transfer Tube Number" },
    {0x300A, 0x02A4, "DS", "Transfer Tube Length" },
    {0x300A, 0x02B0, "SQ", "Channel Shield Sequence" },
    {0x300A, 0x02B2, "IS", "Channel Shield Number" },
    {0x300A, 0x02B3, "SH", "Channel Shield ID" },
    {0x300A, 0x02B4, "LO", "Channel Shield Name" },
    {0x300A, 0x02B8, "DS", "Channel Shield Nominal Thickness" },
    {0x300A, 0x02BA, "DS", "Channel Shield Nominal Transmission" },
    {0x300A, 0x02C8, "DS", "Final Cumulative Time Weight" },
    {0x300A, 0x02D0, "SQ", "Brachy Control Point Sequence" },
    {0x300A, 0x02D2, "DS", "Control Point Relative Position" },
    {0x300A, 0x02D4, "DS", "Control Point 3D Position" },
    {0x300A, 0x02D6, "DS", "Cumulative Time Weight" },
    {0x300A, 0x02E0, "CS", "Compensator Divergence" },
    {0x300A, 0x02E1, "CS", "Compensator Mounting Position" },
    {0x300A, 0x02E2, "DS", "Source to Compensator Distance" },
    {0x300C, 0x0002, "SQ", "Referenced RT Plan Sequence" },
    {0x300C, 0x0004, "SQ", "Referenced Beam Sequence" },
    {0x300C, 0x0006, "IS", "Referenced Beam Number" },
    {0x300C, 0x0007, "IS", "Referenced Reference Image Number" },
    {0x300C, 0x0008, "DS", "Start Cumulative Meterset Weight" },
    {0x300C, 0x0009, "DS", "End Cumulative Meterset Weight" },
    {0x300C, 0x000A, "SQ", "Referenced Brachy Application Setup Sequence" },
    {0x300C, 0x000C, "IS", "Referenced Brachy Application Setup Number" },
    {0x300C, 0x000E, "IS", "Referenced Source Number" },
    {0x300C, 0x0020, "SQ", "Referenced Fraction Group Sequence" },
    {0x300C, 0x0022, "IS", "Referenced Fraction Group Number" },
    {0x300C, 0x0040, "SQ", "Referenced Verification Image Sequence" },
    {0x300C, 0x0042, "SQ", "Referenced Reference Image Sequence" },
    {0x300C, 0x0050, "SQ", "Referenced Dose Reference Sequence" },
    {0x300C, 0x0051, "IS", "Referenced Dose Reference Number" },
    {0x300C, 0x0055, "SQ", "Brachy Referenced Dose Reference Sequence" },
    {0x300C, 0x0060, "SQ", "Referenced Structure Set Sequence" },
    {0x300C, 0x006A, "IS", "Referenced Patient Setup Number" },
    {0x300C, 0x0080, "SQ", "Referenced Dose Sequence" },
    {0x300C, 0x00A0, "IS", "Referenced Tolerance Table Number" },
    {0x300C, 0x00B0, "SQ", "Referenced Bolus Sequence" },
    {0x300C, 0x00C0, "IS", "Referenced Wedge Number" },
    {0x300C, 0x00D0, "IS", "Referenced Compensator Number" },
    {0x300C, 0x00E0, "IS", "Referenced Block Number" },
    {0x300C, 0x00F0, "IS", "Referenced Control Point Index" },
    {0x300E, 0x0002, "CS", "Approval Status" },
    {0x300E, 0x0004, "DA", "Review Date" },
    {0x300E, 0x0005, "TM", "Review Time" },
    {0x300E, 0x0008, "PN", "Reviewer Name" },
    {0x4008, 0x0040, "SH", "Results ID" },
    {0x4008, 0x0042, "LO", "Results ID Issuer" },
    {0x4008, 0x0050, "SQ", "Referenced Interpretation Sequence" },
    {0x4008, 0x0100, "DA", "Interpretation Recorded Date" },
    {0x4008, 0x0101, "TM", "Interpretation Recorded Time" },
    {0x4008, 0x0102, "PN", "Interpretation Recorder" },
    {0x4008, 0x0103, "LO", "Reference to Recorded Sound" },
    {0x4008, 0x0108, "DA", "Interpretation Transcription Date" },
    {0x4008, 0x0109, "TM", "Interpretation Transcription Time" },
    {0x4008, 0x010A, "PN", "Interpretation Transcriber" },
    {0x4008, 0x010B, "ST", "Interpretation Text" },
    {0x4008, 0x010C, "PN", "Interpretation Author" },
    {0x4008, 0x0111, "SQ", "Interpretation Approver Sequence" },
    {0x4008, 0x0112, "DA", "Interpretation Approval Date" },
    {0x4008, 0x0113, "TM", "Interpretation Approval Time" },
    {0x4008, 0x0114, "PN", "Physician Approving Interpretation" },
    {0x4008, 0x0115, "LT", "Interpretation Diagnosis Description" },
    {0x4008, 0x0117, "SQ", "Interpretation Diagnosis Code Sequence" },
    {0x4008, 0x0118, "SQ", "Results Distribution List Sequence" },
    {0x4008, 0x0119, "PN", "Distribution Name" },
    {0x4008, 0x011A, "LO", "Distribution Address" },
    {0x4008, 0x0200, "SH", "Interpretation ID" },
    {0x4008, 0x0202, "LO", "Interpretation ID Issuer" },
    {0x4008, 0x0210, "CS", "Interpretation Type ID" },
    {0x4008, 0x0212, "CS", "Interpretation Status ID" },
    {0x4008, 0x0300, "ST", "Impressions" },
    {0x4008, 0x4000, "ST", "Results Comments" },
    {0x4FFE, 0x0001, "SQ", "MAC Parameters Sequence" },
	/*
    {0x50xx, 0x0005, "US", "Curve Dimensions" },
    {0x50xx, 0x0010, "US", "Number of Points" },
    {0x50xx, 0x0020, "CS", "Type of Data" },
    {0x50xx, 0x0022, "LO", "Curve Description" },
    {0x50xx, 0x0030, "SH", "Axis Units" },
    {0x50xx, 0x0040, "SH", "Axis Labels" },
    {0x50xx, 0x0103, "US", "Data Value Representation" },
    {0x50xx, 0x0104, "US", "Minimum Coordinate Value" },
    {0x50xx, 0x0105, "US", "Maximum Coordinate Value" },
    {0x50xx, 0x0106, "SH", "Curve Range" },
    {0x50xx, 0x0110, "US", "Curve Data Descriptor" },
    {0x50xx, 0x0112, "US", "Coordinate Start Value" },
    {0x50xx, 0x0114, "US", "Coordinate Step Value" },
    {0x50xx, 0x1001, "CS", "Curve Activation Layer" },
    {0x50xx, 0x2000, "US", "Audio Type" },
    {0x50xx, 0x2002, "US", "Audio Sample Format" },
    {0x50xx, 0x2004, "US", "Number of Channels" },
    {0x50xx, 0x2006, "UL", "Number of Samples" },
    {0x50xx, 0x2008, "UL", "Sample Rate" },
    {0x50xx, 0x200A, "UL", "Total Time" },
    {0x50xx, 0x200C, "OB", "Audio Sample Data" },
    {0x50xx, 0x200E, "LT", "Audio Comments" },
    {0x50xx, 0x2500, "LO", "Curve Label" },
    {0x50xx, 0x2600, "SQ", "Referenced Overlay Sequence" },
    {0x50xx, 0x2610, "US", "Referenced Overlay Group" },
    {0x50xx, 0x3000, "OB", "Curve Data" },
	*/
    {0x5200, 0x9229, "SQ", "Shared Functional Groups Sequence" },
    {0x5200, 0x9230, "SQ", "Per-frame Functional Groups Sequence" },
    {0x5400, 0x0100, "SQ", "Waveform Sequence" },
    {0x5400, 0x0110, "OW", "Channel Minimum Value" },
    {0x5400, 0x0112, "OW", "Channel Maximum Value" },
    {0x5400, 0x1004, "US", "Waveform Bits Allocated" },
    {0x5400, 0x1006, "CS", "Waveform Sample Interpretation" },
    {0x5400, 0x100A, "OW", "Waveform Padding Value" },
    {0x5400, 0x1010, "OW", "Waveform Data" },
    {0x5600, 0x0010, "OF", "First Order Phase Correction Angle" },
    {0x5600, 0x0020, "OF", "Spectroscopy Data" },
	/*
    {0x60xx, 0x0010, "US", "Overlay Rows" },
    {0x60xx, 0x0011, "US", "Overlay Columns" },
    {0x60xx, 0x0012, "US", "Overlay Planes" },
    {0x60xx, 0x0015, "IS", "Number of Frames in Overlay" },
    {0x60xx, 0x0022, "LO", "Overlay Description" },
    {0x60xx, 0x0040, "CS", "Overlay Type" },
    {0x60xx, 0x0045, "LO", "Overlay Subtype" },
    {0x60xx, 0x0050, "SS", "Overlay Origin" },
    {0x60xx, 0x0051, "US", "Image Frame Origin" },
    {0x60xx, 0x0052, "US", "Overlay Plane Origin" },
    {0x60xx, 0x0100, "US", "Overlay Bits Allocated" },
    {0x60xx, 0x0102, "US", "Overlay Bit Position" },
    {0x60xx, 0x1001, "CS", "Overlay Activation Layer" },
    {0x60xx, 0x1100, "US", "Overlay Descriptor . Gray" },
    {0x60xx, 0x1101, "US", "Overlay Descriptor . Red" },
    {0x60xx, 0x1102, "US", "Overlay Descriptor . Green" },
    {0x60xx, 0x1103, "US", "Overlay Descriptor . Blue" },
    {0x60xx, 0x1200, "US", "Overlays- Gray" },
    {0x60xx, 0x1201, "US", "Overlays . Red" },
    {0x60xx, 0x1202, "US", "Overlays . Green" },
    {0x60xx, 0x1203, "US", "Overlays- Blue" },
    {0x60xx, 0x1301, "IS", "ROI Area" },
    {0x60xx, 0x1302, "DS", "ROI Mean" },
    {0x60xx, 0x1303, "DS", "ROI Standard Deviation" },
    {0x60xx, 0x1500, "LO", "Overlay Label" },
    {0x60xx, 0x3000, "OW", "Overlay Data" },
	*/
    {0x7FE0, 0x0010, "OB", "Pixel Data" },
    {0xFFFA, 0xFFFA, "SQ", "Digital Signatures Sequence" },
    {0xFFFC, 0xFFFC, "OB", "Data Set Trailing Padding" },

	{0x6971, 0x0001, "US", "" },
	{0x6971, 0x0002, "OB", "" },
	{0x6971, 0x0003, "US", "" },
	{0x6971, 0x0004, "SQ", "" },
	{0x6971, 0x0005, "FL", "" },
	{0x6971, 0x0006, "CS", "" },
};

void Dictionary::setData()
{
	int dic_size = sizeof( g_dic ) / sizeof( g_dic[0] );
	DictionaryItem item;

	for( int i=0; i < dic_size; i++ ){
		item.setID( g_dic[i].groupID, g_dic[i].elementID );
		item.setVR( g_dic[i].vr );
		item.setExplanation( g_dic[i].explanation );
		addItem( item );
	}
}

const DictionaryItem* Dictionary::Find( ushort g, ushort e ) const
{
	const std::list<DictionaryItem>* chain = item_chain[e];
	if( chain == NULL ){ return NULL; }

	std::list<DictionaryItem>::const_iterator it = chain->begin();
	for( ; it != chain->end(); ++it ){
		if( it->groupID() == g ){
			return &(*it);
		}
	}

	return NULL;
}

