#ifndef INCLUDE_DICOMDATA_H
#define INCLUDE_DICOMDATA_H

//#include "BufferedSequence.h"
#include "ConcreteSequence.h"


namespace docmi{

/** Dicomf[^iDICOMvfW+^j
 */
class DicomData : public ConcreteSequence
{
private:
	FileInputController m_input;
	// (0002,0001) File Meta Information Version OB
	String media_storage_sop_class_uid;     // (0002,0002) Media Storage SOP Class UID UI
	String media_storage_sop_instance_uid;  // (0002,0003) Media Storage SOP Instance UID UI
	String transfer_syntax_uid;             // (0002,0010) Transfer Syntax UID UI
	String implementation_class_uid;        // (0002,0012) Implementation Class UID UI
	String implementation_version_name;     // (0002,0013) Implementation Version Name SH
	String source_application_entity_title; // (0002,0016) Source Application Entity Title AE
	// (0002,0100) Private Information Creator UID UI
	// (0002,0102) Private Information OB

public:

	DicomData(){}

	DicomData( const DicomData& rhs ): ConcreteSequence( rhs )
	{
		setMediaStorageSopClassUid( getMediaStorageSopClassUid() );
		setMediaStorageSopInstanceUid( getMediaStorageSopInstanceUid() );
		setTransferSyntaxUid( getTransferSyntaxUid() );
		setImplementationClassUid( getImplementationClassUid() );
		setImplementationVersionName( getImplementationVersionName() );
		setSourceApplicationEntityTitle( getSourceApplicationEntityTitle() );
	}

	virtual void clear()
	{
		ConcreteSequence::clear();
		setMediaStorageSopClassUid( "" );
		setMediaStorageSopInstanceUid( "" );
		setTransferSyntaxUid( "" );
		setImplementationClassUid( "" );
		setImplementationVersionName( "" );
		setSourceApplicationEntityTitle( "" );
	}

	virtual Sequence* clone()
	{
		return new DicomData( *this );
	}

	String getMediaStorageSopClassUid(){ return media_storage_sop_class_uid; }
	String getMediaStorageSopInstanceUid(){ return media_storage_sop_instance_uid; }
	String getTransferSyntaxUid(){ return transfer_syntax_uid; }
	String getImplementationClassUid(){ return implementation_class_uid; }
	String getImplementationVersionName(){ return implementation_version_name; }
	String getSourceApplicationEntityTitle(){ return source_application_entity_title; }

	void setMediaStorageSopClassUid( const char* value ){ media_storage_sop_class_uid = value; }
	void setMediaStorageSopInstanceUid( const char* value ){ media_storage_sop_instance_uid = value; }
	void setTransferSyntaxUid( const char* value ){ transfer_syntax_uid = value; }
	void setImplementationClassUid( const char* value ){ implementation_class_uid = value; }
	void setImplementationVersionName( const char* value ){ implementation_version_name = value; }
	void setSourceApplicationEntityTitle( const char* value ){ source_application_entity_title = value; }
};


} // namespace docmi

#endif
