#ifndef INCLUDE_DOCMI_BASE_H
#define INCLUDE_DOCMI_BASE_H

#pragma warning(disable: 4786)

#include <vector>
#include <list>
#include <string>

typedef unsigned int   uint;
typedef unsigned short ushort;
typedef unsigned char  uchar;

namespace docmi{



typedef std::string base_string;

/** operator const char*()std::stringTuNX
 */
class String : public base_string
{
public:
	explicit String(): base_string(){}
	String(const base_string& rhs): base_string(rhs){}
	String(const base_string& rhs, size_type pos, size_type n): base_string( rhs, pos, n ){}
	String(const char *s, size_type n): base_string( s, n ){}
	String(const char *s): base_string( s ){}
	String(size_type n, char c): base_string( n, c ){}
	String(const_iterator first, const_iterator last): base_string(first, last){}

	operator const char*()
	{
		return c_str();
	}

	String csubstr( size_type pos = 0, size_type n = npos) const
	{
		return substr( pos, n );
	}
};

// printfĕԂ
String strprintf( const char* str_format, ... );
class Exception{
	String error;
public:
	Exception(){}
	Exception( const char* error ){
		this->error = error;
	}
	String message(){ return error; }
	int  code(){ return 0; }
};


/** QƃJE^tf[^NX
 */
class ReferenceData
{
	uchar* m_data;
	int     m_length;
	int     m_counter;

	ReferenceData( const uchar* data, int length ){
		m_length = length;
		m_data = new uchar[length+1];
		if( length > 0 ){
			memcpy( m_data, data, length );
		}
		// ZbgꂽAɕϊ
		if( m_length % 2 ){
			m_data[m_length] = 0;
			m_length += 1;
		}
		m_counter = 1;
	}

	ReferenceData( const ReferenceData& rhs );
	ReferenceData& operator=( const ReferenceData& rhs );

	~ReferenceData(){
		delete [] m_data;
	}

public:
	// QƃJE^𑝂₷
	void AddRef(){
		m_counter++;
	}

	// QƃJE^炷
	void Release()
	{
		m_counter--;
		if( m_counter <= 0 ){
			delete this;
		} else {
		}
	}

	// CX^X쐬
	static ReferenceData* Create( const uchar* data, int length )
	{
		return new ReferenceData( data, length );
	}

	const uchar* data() const{ return m_data; }
	int length() const{ return m_length; }
};

/** oCif[^ێNX(QƃJE^)
 */
class BinaryData
{
	ReferenceData* m_ref_data;

	void copy( const BinaryData& rhs ){
		rhs.m_ref_data->AddRef();
		m_ref_data->Release();
		m_ref_data = rhs.m_ref_data;
	}

	void setDummyData()
	{
		static bool b_first = true;
		static ReferenceData* dummy_data;
		if( b_first ){
			uchar data[1];
			dummy_data = ReferenceData::Create( data, 0 );
			b_first = false;
		}
		
		m_ref_data = dummy_data;
		m_ref_data->AddRef();
	}
public:
	BinaryData(){
		setDummyData();
	}

	BinaryData( const BinaryData& rhs ){
		setDummyData();
		copy( rhs );
	}

	BinaryData& operator=( const BinaryData& rhs ){
		if( this != &rhs ){
			copy( rhs );
		}
		return *this;
	}

	virtual ~BinaryData(){
		m_ref_data->Release();
	}

	void setData( const uchar* data, int length ){
		m_ref_data->Release();
		m_ref_data = ReferenceData::Create( data, length );
	}

	void clear()
	{
		uchar data[1];
		setData( data, 0 );
	}

	const uchar* data() const{ return m_ref_data->data(); }
	int length() const{ return m_ref_data->length(); }
	int size() const{ return length(); } // synonym of length()

	// ^OɊ܂܂f[^̈ꕔԂB
	int getPart( uchar* buf, int start, int request_size ) const
	{
		if( start < 0 || start >= length() ){ return 0; }
		int copy_size = __min( request_size, size() - start );
		memcpy( buf, data() + start, copy_size );
		return copy_size;
	}
};

template <class T>
T getMin( T a, T b ){
	return ( a <= b )? a: b;
}

template <class T>
T getMax( T a, T b ){
	return ( a >= b )? a: b;
}

} // namespace docmi


#endif

