unit ecma_wsh;

//WSH Object
//2002/12/21 ~
//by Wolfy

interface

uses
  Windows,Sysutils,Classes,ecma_type,ecma_object,ecma_activex,ecma_misc,
  regexpr;

type  
  TJWshNamedObject = class(TJObject)
  private
    function DoExists(Param: TJValueList): TJValue;
    function DoItem(Param: TJValueList): TJValue;
    function GetLength: Integer;
  protected
    function GetPropertyList: String; override;
  public
    constructor Create(AFactory: TJObjectFactory; Param: TJValueList); override;
  published
    property Length: Integer read GetLength;
    property Count: Integer read GetLength;
  end;

  TJWshUnnamedObject = class(TJArrayObject)
  private
    function DoItem(Param: TJValueList): TJValue;
  public
    constructor Create(AFactory: TJObjectFactory; Param: TJValueList); override;
  published
    property Count;
  end;

  TJWshArgumentsObject = class(TJArrayObject)
  private
    FNamed: TJWshNamedObject;
    FUnnamed: TJWshUnnamedObject;

    function DoItem(Param: TJValueList): TJValue;
    function DoShowUsage(Param: TJValueList): TJValue;     
  public
    constructor Create(AFactory: TJObjectFactory; Param: TJValueList); override;
    destructor Destroy; override;
    procedure Parse(Args: TJArrayObject);
  published
    property Count;
    property Named: TJWshNamedObject read FNamed;
    property Unnamed: TJWshUnnamedObject read FUnnamed;
  end;

  TJWshBaseStreamObject = class(TJObject)
  private
    FOnRead: TReadStringEvent;
    FOnWrite: TStringEvent;
    function GetAtEndOfLine: Boolean;
    function GetColumn: Integer;
    function GetLine: Integer;

    procedure Write(Param: TJValueList; Line: Boolean; Breaks: Integer = 0);
    function Read: String;
  protected
    function DoClose(Param: TJValueList): TJValue;

    function DoRead(Param: TJValueList): TJValue;
    function DoReadAll(Param: TJValueList): TJValue;
    function DoReadLine(Param: TJValueList): TJValue;
    function DoSkip(Param: TJValueList): TJValue;
    function DoSkipLine(Param: TJValueList): TJValue;

    function DoWrite(Param: TJValueList): TJValue;
    function DoWriteBlankLines(Param: TJValueList): TJValue;
    function DoWriteLine(Param: TJValueList): TJValue;
    
  public
    constructor Create(AFactory: TJObjectFactory; Param: TJValueList); override;

    property OnWrite: TStringEvent read FOnWrite write FOnWrite;
    property OnRead: TReadStringEvent read FOnRead write FOnRead;

    property AtEndOfLine: Boolean read GetAtEndOfLine;
  published
    property Column: Integer read GetColumn;
    property Line: Integer read GetLine;
  end;

  TJWshReadStreamObject = class(TJWshBaseStreamObject)
  public
    constructor Create(AFactory: TJObjectFactory; Param: TJValueList); override;
  published
    property AtEndOfLine;
  end;

  TJWshWriteStreamObject = class(TJWshBaseStreamObject)
  public
    constructor Create(AFactory: TJObjectFactory; Param: TJValueList); override;
  end;

  TJWScriptObject = class(TJObject)
  private
    FArguments: TJWshArgumentsObject;
    FInteractive: Boolean;
    FStdIn: TJWshReadStreamObject;
    FStdOut: TJWshWriteStreamObject;
    FStdErr: TJWshWriteStreamObject;

    function DoCreateObject(Param: TJValueList): TJValue;
    function DoConnectObject(Param: TJValueList): TJValue;
    function DoDisconnectObject(Param: TJValueList): TJValue;
    function DoEcho(Param: TJValueList): TJValue;
    function DoGetObject(Param: TJValueList): TJValue;
    function DoQuit(Param: TJValueList): TJValue;
    function DoSleep(Param: TJValueList): TJValue;
    function GetFullName: String;
    function GetName: String;
    function GetPath: String;
    function GetScriptFullName: String;
    function GetScriptName: String;
    function GetVersion: String;
    function GetOnStdErr: TStringEvent;
    function GetOnStdOut: TStringEvent;
    function GetStdIn: TReadStringEvent;
    procedure SetOnStdErr(const Value: TStringEvent);
    procedure SetOnStdIn(const Value: TReadStringEvent);
    procedure SetOnStdOut(const Value: TStringEvent);
  public
    constructor Create(AFactory: TJObjectFactory; Param: TJValueList); override;
    destructor Destroy; override;

    property OnStdOut: TStringEvent read GetOnStdOut write SetOnStdOut;
    property OnStdIn: TReadStringEvent read GetStdIn write SetOnStdIn;
    property OnStdErr: TStringEvent read GetOnStdErr write SetOnStdErr;
  published
    property Arguments: TJWshArgumentsObject read FArguments;
    property FullName: String read GetFullName;
    property Interactive: Boolean read FInteractive write FInteractive;
    property Name: String read GetName;
    property Path: String read GetPath;
    property ScriptFullName: String read GetScriptFullName;
    property ScriptName: String read GetScriptName;
    property StdErr: TJWshWriteStreamObject read FStdErr;
    property StdIn: TJWshReadStreamObject read FStdIn;
    property StdOut: TJWshWriteStreamObject read FStdOut;
    property Version: String read GetVersion;
  end;




implementation

uses
  dmonkey,ecma_engine;

{ TJWScriptObject }

constructor TJWScriptObject.Create(AFactory: TJObjectFactory;
  Param: TJValueList);
begin
  inherited;
  RegistName('WScript');

  FArguments := TJWshArgumentsObject.Create(AFactory,nil);
  FArguments.IncRef;
  FStdErr := TJWshWriteStreamObject.Create(AFactory,nil);
  FStdErr.IncRef;
  FStdOut := TJWshWriteStreamObject.Create(AFactory,nil);
  FStdOut.IncRef;
  FStdIn := TJWshReadStreamObject.Create(AFactory,nil);
  FStdIn.IncRef;

  RegistMethod('CreateObject',DoCreateObject);
  RegistMethod('ConnectObject',DoConnectObject);
  RegistMethod('DisconnectObject',DoDisconnectObject);
  RegistMethod('Echo',DoEcho);
  RegistMethod('GetObject',DoGetObject);
  RegistMethod('Quit',DoQuit);
  RegistMethod('Sleep',DoSleep);
end;

destructor TJWScriptObject.Destroy;
begin
  FStdIn.DecRef;
  FStdOut.DecRef;
  FStdErr.DecRef;
  FArguments.DecRef;
  inherited;
end;

function TJWScriptObject.DoConnectObject(Param: TJValueList): TJValue;
begin
  EmptyValue(Result);
{ TODO :  }
end;

function TJWScriptObject.DoCreateObject(Param: TJValueList): TJValue;
//ActiveXObject쐬
var
  obj: TJActiveXObject;
begin
  obj := TJActiveXObject.Create(FFactory,Param);
  Result := BuildObject(obj);
end;

function TJWScriptObject.DoDisconnectObject(Param: TJValueList): TJValue;
begin
  EmptyValue(Result);
{ TODO :  }
end;

function TJWScriptObject.DoEcho(Param: TJValueList): TJValue;
//\
var
  s,capt: String;
  v: TJValue;
  i: Integer;
begin
  EmptyValue(Result);
  capt := GetApplicationTitle;
  s := '';
  for i := 0 to Param.Count - 1 do
  begin
    v := Param[i];
    s := s + AsString(@v) + ' ';
  end;

  s := TrimRight(s);
  if IsConsole then
    Writeln(s)
  else
    MsgBox(PChar(s),PChar(capt),MB_OK);
end;

function TJWScriptObject.DoGetObject(Param: TJValueList): TJValue;
begin
  EmptyValue(Result);
{ TODO :  }
end;

function TJWScriptObject.DoQuit(Param: TJValueList): TJValue;
//I
var
  v: TJValue;
begin
  //O
  if IsParam1(Param) then
  begin
    v := Param[0];
    raise EJExit.Create(AsInteger(@v));
  end
  else
    raise EJExit.Create(0);
end;

function TJWScriptObject.DoSleep(Param: TJValueList): TJValue;
//~b~
var
  v: TJValue;
begin
  EmptyValue(Result);
  if IsParam1(Param) then
  begin
    v := Param[0];
    Sleep(AsInteger(@v));
  end
  else
    Sleep(0);
end;

function TJWScriptObject.GetFullName: String;
begin
  Result := ParamStr(0);
end;

function TJWScriptObject.GetName: String;
begin
  Result := ExtractFileName(ParamStr(0));
end;

function TJWScriptObject.GetOnStdErr: TStringEvent;
begin
  Result := FStdErr.OnWrite;
end;

function TJWScriptObject.GetOnStdOut: TStringEvent;
begin
  Result := FStdOut.OnWrite;
end;

function TJWScriptObject.GetPath: String;
begin
  Result := ExtractFilePath(ParamStr(0));
end;

function TJWScriptObject.GetScriptFullName: String;
//XNvgtpXœ
var
  dm: TDMonkey;
  path: String;
  p: PChar;
begin
  dm := ((FFactory.Engine) as TJEngine).Parent as TDMonkey;
  SetLength(path,MAX_PATH);
  if GetFullPathName(PChar(dm.ScriptFilename),MAX_PATH,PChar(path),p) <> 0 then
    Result := PChar(path)
  else
    Result := dm.ScriptFilename;
end;

function TJWScriptObject.GetScriptName: String;
//XNvg𓾂
var
  dm: TDMonkey;
begin
  dm := ((FFactory.Engine) as TJEngine).Parent as TDMonkey;
  Result := ExtractFileName(dm.ScriptFilename);
end;

function TJWScriptObject.GetStdIn: TReadStringEvent;
begin
  Result := FStdIn.OnRead;
end;

function TJWScriptObject.GetVersion: String;
begin
  Result := DMS_VERSION;
end;

procedure TJWScriptObject.SetOnStdErr(const Value: TStringEvent);
begin
  FStdErr.OnWrite := Value;
end;

procedure TJWScriptObject.SetOnStdIn(const Value: TReadStringEvent);
begin
  FStdIn.OnRead := Value;
end;

procedure TJWScriptObject.SetOnStdOut(const Value: TStringEvent);
begin
  FStdOut.OnWrite := Value;
end;

{ TJWshNamedObject }

constructor TJWshNamedObject.Create(AFactory: TJObjectFactory;
  Param: TJValueList);
begin
  inherited;
  RegistName('WshNamed');

  RegistMethod('Exists',DoExists);
  RegistMethod('Item',DoItem);
end;

function TJWshNamedObject.DoExists(Param: TJValueList): TJValue;
//item݂邩
var
  v: TJValue;
begin
  Result := BuildBool(False);
  if IsParam1(Param) then
  begin
    v := Param[0];
    Result := BuildBool(HasKey(AsString(@v)));
  end;
end;

function TJWshNamedObject.DoItem(Param: TJValueList): TJValue;
//item𓾂
var
  v: TJValue;
begin
  Result := BuildNull;
  if IsParam1(Param) then
  begin
    v := Param[0];
    Result := GetValue(AsString(@v),True);
  end;
end;

function TJWshNamedObject.GetLength: Integer;
//key̐
var
  sl: TStringList;
begin
  sl := TStringList.Create;
  try
    sl.Text := GetPropertyList;
    Result := sl.Count;
  finally
    sl.Free;
  end;
end;

function TJWshNamedObject.GetPropertyList: String;
//SẴo𓾂
var
  sl: TStringList;
  i: Integer;
  v: TJValue;
begin
  sl := TStringList.Create;
  try
    sl.Text := Members.Keys;
    for i := sl.Count - 1 downto 0 do
    begin
      //ȊO͍폜
      v := Members[sl[i]];
      if not IsString(@v) then
        sl.Delete(i);
    end;  
    Result := Trim(sl.Text);
  finally
    sl.Free;
  end;
end;

{ TJWshUnnamedObject }

constructor TJWshUnnamedObject.Create(AFactory: TJObjectFactory;
  Param: TJValueList);
begin
  inherited;
  RegistName('WshUnnamed');

  RegistMethod('Item',DoItem);
end;

function TJWshUnnamedObject.DoItem(Param: TJValueList): TJValue;
var
  v: TJValue;
begin
  Result := BuildNull;
  if IsParam1(Param) then
  begin
    v := Param[0];
    Result := Self.GetValue(AsString(@v),True);
  end;
end;


{ TJWshArgumentsObject }

constructor TJWshArgumentsObject.Create(AFactory: TJObjectFactory;
  Param: TJValueList);
begin
  inherited;
  RegistName('WshArguments');
  RegistMethod('Item',DoItem);
  RegistMethod('ShowUsage',DoShowUsage);

  FNamed := TJWshNamedObject.Create(AFactory,nil);
  FNamed.IncRef;
  FUnnamed := TJWshUnnamedObject.Create(Afactory,nil);
  FUnnamed.IncRef;
end;

destructor TJWshArgumentsObject.Destroy;
begin
  FNamed.DecRef;
  FUnnamed.DecRef;
  inherited;
end;

function TJWshArgumentsObject.DoItem(Param: TJValueList): TJValue;
var
  v: TJValue;
begin
  Result := BuildNull;
  if IsParam1(Param) then
  begin
    v := Param[0];
    Result := Self.GetValue(AsString(@v),True);
  end;
end;

function TJWshArgumentsObject.DoShowUsage(Param: TJValueList): TJValue;
begin
  EmptyValue(Result);
{ TODO :  }
end;

procedure TJWshArgumentsObject.Parse(Args: TJArrayObject);
//Engine.BeforeRunĂ΂
var
  i: Integer;
  re: TRegExpr;
  v: TJValue;
begin
  //NA
  Clear;   
  if Assigned(Args) and (Args.Count > 0) then
  begin
    for i := 0 to Args.Count - 1 do
      Add(Args.GetItem(i));
  end
  else begin //R}hC
    for i := 2 to ParamCount do
      Add(BuildString(ParamStr(i)));
  end;
  //
  re := TRegExpr.Create;
  try
    re.Expression := '\/([^\:]+)\:(.*)';
    for i := 0 to Count - 1 do
    begin
      v := GetItem(i);
      if IsString(@v) then
      begin
        //Ot
        if re.Exec(AsString(@v)) then
          FNamed.SetValue(re.Match[1],BuildString(re.Match[2]),True)
        else
          FUnnamed.Add(v);
      end
      else
        FUnnamed.Add(v);
    end;
  finally
    re.Free;
  end;
end;

{ TJWshBaseStreamObject }

constructor TJWshBaseStreamObject.Create(AFactory: TJObjectFactory;
  Param: TJValueList);
begin
  inherited;
  RegistName('WshBaseStream');
  RegistMethod('Close',DoClose);
end;

function TJWshBaseStreamObject.DoClose(Param: TJValueList): TJValue;
begin
  EmptyValue(Result);
  //Ȃ
end;

function TJWshBaseStreamObject.DoRead(Param: TJValueList): TJValue;
var
  v: TJValue;
  size: Integer;
  s: String;
begin
  if IsParam1(Param) then
  begin
    v := Param[0];
    size := AsInteger(@v);
    //wTCYRs[
    s := Copy(Read,1,size);
    Result := BuildString(s);
  end
  else
    Result := BuildString(Read);
end;

function TJWshBaseStreamObject.DoReadAll(Param: TJValueList): TJValue;
begin
  Result := BuildString(Read);
end;

function TJWshBaseStreamObject.DoReadLine(Param: TJValueList): TJValue;
begin
  Result := BuildString(Read);
end;

function TJWshBaseStreamObject.DoSkip(Param: TJValueList): TJValue;
begin
{ TODO :  }
  EmptyValue(Result);
end;

function TJWshBaseStreamObject.DoSkipLine(Param: TJValueList): TJValue;
begin
{ TODO :  }
  EmptyValue(Result);
end;

function TJWshBaseStreamObject.DoWrite(Param: TJValueList): TJValue;
begin
  EmptyValue(Result);
  Write(Param,False);
end;

function TJWshBaseStreamObject.DoWriteBlankLines(
  Param: TJValueList): TJValue;
var
  v: TJValue;
  i: Integer;
begin
  EmptyValue(Result);
  if IsParam1(Param) then
  begin
    v := Param[0];
    i := AsInteger(@v);
  end
  else
    i := 0;

  Write(Param,False,i);
end;

function TJWshBaseStreamObject.DoWriteLine(Param: TJValueList): TJValue;
begin
  EmptyValue(Result);
  Write(Param,True);
end;

function TJWshBaseStreamObject.GetAtEndOfLine: Boolean;
begin
{ TODO :  }
  Result := True;
end;

function TJWshBaseStreamObject.GetColumn: Integer;
begin
{ TODO :  }
  Result := 0;
end;

function TJWshBaseStreamObject.GetLine: Integer;
begin
{ TODO :  }
  Result := 1;
end;

function TJWshBaseStreamObject.Read: String;
var
  success: Boolean;
begin
  success := False;
  if Assigned(FOnRead) then
    FOnRead(Self,Result,success);

  if not success then
    raise EJThrow.Create(E_FILE,'read error: STDIN');
end;

procedure TJWshBaseStreamObject.Write(Param: TJValueList; Line: Boolean;
  Breaks: Integer);
//
var
  i: Integer;
  v: TJValue;
  s: String;
begin
  if not Assigned(FOnWrite) then
    Exit;

  if Breaks > 0 then
  begin
    for i := 0 to Breaks - 1 do
      FOnWrite(Self,CRLF);
  end
  else begin
    if IsParam1(Param) then
    begin
      v := Param[0];
      s := AsString(@v);
    end
    else
      s := '';

    if Line then
      FOnWrite(Self,s + CRLF)
    else if s <> '' then
      FOnWrite(Self,s);
  end;
end;

{ TJWshReadStreamObject }

constructor TJWshReadStreamObject.Create(AFactory: TJObjectFactory;
  Param: TJValueList);
begin
  inherited;
  RegistName('WshReadStream');
  RegistMethod('Read',DoRead);
  RegistMethod('ReadAll',DoReadAll);
  RegistMethod('ReadLine',DoReadLine);
  RegistMethod('Skip',DoSkip);
  RegistMethod('SkipLine',DoSkipLine);
end;

{ TJWshWriteStreamObject }

constructor TJWshWriteStreamObject.Create(AFactory: TJObjectFactory;
  Param: TJValueList);
begin
  inherited;
  RegistName('WshReadStream');
  RegistMethod('Write',DoWrite);
  RegistMethod('WriteBlankLines',DoWriteBlankLines);
  RegistMethod('WriteLine',DoWriteLine);
end;


end.
