unit dm_main;

//R\[C
//2001/04/30
//by Wolfy

interface

uses
  dmonkey,ecma_type,classes,sysutils,ecma_misc;

type
  TDMMain = class(TObject)
  private
    FDM: TDMonkey;

    procedure DMStdout(Sender: TObject; S: String);
    procedure DMStdin(Sender: TObject; var S: String; var Success: Boolean);
  public
    constructor Create;
    destructor Destroy; override;
    procedure Run;
  end;


implementation

{ TDMMain }

constructor TDMMain.Create;
begin
  inherited Create;
  FDM := TDMonkey.Create(nil);
  FDM.CompiledBinary := True;
  FDM.OnStdout := DMStdout;
  FDM.OnStderr := DMStdout;
  FDM.OnStdin := DMStdin;
end;

destructor TDMMain.Destroy;
begin
  FDM.Free;
  inherited;
end;

procedure TDMMain.DMStdin(Sender: TObject; var S: String; var Success: Boolean);
begin
  Readln(S);
  Success := True;
end;

procedure TDMMain.DMStdout(Sender: TObject; S: String);
begin
  Write(S);
end;

procedure TDMMain.Run;
var
  param: TJValueList;
  i: Integer;
  filename: String;
begin
  param := TJValueList.Create;
  try
    if ParamCount < 1 then
    begin
      Writeln('usage: dm SCRIPT_NAME');
      Exit;
    end
    else begin
      filename := ParamStr(1);
      if ExtractFileExt(filename) = '' then
        filename := filename + DMS_EXT;

      if not FileExists(filename) then
      begin
        Writeln('file not found');
        Exit;
      end
      else begin
        for i := 2 to ParamCount do
          param.Add(BuildString(ParamStr(i)));

        FDM.CompileFile(filename);
        FDM.Run(param);
      end;
    end;
  finally
    param.Free;
  end;

  Writeln('compile: ' + MSecToStr2(FDM.TookTimeToCompile));
  Writeln('run: ' + MSecToStr2(FDM.TookTimeToRun));
end;

end.
