unit ecma_parser;

//ċA~p[T
//2001/04/20 ~
//by Wolfy


{
 TokenřGetLex
 if Token = ___ then
 begin
   GetLex;
}



interface

uses
  sysutils,classes,windows,dialogs,ecma_expr,ecma_stmt,ecma_type,ecma_lex,
  ecma_misc,ecma_object;

type
  EJSyntaxError = class(EJException);

  TJParser = class(TObject)
  private
    FExpr: TJExprFactory;
    FStmt: TJStatementFactory;
    FLex: TJLex;
    FRoot: PJStatement;
    FLibPath: TStringList;
    FPackages: TList;
    FSourceCode: ECMAString;

    function Token: Integer;
    function GetLex: Boolean;
    procedure Error;
    //
    function SourceElements: PJStatement;
    function SourceElement: PJStatement;
    //錾
    function ImportDeclaration: PJStatement;
    function Declaration: PJStatement;
    function ClassDeclaration: PJStatement;
    function ClassElements: PJStatement;
    function ClassElement: PJStatement;
    function MemberDeclaration: PJStatement;

    function FunctionDeclaration: PJStatement;
    function ParameterDeclaration: PJStatement;

    function VarStatement: PJStatement;
    function VariableDeclarationList: PJStatement;
    function VariableDeclaration: PJStatement;
    //
    function Statement: PJStatement;
    function StatementList: PJStatement;
    function BlockStatement: PJStatement;
    function EmptyStatement: PJStatement;
    function ExpressionStatement: PJStatement;
    //function PrintStatement: PJStatement;
    function IfStatement: PJStatement;
    function WhileStatement: PJStatement;
    function DoStatement: PJStatement;
    function ForStatement: PJStatement;
    function ContinueStatement: PJStatement;
    function BreakStatement: PJStatement;
    function ReturnStatement: PJStatement;
    function WithStatement: PJStatement;
    function TryStatement: PJStatement;
    function CatchStatement: PJStatement;
    function FinallyStatement: PJStatement;
    function ThrowStatement: PJStatement;
    function SwitchStatement: PJStatement;
    function LabeledStatement(var Default: Boolean): PJStatement;
    function LabeledStatementList: PJStatement;

    //
    function OptionExpression: PJExpr;
    function OptionVarExpression: PJExpr;
    function Variable(var lval: Boolean): PJExpr;
    function ConstFalse(var lval: Boolean): PJExpr;
    function ConstTure(var lval: Boolean): PJExpr;
    function ConstNull(var lval: Boolean): PJExpr;
    function ConstNaN(var lval: Boolean): PJExpr;
    function QuoteString(var lval: Boolean): PJExpr;
    function RegExp(var lval: Boolean): PJExpr;
    function Number(var lval: Boolean): PJExpr;
    function AddtiveSignNumber(var lval: Boolean): PJExpr;
    function Constant(var lval: Boolean): PJExpr;
    function LabeledConstant(var lval: Boolean): PJExpr;
    function This(var lval: Boolean): PJExpr;
    function Super(var lval: Boolean): PJExpr;
    function NewExpression(var lval: Boolean): PJExpr;

    function ObjectElements: PJExpr;
    function ObjectElement: PJExpr;

    function PrimaryExpression(var lval: Boolean): PJExpr;
    function PostfixExpression(var lval: Boolean): PJExpr;
    function Arguments(var lval: Boolean): PJExpr;
    function UnaryExpression(var lval: Boolean): PJExpr;
    function MultiplicaveExpression(var lval: Boolean): PJExpr;
    function AddtiveExpression(var lval: Boolean): PJExpr;
    function ShiftExpression(var lval: Boolean): PJExpr;
    function RelationalExpression(var lval: Boolean): PJExpr;
    function EqualityExpression(var lval: Boolean): PJExpr;
    function AndExpression(var lval: Boolean): PJExpr;
    function XorExpression(var lval: Boolean): PJExpr;
    function OrExpression(var lval: Boolean): PJExpr;
    function LogicalAndExpression(var lval: Boolean): PJExpr;
    function LogicalOrExpression(var lval: Boolean): PJExpr;
    function ConditionalExpression(var lval: Boolean): PJExpr;
    function AssignmentExpression: PJExpr;
    function Expression: PJExpr;

    //VACY
    procedure SerializeRoot(ARoot: PJStatement; Stream: TStream);
    procedure SerializeStatement(P: PJStatement; Stream: TStream);
    procedure SerializeExpr(P: PJExpr; Stream: TStream);
    procedure SerializeValue(P: PJValue; Stream: TStream);
    //fVACY
    function DeserializeRoot(Stream: TStream): PJStatement;
    function DeserializeStatement(Stream: TStream): PJStatement;
    function DeserializeExpr(Stream: TStream): PJExpr;
    function DeserializeValue(Stream: TStream): PJValue; 
  public
    constructor Create;
    destructor Destroy; override;
    procedure Clear;
    function Parse: Boolean;
    function Serialize(Filename: String): Boolean;
    function Deserialize(Filename: String): Boolean;

    property Root: PJStatement read FRoot;
    property Lex: TJLex read FLex;
    property SourceCode: ECMAString read FSourceCode write FSourceCode;
    property LibPath: TStringList read FLibPath;
  end;

implementation

{ TJParser }

function TJParser.AddtiveExpression(var lval: Boolean): PJExpr;
//
//| assignment_expression ADDOP assignment_expression
//              { case $2 of
//                  '+': $$ := FExpr.MakeExpr2(opAdd,$1,$3);
//                  '-': $$ := FExpr.MakeExpr2(opSub,$1,$3);
//                end; }
var
  expr: PJExpr;
  op: ECMAChar;
begin
  Result := MultiplicaveExpression(lval);
  while Assigned(Result) do
  begin
    if Token = ADDOP then
    begin
      op := FLex.yylval.yyChar;
      GetLex;
      expr := MultiplicaveExpression(lval);
      if Assigned(expr) then
      begin
        case op of
          '+': Result := FExpr.MakeExpr2(opAdd,Result,expr);
          '-': Result := FExpr.MakeExpr2(opSub,Result,expr);
        end;
      end
      else
        Error;
    end
    else
      Break;
  end;
end;

function TJParser.AndExpression(var lval: Boolean): PJExpr;
//and
// | assignment_expression OP_BIT_AND assignment_expression
//                  { $$ := FExpr.MakeExpr2(opBitAnd,$1,$3); }
var
  expr: PJExpr;
begin
  Result := EqualityExpression(lval);
  while Assigned(Result) do
  begin
    if Token = OP_BIT_AND then
    begin
      GetLex;
      expr := EqualityExpression(lval);
      if Assigned(expr) then
      begin
        Result := FExpr.MakeExpr2(opBitAnd,Result,expr);
      end
      else
        Error;
    end
    else
      Break;
  end;
end;

function TJParser.Arguments(var lval: Boolean): PJExpr;
//arguments : arguments COMMA assignment_expression
//                       { $$ := FExpr.MakeArguments($1,$3); }
//          | assignment_expression
//                       { $$ := FExpr.MakeArguments(nil,$1); }
// :  assignment_expression COMMA arguments
// |  assignment_expression

//
var
  prev,expr: PJExpr;
begin
  Result := nil;
  prev := AssignmentExpression;
  if not Assigned(prev) then
    Exit
  else
   Result := FExpr.MakeArguments(nil,prev);
  {//EċA Ԃɕ
  while True do
  begin
    if Token = COMMA then
    begin
      GetLex;
      expr := Arguments(lval);
      if Assigned(expr) then
        Result := FExpr.MakeArguments(Result,expr)
      else
        Error;
    end
    else
      Break;
  end;
  }
  //   ċA tɕ
  while True do
  begin
    if Token = COMMA then
    begin
      GetLex;
      expr := AssignmentExpression;
      if Assigned(expr) then
        Result := FExpr.MakeArguments(Result,expr)
      else
        Error;
    end
    else
      Break;
  end;
end;

function TJParser.AssignmentExpression: PJExpr;
//
//| assignment_expression ASSIGNOP assignment_expression
//         { case $2 of
//              '+': $$ := FExpr.MakeExpr2(opAddAssign,$1,$3);
//              '-': $$ := FExpr.MakeExpr2(opSubAssign,$1,$3);
//              '*': $$ := FExpr.MakeExpr2(opMulAssign,$1,$3);
//              '/': $$ := FExpr.MakeExpr2(opDivAssign,$1,$3);
//              '%': $$ := FExpr.MakeExpr2(opModAssign,$1,$3);
//              '<': $$ := FExpr.MakeExpr2(opBitLeftAssign,$1,$3);
//              '>': $$ := FExpr.MakeExpr2(opBitRightAssign,$1,$3);
//              '3': $$ := FExpr.MakeExpr2(opBitRightZeroAssign,$1,$3);
//              '&': $$ := FExpr.MakeExpr2(opBitAndAssign,$1,$3);
//              '|': $$ := FExpr.MakeExpr2(opBitOrAssign,$1,$3);
//            end; }
//  | assignment_expression OP_ASSIGN assignment_expression
//         { $$ := FExpr.MakeExpr2(opAssign,$1,$3); }
var
  expr1,expr2: PJExpr;
  op: ECMAChar;
  lval: Boolean;
begin
  lval := False;
  expr1 := ConditionalExpression(lval);//UnaryExpression;
  Result := expr1;
  if Assigned(expr1) then
  begin
    //Ӓlɑłꍇ
    if lval then
    begin
      if Token = OP_ASSIGN then
      begin
        GetLex;
        expr2 := AssignmentExpression;
        if Assigned(expr2) then
        begin
          Result := FExpr.MakeExpr2(opAssign,expr1,expr2);
        end
        else
          Error;
      end
      else if Token = ASSIGNOP then
      begin
        op := FLex.yylval.yyChar;
        GetLex;
        expr2 := Assignmentexpression;
        if Assigned(expr2) then
        begin
          case op of
            '+': Result := FExpr.MakeExpr2(opAddAssign,expr1,expr2);
            '-': Result := FExpr.MakeExpr2(opSubAssign,expr1,expr2);
            '*': Result := FExpr.MakeExpr2(opMulAssign,expr1,expr2);
            '/': Result := FExpr.MakeExpr2(opDivAssign,expr1,expr2);
            '%': Result := FExpr.MakeExpr2(opModAssign,expr1,expr2);
            '<': Result := FExpr.MakeExpr2(opBitLeftAssign,expr1,expr2);
            '>': Result := FExpr.MakeExpr2(opBitRightAssign,expr1,expr2);
            '3': Result := FExpr.MakeExpr2(opBitRightZeroAssign,expr1,expr2);
            '&': Result := FExpr.MakeExpr2(opBitAndAssign,expr1,expr2);
            '|': Result := FExpr.MakeExpr2(opBitOrAssign,expr1,expr2);
          end;
        end
        else
          Error;
      end;
    end;
  end;

end;

function TJParser.BlockStatement: PJStatement;
//7 ubN
//block : LB statement_list rb  { $$ := FStmt.MakeBlockStatement($2); }
//      | LB rb                 { $$ := FStmt.MakeBlockStatement(nil); }
var
  stmt: PJStatement;
begin
  Result := nil;
  if Token = LB then
  begin
    GetLex;
    stmt := StatementList;
    if Token = RB then
    begin
      GetLex;
      Result := FStmt.MakeBlockStatement(stmt);
    end
    else
      Error;
  end;
end;

function TJParser.BreakStatement: PJStatement;
//break_statement         : _BREAK sc             { $$ := FStmt.MakeBreakStatement; }
begin
  Result := nil;
  if Token = _BREAK then
  begin
    GetLex;
    if Token = SC then
      Result := FStmt.MakeBreakStatement
    else
      Error;
  end;
end;

function TJParser.CatchStatement: PJStatement;
////catch_statement         : _CATCH LP expression rp statement
////                                                { $$ := FStmt.MakeCatchStatement($3,$5); }
////                        | _CATCH statement      { $$ := FStmt.MakeCatchStatement(nil,$2); }
//catch_statement : _CATCH LP variable RP statement
//                | _CATCH LP RP statement
//                | _CATCH statement

var
  expr: PJExpr;
  stmt: PJStatement;
  lval: Boolean;
begin
  Result := nil;
  if Token = _CATCH then
  begin
    GetLex;
    if Token = LP then
    begin
      GetLex;
      expr := Variable(lval);
      if Token = RP then
      begin
        GetLex;
        stmt := Statement;
        if Assigned(stmt) then
          Result := FStmt.MakeCatchStatement(expr,stmt)
        else
          Error;
      end
      else
        Error;
    end
    else begin
      stmt := Statement;
      if Assigned(stmt) then
        Result := FStmt.MakeCatchStatement(nil,stmt)
      else
        Error;
    end;
  end;
end;

procedure TJParser.Clear;
//NA
var
  i: Integer;
begin
  FLex.Clear;
  FExpr.Clear;
  FStmt.Clear;
  for i := FPackages.Count - 1 downto 0 do
    TJParser(FPackages[i]).Free;

  FPackages.Clear;
  FRoot := nil;
end;

function TJParser.ConditionalExpression(var lval: Boolean): PJExpr;
//
//| assignment_expression QUERY assignment_expression COLON assignment_expression
//                         { $$ := FExpr.MakeExpr3(opConditional,$1,$3,$5); }
var
  expr,cond: PJExpr;
begin
  Result := LogicalOrExpression(lval);
  if Assigned(Result) then
  begin
    if Token = QUERY then
    begin
      GetLex;
      expr := Expression;
      if Assigned(expr) then
      begin
        if Token = COLON then
        begin
          GetLex;
          cond := ConditionalExpression(lval);
          if Assigned(cond) then
            Result := FExpr.MakeExpr3(opConditional,Result,expr,cond)
          else
            Error;
        end
        else
          Error;
      end
      else
        Error;
    end;
  end;
end;

function TJParser.Constant(var lval: Boolean): PJExpr;
//constant  : number                { $$ := $1; }
//          | string                { $$ := $1; }
//          | regexp                { $$ := $1; }
//          | null                  { $$ := $1; }
//          | true                  { $$ := $1; }
//          | false                 { $$ := $1; }
begin
  Result := Number(lval);
  if Assigned(Result) then Exit;

  Result := QuoteString(lval);
  if Assigned(Result) then Exit;

  Result := RegExp(lval);
  if Assigned(Result) then Exit;

  Result := ConstTure(lval);
  if Assigned(Result) then Exit;

  Result := ConstFalse(lval);
  if Assigned(Result) then Exit;

  Result := ConstNull(lval);
  if Assigned(Result) then Exit;

  Result := ConstNaN(lval);
end;

function TJParser.ConstFalse(var lval: Boolean): PJExpr;
//false
//false   : _FALSE        { $$ := FExpr.MakeBoolean(False); }
begin
  Result := nil;
  if Token = _FALSE then
  begin
    Result := FExpr.MakeBoolean(False);
    GetLex;
  end;
end;

function TJParser.ConstNull(var lval: Boolean): PJExpr;
//null     : _NULL                 { $$ := FExpr.MakeNull; }
begin
  Result := nil;
  if Token = _NULL then
  begin
    Result := FExpr.MakeNull;
    GetLex;
  end;
end;

function TJParser.ConstTure(var lval: Boolean): PJExpr;
//ture
//ture   : _TRUE        { $$ := FExpr.MakeBoolean(True); }
begin
  Result := nil;
  if Token = _TRUE then
  begin
    Result := FExpr.MakeBoolean(True);
    GetLex;
  end;
end;

function TJParser.ContinueStatement: PJStatement;
//continue_statement      : _CONTINUE sc          { $$ := FStmt.MakeContinueStatement; }
begin
  Result := nil;
  if Token = _CONTINUE then
  begin
    GetLex;
    if Token = SC then
      Result := FStmt.MakeContinueStatement
    else
      Error;
  end;
end;

constructor TJParser.Create;
//쐬
begin
  inherited Create;
  FLex := TJLex.Create;
  FExpr := TJExprFactory.Create;
  FStmt := TJStatementFactory.Create(FExpr);
  FLibPath := TStringList.Create;
  FPackages := TList.Create;
end;

destructor TJParser.Destroy;
//j
begin
  Clear;
  FreeAndNil(FPackages);
  FreeAndNil(FLibPath);
  FreeAndNil(FLex);
  FreeAndNil(FExpr);
  FreeAndNil(FStmt);
  inherited;
end;

function TJParser.EmptyStatement: PJStatement;
//8 
//empty_statement : sc                    { $$ := FStmt.MakeEmptyStatement; }
begin
  if Token = SC then
  begin
    Result := FStmt.MakeEmptyStatement;
    GetLex;
  end
  else
    Result := nil;
end;

function TJParser.EqualityExpression(var lval: Boolean): PJExpr;
//
//| assignment_expression EQOP assignment_expression
//        { case $2 of
//               '=': $$ := FExpr.MakeExpr2(opEQ,$1,$3);
//               '!': $$ := FExpr.MakeExpr2(opNE,$1,$3);
//               '3': $$ := FExpr.MakeExpr2(opEQEQEQ,$1,$3);
//               '2': $$ := FExpr.MakeExpr2(opNEEQEQ,$1,$3);
//          end; }
var
  expr: PJExpr;
  op: ECMAChar;
begin
  Result := RelationalExpression(lval);
  while Assigned(Result) do
  begin
    if Token = EQOP then
    begin
      op := FLex.yylval.yyChar;
      GetLex;
      expr := RelationalExpression(lval);
      if Assigned(expr) then
      begin
        case op of
          '=': Result := FExpr.MakeExpr2(opEQ,Result,expr);
          '!': Result := FExpr.MakeExpr2(opNE,Result,expr);
          '3': Result := FExpr.MakeExpr2(opEQEQEQ,Result,expr);
          '2': Result := FExpr.MakeExpr2(opNEEQEQ,Result,expr);
        end;
      end
      else
        Error;
    end
    else
      Break;
  end;
end;

procedure TJParser.Error;
//O
begin
  raise EJSyntaxError.Create('SyntaxError: ' + 'Line( ' + IntToStr(FLex.LineNo) +
    ' ) Text( ' + FLex.yytext + ' )');
end;

function TJParser.Expression: PJExpr;
//
//expression : assignment_expression { $$ := $1; }
//           | expression COMMA assignment_expression
//                  { $$ := FExpr.MakeExpr2(opExpr,$1,$3); }
var
  expr: PJExpr;
begin
  Result := AssignmentExpression;
  while Assigned(Result) do
  begin
    if Token = COMMA then
    begin
      GetLex;
      expr := AssignmentExpression;
      if Assigned(expr) then
        Result := FExpr.Makeexpr2(opExpr,Result,expr)
      else
        Error;
    end
    else
      Break;
  end;
end;

function TJParser.ExpressionStatement: PJStatement;
//9 
//expression_statement    : expression sc         { $$ := FStmt.MakeExprStatement($1); }
var
  expr: PJExpr;
begin
  Result := nil;
  expr := Expression;
  if Assigned(expr) then
  begin
    if Token = SC then
    begin
      Result := FStmt.MakeExprStatement(expr);
      GetLex;
    end
    else
      Error;
  end;
end;

function TJParser.FinallyStatement: PJStatement;
//finally_statement       : _FINALLY statement    { $$ := FStmt.MakeFinallyStatement($2); }
var
  stmt: PJStatement;
begin
  Result := nil;
  if Token = _FINALLY then
  begin
    GetLex;
    stmt := Statement;
    if Assigned(stmt) then
      Result := FStmt.MakeFinallyStatement(stmt)
    else
      Error;
  end;
end;


function TJParser.ForStatement: PJStatement;
//13 for
//for_statement  : _FOR LP option_var_expression sc option_expression sc option_expression rp statement
//               { $$ := FStmt.MakeForStatement($3,$5,$7,$9); }
//forin_statement: _FOR LP variable _IN postfix_expression rp statement
//                          { $$ := FStmt.MakeForInStatement($3,$5,$7); }
var
  op1,op2,op3: PJExpr;
  stmt: PJStatement;
  lval: Boolean;
begin
  Result := nil;
  if Token = _FOR then
  begin
    GetLex;
    if Token = LP then
    begin
      GetLex;
      op1 := OptionVarExpression;
      if Token = SC then
      begin
        GetLex;
        op2 := OptionExpression;
        if Token = SC then
        begin
          GetLex;
          op3 := OptionExpression;
          if Token = RP then
          begin
            GetLex;
            stmt := Statement;
            if Assigned(stmt) then
              Result := FStmt.MakeForStatement(op1,op2,op3,stmt)
            else
              Error;
          end
          else
            Error;
        end
        else
          Error;
      end
      else if Assigned(op1) and (Token = _IN) then
      begin
        GetLex;
        op2 := PostfixExpression(lval);
        //op2 := Variable(lval);
        if Assigned(op2) then
        begin
          if Token = RP then
          begin
            GetLex;
            stmt := Statement;
            if Assigned(stmt) then
              Result := FStmt.MakeForInStatement(op1,op2,stmt)
            else
              Error;
          end
          else
            Error;
        end
        else
          Error;
      end
      else
        Error;
    end
    //else if
    //begin

    //end
    else
      Error;
  end;

end;

function TJParser.FunctionDeclaration: PJStatement;
//4֐`
//function_declaration    : _FUNCTION variable LP parameter_declaration rp block
//                          { $$ := FStmt.MakeFunctionDecl($2,$4,$6);}
var
  expr: PJExpr;
  param,block: PJStatement;
  templval: Boolean;
begin
  templval := False;
  Result := nil;
  if Token = _FUNCTION then
  begin
    GetLex;
    expr := Variable(templval);
    if Assigned(expr) then
    begin
      if Token = LP then
      begin
        GetLex;
        param := ParameterDeclaration;
        if Assigned(param) then
        begin
          if Token = RP then
          begin
            GetLex;
            block := BlockStatement;
            if Assigned(block) then
            begin
              Result := FStmt.MakeFunctionDecl(expr,param,block);
            end
            else
              Error;
          end
          else
            Error;
        end
        else
          Error;
      end
      else
        Error;
    end
    else
      Error;
  end;

end;

function TJParser.IfStatement: PJStatement;
//11 if
//if_statement  : _IF LP expression rp statement
//                       { $$ := FStmt.MakeIfStatement($3,$5) ;}
//              | _IF LP expression rp statement _ELSE statement
//                       { $$ := FStmt.MakeIfStatement($3,$5,$7) ;}
var
  expr: PJExpr;
  stmt1,stmt2: PJStatement;
begin
  Result := nil;
  if Token = _IF then
  begin
    GetLex;
    if Token = LP then
    begin
      GetLex;
      expr := Expression;
      if Assigned(expr) then
      begin
        if Token = RP then
        begin
          GetLex;
          stmt1 := Statement;
          if Assigned(stmt1) then
          begin
            if Token = _ELSE then
            begin
              GetLex;
              stmt2 := Statement;
              if Assigned(stmt2) then
                Result := FStmt.MakeIfStatement(expr,stmt1,stmt2)
              else
                Error;
            end
            else begin
              Result := FStmt.MakeIfStatement(expr,stmt1);
            end;
          end
          else
            Error;
        end
        else
          Error;
      end
      else
        Error;
    end
    else
      Error;
  end;
end;

function TJParser.LogicalAndExpression(var lval: Boolean): PJExpr;
//_a
//| assignment_expression OP_LOGICAL_AND assignment_expression
//                  { $$ := FExpr.MakeExpr2(opLogicalAnd,$1,$3);
var
  expr: PJExpr;
begin
  Result := OrExpression(lval);
  while Assigned(Result) do
  begin
    if Token = OP_LOGICAL_AND then
    begin
      GetLex;
      expr := OrExpression(lval);
      if Assigned(expr) then
      begin
        Result := FExpr.MakeExpr2(opLogicalAnd,Result,expr);
      end
      else
        Error;
    end
    else
      Break;
  end;
end;

function TJParser.LogicalOrExpression(var lval: Boolean): PJExpr;
//_
//| assignment_expression OP_LOGICAL_OR assignment_expression
//                        { $$ := FExpr.MakeExpr2(opLogicalOr,$1,$3);
var
  expr: PJExpr;
begin
  Result := LogicalAndExpression(lval);
  while Assigned(Result) do
  begin
    if Token = OP_LOGICAL_OR then
    begin
      GetLex;
      expr := LogicalAndExpression(lval);
      if Assigned(expr) then
      begin
        Result := FExpr.MakeExpr2(opLogicalOr,Result,expr);
      end
      else
        Error;
    end
    else
      Break;
  end;
end;

function TJParser.MultiplicaveExpression(var lval: Boolean): PJExpr;
//揜
// assignment_expression MULOP assignment_expression
//       { case $2 of
//          '*': $$ := FExpr.MakeExpr2(opMul,$1,$3);
//          '/': $$ := FExpr.MakeExpr2(opDiv,$1,$3);
//          '%': $$ := FExpr.MakeExpr2(opMod,$1,$3);
//          'd': $$ := FExpr.MakeExpr2(opDivInt,$1,$3);
//        end; }
var
  expr: PJExpr;
  op: ECMAChar;
begin
  Result := UnaryExpression(lval);
  while Assigned(Result) do
  begin
    if Token = MULOP then
    begin
      op := FLex.yylval.yyChar;
      GetLex;
      expr := UnaryExpression(lval);
      if Assigned(expr) then
      begin
        case op of
          '*': Result := FExpr.MakeExpr2(opMul,Result,expr);
          '/': Result := FExpr.MakeExpr2(opDiv,Result,expr);
          '%': Result := FExpr.MakeExpr2(opMod,Result,expr);
          'd': Result := FExpr.MakeExpr2(opDivInt,Result,expr);
        end;
      end
      else
        Error;
    end
    else
      Break;
  end;
end;

function TJParser.GetLex: Boolean;
//֑
begin
  Result := FLex.Next;
end;

function TJParser.Number(var lval: Boolean): PJExpr;
//number  : NUMBER                { $$ := FExpr.MakeNumberInt($1);}
//        | FLOAT_NUMBER          { $$ := FExpr.MakeNumberFloat($1);}
begin
  Result := nil;
  if Token = _NUMBER then
  begin
    Result := FExpr.MakeNumberInt(FLex.yylval.yyInteger);
    GetLex;
  end
  else if Token = _FLOAT_NUMBER then
  begin
    Result := FExpr.MakeNumberFloat(FLex.yylval.yyDouble);
    GetLex;
  end
  else if Token = _INVALID_VALUE then
    raise EJSyntaxError.Create('Invalid Value: ' + 'Line( ' + IntToStr(FLex.LineNo) +
      ' ) Text( ' + FLex.yytext + ' )');
end;

function TJParser.OptionExpression: PJExpr;
//
//option_expression       : expression            { $$ := $1; }
//                        |                       { $$ := nil; }
begin
  Result := Expression;
end;

function TJParser.OrExpression(var lval: Boolean): PJExpr;
//or
// | assignment_expression OP_BIT_OR assignment_expression
//                { $$ := FExpr.MakeExpr2(opBitOr,$1,$3); }
var
  expr: PJExpr;
begin
  Result := XorExpression(lval);
  while Assigned(Result) do
  begin
    if Token = OP_BIT_OR then
    begin
      GetLex;
      expr := XorExpression(lval);
      if Assigned(expr) then
      begin
        Result := FExpr.MakeExpr2(opBitOr,Result,expr);
      end
      else
        Error;
    end
    else
      Break;
  end;
end;

function TJParser.ParameterDeclaration: PJStatement;
//5 p[^錾
//parameter_declaration   : parameter_declaration COMMA variable
//                                                { $$ := FStmt.MakeParamDecl($1,$3); }
//                        | variable              { $$ := FStmt.MakeParamDecl(nil,$1); }
//                        |                       { $$ := FStmt.MakeParamDecl(nil,nil); }
var
  expr: PJExpr;
  lval: Boolean;
begin
  lval := False;
  expr := Variable(lval);
  Result := FStmt.MakeParamDecl(nil,expr);
  while Assigned(expr) do
  begin
    if Token = COMMA then
    begin
      GetLex;
      expr := Variable(lval);
      if Assigned(expr) then
        Result := FStmt.MakeParamDecl(Result,expr)
      else
        Error;
    end
    else
      Break;
  end;
end;

function TJParser.Parse: Boolean;
//͊Jn
begin
  Result := False;
  //NA
  Clear;
  FLex.Input := FSourceCode;
  if GetLex then
  begin
    //try
      FRoot := SourceElements;
    //except
    //  on E:EJSyntaxError do
    //    ShowMessage(E.Message);
    //  on E:EJThrow do
    //    ShowMessage('Exception: ' + E.Message + ' => ' + E.ErrorMsg);
    //end;

    Result := Assigned(FRoot);
  end;
end;

function TJParser.PostfixExpression(var lval: Boolean): PJExpr;
//u
var
  expr: PJExpr;
  op: ECMAChar;
begin
  Result := PrimaryExpression(lval);
  while Assigned(Result) do
  begin
    //z
    if Token = LSQ then
    begin
      GetLex;
{ TODO :
        expr := Argments(lval)ɕς
        zɕ̈킽 }
      //expr := Expression;
      expr := Arguments(lval);
      if Assigned(expr) then
      begin
        if Token = RSQ then
        begin
          GetLex;
          Result := FExpr.MakeExpr2(opArray,Result,expr);
          lval := True;
        end
        else
          Error;
      end
      else
        Error;
    end
    //R[
    else if Token = LP then
    begin
      GetLex;
      expr := Arguments(lval);
      if Token = RP then
      begin
        GetLex;
        Result := FExpr.MakeExpr2(opCall,Result,expr);
      end
      else
        Error;
    end
    //o
    else if Token = DOT then
    begin
      GetLex;
      expr := Variable(lval);
      if Assigned(expr) then
      begin
        Result := FExpr.MakeExpr2(opMember,Result,expr);
        lval := True;
      end
      else
        Error;
    end
    else if Token = INCDECOP then
    begin
      op := FLex.yylval.yyChar;
      GetLex;
      case op of
        '+':  Result := FExpr.MakeExpr1(opPostInc,Result);
        '-':  Result := FExpr.MakeExpr1(opPostDec,Result);
      end;
    end
    else
      Break;
  end;

end;

function TJParser.PrimaryExpression(var lval: Boolean): PJExpr;
//P
//primary_expression    : this                  { $$ := $1; }
//                      | super DOT variable
//                      | variable              { $$ := $1; }
//                      | constant              { $$ := $1; }
//                      | LP expression rp      { $$ := $2; }
//                      | new_expression
//typeof_expression     : _TYPEOF expression
//                      | _TYPEOF LP expression RP
//delete_expression     : _DELETE expression
//void_expression       : _VOID expression
//                      | _VOID LP expression RP
//object_expression     : LB object_elements RB
//array_expression      : LSQ arguments RSQ
var
  expr: PJExpr;
begin
  Result := nil;
  if Token = LP then
  begin
    GetLex;
    expr := Expression;
    if Assigned(expr) then
    begin
      if Token = RP then
      begin
        GetLex;
        Result := expr;
      end
      else
        Error;
    end
    else
      Error;
  end
  else if Token = _TYPEOF then
  begin
    GetLex;
    if Token = LP then
    begin
      GetLex;
      expr := Expression;
      if Assigned(expr) then
      begin
        if Token = RP then
        begin
          GetLex;
          Result := FExpr.MakeExpr1(opTypeOf,expr);
        end
        else
          Error;
      end
      else
        Error;
    end
    else begin
      expr := Expression;
      if Assigned(expr) then
        Result := FExpr.MakeExpr1(opTypeOf,expr)
      else
        Error;
    end
  end
  else if Token = _VOID then
  begin
    GetLex;
    if Token = LP then
    begin
      GetLex;
      expr := Expression;
      if Assigned(expr) then
      begin
        if Token = RP then
        begin
          GetLex;
          Result := FExpr.MakeExpr1(opVoid,expr);
        end
        else
          Error;
      end
      else
        Error;
    end
    else begin
      expr := Expression;
      if Assigned(expr) then
        Result := FExpr.MakeExpr1(opVoid,expr)
      else
        Error;
    end
  end
  else if Token = _DELETE then
  begin
    GetLex;
    expr := Expression;
    if Assigned(expr) then
      Result := FExpr.MakeExpr1(opDelete,expr)
    else
      Error;
  end
  else if Token = LB then
  begin
    //object_expression     : LB object_elements RB
    GetLex;
    expr := ObjectElements;
    //if Assigned(expr) then
    //begin
      if Token = RB then
      begin
        GetLex;
        Result := FExpr.MakeExpr1(opNewObject,expr);
      end
      else
        Error;
    //end
    //else
    //  Error;
  end
  else if Token = LSQ then
  begin
    //array_expression      : LSQ arguments RSQ
    GetLex;
    expr := Arguments(lval);
    //if Assigned(expr) then
    //begin
      if Token = RSQ then
      begin
        GetLex;
        Result := FExpr.MakeExpr1(opNewArray,expr);
      end
      else
        Error;
    //end
    //else
    //  Error;
  end
  else begin
    Result := Variable(lval);
    if Assigned(Result) then Exit;

    Result := Constant(lval);
    if Assigned(Result) then Exit;

    Result := This(lval);
    if Assigned(Result) then Exit;

    Result := NewExpression(lval);
    if Assigned(Result) then Exit;

    Result := Super(lval);
  end;
end;

(*function TJParser.PrintStatement: PJStatement;
//10 print
//print_statement         : _PRINT expression sc  { $$ := FStmt.MakePrintStatement($2); }
//                        | _PRINT LP expression rp sc
//                                                { $$ := FStmt.MakePrintStatement($3); }
var
  expr: PJExpr;
begin
  Result := nil;
  if Token = _PRINT then
  begin
    GetLex;
    if Token = LP then
    begin
      GetLex;
      expr := Expression;
      if Assigned(expr) then
      begin
        if Token = RP then
        begin
          GetLex;
          if Token = SC then
          begin
            GetLex;
            Result := FStmt.MakePrintStatement(expr);
          end
          else
            Error;
        end
        else
          Error;
      end
      else
        Error;
    end
    else begin
      expr := Expression;
      if Assigned(expr) then
      begin
        if Token = SC then
        begin
          GetLex;
          Result := FStmt.MakePrintStatement(expr);
        end
        else
          Error;
      end
      else
        Error;
    end;
  end;

end;
  *)
function TJParser.QuoteString(var lval: Boolean): PJExpr;
//string    : QUOTE_STRING          { $$ := FExpr.MakeString(String($1)); }
begin
  Result := nil;
  if Token = _QUOTE_STRING then
  begin
    Result := FExpr.MakeString(FLex.yytext);
    GetLex;
  end;
end;

function TJParser.RegExp(var lval: Boolean): PJExpr;
begin
  Result := nil;
  if Token = _REGEXP then
  begin
    Result := FExpr.MakeRegExp(FLex.yytext);
    GetLex;
  end;
end;

function TJParser.RelationalExpression(var lval: Boolean): PJExpr;
//r
//| assignment_expression COMPOP assignment_expression
//                   { case $2 of
//                        '(': $$ := FExpr.MakeExpr2(opLSEQ,$1,$3);
//                        '<': $$ := FExpr.MakeExpr2(opLS,$1,$3);
//                        ')': $$ := FExpr.MakeExpr2(opGTEQ,$1,$3);
//                        '>': $$ := FExpr.MakeExpr2(opGT,$1,$3);
//                     end; }
var
  expr: PJExpr;
  op: ECMAChar;
begin
  Result := ShiftExpression(lval);
  while Assigned(Result) do
  begin
    if Token = COMPOP then
    begin
      op := FLex.yylval.yyChar;
      GetLex;
      expr := ShiftExpression(lval);
      if Assigned(expr) then
      begin
        case op of
          '(': Result := FExpr.MakeExpr2(opLSEQ,Result,expr);
          '<': Result := FExpr.MakeExpr2(opLS,Result,expr);
          ')': Result := FExpr.MakeExpr2(opGTEQ,Result,expr);
          '>': Result := FExpr.MakeExpr2(opGT,Result,expr);
        end;
      end
      else
        Error;
    end
    else
      Break;
  end;
end;

function TJParser.ReturnStatement: PJStatement;
//return_statement        : _RETURN expression sc { $$ := FStmt.MakeReturnStatement($2); }
//                        | _RETURN sc            { $$ := FStmt.MakeReturnStatement(nil); }
var
  expr: PJExpr;
begin
  Result := nil;
  if Token = _RETURN then
  begin
    GetLex;
    expr := Expression;
    if Token = SC then
    begin
      GetLex;
      Result := FStmt.MakeReturnStatement(expr);
    end
    else
      Error;
  end;
end;

function TJParser.ShiftExpression(var lval: Boolean): PJExpr;
//shift
//| assignment_expression SHIFTOP assignment_expression
//             { case $2 of
//                 '<': $$ := FExpr.MakeExpr2(opBitLeft,$1,$3);
//                 '>': $$ := FExpr.MakeExpr2(opBitRight,$1,$3);
//                 '3': $$ := FExpr.MakeExpr2(opBitRightZero,$1,$3);
//               end; }
var
  expr: PJExpr;
  op: ECMAChar;
begin
  Result := AddtiveExpression(lval);
  while Assigned(Result) do
  begin
    if Token = SHIFTOP then
    begin
      op := FLex.yylval.yyChar;
      GetLex;
      expr := AddtiveExpression(lval);
      if Assigned(expr) then
      begin
        case op of
          '<': Result := FExpr.MakeExpr2(opBitLeft,Result,expr);
          '>': Result := FExpr.MakeExpr2(opBitRight,Result,expr);
          '3': Result := FExpr.MakeExpr2(opBitRightZero,Result,expr);
        end;
      end
      else
        Error;
    end
    else
      Break;
  end;
end;

function TJParser.SourceElement: PJStatement;
// 2
//source_element          : statement             { $$ := $1; }
//                        | declaration
//                       xx| function_declaration  { $$ := $1; }
begin
  Result := Statement;
  if Assigned(Result) then
    Exit;

  Result := Declaration;
end;

function TJParser.SourceElements: PJStatement;
// 1
//source_elements         : source_elements source_element { $$ := $2; FStmt.MergeStatement($1,$2); }
//                        | source_element        { $$ := $1; }
var
  prev,next: PJStatement;
begin
  Result := SourceElement;
  if not Assigned(Result) then
    Exit;

  prev := Result;
  next := SourceElement;
  FStmt.MergeStatement(prev,next);
  //ԂɌqĂ
  while Assigned(next) do
  begin
    prev := next;
    next := SourceElement;
    FStmt.MergeStatement(prev,next);
  end;
end;

function TJParser.Statement: PJStatement;
// 3
//statement               : block                 { $$ := $1; }
//                        | expression_statement  { $$ := $1; }
//                        | empty_statement       { $$ := $1; }
//                        | if_statement          { $$ := $1; }
//                        | while_statement       { $$ := $1; }
//                        | for_statement         { $$ := $1; }
//                        | forin_statement       { $$ := $1; }
//                        | continue_statement    { $$ := $1; }
//                        | break_statement       { $$ := $1; }
//                        | return_statement      { $$ := $1; }
//                        | print_statement       { $$ := $1; }
//                        | try_statement         { $$ := $1; }
//                        | catch_statement       { $$ := $1; }
//                        | finally_statement     { $$ := $1; }
//                        | throw_statement       { $$ := $1; }
//                        | with_statement        { $$ := $1; }
//                        | var_statement         { $$ := $1; }
//                        | do_statement          { $$ := $1; }
//                        | switch_statement      { $$ := $1; }
//                        | var_statement
begin
  Result := BlockStatement;
  if Assigned(Result) then Exit;

  Result := ExpressionStatement;
  if Assigned(Result) then Exit;

  Result := EmptyStatement;
  if Assigned(Result) then Exit;

  Result := IfStatement;
  if Assigned(Result) then Exit;

  Result := WhileStatement;
  if Assigned(Result) then Exit;

  Result := ForStatement;
  if Assigned(Result) then Exit;

  Result := ContinueStatement;
  if Assigned(Result) then Exit;

  Result := BreakStatement;
  if Assigned(Result) then Exit;

  Result := ReturnStatement;
  if Assigned(Result) then Exit;

  Result := SwitchStatement;
  if Assigned(Result) then Exit;

  Result := VarStatement;
  if Assigned(Result) then Exit;
  
  Result := TryStatement;
  if Assigned(Result) then Exit;

  Result := CatchStatement;
  if Assigned(Result) then Exit;

  Result := FinallyStatement;
  if Assigned(Result) then Exit;

  Result := ThrowStatement;
  if Assigned(Result) then Exit;

  Result := WithStatement;
  if Assigned(Result) then Exit;

  Result := DoStatement;
end;

function TJParser.StatementList: PJStatement;
//6Xg
//statement_list          : statement_list statement
//                        | statement
var
  prev,next: PJStatement;
begin
  Result := Statement;
  if not Assigned(Result) then
    Exit;

  prev := Result;
  next := Statement;
  FStmt.MergeStatement(prev,next);
  //ԂɌqĂ
  while Assigned(next) do
  begin
    prev := next;
    next := Statement;
    FStmt.MergeStatement(prev,next);
  end;

end;

function TJParser.This(var lval: Boolean): PJExpr;
//this  : _THIS                 { $$ := FExpr.MakeThis; }
begin
  Result := nil;
  if Token = _THIS then
  begin
    Result := Fexpr.MakeThis;
    GetLex;
  end;
end;

function TJParser.ThrowStatement: PJStatement;
//throw_statement         | _THROW expression sc  { $$ := FStmt.MakeThrowStatement($2); }
//                        | _THROW sc             { $$ := FStmt.MakeThrowStatement(nil);}
var
  expr: PJExpr;
begin
  Result := nil;
  if Token = _THROW then
  begin
    GetLex;
    expr := Expression;
    if Token = SC then
    begin
      GetLex;
      Result := FStmt.MakeThrowStatement(expr);
    end
    else
      Error;
  end;
end;

function TJParser.Token: Integer;
//݂token
begin
  if FLex.EOF then
    Result := 0
  else
    Result := Flex.Token;
end;

function TJParser.TryStatement: PJStatement;
//try_statement           : _TRY statement        { $$ := FStmt.MakeTryStatement($2); }
var
  stmt: PJStatement;
begin
  Result := nil;
  if Token = _TRY then
  begin
    GetLex;
    stmt := Statement;
    if Assigned(stmt) then
      Result := FStmt.MakeTryStatement(stmt)
    else
      Error;
  end;
end;

function TJParser.UnaryExpression(var lval: Boolean): PJExpr;
//Ou
//| INCDECOP assignment_expression
//                 { case $1 of
//                     '+': $$ := FExpr.MakeExpr1(opPreInc,$2);
//                     '-': $$ := FExpr.MakeExpr1(opPreDec,$2);
//                   end; }
//| ADDOP assignment_expression %prec UNOP
//                { case $1 of
//                   '+': $$ := FExpr.MakeExpr1(opPlus,$2);
//                   '-': $$ := FExpr.MakeExpr1(opMinus,$2);
//                  end; }
//| UNOP assignment_expression
//                { case $1 of
//                   '!': $$ := FExpr.MakeExpr1(opLogicalNot,$2);
//                   '~': $$ := FExpr.MakeExpr1(opBitNot,$2);
//                  end; }
var
  op: ECMAChar;
  expr: PJExpr;
begin
  Result := PostfixExpression(lval);
  if Assigned(Result) then
    Exit;

  if Token = INCDECOP then
  begin
    op := FLex.yylval.yyChar;
    GetLex;
    case op of
      '+':
      begin
        expr := UnaryExpression(lval);
        if Assigned(expr) then
          Result := FExpr.MakeExpr1(opPreInc,expr)
        else
          Error;
      end;
      '-':
      begin
        expr := UnaryExpression(lval);
        if Assigned(expr) then
          Result := FExpr.MakeExpr1(opPreDec,expr)
        else
          Error;
      end;
    end;
  end
  else if Token = ADDOP then
  begin
    op := FLex.yylval.yyChar;
    GetLex;
    case op of
      '+':
      begin
        expr := UnaryExpression(lval);
        if Assigned(expr) then
          Result := FExpr.MakeExpr1(opPlus,expr)
        else
          Error;
      end;
      '-':
      begin
        expr := UnaryExpression(lval);
        if Assigned(expr) then
          Result := FExpr.MakeExpr1(opMinus,expr)
        else
          Error;
      end;
    end;
  end
  else if Token = UNOP then
  begin
    op := FLex.yylval.yyChar;
    GetLex;
    case op of
      '!':
      begin
        expr := UnaryExpression(lval);
        if Assigned(expr) then
          Result := FExpr.MakeExpr1(opLogicalNot,expr)
        else
          Error;
      end;
      '~':
      begin
        expr := UnaryExpression(lval);
        if Assigned(expr) then
          Result := FExpr.MakeExpr1(opBitNot,expr)
        else
          Error;
      end;
    end;
  end;

end;

function TJParser.Variable(var lval: Boolean): PJExpr;
//ϐ
//variable   : VARIABLE              { $$ := FExpr.MakeVariable(String($1)); }
begin
  Result := nil;
  if Token = _VARIABLE then
  begin
    Result := FExpr.MakeVariable(FLex.yytext);
    lval := True;
    GetLex;
  end;
end;

function TJParser.VarStatement: PJStatement;
//var_statement           : _VAR variable_declaration_list SC
var
  stmt: PJStatement;
begin
  Result := nil;
  if Token = _VAR then
  begin
    GetLex;
    stmt := VariableDeclarationList;
    if Assigned(stmt) then
    begin
      if Token = SC then
      begin
        GetLex;
        Result := FStmt.MakeVarDecl(stmt);
      end
      else
        Error;
    end
    else
      Error;
  end;
end;

function TJParser.WhileStatement: PJStatement;
//12 while
//while_statement         : _WHILE LP expression rp statement
//                      { $$ := FStmt.MakeWhileStatement($3,$5); }
var
  expr: PJExpr;
  stmt: PJStatement;
begin
  Result := nil;
  if Token = _WHILE then
  begin
    GetLex;
    if Token = LP then
    begin
      GetLex;
      expr := Expression;
      if Assigned(expr) then
      begin
        if Token = RP then
        begin
          GetLex;
          stmt := Statement;
          if Assigned(stmt) then
            Result := FStmt.MakeWhileStatement(expr,stmt)
          else
            Error;
        end
        else
          Error;
      end
      else
        Error;
    end
    else
      Error;
  end;
end;

function TJParser.WithStatement: PJStatement;
//with_statement          : _WITH LP expression rp statement
//                        { $$ := FStmt.MakeWithStatement($3,$5);}
var
  expr: PJExpr;
  stmt: PJStatement;
begin
  Result := nil;
  if Token = _WITH then
  begin
    GetLex;
    if Token = LP then
    begin
      GetLex;
      expr := Expression;
      if Assigned(expr) then
      begin
        if Token = RP then
        begin
          GetLex;
          stmt := Statement;
          if Assigned(stmt) then
            Result := FStmt.MakeWithStatement(expr,stmt)
          else
            Error;
        end
        else
          Error;
      end
      else
        Error;
    end
    else
      Error;
  end;

end;

function TJParser.XorExpression(var lval: Boolean): PJExpr;
//xor
//| assignment_expression OP_BIT_XOR assignment_expression
//                 { $$ := FExpr.MakeExpr2(opBitXor,$1,$3); }
var
  expr: PJExpr;
begin
  Result := AndExpression(lval);
  while Assigned(Result) do
  begin
    if Token = OP_BIT_XOR then
    begin
      GetLex;
      expr := AndExpression(lval);
      if Assigned(expr) then
      begin
        Result := FExpr.MakeExpr2(opBitXor,Result,expr);
      end
      else
        Error;
    end
    else
      Break;
  end;
end;

function TJParser.DoStatement: PJStatement;
//do - while
//do_statement         : _DO statement _WHILE LP expression RP SC
//                      { $$ := FStmt.MakeDoStatement($3,$5); }
var
  expr: PJExpr;
  stmt: PJStatement;
begin
  Result := nil;
  if Token = _DO then
  begin
    GetLex;
    stmt := Statement;
    if Assigned(stmt) then
    begin
      if Token = _WHILE then
      begin
        GetLEx;
        if Token = LP then
        begin
          GetLex;
          expr := Expression;
          if Assigned(expr) then
          begin
            if Token = RP then
            begin
              GetLex;
              if Token = SC then
                Result := FStmt.MakeDoStatement(expr,stmt)
              else
                Error;
            end
            else
              Error;
          end
          else
            Error;
        end
        else
          Error;
      end
      else
        Error;
    end
    else
      Error;
  end;

end;

function TJParser.ConstNaN(var lval: Boolean): PJExpr;
begin
  Result := nil;
  if Token = _NaN then
  begin
    Result := FExpr.MakeNaN;
    GetLex;
  end;
end;

function TJParser.ObjectElement: PJExpr;
//object_element        : variable COLON assignment_expression
//                      | variavle
var
  va,expr: PJExpr;
  lval: Boolean;
begin
  Result := nil;
  va := Variable(lval);
  if Assigned(va) then
  begin
    if Token = COLON then
    begin
      GetLex;
      expr := AssignmentExpression;
      if Assigned(expr) then
        Result := FExpr.MakeObjectElement(va,expr)
      else
        Error;
    end
    else
      Result := FExpr.MakeObjectElement(va,nil);
  end;
end;

function TJParser.ObjectElements: PJExpr;
//object_elements       : object_elements COMMA object_element
//                      | object_element
var
  prev,expr: PJExpr;
begin
  Result := nil;
  prev := ObjectElement;
  if not Assigned(prev) then
    Exit
  else
   Result := FExpr.MakeArguments(nil,prev);
  //   ċA tɕ
  while True do
  begin
    if Token = COMMA then
    begin
      GetLex;
      expr := ObjectElement;
      if Assigned(expr) then
        Result := FExpr.MakeArguments(Result,expr)
      else
        Error;
    end
    else
      Break;
  end;
end;

function TJParser.ClassDeclaration: PJStatement;
//class_declaration     : _CLASS variable LB class_elements RB
//                      | _CLASS variable LP variavle RP LB class_elements RB
//                      | _CLASS variable _EXTENDS variable LB class_elements RB
var
  obj,super: PJExpr;
  stmt: PJStatement;
  lval: Boolean;
begin
  Result := nil;
  if Token = _CLASS then
  begin
    GetLex;
    obj := Variable(lval);
    if Assigned(obj) then
    begin
      if Token = LB then
      begin
        GetLex;
        stmt := ClassElements;
        if Token = RB then
        begin
          GetLex;
          Result := FStmt.MakeClassDecl(obj,nil,stmt);
        end
        else
          Error;
      end
      else if Token = LP then
      begin
        GetLex;
        super := Variable(lval);
        if Token = RP then
        begin
          GetLex;
          if Token = LB then
          begin
            GetLex;
            stmt := ClassElements;
            if Token = RB then
            begin
              GetLex;
              Result := FStmt.MakeClassDecl(obj,super,stmt);
            end
            else
              Error;
          end;
        end
        else
          Error;
      end
      else if Token = _EXTENDS then
      begin
        GetLex;
        super := Variable(lval);
        if Assigned(super) then
        begin
          if Token = LB then
          begin
            GetLex;
            stmt := ClassElements;
            if Token = RB then
            begin
              GetLex;
              Result := FStmt.MakeClassDecl(obj,super,stmt);
            end
            else
              Error;
          end;
        end
        else
          Error;
      end
      else
        Error;
    end
    else
      Error;
  end;
end;

function TJParser.Declaration: PJStatement;
//declaration   : function_declaration
//              | class_declaration
//              | import_declaration
begin
  Result := FunctionDeclaration;

  if not Assigned(Result) then
    Result := ClassDeclaration;

  if not Assigned(Result) then
    Result := ImportDeclaration;
end;

function TJParser.ClassElement: PJStatement;
//class_element : member_declaration
//              | function_declaration
begin
  Result := FunctionDeclaration;
  if not Assigned(Result) then
    Result := MemberDeclaration;
end;

function TJParser.ClassElements: PJStatement;
//class_elements        : class_elements class_element
//                      | class_element
var
  prev,next: PJStatement;
begin
  Result := ClassElement;
  if not Assigned(Result) then
    Exit;

  prev := Result;
  next := ClassElement;
  FStmt.MergeStatement(prev,next);
  //ԂɌqĂ
  while Assigned(next) do
  begin
    prev := next;
    next := ClassElement;
    FStmt.MergeStatement(prev,next);
  end;
end;

function TJParser.MemberDeclaration: PJStatement;
//member_declaration    : var_statement
//                      | variable_declaration_lsit SC
var
  stmt: PJStatement;
begin
  Result := VarStatement;
  if Assigned(Result) then
    Exit;

  stmt := VariableDeclaration;
  if Assigned(stmt) then
  begin
    if Token = SC then
    begin
      GetLex;
      Result := stmt;
    end
    else
      Error;
  end;
end;

function TJParser.Super(var lval: Boolean): PJExpr;
//super : _SUPER                 { $$ := FExpr.MakeThis; }
//      | _SUPER DOT variable
var
  v: PJExpr;
begin
  Result := nil;
  if Token = _SUPER then
  begin
    GetLex;
    if Token = DOT then
    begin
      GetLex;
      v := Variable(lval);
      if Assigned(v) then
        Result := FExpr.MakeSuper(v)
      else
        Error;
    end
    else
      Result := FExpr.MakeThis;
  end;
end;

function TJParser.ImportDeclaration: PJStatement;
//import_declaration    : _IMPORT variable SC    OԂ
//                      | _IMPORT variavle DOT OP_MUL SC OԂȂ
var
  expr: PJExpr;
  lval: Boolean;
  sl: TStringList;
  name,path,source: ECMAString;
  i: Integer;
  flag: Boolean;
  p: TJParser;
begin
  Result := nil;
  source := '';
  flag := False;
  if Token = _IMPORT then
  begin
    GetLex;
    expr := Variable(lval);
    if Assigned(expr) then
    begin
      //\[Xǂݍ
      sl := TStringList.Create;
      try try
        name := expr^.Symbol + DMS_EXT;
        for i := 0 to FLibPath.Count - 1 do
        begin
          path := IncludeTrailingBackslash(FLibPath[i]) + name;
          if FileExists(path) then
          begin
            sl.LoadFromFile(path);
            source := sl.Text;
            flag := True;
            Break;
          end;
        end;
        if not flag then
          raise EJSyntaxError.Create('file not found: ' + name);
      finally
        sl.Free;
      end;
      except
        raise EJSyntaxError.Create('can not open: ' + name);
      end;

      if Token = SC then
      begin
        GetLex;
        //OԂ
        p := TJParser.Create;
        FPackages.Add(p);
        p.SourceCode := source;
        p.Parse;
        Result := FStmt.MakeImportDecl(expr,p.Root);
      end
      else if Token = DOT then
      begin
        GetLex;
        if (Token = MULOP) and (FLex.yylval.yyChar = '*') then
        begin
          GetLex;
          if Token = SC then
          begin
            //Ȃ_~[
            Result := FStmt.NewStatement;
            FLex.ImportSource(source);
            GetLex;
          end;
        end
        else
          Error;
      end
      else
        Error;
    end
    else
      Error;
  end;
end;


function TJParser.NewExpression(var lval: Boolean): PJExpr;
//new_expression        : _NEW variable         { $$ := FExpr.MakeExpr2(opNew,$2,nil); }
//                      | _NEW variable LP arguments rp
//                                { $$ := FExpr.MakeExpr2(opNew,$2,$4); }
//                      | _NEW variable LP rp
//                                { $$ := FExpr.MakeExpr2(opNew,$2,nil); }
//                      | _NEW variable DOT variable
//                      | _NEW variable DOT variable LP RP
//                      | _NEW variable DOT variable LP arguments RP
var
  expr1,expr2,arg: PJExpr;
begin
  Result := nil;
  if Token = _NEW then
  begin
    GetLex;
    expr1 := Variable(lval);
    if Assigned(expr1) then
    begin
      if Token = LP then
      begin
        GetLex;
        arg := Arguments(lval);
        if Token = RP then
        begin
          GetLex;
          Result := FExpr.MakeExpr2(opNew,expr1,arg)
        end
        else
          Error;
      end
      else if Token = DOT then
      begin
        GetLex;
        expr2 := Variable(lval);
        if Assigned(expr2) then
        begin
          if Token = LP then
          begin
            GetLex;
            arg := Arguments(lval);
            if Token = RP then
            begin
              GetLex;
              //expr12tɂȂ
              Result := FExpr.MakeExpr3(opNew,expr2,arg,expr1);
            end
            else
              Error;
          end
          else begin
            Result := FExpr.MakeExpr3(opNew,expr2,nil,expr1);
          end;
        end
        else
          Error;
      end
      else begin
        Result := FExpr.MakeExpr2(opNew,expr1,nil);
      end;
    end
    else
      Error;
  end
end;

function TJParser.VariableDeclarationList: PJStatement;
//variable_declaration_list     : variable_declaration
//                              | variable_declaration_list COMMA variable_declaration
var
  prev,next: PJStatement;
begin
  Result := VariableDeclaration;
  if not Assigned(Result) then
    Exit;

  prev := Result;
  while True do
  begin
    if Token = COMMA then
    begin
      GetLex;
      next := VariableDeclaration;
      if Assigned(next) then
      begin
        FStmt.MergeStatement(prev,next);
        prev := next;
      end
      else
        Error;
    end
    else
      Break;
  end;

end;

function TJParser.VariableDeclaration: PJStatement;
//variable_declaration  : variable
//                      | variable OP_ASSIGN assignement_expression
var
  lval: Boolean;
  name,value: PJExpr;
begin
  Result := nil;
  name := Variable(lval);
  if Assigned(name) then
  begin
    if Token = OP_ASSIGN then
    begin
      GetLex;
      value := AssignmentExpression;
      if Assigned(value) then
        Result := FStmt.MakeVariableDecl(name,value)
      else
        Error;
    end
    else
      Result := FStmt.MakeVariableDecl(name,nil);
  end;
end;

function TJParser.SwitchStatement: PJStatement;
//switch_statement  : _SWITCH LP expression rp LB labeled_statement_list RB
var
  expr: PJExpr;
  stmt: PJStatement;
begin
  Result := nil;
  //_SWITCH LP expression rp statement
  if Token = _SWITCH then
  begin
    GetLex;
    //LP
    if Token = LP then
    begin
      GetLex;
      //expression
      expr := Expression;
      if Assigned(expr) then
      begin
        if Token = RP then
        begin
          GetLex;
          if Token = LB then
          begin
            GetLex;
            //statement
            stmt := LabeledStatementList;
            if Assigned(stmt) then
            begin
              if Token = RB then
              begin
                GetLex;
                Result := FStmt.MakeSwitchStatement(expr,stmt);
              end
              else
                Error;
            end
            else
              Error;
          end
          else
            Error;
        end
        else
          Error;
      end
      else
        Error;
    end
    else
      Error;
  end;    
end;

function TJParser.LabeledStatement(var Default: Boolean): PJStatement;
//labeled_statement : _CASE    laveled_constant_expression COLON statement_list
//                  | _CASE    laveled_constant_expression COLON
//                  | _DEFAULT COLON statement_list
//                  | _DEFAULT COLON
var
  expr: PJExpr;
  lval: Boolean;
begin
  Result := nil;
  lval := False;
  //_CASE    constant_expression COLON statement
  if Token = _CASE then
  begin
    GetLex;
    //constant_expression
{ TODO : ςcaseŒ萔ȊO̔r\ }
    //expr := Constant(lval);
    expr := LabeledConstant(lval);
    if Assigned(expr) then
    begin
      //COLON
      if Token = COLON then
      begin
        GetLex;
        //statement nilłOK
        Result := FStmt.MakeLabeledStatement(expr,StatementList)
      end
      else
        Error;
    end
    else
      Error;
  end
  //_DEFAULT COLON statement
  else if Token = _DEFAULT then
  begin
    if not Default then
    begin
      Default := True;
      GetLex;
      //COLON
      if Token = COLON then
      begin
        GetLex;
        //statement nilłOK
        Result := FStmt.MakeLabeledStatement(nil,StatementList)
      end
      else
        Error;
    end
    else //default傪
      Error;
  end;
end;

function TJParser.LabeledStatementList: PJStatement;
//lebeledXg
//labeled_statement_list  : labeled_statement_list labeled_statement
//                        | labeled_statement
var
  prev,next: PJStatement;
  default: Boolean;
begin
  default := False;
  Result := LabeledStatement(default);
  if not Assigned(Result) then
    Exit;

  prev := Result;
  next := LabeledStatement(default);
  FStmt.MergeStatement(prev,next);
  //ԂɌqĂ
  while Assigned(next) do
  begin
    prev := next;
    next := LabeledStatement(default);
    FStmt.MergeStatement(prev,next);
  end;
end;

procedure TJParser.SerializeRoot(ARoot: PJStatement; Stream: TStream);
//RootVACY
begin
  //ŏɖ߂
  Stream.Seek(0,soFromBeginning);
  //header
  Stream.WriteBuffer(DMS_ENGINE[1],Length(DMS_ENGINE));
  Stream.WriteBuffer(DMS_SERIALIZE_VER,SizeOf(DMS_SERIALIZE_VER));
  //Jn
  if Assigned(ARoot) then
    SerializeStatement(ARoot,Stream);
  //؂̂
  Stream.Size := Stream.Position;
end;

function TJParser.DeserializeRoot(Stream: TStream): PJStatement;
//RootfVACY
var
  ver: Byte;
  script: String;
begin
  Result := nil;
  //ŏɖ߂
  Stream.Seek(0,soFromBeginning);
  //header
  SetLength(script,Length(DMS_ENGINE));
  Stream.ReadBuffer(script[1],Length(DMS_ENGINE));
  if script <> DMS_ENGINE then
    Exit;
  //ver
  Stream.ReadBuffer(ver,SizeOf(ver));
  if ver <> DMS_SERIALIZE_VER then
    Exit;
  //Jn
  if Stream.Position < Stream.Size then
    Result := DeserializeStatement(Stream);
end;

procedure TJParser.SerializeStatement(P: PJStatement; Stream: TStream);
//̃VACY
//0.ok 1.expr 2.sub1 3.sub2 4.next
var
  flags: Byte;
begin
  //flag쐬
  flags := SetByteFlag(
    [True,
     Assigned(P^.Expr),
     Assigned(P^.Sub1),
     Assigned(p^.Sub2),
     Assigned(P^.Next),
     False,False,False]);
  
  //flags
  Stream.WriteBuffer(flags,SizeOf(flags));
  //^Cv
  Stream.WriteBuffer(P^.SType,SizeOf(P^.SType));
  //
  if Assigned(P^.Expr) then
    SerializeExpr(P^.Expr,Stream);
  //sub1
  if Assigned(P^.Sub1) then
    SerializeStatement(P^.Sub1,Stream);
  //sub2
  if Assigned(P^.Sub2) then
    SerializeStatement(P^.Sub2,Stream);
  //next
  if Assigned(P^.Next) then
    SerializeStatement(P^.Next,Stream);
end;

function TJParser.DeserializeStatement(Stream: TStream): PJStatement;
//̃fVACY
//0.ok 1.expr 2.sub1 3.sub2 4.next
var
  flags: Byte;
begin
  Stream.ReadBuffer(flags,SizeOf(flags));
  //쐬
  Result := FStmt.NewStatement;
  //^Cv
  Stream.ReadBuffer(Result^.SType,SizeOf(Result^.SType));
  //
  if GetByteFlag(flags,1) then
    Result^.Expr := DeserializeExpr(Stream);
  //sub1
  if GetByteFlag(flags,2) then
    Result^.Sub1 := DeserializeStatement(Stream);
  //sub2
  if GetByteFlag(flags,3) then
    Result^.Sub2 := DeserializeStatement(Stream);
  //next
  if GetByteFlag(flags,4) then
    Result^.Next := DeserializeStatement(Stream);
end;

procedure TJParser.SerializeExpr(P: PJExpr; Stream: TStream);
//̃VACY
//0.ok 1.symbol 2.value 3.left 4.right 5.third
var
  len: Integer;
  flags: Byte;
begin
  //flag쐬
  flags := SetByteFlag(
    [True,                 //0
     Length(P^.Symbol) > 0,//1
     Assigned(P^.Value),   //2
     Assigned(P^.Left),    //3
     Assigned(p^.Right),   //4
     Assigned(P^.Third),   //5
     False,False]);
  //
  Stream.WriteBuffer(flags,SizeOf(flags));
  //op
  Stream.WriteBuffer(P^.Code,SizeOf(P^.Code));
  //
  len := Length(P^.Symbol);
  if len > 0 then
  begin
    Stream.WriteBuffer(len,SizeOf(len));
    Stream.WriteBuffer(P^.Symbol[1],len);
  end;
  //TJValue
  if Assigned(p^.Value) then
    SerializeValue(P^.Value,Stream);
  //left
  if Assigned(p^.Left) then
    SerializeExpr(P^.Left,Stream);
  //right
  if Assigned(p^.Right) then
    SerializeExpr(P^.Right,Stream);
  //third
  if Assigned(p^.Third) then
    SerializeExpr(P^.Third,Stream);
end;

function TJParser.DeserializeExpr(Stream: TStream): PJExpr;
//̃fVACY
//0.ok 1.symbol 2.value 3.left 4.right 5.third
var
  len: Integer;
  flags: Byte;
begin
  Stream.ReadBuffer(flags,SizeOf(flags));
  //쐬
  Result := FExpr.NewExpr;
  //op
  Stream.ReadBuffer(Result^.Code,SizeOf(Result^.Code));
  //
  if GetByteFlag(flags,1) then
  begin
    Stream.ReadBuffer(len,SizeOf(len));
    SetLength(Result^.Symbol,len);
    Stream.ReadBuffer(Result^.Symbol[1],len);
  end;
  //TJValue
  if GetByteFlag(flags,2) then
    Result^.Value := DeserializeValue(Stream);
  //left
  if GetByteFlag(flags,3) then
    Result^.Left := DeserializeExpr(Stream);
  //right
  if GetByteFlag(flags,4) then
    Result^.Right := DeserializeExpr(Stream);
  //third
  if GetByteFlag(flags,5) then
    Result^.Third := DeserializeExpr(Stream);
end;

procedure TJParser.SerializeValue(P: PJValue; Stream: TStream);
//valuẽVACY
//0.ok 1.vstring
var
  len: Integer;
  flags,objflags: Byte;
  re: TJRegExpObject;
begin
  //flag쐬
  flags := SetByteFlag(
    [True,                   //0
     Length(P^.vString) > 0, //1
     False,False,False,False,False]);
  //value
  Stream.WriteBuffer(flags,SizeOf(flags));
  //value type
  Stream.WriteBuffer(P^.ValueType,SizeOf(P^.ValueType));
  //l
  case P^.ValueType of
    vtUndefined,vtNull,vtInteger,
    vtBool,vtInfinity,vtNaN:
    begin  //4oCg
      Stream.WriteBuffer(P^.vInteger,SizeOf(P^.vInteger));
    end;

    vtDouble:
    begin
      Stream.WriteBuffer(P^.vDouble,SizeOf(P^.vDouble));
    end;

    vtObject:
    begin
      objflags := 0;
      //K\
      if P^.vObject is TJRegExpObject then
      begin
        re := P^.vObject as TJRegExpObject;
        //0.re 1.ignore 2.global
        objflags := SetByteFlag([True,re.ignoreCase,re.global,
          False,False,False,False,False,False]);

        Stream.WriteBuffer(objflags,SizeOf(objflags));
        //
        len := Length(re.source);
        Stream.WriteBuffer(len,SizeOf(len));
        Stream.WriteBuffer(re.source[1],len); 
      end
      else //K
        Stream.WriteBuffer(objflags,SizeOf(objflags));
    end;

    vtString,vtFunction,
    vtDispatch://Ȃ;
  end;

  //
  len := Length(P^.vString);
  if len > 0 then
  begin
    Stream.WriteBuffer(len,SizeOf(len));
    Stream.WriteBuffer(P^.vString[1],len);
  end;
end;

function TJParser.DeserializeValue(Stream: TStream): PJValue;
//valuẽfVACY
//0.ok 1.vstring
var
  flags,objflags: Byte;
  len: Integer;
  re: TJRegExpObject;
  s: String;
begin
  Stream.ReadBuffer(flags,SizeOf(flags));
  //value쐬
  New(Result);
  EmptyValue(Result^);
  //value type
  Stream.ReadBuffer(Result^.ValueType,SizeOf(Result^.ValueType)); 
  //l
  case Result^.ValueType of
    vtUndefined,vtNull,vtInteger,
    vtBool,vtInfinity,vtNaN:
    begin  //4oCg
      Stream.ReadBuffer(Result^.vInteger,SizeOf(Result^.vInteger));
    end;

    vtDouble:
    begin
      Stream.ReadBuffer(Result^.vDouble,SizeOf(Result^.vDouble));
    end;

    vtObject:
    begin
      //0.re 1.ignore 2.global
      Stream.ReadBuffer(objflags,SizeOf(objflags));
      if GetByteFlag(objflags,0) then
      begin
        re := TJRegExpObject.Create(nil,nil);
        re.IncRef;
        Result^.vObject := re;    
        re.ignoreCase := GetByteFlag(objflags,1);
        re.global := GetByteFlag(objflags,2);
        //
        Stream.ReadBuffer(len,SizeOf(len));
        SetLength(s,len);
        Stream.ReadBuffer(s[1],len);
        re.source := s;
      end;
    end;

    vtString,vtFunction,
    vtDispatch://Ȃ;
  end;

  //
  if GetByteFlag(flags,1) then
  begin
    Stream.ReadBuffer(len,SizeOf(len));
    SetLength(Result^.vString,len);
    Stream.ReadBuffer(Result^.vString[1],len);
  end;
end;

function TJParser.Serialize(Filename: String): Boolean;
//VACY
var
  fs: TFileStream;
begin
  Result := False;
  if not Assigned(FRoot) then
    Exit;

  try
    fs := TFileStream.Create(Filename,fmCreate);
    try
      SerializeRoot(FRoot,fs);
      Result := True;
    finally
      fs.Free;
    end;
  except
    on EFCreateError do
  end;
end;

function TJParser.Deserialize(Filename: String): Boolean;
//ɖ߂
var
  fs: TFileStream;
begin
  Result := False;
  //NA
  Clear;
  FSourceCode := '';
  //I
  if not FileExists(Filename) then
    Exit; 

  try
    fs := TFileStream.Create(Filename,fmOpenRead);
    try
      FRoot := DeserializeRoot(fs);
      Result := Assigned(FRoot);
    finally
      fs.Free;
    end;
  except
    on EFOpenError do
  end;
end;

function TJParser.OptionVarExpression: PJExpr;
//ϐ錾܂ގ
//option_var_expression  : expression
//                       | _VAR expression
//                       | (null)
begin
  Result := Expression;
  if not Assigned(Result) then
  begin
    if Token = _VAR then
    begin
      GetLex;
      Result := Expression;
    end;
  end;
end;

function TJParser.AddtiveSignNumber(var lval: Boolean): PJExpr;
//t
//addtive_sign_number  : + NUMBER
//                     | - NUMBER
//                     | + FLOAT_NUMBER
//                     | - FLOAT_NUMBER
var
  op: ECMAChar;
begin
  Result := nil;
  if Token = ADDOP then
  begin     
    op := FLex.yylval.yyChar;
    GetLex;
    if Token = _NUMBER then
    begin
      case op of
        '+': Result := FExpr.MakeNumberInt(FLex.yylval.yyInteger);
        '-': Result := FExpr.MakeNumberInt(-FLex.yylval.yyInteger);
      end;

      GetLex;
    end
    else if Token = _FLOAT_NUMBER then
    begin
      case op of
        '+': Result := FExpr.MakeNumberFloat(FLex.yylval.yyDouble);
        '-': Result := FExpr.MakeNumberFloat(-FLex.yylval.yyDouble);
      end;

      GetLex;
    end
    else if Token = _INVALID_VALUE then
      raise EJSyntaxError.Create('Invalid Value: ' + 'Line( ' + IntToStr(FLex.LineNo) +
        ' ) Text( ' + FLex.yytext + ' )');
  end;
end;

function TJParser.LabeledConstant(var lval: Boolean): PJExpr;
//swicthɎg萔
//labeled_constant     : constant
//                     | addtive_sign_number
begin
  Result := Constant(lval);
  if not Assigned(Result) then
    Result := AddtiveSignNumber(lval);
end;

end.
