unit DMonkey;

{
  DMS(DMonkey Script) by Project DMonkey
  License: BSD
           ̃Cu͖ۏ؂łB
           gpAρAzzɈ؂̐͂܂B
           ҂ɒʒm⃉CZX\Kv܂B
  History:
  2002/12/26 ver.0.2.0.3
          caseAŕׂȂ̂C
          
  2002/12/26 ver.0.2.0.2
          xɕtgȂ̂C

  2002/12/25 ver.0.2.0.1
          ActiveXPropertyGetC

  2002/12/23 ver.0.2.0
          shobohñR[h}[W
          gq̒`(ecma_type.pas)
          gObjectIC|[g邽߂$DEFINE
          ComplieLibPathǉ
          evalC
          QƃJEg̃R[h
          ȇÔƂeĂ̂CB(ecma_lex.pas)
          bZ[W{bNX̃I[i[̗Lw肷$DEFINEǉB(ecma_misc.pas)
          String.crypt([salt]) UnixDES crypt(3)BPerl݊łB
          OnStdinCxgGlobal.read() Global.readln()
          K\e /patern/ig
          switch
          Global.scriptEngineVersion()
          constructorŗONobject̃ANZXᔽC
          RpCς݃oCi(gq .dmc)
          for(var i=0; ... G[ɂȂȂ悤C
          VQƃJEg
          FTPIuWFNg
          RegExp.replaceC
          Global.isConsole()
          z()ŃANZX  a = [1]; println(a(0));
          Global.args폜
          WScriptIuWFNgisSj
          ActiveXObject̃vpeBĂяoC
          RegExp.multiline  mIvV
          EnumeratorIuWFNg
          for..inŃRNVArray̏ꍇ͗vfԂ悤ɏC
          ArrayIuWFNgTJBaseArrayObject`(count,lengthfor..ingObject͌p邱Ƃ𐄏)
          TJStringsTJBaseArrayObjectpɕύX
          TJHtmlParserObjectTJBaseArrayObjectpɕύX
          String.trim() trimLeft() trimRight() E󔒕폜
          TJStringObjectTJBaseArrayObjectpɕύX
          ֐varG[ɂȂĂ̂C
          zvf1̎Az񐔂ɂȂĂ̂C a = [5]
          
  2002/05/25 ver.0.1.7
          scriptEngine()Ȃǂ`

  2002/05/20 ver.0.1.6
          HtmlParser
          RegExp.test()̏C
          ̑

  2002/05/15 ver.0.1.5
          DatȅC

  2002/05/11 ver.0.1.4
          XNvg̑Sp󔒂𖳎悤ɏC
          RegIni
          DatȅC

  2002/04/23 Ver.0.1.3
          Object̂QC

  2002/04/14 Ver.0.1.2
          TJObjectFactory̎dlύXidvjɂTJObject̓RXgN^TJObjectFactoryɎIɏL܂BNewObject\bh͎gpȂłB
          vpeBFactoryǉ
          QƃJEg̏CiUSE_GCKvj
          CheckListBox
  2002/03/21 Ver.0.1.1
          DynaCall̏C
  2002/03/20 Ver.0.1.0
          Cxg̓o^ύX
          DynaCallIuWFNg
  2002/03/10 Ver.0.0.15
          Datě0`11ɕύX
          ArrayIuWFNg̏
          OnStepCxgǉ(XNvg̒fȂǂɎgp)
          K\Cu̕ύX
          String.toUTF8()ǉ
          String.fromUTF8toSJIS()ǉ
  2002/03/06 Ver.0.0.14
          Objecto̎QƃJEgC
          z񎮂̏C
          ArrayIuWFNg̏C
  2002/02/07 Ver.0.0.13
          oC
  2002/02/06 Ver.0.0.12
          IDispatcȟĂяoC
  2002/02/02 Ver.0.0.11
          ClipboardIuWFNg
  2002/02/01 Ver.0.0.10
          ActiveX\bhƃvpeBĂяoC
  2002/01/28 Ver.0.0.9
            KeyboardMouseIuWFNg
  2002/01/27 Ver.0.0.8
            oOC
  2001/11/16 Ver.0.0.7
            G[o
          published property̕P[X𖳎
  2001/05/09 Ver.0.0.6
            var
  2001/05/06 Ver.0.0.5
            import
  2001/05/04 Ver.0.0.4
            NX`
  2001/05/04 Ver.0.0.3
            ActiveXObject
  2001/05/02 Ver.0.0.2
          breakcontinueC
  2001/04/30 Ver.0.0.1
          
}


interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ecma_lex,ecma_parser,ecma_type,ecma_engine,
{$IFNDEF NO_EXTENSION}
  ecma_extobject,
{$ENDIF}
{$IFNDEF NO_SOCKET}
  ecma_sockobject,
{$ENDIF}
{$IFNDEF NO_ACTIVEX}
  ecma_activex,
{$ENDIF}
{$IFNDEF NO_DYNACALL}
  ecma_dynacall,
{$ENDIF}
{$IFNDEF NO_GUI}
  ecma_guiobject,
{$ENDIF}
  ecma_object,ecma_misc;

type
  TDMonkey = class(TComponent)
  private
    FParser: TJParser;
    FEngine: TJEngine;

    FFilename: String;
    FErrorText: String;
    FTookTimeToCompile: Cardinal;
    FTookTimeToRun: Cardinal;
    FTookTimeToCallFunction: Cardinal;
    FCompiledBinary: Boolean;
    //Cxg
    FOnStdout: TStringEvent;
    FOnDebugout: TStringEvent;
    FOnNewObject: TNewObjectEvent;
    FOnStderr: TStringEvent;
    FOnRun: TNotifyEvent;
    FOnDone: TNotifyEvent;
    FOnStep: TStepEvent;
    FOnStdin: TReadStringEvent;
    
    //
    procedure ParserOnDebug(Sender: TObject; S: String);
    procedure EngineOnStdout(Sender: TObject; S: String);
    procedure EngineOnStderr(Sender: TObject; S: String);
    procedure EngineOnNewObject(Sender: TObject; JObject: TJObject);
    procedure EngineOnRun(Sender: TObject);
    procedure EngineOnDone(Sender: TObject);
    procedure EngineOnStep(Sender: TObject; var AbortScript: Boolean);
    procedure EngineOnStdin(Sender: TObject; var S: String; var Success: Boolean);

    function GetLibraryPath: TStrings;
    procedure SetLibraryPath(const Value: TStrings);
    function GetObjectCount: Integer;
    function GetGarbageCollection: Boolean;
    procedure SetGarbageCollection(const Value: Boolean);
    procedure SetOnDone(const Value: TNotifyEvent);
    procedure SetOnNewObject(const Value: TNewObjectEvent);
    procedure SetOnRun(const Value: TNotifyEvent);
    procedure SetOnStderr(const Value: TStringEvent);
    procedure SetOnStep(const Value: TStepEvent);
    procedure SetOnStdout(const Value: TStringEvent);
    function GetFactory: TJObjectFactory;
    procedure SetOnStdin(const Value: TReadStringEvent);

  protected
  public
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    function Compile(SourceCode: String): Boolean;
    function CompileFile(AFilename: String): Boolean;
    function Run(Args: array of const): Integer; overload;
    function Run(Args: TJValueList): Integer; overload;
    function Run: Integer; overload;
    function CallFunction(Symbol: String; Param: array of const; var RetValue: TJValue): Boolean; overload;
    function CallFunction(Symbol: String; Param: TJValueList; var RetValue: TJValue): Boolean; overload;
    procedure Clear;
    procedure Abort;
    procedure ImportObject(ObjectName: String; ObjectClass: TJObjectClass);
    function IsRunning: Boolean;
    class function ScriptBuild: Integer;
    class function ScriptEngine: String;
    class function ScriptVersion: String;

    property ObjectCount: Integer read GetObjectCount;
    property Factory: TJObjectFactory read GetFactory;
    property TookTimeToCompile: Cardinal read FTookTimeToCompile write FTookTimeToCompile;
    property TookTimeToRun: Cardinal read FTookTimeToRun write FTookTimeToRun;
    property TookTimeToCallFunction: Cardinal read FTookTimeToCallFunction write FTookTimeToCallFunction;
    property ScriptFilename: String read FFilename;
  published
    property LibraryPath: TStrings read GetLibraryPath write SetLibraryPath;
    property GarbageCollection: Boolean read GetGarbageCollection write SetGarbageCollection;
    property CompiledBinary: Boolean read FCompiledBinary write FCompiledBinary; 
    //Cxg
    property OnStdout: TStringEvent read FOnStdout write SetOnStdout;
    property OnStderr: TStringEvent read FOnStderr write SetOnStderr;
    property OnDebugout: TStringEvent read FOnDebugout write FOnDebugout;
    property OnNewObject: TNewObjectEvent read FOnNewObject write SetOnNewObject;
    property OnRun: TNotifyEvent read FOnRun write SetOnRun;
    property OnDone: TNotifyEvent read FOnDone write SetOnDone;
    property OnStep: TStepEvent read FOnStep write SetOnStep;
    property OnStdin: TReadStringEvent read FOnStdin write SetOnStdin;
  end;

  TDMS = class(TDMonkey);
  

procedure ShowDMonkeyException(DMonkey: TDMonkey);


procedure Register;

implementation

procedure Register;
begin
  RegisterComponents('Samples', [TDMS]);
end;


procedure ShowDMonkeyException(DMonkey: TDMonkey);
//G[\
var
  caption,text: String;
begin
  caption := GetApplicationTitle;
  if DMonkey.FFilename <> '' then
    caption := caption + ' - ' + ExtractFilename(DMonkey.FFilename);

  text := DMonkey.FErrorText;
  MsgBox(PChar(text), PChar(caption), MB_OK or MB_ICONHAND);
end;


{ TDMonkey }

procedure TDMonkey.Abort;
//~
begin
  FEngine.Abort;
end;

function TDMonkey.CallFunction(Symbol: String; Param: TJValueList; var RetValue: TJValue): Boolean;
//֐Ăяo
var
  tmp: Cardinal;
  i: Integer;
  v: TJValue;
begin
  //Ԍv
  tmp := GetTickCount;

  Result := False;
  if Assigned(FParser.Root) then
  begin
    if Assigned(Param) then
    begin
      //QƃJEg𑝂₷
      for i := 0 to Param.Count - 1 do
      begin
        v := Param[i];
        if IsObject(@v) then
          v.vObject.IncRef;
      end;

      Result := FEngine.CallFunction(FParser.Root,Symbol,Param,RetValue);
      { TODO : QƃJEg炷H }
      //
    end
    else begin
      Param := TJValueList.Create;
      try
        Result := FEngine.CallFunction(FParser.Root,Symbol,Param,RetValue);
      finally
        Param.Free;
      end;
    end;
  end;

  FTookTimeToCallFunction := GetTickCount - tmp;
end;

function TDMonkey.CallFunction(Symbol: String;
  Param: array of const; var RetValue: TJValue): Boolean;
//֐Ăяo
var
  list: TJValueList;
  i: Integer;
begin
  list := TJValueList.Create;
  try
    //ϊ
    for i := 0 to High(Param) do
      list.Add(VarRecToValue(Param[i]));

    Result := CallFunction(Symbol,list,RetValue);
  finally
    list.Free;
  end;
end;

procedure TDMonkey.Clear;
//f[^NA
begin
  FParser.Clear;
  FEngine.AllClear;
end;

function TDMonkey.Compile(SourceCode: String): Boolean;
//͖؂
var
  tmp: Cardinal;
begin
  Result := False;
  //RpC
  tmp := GetTickCount;
  try
    //fobO
    if Assigned(FOnDebugout) then
      FParser.Lex.OnDebug := ParserOnDebug;

    FParser.SourceCode := SourceCode;
    //exe pathǉ
    FParser.LibPath.Add(ExtractFilePath(ParamStr(0)));
    try try
      Result := FParser.Parse;
    except
      on E:EJSyntaxError do
        EngineOnStderr(Self,(E.Message));
      on E:EJThrow do
        EngineOnStderr(Self,'Exception: ' + E.Message + ' => ' + E.ErrorMsg);
    end;
    finally
      //libpath폜
      FParser.LibPath.Delete(FParser.LibPath.Count - 1);
    end;
  finally
    //RpC
    FTookTimeToCompile := GetTickCount - tmp;
  end;
end;

function TDMonkey.CompileFile(AFilename: String): Boolean;
//t@Cw肵Ďs(lib pathǉ)

  function GetTempDmc(dmc: String): String;
  var
    path: array[0..MAX_PATH] of Char;
  begin
    GetTempPath(MAX_PATH,path);
    Result := String(path) + ExtractFilename(dmc);
  end;

var
  sl: TStringList;
  dmc,tmpdmc: String;
  tmp: Cardinal;
  ok: Boolean;
begin
  Result := False;
  FFilename := AFilename;
  if not FileExists(AFilename) then
    Exit;

  tmp := GetTickCount;
  try
    //RpCς݃oCi[h
    dmc := ChangeFileExt(AFilename,DMS_COMPILED_EXT);
    if FCompiledBinary then
    begin
      //trĐV
      if FileExists(dmc) and (FileAge(dmc) >= FileAge(AFilename)) then
        Result := FParser.Deserialize(dmc);
      //ǂݍ݂Ɏse|ǂ
      if not Result then
      begin
        tmpdmc := GetTempDmc(dmc);
        if FileExists(tmpdmc) and (FileAge(tmpdmc) >= FileAge(AFilename)) then
          Result := FParser.Deserialize(tmpdmc);
      end;
    end;

    if not Result then
    begin
      //lib pathǉ
      FParser.LibPath.Add(ExtractFilePath(AFilename));
      sl := TStringList.Create;
      try
        sl.LoadFromFile(AFilename);
        Result := Compile(sl.Text);
        //Ȃ΃VACY
        if Result and FCompiledBinary then
        begin
          ok := FParser.Serialize(dmc);
          //t@C쐬Ɏse|ɍ
          if not ok then
          begin
            tmpdmc := GetTempDmc(dmc);
            FParser.Serialize(tmpdmc);
          end; 
         end;
      finally
        sl.Free;
        //libpath폜
        FParser.LibPath.Delete(FParser.LibPath.Count - 1);
      end;
    end;
  finally
    //RpC
    FTookTimeToCompile := GetTickCount - tmp;
  end;
end;

constructor TDMonkey.Create(AOwner: TComponent);
//쐬
begin
  inherited;
  FParser := TJParser.Create;
  FEngine := TJEngine.Create(Self);
  //gobjectC|[g
{$IFNDEF NO_EXTENSION}
  ImportObject('File',TJFileObject);
  ImportObject('Directory',TJDirectoryObject);
  ImportObject('Strings',TJStringsObject);
  ImportObject('Win32',TJWin32Object);
  ImportObject('Ini',TJIniObject);
  ImportObject('CRC',TJCRCObject);
  ImportObject('Base64',TJBase64Object);
  ImportObject('Dialog',TJDialogObject);
  ImportObject('Mutex',TJMutexObject);
  ImportObject('Keyboard',TJKeyboard);
  ImportObject('Mouse',TJMouse);
  ImportObject('Clipboard',TJClipboard);
  ImportObject('RegIni',TJRegIniObject);
{$ENDIF}
{$IFNDEF NO_SOCKET}
  ImportObject('URL',TJUrlInfoObject);
  ImportObject('Cookie',TJCookieObject);
  ImportObject('Response',TJResponseObject);
  ImportObject('HTTP',TJHTTPObject);
  ImportObject('HTTPS',TJHTTPSObject);
  ImportObject('TCPSocket',TJTCPSocketObject);
  ImportObject('Mail',TJMailObject);
  ImportObject('POP3',TJPOP3Object);
  ImportObject('SMTP',TJSMTPObject);
  ImportObject('HtmlTag',TJHtmlTagObject);
  ImportObject('HtmlParser',TJHtmlParserObject);
  ImportObject('FTP',TJFTPObject);
  ImportObject('FileProperty',TJFTPFilePropertyObject);
{$ENDIF}
{$IFNDEF NO_ACTIVEX}
   ImportObject('ActiveXObject',TJActiveXObject);
   ImportObject('Enumerator',TJEnumeratorObject);
{$ENDIF}
{$IFNDEF NO_DYNACALL}
   ImportObject('DynaCall',TJDynaCall);
{$ENDIF}
{$IFNDEF NO_GUI}
   ImportObject('CheckListBox',TJCheckListBox);
{$ENDIF}
end;

destructor TDMonkey.Destroy;
//j
begin
  Clear;   
  FreeAndNil(FParser);
  FreeAndNil(FEngine);
  inherited;
end;

procedure TDMonkey.EngineOnDone(Sender: TObject);
begin
 if Assigned(FOnDone) then
   FOnDone(Self);
end;

procedure TDMonkey.EngineOnNewObject(Sender: TObject; JObject: TJObject);
//object 쐬Cxg
begin
  if Assigned(FOnNewObject) then
    FOnNewObject(Self,JObject);
end;

procedure TDMonkey.EngineOnRun(Sender: TObject);
begin
  if Assigned(FOnRun) then
    FOnRun(Self);
end;

procedure TDMonkey.EngineOnStderr(Sender: TObject; S: String);
//WG[
begin
  FErrorText := S;
  if Assigned(FOnStderr) then
    FOnStderr(Self,S);
end;

procedure TDMonkey.EngineOnStdout(Sender: TObject; S: String);
//Wo
begin
  if Assigned(FOnStdout) then
    FOnStdout(Self,S);
end;

procedure TDMonkey.EngineOnStep(Sender: TObject; var AbortScript: Boolean);
begin
  if Assigned(FOnStep) then
    FOnStep(Self,AbortScript);
end;

function TDMonkey.GetGarbageCollection: Boolean;
begin
  Result := FEngine.GarbageCollection;
end;

function TDMonkey.GetLibraryPath: TStrings;
begin
  Result := FParser.LibPath;
end;

function TDMonkey.GetObjectCount: Integer;
begin
  Result := FEngine.ObjectCount;
end;

procedure TDMonkey.ImportObject(ObjectName: String;
  ObjectClass: TJObjectClass);
//g݃IuWFNgC|[g
begin
  FEngine.ImportObject(ObjectName,ObjectClass);
end;

function TDMonkey.IsRunning: Boolean;
begin
  Result := FEngine.IsRunning;
end;

procedure TDMonkey.ParserOnDebug(Sender: TObject; S: String);
//fobO
begin
  if Assigned(FOnDebugout) then
    FOnDebugout(Self,S);
end;

function TDMonkey.Run(Args: array of const): Integer;
//scripts
var
  i: Integer;
  param: TJValueList;
begin
  param := TJValueList.Create;
  try
    for i := 0 to High(Args) do
      param.Add(VarRecToValue(Args[i]));

    Result := Run(param);
  finally
    param.Free;
  end;
end;

function TDMonkey.Run(Args: TJValueList): Integer;
//s
var
  i: Integer;
  tmp: Cardinal;
begin
  //s
  tmp := GetTickCount;

  Result := 0;
  FEngine.GlobalObject.Arguments.Clear;
  if Assigned(FParser.Root) then
  begin
    if Assigned(Args) then
    begin
      for i := 0 to Args.Count - 1 do
        FEngine.GlobalObject.Arguments.Add(Args[i]);
    end;

    Result := FEngine.Run(FParser.Root);
  end;

  FTookTimeToRun := GetTickCount - tmp;
end;

function TDMonkey.Run: Integer;
//s
begin
  Result := Run([]);
end;

procedure TDMonkey.SetGarbageCollection(const Value: Boolean);
begin
  FEngine.GarbageCollection := Value;
end;

procedure TDMonkey.SetLibraryPath(const Value: TStrings);
begin
  FParser.LibPath.Assign(Value);
end;

procedure TDMonkey.SetOnDone(const Value: TNotifyEvent);
begin
  FOnDone := Value;
  if Assigned(Value) then
    FEngine.OnDone := EngineOnDone
  else
    FEngine.OnDone := nil;
end;

procedure TDMonkey.SetOnNewObject(const Value: TNewObjectEvent);
begin
  FOnNewObject := Value;
  if Assigned(Value) then
    FEngine.OnNewObject := EngineOnNewObject
  else
    FEngine.OnNewObject := nil;
end;

procedure TDMonkey.SetOnRun(const Value: TNotifyEvent);
begin
  FOnRun := Value;
  if Assigned(Value) then
    FEngine.OnRun := EngineOnRun
  else
    FEngine.OnRun := nil;
end;

procedure TDMonkey.SetOnStderr(const Value: TStringEvent);
begin
  FOnStderr := Value;
  if Assigned(Value) then
    FEngine.OnStdErr := EngineOnStdErr
  else
    FEngine.OnStdErr := nil;
end;

procedure TDMonkey.SetOnStep(const Value: TStepEvent);
begin
  FOnStep := Value;
  if Assigned(Value) then
    FEngine.OnStep := EngineOnStep
  else
    FEngine.OnStep := nil;
end;

procedure TDMonkey.SetOnStdout(const Value: TStringEvent);
begin
  FOnStdout := Value;
  if Assigned(Value) then
    FEngine.OnStdOut := EngineOnStdOut
  else
    FEngine.OnStdOut := nil;
end;

function TDMonkey.GetFactory: TJObjectFactory;
begin
  Result := FEngine.GlobalFactory;
end;

class function TDMonkey.ScriptBuild: Integer;
begin
  Result := DMS_BUILD;
end;

class function TDMonkey.ScriptEngine: String;
begin
  Result := DMS_ENGINE;
end;

class function TDMonkey.ScriptVersion: String;
begin
  Result := DMS_VERSION;
end;

procedure TDMonkey.EngineOnStdin(Sender: TObject; var S: String; var Success: Boolean);
//W
begin
  if Assigned(FOnStdin) then
    FOnStdin(Self,S,Success);
end;

procedure TDMonkey.SetOnStdin(const Value: TReadStringEvent);
begin
  FOnStdin := Value;
  if Assigned(Value) then
    FEngine.OnStdin := EngineOnStdin
  else
    FEngine.OnStdin := nil; 
end;

end.
