(*
DMonkey Script Host

  ver0.01a
  2002/12/04
  ETJParser.NumberύXB
	ETJLex const _INVALID_VALUE ǉB
	ETJLex.LexNumber()CB
	Eecma_expr.pas CalcValue2CB

  ver0.01
  2002/11/23
  	Einfinity֘A̎dlύXB
  		ecma_expr.pas CalcValue2, CompareValue
  		ecma_object.pas TJNumberObject.RegistProps
  		ecma_type.pas AsString, BuildInfinyty
  2002/11/22
  	Eecma_expr.CalcValue2CB
  2002/11/19
  	Eecma_guiobject(TJCheckListBox)QƂȂ悤ɂB
  	ETDMonkey.ShowDMonkeyException()ύXB
  	Eecma_misc.MsgBox()ύXB
  2002/11/15
  	EWo͂t@Cɓf悤ɂB
  	ETJGlobalObject.DoMsgBox()ύXB
  	ETJGlobalObject.DoTextArea()ύXB
  	ETJGlobalObject.DoPrompt()ύXB
  	ETJGlobalObject.DoConfirm()ύXB
  	ETJGlobalObject.DoAlert()ύXBE
  	ETDMonkey.ShowDMonkeyException()ύXB
  	ETJLex.LexNumber()(tĐnI)CB
  	E0.1.7ō蒼B
*)
unit dmsh;

interface

uses
	Windows, Classes, SysUtils, Forms, DMonkey, ecma_type, dm_terapad;

type
	TDMSH = class(TObject)
	private
		FDM: TDMonkey;
		FStdout: TStringList;
		procedure DMStdout(Sender: TObject; S: string);
		procedure DMStderr(Sender: TObject; S: string);
	public
		constructor Create;
		destructor Destroy; override;
		procedure Run;
	end;


implementation

{ TDMSH }

constructor TDMSH.Create;
begin
	inherited Create;
	FDM := TDMonkey.Create(nil);
	FDM.OnStdout := DMStdout;
	FDM.OnStderr := DMStderr;
	FStdout := TStringList.Create;
end;

destructor TDMSH.Destroy;
begin
	FStdout.Free;
	FDM.Free;
	inherited;
end;

procedure TDMSH.DMStdout(Sender: TObject; S: string);
begin
	FStdout.Add(S);
end;

procedure TDMSH.DMStderr(Sender: TObject; S: string);
begin
	ShowDMonkeyException(Sender as TDMonkey);
end;

procedure TDMSH.Run;
var
	prm: TJValueList;
	src: string;
	i: Integer;
begin
	prm := TJValueList.Create;
	src := ParamStr(1);
  //src := 'test.dms';
	try
		for i := 1 to ParamCount do
			prm.Add(BuildString(ParamStr(i)));

		if FDM.CompileFile(src) then
			FDM.Run(prm);
	finally
		prm.Free;
	end;

	if (FStdout.Count > 0) and FileExists(src) then
		try
			FStdout.SaveToFile(ChangeFileExt(src, '.log'));
		except
			MessageBox(0, 'Ot@C쐬ł܂',
					PChar(Application.Title), MB_OK or MB_ICONHAND);
		end;
end;

end.
