unit ecma_classes;

//NXȂ
//2001/04/10
//by Wolfy

interface

uses
  windows,classes,sysutils,ecma_type,ecma_expr,ecma_object,ecma_sockobject,
  contnrs,hashtable;

type

  //symbol table
  TJSymbolTable = class(TObject)
  private
    FGlobal: TJHash;
    FLocals: TJHashStack;
    FThis: TStack;
    FGlobalObject: TJGlobalObject;
    FOnClear: TNotifyEvent;
    FName: String;

    function GetValue(S: String): TJValue;
    procedure SetValue(S: String; const Value: TJValue);
    function GetThis: TJObject;
  public
    constructor Create(AGlobalObject: TJGlobalObject);
    destructor Destroy; override;
    procedure Push;
    procedure Pop;
    procedure PushThis(Obj: TJObject);
    procedure PopThis;
    procedure Clear;
    function HasValue(S: String): Boolean;
    procedure DecLocalObjectRefCount;
    procedure DecGlobalObjectRefCount;

    property Value[S: String]: TJValue read GetValue write SetValue; default;
    property This: TJObject read GetThis;
    property Global: TJHash read FGlobal;
    property Name: String read FName write FName;

    property OnClear: TNotifyEvent read FOnClear write FOnClear;
  end;

{$IFDEF SYMBOLTABLES_HASH}

  TJSymbolTables = class(TObjectHashTable)
  private
    FCurrent: String;

    function GetValueObject(Key: String): TJSymbolTable;
    procedure SetValueObject(Key: String; const NewTable: TJSymbolTable);
    function GetTable: TJSymbolTable;
  public
    constructor Create;
    procedure Clear;

    property Current: String read FCurrent write FCurrent;
    property Value[Key: String]: TJSymbolTable read GetValueObject write SetValueObject; default;
    property Table: TJSymbolTable read GetTable;
  end;

{$ELSE}
  TJSymbolTablesList = class;
  TJSymbolTables = TJSymbolTablesList;
{$ENDIF}

  TJSymbolTablesList = class(TObject)
  private
    FCurrent: String;
    FCurrentTable: TJSymbolTable;
    FItems: TStringList;

    function GetItems(Key: String): TJSymbolTable;
    procedure SetItems(Key: String; const Value: TJSymbolTable);
    procedure Clearnup;
    function GetCurrentTable: TJSymbolTable;
    procedure SetCurrent(const Value: String);
    function GetGlobal: TJHash;
    function GetThis: TJObject;
    function GetValues(S: String): TJValue;
    procedure SetValues(S: String; const Value: TJValue);
  public
    constructor Create;
    destructor Destroy; override;
    procedure Clear;
    procedure Delete(Index: Integer);
    function HasTable(Key: String): Boolean;
    property Current: String read FCurrent write SetCurrent;
    property CurrentTable: TJSymbolTable read GetCurrentTable;
    //property Table: TJSymbolTable read GetCurrentTable;
    property Items[Key: String]: TJSymbolTable read GetItems write SetItems;
  public
    //symbol tablẽbp[
    procedure Push;
    procedure Pop;
    procedure PushThis(Obj: TJObject);
    procedure PopThis;
    procedure DecLocalObjectRefCount;
    procedure DecGlobalObjectRefCount;
    function HasValue(S: String): Boolean;
    property Values[S: String]: TJValue read GetValues write SetValues; default;
    property This: TJObject read GetThis;
    property Global: TJHash read GetGlobal;    
  end;


const
  __GLOBAL = '__Global__';


implementation

{ TJSymbolTable }

procedure TJSymbolTable.Clear;
//NA
begin
  while FLocals.Count > 0 do
    FLocals.Pop;

  while FThis.Count > 0 do
    FThis.Pop;

  FGlobal.Clear;
  FThis.Push(FGlobalObject);
  //event
  if Assigned(FOnClear) then
    FOnClear(Self);
end;

constructor TJSymbolTable.Create(AGlobalObject: TJGlobalObject);
//쐬
begin
  inherited Create;
  FLocals := TJHashStack.Create;
  FThis := TStack.Create;
  FGlobal := TJHash.Create(HASH_100);
  FGlobalObject := AGlobalObject;
  Clear;
end;

procedure TJSymbolTable.DecGlobalObjectRefCount;
//O[oIuWFNg̎QƃJEg炷
var
  sl: TStringList;
  v: TJValue;
  i: Integer;
begin
{$IFDEF USE_GC}
  sl := FGlobal.KeyList;
  for i := 0 to sl.Count - 1 do
  begin
    v := FGlobal[sl[i]];
    DecRefObject(v);
  end;
{$ENDIF}
end;

procedure TJSymbolTable.DecLocalObjectRefCount;
//[J̃IuWFNg̎QƃJEg炷
var
  h: TJHash;
  sl: TStringList;
  v: TJValue;
  i: Integer;
begin
{$IFDEF USE_GC}
  h := FLocals.Hash;
  sl := h.KeyList;
  for i := 0 to sl.Count - 1 do
  begin
    v := h[sl[i]];
    DecRefObject(v);
  end;
{$ENDIF}
end;

destructor TJSymbolTable.Destroy;
//j
begin
  FreeAndNil(FGlobal);
  FreeAndNil(FThis);
  FreeAndNil(FLocals);

  inherited;
end;

function TJSymbolTable.GetThis: TJObject;
//擪̃IuWFNgԂ
begin
  if FThis.Count > 0 then
    Result := FThis.Peek
  else
    Result := FGlobalObject;
end;

function TJSymbolTable.GetValue(S: String): TJValue;
//l𓾂
var
  h: TJHash;
  o: TJObject;
begin
  //local
  if FLocals.Count > 0 then
  begin
    h := FLocals.Hash;
    //I
    if h.HasKey(S) then
    begin
      Result := h[S];
      Exit;
    end;
  end;

  //object
  if FThis.Count > 0 then
  begin
    o := This;
    if Assigned(o) and o.HasKey(S) then
    begin
      Result := o.GetValue(S,False);
      Exit;
    end;
  end;

  //global
  Result := FGlobal[S];
end;

function TJSymbolTable.HasValue(S: String): Boolean;
//symbol邩ׂ
var
  h: TJHash;
  o: TJObject;
begin
  //local
  if FLocals.Count > 0 then
  begin
    h := FLocals.Hash;
    //I
    if h.HasKey(S) then
    begin
      Result := True;
      Exit;
    end;
  end;

  //object
  if FThis.Count > 0 then
  begin
    o := This;
    if Assigned(o) and o.HasKey(S) then
    begin
      Result := True;
      Exit;
    end;
  end;

  //global
  Result := FGlobal.HasKey(S);
end;

procedure TJSymbolTable.Pop;
//ŏ̃e[u폜
begin
  FLocals.Pop;
end;

procedure TJSymbolTable.PopThis;
//擪object폜
begin
  FThis.Pop;
end;

procedure TJSymbolTable.Push;
//VKe[u쐬
begin
  FLocals.Push;
end;

procedure TJSymbolTable.PushThis(Obj: TJObject);
//object擪ɓ
begin
  FThis.Push(Obj);
end;

procedure TJSymbolTable.SetValue(S: String; const Value: TJValue);
//ŏ̃e[uɃZbg
var
  h: TJHash;
  v: TJValue;
begin
  if FLocals.Count <= 0 then
    h := FGlobal
  else
    h := FLocals.Hash;

  v := h[S];
  h[S] := Value;   
end;


{$IFDEF SYMBOLTABLES_HASH}

{ TJSymbolTables }

procedure TJSymbolTables.Clear;
//NA
var
  sl: TStringList;
  i: Integer;
begin
  sl := TStringList.Create;
  try
    sl.Text := Keys;
    for i := 0 to sl.Count - 1 do
      Value[sl[i]].Clear;
  finally
    sl.Free;
  end;
end;

constructor TJSymbolTables.Create;
begin
  inherited Create(100);
  FCurrent := __GLOBAL;
end;

function TJSymbolTables.GetTable: TJSymbolTable;
begin
  if HasKey(FCurrent) then
    Result := Value[FCurrent]
  else
    raise EJThrow.Create(E_NAME,FCurrent);
end;

function TJSymbolTables.GetValueObject(Key: String): TJSymbolTable;
begin
  Result := inherited GetValueObject(Key) as TJSymbolTable;
end;

procedure TJSymbolTables.SetValueObject(Key: String;
  const NewTable: TJSymbolTable);
begin
  NewTable.Name := Key;
  inherited SetValueObject(Key,NewTable);
end;

{$ENDIF}

{ TJSymbolTablesList }

procedure TJSymbolTablesList.Clear;
var
  i: Integer;
  st: TJSymbolTable;
begin
  for i := FItems.Count - 1 downto 0 do
  begin
    st := FItems.Objects[i] as TJSymbolTable;
    st.Clear;
  end;
end;

procedure TJSymbolTablesList.Clearnup;
var
  i: Integer;
begin
  for i := FItems.Count - 1 downto 0 do
    Delete(i);
end;

constructor TJSymbolTablesList.Create;
begin
  inherited Create;
  FItems := TStringList.Create;
  FItems.Sorted := True;
  FItems.Duplicates := dupIgnore;
  FCurrent := __GLOBAL;
end;

procedure TJSymbolTablesList.DecGlobalObjectRefCount;
begin
  CurrentTable.DecGlobalObjectRefCount;
end;

procedure TJSymbolTablesList.DecLocalObjectRefCount;
begin
  CurrentTable.DecLocalObjectRefCount;
end;

procedure TJSymbolTablesList.Delete(Index: Integer);
var
  st: TJSymbolTable;
begin
  st := FItems.Objects[Index] as TJSymbolTable;
  st.Free;
  FItems.Delete(Index);
end;

destructor TJSymbolTablesList.Destroy;
begin
  Clearnup;
  FreeAndNil(FItems);
  inherited;
end;

function TJSymbolTablesList.GetCurrentTable: TJSymbolTable;
//Jg𓾂
begin
  if not Assigned(FCurrentTable) then
    FCurrentTable := GetItems(FCurrent);

  Result := FCurrentTable
end;

function TJSymbolTablesList.GetGlobal: TJHash;
begin
  Result := CurrentTable.Global;
end;

function TJSymbolTablesList.GetItems(Key: String): TJSymbolTable;
var
  index: Integer;
begin
  if FItems.Find(Key,index) then
    Result := FItems.Objects[index] as TJSymbolTable
  else
    raise EJThrow.Create(E_NAME,Key);
end;

function TJSymbolTablesList.GetThis: TJObject;
begin
  Result := CurrentTable.This;
end;

function TJSymbolTablesList.GetValues(S: String): TJValue;
var
  i: Integer;
  st: TJSymbolTable;
begin
  EmptyValue(Result);
  //܂Jg𒲂ׂ
  if CurrentTable.HasValue(S) then
    Result := CurrentTable.GetValue(S)
  else begin
    //ȂΑSĂT
    for i := 0 to FItems.Count - 1 do
    begin
      st := FItems.Objects[i] as TJSymbolTable;
      if st.Name <> FCurrent then
      begin
        if st.HasValue(S) then
        begin
          Result := st.GetValue(S);
          Break;
        end;
      end;
    end;
  end;

end;

function TJSymbolTablesList.HasTable(Key: String): Boolean;
begin
  Result := (FItems.IndexOf(Key) > -1);
end;

function TJSymbolTablesList.HasValue(S: String): Boolean;
var
  i: Integer;
  st: TJSymbolTable;
begin
  //܂Jg𒲂ׂ
  Result := CurrentTable.HasValue(S);
  //ȂΑSĂT
  if not Result then
  begin
    for i := 0 to FItems.Count - 1 do
    begin
      st := FItems.Objects[i] as TJSymbolTable;
      if st.Name <> FCurrent then
      begin
        Result := st.HasValue(S);
        //ΏI
        if Result then
          Break;
      end;
    end;
  end;
  
end;

procedure TJSymbolTablesList.Pop;
begin
  CurrentTable.Pop;
end;

procedure TJSymbolTablesList.PopThis;
begin
  CurrentTable.PopThis;
end;

procedure TJSymbolTablesList.Push;
begin
  CurrentTable.Push;
end;

procedure TJSymbolTablesList.PushThis(Obj: TJObject);
begin
  CurrentTable.PushThis(Obj);
end;

procedure TJSymbolTablesList.SetCurrent(const Value: String);
//Jg؂ւ
begin
  FCurrent := Value;
  if HasTable(Value) then
    FCurrentTable := GetItems(Value)
  else
    FCurrentTable := nil;
end;

procedure TJSymbolTablesList.SetItems(Key: String;
  const Value: TJSymbolTable);
var
  index: Integer;
begin
  Value.Name := Key;
  if FItems.Find(Key,index) then
    //݂Ώ
    Delete(index);

  //
  FItems.AddObject(Key,Value);
end;

procedure TJSymbolTablesList.SetValues(S: String; const Value: TJValue);
begin
  //JgɃZbg
  CurrentTable.SetValue(S,Value);
end;

end.
