unit ecma_engine;

//͖؂̎s
//2001/04/10 ~
//by Wolfy

interface

uses
  windows,classes,sysutils,ecma_type,ecma_expr,ecma_classes,hashtable,ecma_object,
  activex,ComObj,ecma_sockobject,ecma_activex,forms,dynamiccall;

type
  TJEngine = class(TObject)
  private
    FTables: TJSymbolTables;
    FFactory: TJObjectFactory;
    FGlobalFactory: TJObjectFactory;
    
    FIsRan: Boolean;
    FAbort: Boolean;
    FIsRunning: Boolean;
    FFuncFactory: TJFunctionFactory;
    FGarbageCollection: Boolean;
    //event
    FOnNewObject: TNewObjectEvent;
    FOnStdout: TStringEvent;
    FOnStderr: TStringEvent;
    FOnRun: TNotifyEvent;
    FOnDone: TNotifyEvent;
    FOnStep: TStepEvent;
    
    //global object
    FGlobalObject: TJGlobalObject;
    FStringObject: TJStringObject;
    FNumberObject: TJNumberObject;
    FRegExpObject: TJRegExpObject;
    FMathObject: TJMathObject;
    FDateObject: TJDateObject;        

    procedure Println(S: String);
    procedure PrintlnError(S: String);
    procedure EvalStatement(P: PJStatement; Iteration: Boolean);
    function EvalExpr(P: PJExpr): TJValue;
    function MemberExpr(P: PJExpr): TJValue;
    procedure MemberAssign(P: PJExpr; Value: TJValue);
    function ArrayExpr(P: PJExpr): TJValue;
    procedure ArrayAssign(P: PJExpr; Value: TJValue);

    procedure ParamExpr(List: TJValueList; Arg: PJExpr);
    procedure ObjectExpr(Obj: TJObject; Elements: PJExpr);

    procedure MakeInstance(Obj: TJObject; Members: PJStatement);
    function MakeObject(Name: String; Param: TJValueList): TJObject;
    function NewSymbolTable: TJSymbolTable;
    procedure RegistGlobalObjects(ASymbolTable: TJSymbolTable);

    //object event
    procedure RegExpOnMatchStart(Sender: TObject);
    procedure RegExpOnMatch(Sender: TObject; Index: Integer; var Value: TJValue);
    procedure RegExpOnMatchEnd(Sender: TObject);
    procedure FactoryOnNewObject(Sender: TObject; JObject: TJObject);
    procedure GlobalObjectOnPrint(Sender: TObject; S: String);
    procedure GlobalObjectOnPrintError(Sender: TObject; S: String);
    procedure SymbolTableOnClear(Sender: TObject);
    function GetObjectCount: Integer;
  public
    constructor Create;
    destructor Destroy; override;
    function Run(Root: PJStatement): Integer;
    function CallExpr(Func: TJFunction; Param: TJValueList): TJValue;
    function CallFunction(Root: PJStatement; Symbol: String;
      Param: TJValueList; var RetValue: TJValue): Boolean;
    procedure Clear;
    procedure GarbaseCollect;
    procedure Abort;
    procedure ImportObject(ObjectName: String; ObjectClass: TJObjectClass);
    procedure AllClear;
    function IsRunning: Boolean;
    function WaitRunning: Boolean;

    property GlobalObject: TJGlobalObject read FGlobalObject;
    property ObjectCount: Integer read GetObjectCount;
    property GarbageCollection: Boolean read FGarbageCollection write FGarbageCollection;
    property GlobalFactory: TJObjectFactory read FGlobalFactory;
    //event
    property OnNewObject: TNewObjectEvent read FOnNewObject write FOnNewObject;
    property OnStdout: TStringEvent read FOnStdout write FOnStdout;
    property OnStderr: TStringEvent read FOnStderr write FOnStderr;
    property OnRun: TNotifyEvent read FOnRun write FOnRun;
    property OnDone: TNotifyEvent read FOnDone write FOnDone;
    property OnStep: TStepEvent read FOnStep write FOnStep;
  end;
                                 
implementation


{ TJEngine }

procedure TJEngine.Println(S: String);
//stdout
begin
  GlobalObjectOnPrint(Self,S + CRLF);
end;

constructor TJEngine.Create;
//쐬
begin
  inherited Create;
  FFuncFactory := TJFunctionFactory.Create;
  FFactory := TJObjectFactory.Create(Self);
  FFactory.OnNewObject := FactoryOnNewObject;
  FGlobalFactory := TJObjectFactory.Create(Self);
  //FGlobalFactory.OnNewObject := FactoryOnNewObject;

  //g݃IuWFNgo^
  ImportObject('Global',TJGlobalObject);
  ImportObject('Array',TJArrayObject);
  ImportObject('String',TJStringObject);
  ImportObject('Number',TJNumberObject);
  ImportObject('Boolean',TJBooleanObject);
  ImportObject('RegExp',TJRegExpObject);
  ImportObject('Math',TJMathObject);
  ImportObject('Date',TJDateObject);  

  //ftHgIuWFNg
  FGlobalObject := TJGlobalObject.Create(FGlobalFactory,nil);
  FGlobalObject.OnPrint := GlobalObjectOnPrint;
  FStringObject := TJStringObject.Create(FGlobalFactory,nil);
  FNumberObject := TJNumberObject.Create(FGlobalFactory,nil);
  FRegExpObject := TJRegExpObject.Create(FGlobalFactory,nil);
  FMathObject := TJMathObject.Create(FGlobalFactory,nil);
  FDateObject := TJDateObject.Create(FGlobalFactory,nil);

  FTables := TJSymbolTables.Create;
  //Ce[u
  FTables.Current := __GLOBAL;
  FTables.Items[__GLOBAL] := NewSymbolTable;
end;

destructor TJEngine.Destroy;
//j
begin
  FreeAndNil(FTables);
  FreeAndNil(FFuncFactory);
  FreeAndNil(FFactory);
  FreeAndNil(FGlobalFactory);
  inherited;
end;

function TJEngine.Run(Root: PJStatement): Integer;
//s
var
  func: TJFunction;
begin
  Result := 0;
  //s̏ꍇI
  if IsRunning then
    Exit;
  //s
  FIsRunning := True;
  if Assigned(FOnRun) then
    FOnRun(Self);

  try
    FAbort := False;
    Clear;
    try
      //O[ol[Xy[X
      func.FuncType := ftImport;
      func.Table := FTables.Items[__GLOBAL];
      FTables[__GLOBAL] := FFuncFactory.BuildFunction(func);

      EvalStatement(Root,False);
      FIsRan := True;
    except
      on E:EJThrow do
        PrintlnError('Exception: ' + E.ExceptName + ' => ' + E.ErrorMsg);
      on E:EJReturn do
        Result := AsInteger(@E.Value);
      on E:EJAbort do
        PrintlnError('Abort Script');
      on E:EJExit do
        Result := E.Status;
    end;

  { TODO : O[oIuWFNg͎EȂ }
    //FTables.DecGlobalObjectRefCount;

    if Assigned(FOnDone) then
      FOnDone(Self);
  finally
    FIsRunning := False;
  end;  
end;

procedure TJEngine.EvalStatement(P: PJStatement; Iteration: Boolean);
//ԂɎs
var
  current: PJStatement;
  v,v1,exceptvalue,returnvalue: TJValue;
  exception,ereturn,ebreak,econtinue,abrt: Boolean;
  exceptname,errormsg,currenttablename: String;
  sl: TStringList;
  i: Integer;
  func: TJFunction;
begin
  exception := False;
  ereturn := False;
  econtinue := False;
  ebreak := False;

  current := P;
  while Assigned(current) do
  begin
    //abort
    if FAbort then
      raise EJAbort.Create('script abort');
    //Cxg
    if Assigned(FOnStep) then
    begin
      abrt := False;
      FOnStep(Self,abrt);
      //~
      if abrt then
        raise EJAbort.Create('script abort');
    end;

    //ϐ錾Jn
    if current^.SType = stVar then
    begin
      EvalStatement(current^.Sub1,Iteration);
    end
    else if current^.SType = stVarDecl then
    begin  //ϐ錾o^
      if Assigned(current^.Expr^.Left) then
        v := EvalExpr(current^.Expr^.Left)
      else
        EmptyValue(v);

      FTables[current^.Expr^.Symbol] := v;
    end
    //C|[g
    else if current^.SType = stImport then
    begin
      //__Global__e[uɒlƂēo^
      func.FuncType := ftImport;
      func.Table := NewSymbolTable;
      FTables[current^.Expr^.Symbol] := FFuncFactory.BuildFunction(func);
      //Ve[uo^
      FTables.Items[current^.Expr^.Symbol] := func.Table as TJSymbolTable;
      currenttablename := FTables.Current;
      FTables.Current := current^.Expr^.Symbol;
      try
        //s
        EvalStatement(current^.Sub1,False);
      finally
        //Ƃɖ߂
        FTables.Current := currenttablename;
      end;
    end
    //֐`
    else if current^.SType = stFunctionDecl then
    begin
      //֐Zbg
      func.FuncType := ftStatement;
      func.Statement := current;
      //p[^Zbg
      func.Parameter := current^.Sub1;
      //e[uɓo^
      FTables[current^.Expr^.Symbol] := FFuncFactory.BuildFunction(func);
    end
    //NX`
    else if current^.SType = stClassDecl then
    begin
      func.FuncType := ftClass;
      func.Statement := current;
      FTables[current^.Expr^.Symbol] := FFuncFactory.BuildFunction(func);
    end
    else if current^.SType = stFinally then
    begin
      //OɊ֌WȂs
      EvalStatement(current^.Sub1,Iteration);
      //return̏ꍇ͗ON
      if ereturn then
      begin
        //ereturn := False;
        raise EJReturn.Create(returnvalue);
      end
      else if ebreak then
      begin
        //ebreak := False;
        //if Iteration then
          raise EJBreak.Create('break');
      end
      else if econtinue then
      begin
        //econtinue := False;
        //if Iteration then
          raise EJContinue.Create('continue');
      end; 
    end
    else if exception then
    begin
      //OLb`
      if current^.SType = stCatch then
      begin
        exception := False;
        //ϐo^
        if IsVariable(current^.Expr) then
        begin
          //userO
          if exceptname = E_THROW then
            FTables[current^.Expr^.Symbol] := exceptvalue
          else //Oo^
            FTables[current^.Expr^.Symbol] := BuildString(exceptname);
        end;
        //s
        EvalStatement(current^.Sub1,Iteration);
      end;
    end
    else begin //OȂ
      case current^.SType of
        stNone:;

        stExpr: EvalExpr(current^.Expr);
        //print
        //stPrint: Println(EvalExpr(current^.Expr));
        //while 
        stWhile:
        begin
          while True do
          begin
            v := EvalExpr(current^.Expr);
            if not AsBool(@v) then
              Break;

            try
              //s
              EvalStatement(current^.Sub1,True);
            except
              //OƂĎ
              on EJBreak do
                Break;
              on EJContinue do
                Continue;
            end;
          end;
        end;
        stDo: //do - while
        begin
          while True do
          begin
            try
              //s
              EvalStatement(current^.Sub1,True);
            except
              //OƂĎ
              on EJBreak do
                Break;
              on EJContinue do
                Continue;
            end;

            //𔻒f
            v := EvalExpr(current^.Expr);
            if not AsBool(@v) then
              Break;
          end;
        end;
        //for
        stFor:
        begin
          //
          EvalExpr(current^.Expr);
          while True do
          begin
            //݂ꍇ̂
            if Assigned(current^.Sub2^.Expr) then
            begin
              v := EvalExpr(current^.Sub2^.Expr);
              if not AsBool(@v) then
                Break;
            end;

            try try
              //ubNs
              EvalStatement(current^.Sub1,True);
            finally
              //n
              EvalExpr(current^.Sub2^.Next^.Expr);
            end;

            except
              //OƂĎ
              on EJBreak do
                Break;
              on EJContinue do
                Continue;
            end;             
          end;
        end;
        //for in
        stForIn:
        begin
          sl := TStringList.Create;
          try
            //SĂkey𓾂
            v := EvalExpr(current^.Sub2^.Expr);
            if v.ValueType <> vtObject then
              //O
              raise EJThrow.Create(E_TYPE,'');

            sl.Text := v.vObject.PropertyList;
            //keyϐɓ
            for i := 0 to sl.Count - 1 do
            begin
              //if v.vObject is TJArrayObject then
                //zANZX
                //v1 := v.vObject.GetValue(sl[i],True);
              //else
              //  v1 := v.vObject.GetValue(sl[i],False);

              //value`FbN
              //if v1.ValueType = vtFunction then
              //  Continue;

              v1 := BuildString(sl[i]);

              if current^.Expr^.Code = opVariable then
                FTables[current^.Expr^.Symbol] := v1
              else
                //O
                raise EJThrow.Create(E_TYPE,'');
              try
                //ubNs
                EvalStatement(current^.Sub1,True);
              except
                //OƂĎ
                on EJBreak do
                  Break;
                on EJContinue do
                  Continue;
              end;
            end;
          finally
            sl.Free;
          end;
        end;
        //if
        stIf:
        begin
          v := EvalExpr(current^.Expr);
          if AsBool(@v) then
            EvalStatement(current^.Sub1,Iteration)
          else begin
            EvalStatement(current^.Sub2,Iteration);
          end;
        end;
        //blocks
        stBlock:
        begin
          EvalStatement(current^.Sub1,Iteration);
        end;
        //break
        stBreak:
        begin
          if Iteration then
            raise EJBreak.Create('break')
          else
            raise EJThrow.Create(E_SYNTAX,'break');
        end;
        //continue
        stContinue:
        begin
          if Iteration then
            raise EJContinue.Create('continue')
          else
            raise EJThrow.Create(E_SYNTAX,'continue');
        end;
        //return
        stReturn:
        begin
          //returnO
          raise EJReturn.Create(EvalExpr(current^.Expr));
        end;
        //throw
        stThrow:
        begin
          v := EvalExpr(current^.Expr);
          //throwO
          raise EJThrow.Create(E_THROW,'',@v);
        end;
        //try
        stTry:
        begin
          try
            EvalStatement(current^.Sub1,Iteration);
          except
            on E:EJThrow do
            begin
              exceptname := E.ExceptName;
              exception := True;
              exceptvalue := E.Value;
              errormsg := E.ErrorMsg;
            end;
            //return߂炦
            on E:EJReturn do
            begin
              ereturn := True;
              returnvalue := E.Value;
            end;

            on EJBreak do
              ebreak := True;

            on EJContinue do
              econtinue := True;
              
          end;
        end;
        //with
        stWith:
        begin
          v := EvalExpr(current^.Expr);
          //objectȂ
          if v.ValueType = vtObject then
            FTables.PushThis(v.vObject)
          else //O
            raise EJThrow.Create(E_TYPE,'');
            
          try
            EvalStatement(current^.Sub1,Iteration);
          finally
            FTables.PopThis;
          end;

        end;

      end;
    end;
    //
    current := current^.Next;
  end;
  //OłȂȂ
  if exception then
    raise EJThrow.Create(exceptname,errormsg,@exceptvalue);
end;


function TJEngine.EvalExpr(P: PJExpr): TJValue;
//]
var
  l,r,t: PJExpr;
  v,con: TJValue;
  param: TJValueList;
  currenttablename,objname: String;
begin
  EmptyValue(Result);
  if not Assigned(P) then
    Exit;

  l := P^.Left;
  r := P^.Right;
  t := P^.Third;

  case P^.Code of
    opExpr:
    begin
      EvalExpr(l);
      Result := EvalExpr(r);
    end;

    //P
    //萔ĉ܂ܕԂ
    opConstant:
    begin
      Result := P^.Value^;
    end;
    //ϐce[u猟
    opVariable:         
    begin
      if FTables.HasValue(P^.Symbol) then
        Result := FTables[P^.Symbol]
      else //ϐ`Ȃ̂ŗO
        raise EJThrow.Create(E_NAME,P^.Symbol);
    end;
    //݂̃JgobjectԂ
    opThis:
    begin
      Result.ValueType := vtObject;
      Result.vObject := FTables.This;
    end;
    opSuper:
    begin
      raise EJThrow.Create(E_SYNTAX,'super');
      //Result := MemberExpr(P,FTables.This);
      //Result.ValueType := vtObject;
      //Result.vObject := FTable.This;
    end;
    //object쐬
    opNew:
    begin
      objname := l^.Symbol;
      param := TJValueList.Create;
      try
        ParamExpr(param,r);
        if not Assigned(t) then
          Result := BuildObject(MakeObject(objname,param))
        else begin
          currenttablename := FTables.Current;
          FTables.Current := t^.Symbol;
          try
            Result := BuildObject(MakeObject(objname,param));
          finally
            FTables.Current := currenttablename;
          end;
        end;
        //RXgN^ 񂾂Ă
        if Result.vObject.Members.HasKey(objname) then
        begin
          con := Result.vObject.Members.Value[objname];
          if IsFunction(@con) and (con.vFunction.FuncType = ftStatement) then
          begin
            con.vFunction.This := Result.vObject;
{ TODO : QƃJEg𑝂₷@RXgN^O }
            IncRefObject(Result);
            try
              CallExpr(con.vFunction^,param);
            finally
              DecRefObject(Result);
            end;
          end;
        end;
      finally
        param.Free;
      end;
    end;
    //Object쐬
    opNewObject:
    begin
      Result := BuildObject(TJObject.Create(FFactory,nil));
      ObjectExpr(Result.vObject,l);
    end;
    //z쐬
    opNewArray:
    begin
      param := TJValueList.Create;
      try
         //lZbg
         ParamExpr(param,l);
         Result.ValueType := vtObject;
         Result.vObject := TJArrayObject.Create(FFactory,param);
       finally
         param.Free;
       end;
    end;
    //֐Ăяo
    opCall:    //L(vtFunction) R
    begin
      v := EvalExpr(l);
      if IsFunction(@v) then
      begin
        param := TJValueList.Create;
        try try
          //p[^Zbg
          ParamExpr(param,r);
          Result := CallExpr(v.vFunction^,param)
        except
          on EJReturn do
        end;
        finally
          param.Free;
        end;
      end
      else
        raise EJThrow.Create(E_CALL,'call error');
    end;

    //oĂяo L=object R=variable
    opMember: Result := MemberExpr(P);

    opArray: Result := ArrayExpr(P);

    opMinus,opPlus,opBitNot:
    begin
      Result := CalcValue1(P^.Code,EvalExpr(l));
    end;
    opPreInc:
    begin
      Result := EvalExpr(l);
      Result := BuildInteger(AsInteger(@Result) + 1);
      if l^.Code = opVariable then
        FTables[l^.Symbol] := Result;
    end;
    opPreDec:
    begin
      Result := EvalExpr(l);
      Result := BuildInteger(AsInteger(@Result) - 1);
      if l^.Code = opVariable then
        FTables[l^.Symbol] := Result;
    end;
    opPostInc:
    begin
      Result := EvalExpr(l);
      if l^.Code = opVariable then
        FTables[l^.Symbol] := BuildInteger(AsInteger(@Result) + 1);
    end;
    opPostDec:
    begin
      Result := EvalExpr(l);
      if l^.Code = opVariable then
        FTables[l^.Symbol] := BuildInteger(AsInteger(@Result) - 1);
    end;
    opDelete:
    begin
      //Object̎QƃJEg炷
      v := EvalExpr(l);
      DecRefObject(v);
      //`
      if l^.Code = opVariable then
        FTables[l^.Symbol] := BuildUndefined;
    end;
    opVoid:
    begin
      Result := Evalexpr(l);
      Result := BuildNull;
    end;
    opTypeOf:
    begin
      Result := EvalExpr(l);
      Result := BuildString(TypeOf(@Result));
    end;

    //Q
    opAdd,opSub,opMul,opDiv,opMod,opDivInt,opBitAnd,opBitOr,opBitXor,
    opBitLeft,opBitRight,opBitRightZero:
    begin
      Result := CalcValue2(P^.Code,EvalExpr(l),EvalExpr(r));
    end;
    // variable = expr
    opAssign:
    begin
      Result := EvalExpr(r);
      //QƃJEg𑝂₷@
      IncRefObject(Result);

      if l^.Code = opVariable then
      begin
        //QƃJEg炷
        if FTables.HasValue(l^.Symbol) then
        begin
          v := FTables[l^.Symbol];
          DecRefObject(v);
        end;

        FTables[l^.Symbol] := Result;   
      end
      else if (l^.Code = opMember) then
      begin
        //oɑ MemberAssignŎQƃJEg炷
        MemberAssign(l,Result);
      end
      else if (l^.Code = opArray) then
      begin
        //zɑ ArrayAssignŎQƃJEg炷
        ArrayAssign(l,Result);
      end;
    end;
    //Z
    opMulAssign,opDivAssign,opAddAssign,opSubAssign,opModAssign,
    opBitLeftAssign,opBitRightAssign,opBitRightZeroAssign,
    opBitAndAssign,opBitXorAssign,opBitOrAssign:
    begin
      Result := AssignValue(P^.Code,EvalExpr(l),EvalExpr(r));
      if l^.Code = opVariable then
        FTables[l^.Symbol] := Result
      else if (l^.Code = opMember) then //oɑ
        MemberAssign(l,Result)
      else if (l^.Code = opArray) then
        ArrayAssign(l,Result);
    end;
    //r
    opLS,opGT,opLSEQ,opGTEQ,opEQ,opNE,opEQEQEQ,opNEEQEQ,
    opLogicalOr,opLogicalAnd:
    begin
      Result := CompareValue(P^.Code,EvalExpr(l),EvalExpr(r));
    end;
    opLogicalNot:
    begin
      Result := CompareValue(P^.Code,EvalExpr(l),v);
    end;
    //R
    opConditional:
    begin
      Result := CalcValue3(opConditional,Evalexpr(l),EvalExpr(r),EvalExpr(t));
    end;

    else begin
      EvalExpr(l);
      EvalExpr(r);
    end;
  end;   
end;

function TJEngine.CallFunction(Root: PJStatement; Symbol: String;
  Param: TJValueList; var RetValue: TJValue): Boolean;
//O̊֐Ăяo
var
  v: TJValue;
begin
  Result := False;
  EmptyValue(RetValue);
  //s̏ꍇI
  if IsRunning then
    Exit;
  //s
  FIsRunning := True;        

  try
    FAbort := False;
    if Assigned(Root) then
      Run(Root)
    else if not FIsRan then
      Exit;

    v := FTables[Symbol];
    //֐s
    if v.ValueType = vtFunction then
    begin
      if Assigned(FOnRun) then
        FOnRun(Self);

      try
        RetValue := CallExpr(v.vFunction^,Param);
        Result := True;
      except
        on E:EJThrow do
          PrintlnError('Exception: ' + E.ExceptName + ' => ' + E.ErrorMsg);
        on E:EJAbort do
          PrintlnError('Abort Script');
      end;

      if Assigned(FOnDone) then
        FOnDone(Self);
    end;
  finally
    FIsRunning := False;
  end;
end;

function TJEngine.CallExpr(Func: TJFunction; Param: TJValueList): TJValue;
//֐Ăяo
var
  paramdecl: PJStatement;
  i,index: Integer;
  args: TJArrayObject;
  oleret: OleVariant;
  dispparams: TDispParams;
  arglist: PVariantArgList;
  currenttablename,funcname: String;
  value: TJValue;
  diput: TDispId;
  dynavalues: TDynaValueArray;
begin
  EmptyValue(Result);
  dynavalues := nil;

  //\
  if Func.FuncType = ftStatement then
  begin
    { TODO : QƃJEg𑝂₷@ }
    for i := 0 to Param.Count - 1 do
    begin
      value := Param[i];
      IncRefObject(value);
    end;

    //O
    currenttablename := FTables.Current;
    if Func.NameSpace <> '' then
      FTables.Current := Func.NameSpace;

    FTables.Push;
    //݂ꍇthisvbV
    if Assigned(Func.This) then
      FTables.PushThis(Func.This)
    else //݂ȂƂ GlobalObject
      FTables.PushThis(FGlobalObject);

    //argumentsɓo^
    args := TJArrayObject.Create(FFactory,Param);
    try
      //QƃJEg
      args.IncRefCount;
      FTables['arguments'] := BuildObject(args);
      //p[^o^
      i := 0;
      paramdecl := Func.Parameter;
      while Assigned(paramdecl) do
      begin
        //ԂɃ[Jϐɓo^
        if (i < Param.Count) and (Assigned(paramdecl^.Expr)) then
          FTables[paramdecl^.Expr^.Symbol] := Param[i];

        paramdecl := paramdecl^.Next;
        Inc(i);
      end;

      try
        EvalStatement(Func.Statement^.Sub2,False);
      except
        on E:EJReturn do
          Result := E.Value;
      end;
    finally
      FTables.PopThis;
{ TODO : QƃJEg炷@֐I }
      args.DecRefCount;
      FTables.DecLocalObjectRefCount;
      FTables.Pop;
      FTables.Current := currenttablename;
    end;
  end
  //Delphi\bh
  else if Func.FuncType = ftMethod then
    Result := Func.Method(Param)
  else if Func.FuncType = ftActiveX then
  begin //ActiveX\bh
{$IFNDEF AX}
    //VarClear(oleret); VarClear̓oOĂ
    VariantInit(oleret);
    //p[^쐬
    if Param.Count > 0 then
      GetMem(arglist,SizeOf(TVariantArg) * Param.Count)
    else
      arglist := nil;

    try
      //tɂ
      index := 0;
      for i := Param.Count - 1 downto 0 do
      begin
        //tagVariantOleVariant͓
        arglist^[index] := TVariantArg(ValueToVariant(Param[i]));
        Inc(Index);
      end;

      dispparams.rgvarg := arglist;
      dispparams.cArgs := Param.Count;
      dispparams.rgdispidNamedArgs := nil;
      dispparams.cNamedArgs := 0;
      //property put̏ꍇ
      if Func.AXMethod.Flag = axfPut then
      begin
        diput := DISPID_PROPERTYPUT;
        dispparams.rgdispidNamedArgs := @diput;
        dispparams.cNamedArgs := 1;
      end;

      //Ăяo
      try
        //\bhĂяõoOVarClearVariantInitɑウƒ
        OleCheck(Func.AXMethod.Parent.Invoke(
          Func.AXMethod.Dispid,
          GUID_NULL,
          GetUserDefaultLCID,
          AXMethodFlagToDisp(Func.AXMethod.Flag),
          dispparams,
          @oleret,nil,nil));

        Result := VariantToValue(oleret,FFactory);
      except
        if Func.This is TJActiveXObject then
          funcname := (Func.This as TJActiveXObject).DispIdToString(Func.AXMethod.Dispid)
        else
          funcname := '';
        //O
        raise EJThrow.Create(E_ACTIVEX,
          AXMethodFlagToString(Func.AXMethod.Flag) + ' error: ' + funcname);
      end;
    finally
      if Assigned(arglist) then
        FreeMem(arglist);   
    end;
{$ENDIF}
  end
  //DLL֐̌Ăяo
  else if Func.FuncType = ftDynaCall then
  begin      
    //SynaValueXg쐬
    dynavalues := ValueListToDynaValueArray(Func.DynaDeclare.Arguments,Param);
    //Ăяo
    Result :=
      DynaResultToValue(
        Func.DynaDeclare.ReturnValue,
        DynaCall(
          MakeCallFlags(Func.DynaDeclare.Call),
          Func.DynaDeclare.Procaddr,
          DynaValueArrayToDynaParmArray(dynavalues),
          nil,
          0
        )
      );
  end
  else
    raise EJThrow.Create(E_CALL,'');

{$IFDEF USE_GC}
  //QƃJEg𑝂₷@Return
  IncRefObject(Result);
  try
    //S~
    if FGarbageCollection then
      FFactory.GarbageCollect;
  finally
    //QƃJEg炷 return
    DecRefObject(Result);
  end;
{$ENDIF}
end;

function TJEngine.MemberExpr(P: PJExpr): TJValue;
//o
//L(ʃIuWFNg) R(ϐj
//member ... object.variable
var
  parent: TJValue;
  l,r: PJExpr;
  obj: TJObject;
  param: TJValueList;
  sym: TJSymbolTable;
begin
  EmptyValue(Result);
  if not Assigned(P) then
    Exit;

  l := P^.Left;
  r := P^.Right;
  //IuWFNg𓾂
  parent := EvalExpr(l);

  if parent.ValueType = vtObject then
  begin
    //thisIuWFNgς c ӖH
    //FTable.PushThis(parent.vObject);
    try
      Result := parent.vObject.GetValue(r^.Symbol,False);
      //֐̏ꍇɂthisZbg
      if IsFunction(@Result) then
        Result.vFunction.This := parent.vObject;
    finally
      //FTable.PopThis;
    end;
  end
  else if IsString(@parent) then //̃vpeB
  begin
    //o
    param := TJValueList.Create;
    try
      param.Add(parent);
      obj := TJStringObject.Create(FFactory,param);
      Result := obj.GetValue(r^.Symbol,False);
      //QƃJEg𑝂₷
      obj.IncRefCount;
    finally
      param.Free;
    end;
  end
  else if not IsNaN(@parent) then //
  begin
    //o
    param := TJValueList.Create;
    try
      param.Add(parent);
      obj := TJNumberObject.Create(FFactory,param);
      Result := obj.GetValue(r^.Symbol,False);
      //QƃJEg𑝂₷
      obj.IncRefCount;
    finally
      param.Free;
    end;
  end
  else if IsBool(@parent) then //bool
  begin
    //o
    param := TJValueList.Create;
    try
      param.Add(parent);
      obj := TJBooleanObject.Create(FFactory,param);
      Result := obj.GetValue(r^.Symbol,False);
      //QƃJEg𑝂₷
      obj.IncRefCount;
    finally
      param.Free;
    end;
  end
  else if IsDispatch(@parent) then
  begin
    //o
    param := TJValueList.Create;
    try
      param.Add(parent);
      obj := TJActiveXObject.Create(FFactory,param);
      Result := obj.GetValue(r^.Symbol,False);
      //QƃJEg𑝂₷
      obj.IncRefCount;
    finally
      param.Free;
    end;
  end
  else if IsFunction(@parent) and (parent.vFunction^.FuncType = ftImport) then
  begin
    //O
    sym := parent.vFunction^.Table as TJSymbolTable;
    Result := sym[r^.Symbol];
    if IsFunction(@Result) and (Result.vFunction^.FuncType = ftStatement) then
    begin
      //֐ɂ͖O
      Result.vFunction.NameSpace := sym.Name;
    end;   
  end
  else
    raise EJThrow.Create(E_NAME,r^.Symbol);
end;

procedure TJEngine.MemberAssign(P: PJExpr; Value: TJValue);
//o֑
//L(ʃIuWFNg) R(ϐj
//member ... object.variable
var
  parent,v: TJValue;
  l,r: PJExpr;
  sym: TJSymbolTable;
  //obj: TJObject;
  //param: TJValueList;
begin
  if not Assigned(P) then
    Exit;

  l := P^.Left;
  r := P^.Right;
  //IuWFNg𓾂
  parent := EvalExpr(l);
  if IsObject(@parent) then
  begin
    //o
    if r^.Code = opVariable then
    begin
      //QƃJEg炷
      if parent.vObject.HasKey(r^.Symbol) then
      begin
        v := parent.vObject.GetValue(r^.Symbol,False);
        DecRefObject(v);
      end;

      parent.vObject.SetValue(r^.Symbol,Value,False);
    end
    else
      raise EJThrow.Create(E_KEY,r^.Symbol);
  end
{ TODO : IuWFNg̎QƂ͕ۗ }
  {else if IsString(@parent) then //̃vpeB
  begin
    //o
    if r^.Code = opVariable then
    begin
      param := TJValueList.Create;
      try
        param.Add(parent);
        obj := FFactory.NewObject('String',param);
        obj.SetValue(r^.Symbol,Value,False);
        //QƃJEg𑝂₷
        obj.IncRefCount;
      finally
        param.Free;
      end;
    end
    else
      raise EJThrow.Create(E_KEY,r^.Symbol);
  end}
  else if IsFunction(@parent) and (parent.vFunction^.FuncType = ftImport) then
  begin
    //O
    sym := parent.vFunction^.Table as TJSymbolTable;
    sym[r^.Symbol] := Value;
  end
  else
    raise EJThrow.Create(E_NAME,r^.Symbol);
end;

procedure TJEngine.ParamExpr(List: TJValueList; Arg: PJExpr);
//֐p[^Zbg
var
  current: PJExpr;
  v: TJValue;
begin
  current := Arg;
  while Assigned(current) do
  begin
    v := EvalExpr(current^.Right);
    List.Insert(0,v);
    //List.Add(EvalExpr(current^.Right));
    current := current^.Left;
  end;
end;

procedure TJEngine.Clear;
//e[uNA
begin
  FTables.Clear;
  FFuncFactory.Clear;
  FFactory.Clear;

  FIsRan := False;
end;

procedure TJEngine.Abort;
begin
  FAbort := True;
end;

procedure TJEngine.FactoryOnNewObject(Sender: TObject;
  JObject: TJObject);
var
  re: TJRegExpObject;
begin
  if JObject is TJRegExpObject then
  begin
    //K\ɍ׍H
    re := TJRegExpObject(JObject);
    re.OnMatchStart := RegExpOnMatchStart;
    re.OnMatchParen := RegExpOnMatch;
    re.OnMatchEnd := RegExpOnMatchEnd;
  end;

  //socket֌Wɍ׍H
  if JObject is TJBaseSocketObject then
  begin
    TJBaseSocketObject(JObject).OnPrint := FGlobalObject.Print;
  end;

  if Assigned(FOnNewObject) then
    FOnNewObject(Self,JObject);
end;

procedure TJEngine.ObjectExpr(Obj: TJObject; Elements: PJExpr);
//L(ϐ)
//R(l)
var
  current: PJExpr;
  //a,b,c,d: TJExpr;
begin
  current := Elements;
  while Assigned(current) do
  begin   
    Obj.SetValue(current^.Right^.Left^.Symbol,EvalExpr(current^.Right^.Right),True);
    current := current^.Left;
  end;
end;

procedure TJEngine.MakeInstance(Obj: TJObject; Members: PJStatement);
//objectɃoZbg
var
  current: PJStatement;
  func: TJFunction;
  v: TJValue;
begin
  //Oo^
  Obj.RegistName(Members^.Expr^.Symbol);
  //super
  //Obj.RegistProperty('super',BuildObject(Obj));
  
  current := Members^.Sub1;
  while Assigned(current) do
  begin
    case current^.SType of
      stFunctionDecl:
      begin
        //֐Zbg
        func.FuncType := ftStatement;
        func.Statement := current;
        //p[^Zbg
        func.Parameter := current^.Sub1;
        //oɓo^
        Obj.RegistProperty(current^.Expr^.Symbol,FFuncFactory.BuildFunction(func));
      end;
      stVarDecl:
      begin
        //oZbg
        if Assigned(current^.Expr^.Left) then
          v := EvalExpr(current^.Expr^.Left)
        else
          v := BuildNull;
{ TODO : QƃJEg𑝂₷@o }
        if IsObject(@v) then
          v.vObject.IncRefCount;

        Obj.RegistProperty(current^.Expr^.Symbol,v)
      end;
    end;
    current := current^.Next;
  end;
end;

function TJEngine.MakeObject(Name: String; Param: TJValueList): TJObject;
var
  v: TJValue;
begin
  //g݃IuWFNgΕԂ
  if FFactory.HasObject(Name) then
  begin
    Result := FFactory._NewObject(Name,Param);
  end
  else if FTables.HasValue(Name) then //[U`邩H
  begin
    v := FTables[Name];
    //tableɓo^Ă
    if IsFunction(@v) and (v.vFunction.FuncType = ftClass) then
    begin
      //super objectꍇobject
      if not Assigned(v.vFunction.Statement^.Expr^.Left) then
      begin
        //ċAŌĂ
        Result := MakeObject('Object',Param);
        //쐬
        MakeInstance(Result,v.vFunction.Statement);
      end
      //
      else begin
        //ċA
        Result := MakeObject(v.vFunction.Statement^.Expr^.Left^.Symbol,Param);
        //쐬
        MakeInstance(Result,v.vFunction.Statement);
      end;
    end
    else
      raise EJThrow.Create(E_NAME,Name);
  end
  else //object̂ŗO
    raise EJThrow.Create(E_NAME,Name);
end;

function TJEngine.NewSymbolTable: TJSymbolTable;
//VV{e[u쐬
begin
  Result := TJSymbolTable.Create(FGlobalObject);
  Result.OnClear := SymbolTableOnClear;
  RegistGlobalObjects(Result);
end;

procedure TJEngine.ImportObject(ObjectName: String;
  ObjectClass: TJObjectClass);
begin
  FFactory.ImportObject(ObjectName,ObjectClass);
  FGlobalFactory.ImportObject(ObjectName,ObjectClass);
end;

procedure TJEngine.RegExpOnMatch(Sender: TObject; Index: Integer;
  var Value: TJValue);
//K\IuWFNgXV
begin
  FRegExpObject.RegistProperty('$' + IntToStr(Index),Value);
  FRegExpObject.RegistProperty('lastParen',Value);
end;

procedure TJEngine.RegExpOnMatchStart(Sender: TObject);
//K\IuWFNgXVJn
begin
  FRegExpObject.ClearMatch;
end;

procedure TJEngine.RegExpOnMatchEnd(Sender: TObject);
//}b`I O[oXV
var
  re: TJRegExpObject;
begin
  re := Sender as TJRegExpObject;
  FRegExpObject.RegistProperty('input',re.GetValue('input',True));
  FRegExpObject.RegistProperty('index',re.GetValue('index',True));
  FRegExpObject.RegistProperty('lastIndex',re.GetValue('lastIndex',True));
  FRegExpObject.RegistProperty('lastMatch',re.GetValue('lastMatch',True));
  FRegExpObject.RegistProperty('leftContext',re.GetValue('leftContext',True));
  FRegExpObject.RegistProperty('rightContext',re.GetValue('rightContext',True));
  FRegExpObject.RegistProperty('lastParen',re.GetValue('lastParen',True));
end;


procedure TJEngine.GlobalObjectOnPrint(Sender: TObject; S: String);
begin
  if Assigned(FOnStdout) then
    FOnStdout(Self,S);
end;

procedure TJEngine.SymbolTableOnClear(Sender: TObject);
begin
  RegistGlobalObjects(Sender as TJSymbolTable);
end;

procedure TJEngine.RegistGlobalObjects(ASymbolTable: TJSymbolTable);
begin
  ASymbolTable.Global['Global'] := BuildObject(FGlobalObject);
  ASymbolTable.Global['String'] := BuildObject(FStringObject);
  ASymbolTable.Global['Number'] := BuildObject(FNumberObject);
  ASymbolTable.Global['RegExp'] := BuildObject(FRegExpObject);
  ASymbolTable.Global['Math'] := BuildObject(FMathObject);
  ASymbolTable.Global['Date'] := BuildObject(FDateObject);
end;

procedure TJEngine.PrintlnError(S: String);
//stderr
begin
  GlobalObjectOnPrintError(Self,S + CRLF);
end;

procedure TJEngine.GlobalObjectOnPrintError(Sender: TObject; S: String);
begin
  if Assigned(FOnStderr) then
    FOnStderr(Self,S);
end;

procedure TJEngine.GarbaseCollect;
begin
  FFactory.GarbageCollect;
end;

procedure TJEngine.AllClear;
//SăNA
begin
  Clear;
  FFactory.Clear;
end;

function TJEngine.IsRunning: Boolean;
//sǂ
begin
  Result := FIsRunning;
end;

function TJEngine.WaitRunning: Boolean;
//ҋ@
var
  tid,aid: DWORD;
begin
  Result := IsRunning;
  //s̏ꍇ
  if Result then
  begin
    //ҋ@
    Sleep(5);
    //sXbh`FbN
    tid := GetCurrentThreadId;
    aid := GetWindowThreadProcessId(Application.Handle,nil);
    //C̏ꍇ̓bZ[W
    if aid = tid then
      Application.ProcessMessages;
  end;
end;

function TJEngine.GetObjectCount: Integer;
begin
  Result := FFactory.ObjectCount;
end;

procedure TJEngine.ArrayAssign(P: PJExpr; Value: TJValue);
//z֑
//L(ʃIuWFNg) R(ϐj
//array  ... object[arguments]
var
  parent: TJValue;
  l,r: PJExpr;
  key: String;
  param: TJValueList;
  v,tmp: TJValue;
begin
  if not Assigned(P) then
    Exit;

  l := P^.Left;
  r := P^.Right;
  //IuWFNg𓾂
  parent := EvalExpr(l);
  if IsObject(@parent) then
  begin
    //RargumentsȂ̂R^.RightōŌ̈𓾂邱Ƃł
    v := EvalExpr(r^.Right);
    key := AsString(@v);

    //QƃJEg炷
    if parent.vObject.HasKey(key) then
    begin
      tmp := parent.vObject.GetValue(key,True);
      DecRefObject(tmp);
    end;
    //Zbg
    parent.vObject.SetValue(key,Value,True);
  end
  else if IsFunction(@parent) and (parent.vFunction^.FuncType = ftActiveX) then
  begin
{$IFNDEF AX}
    //ActiveXvpeBPutĂяo
    param := TJValueList.Create;
    try
      //CfNT
      ParamExpr(param,r);
      //l
      param.Add(Value);
      parent.vFunction.AXMethod.Flag := axfPut;
      CallExpr(parent.vFunction^,param);
    finally
      param.Free;
    end;
{$ENDIF}
  end
  else
    raise EJThrow.Create(E_NAME,r^.Symbol);
end;

function TJEngine.ArrayExpr(P: PJExpr): TJValue;
//z̒l𓾂
//L(ʃIuWFNg) R(ϐj
//array  ... object[arguments]
var
  parent,v: TJValue;
  l,r: PJExpr;
  obj: TJObject;
  param: TJValueList;
begin
  EmptyValue(Result);
  if not Assigned(P) then
    Exit;

  l := P^.Left;
  r := P^.Right;
  //IuWFNg𓾂
  parent := EvalExpr(l);

  if parent.ValueType = vtObject then
  begin
    //thisIuWFNgς c ӖH
    //FTable.PushThis(parent.vObject);
    try
      //z
      //RargumentsȂ̂R^.RightōŌ̈𓾂邱Ƃł
      v := EvalExpr(r^.Right);
      Result := parent.vObject.GetValue(AsString(@v),True);
      //֐̏ꍇɂthisZbg
      if IsFunction(@Result) then
        Result.vFunction.This := parent.vObject;
    finally
      //FTable.PopThis;
    end;
  end
  else if IsString(@parent) then //̃vpeB
  begin
    //z
    param := TJValueList.Create;
    try
      param.Add(parent);
      obj := TJStringObject.Create(FFactory,param);
      v := EvalExpr(r^.Right);
      Result := obj.GetValue(AsString(@v),True);
      //QƃJEg𑝂₷
      obj.IncRefCount;
    finally
      param.Free;
    end;
  end
  else if IsFunction(@parent) and (parent.vFunction^.FuncType = ftActiveX) then
  begin
{$IFNDEF AX}
    //ActiveXvpeBGetĂяo
    param := TJValueList.Create;
    try
      ParamExpr(param,r);
      parent.vFunction.AXMethod.Flag := axfGet;
      Result := CallExpr(parent.vFunction^,param);
    finally
      param.Free;
    end;
{$ENDIF}
  end
  else
    raise EJThrow.Create(E_NAME,r^.Symbol);
end;

end.
