unit ecma_guiobject;

interface

uses
  Windows,Sysutils,Classes,ecma_type,ecma_checklistfrm,ecma_extobject,
  forms;

type
  TJCheckListBox = class(TJObject)
  private
    FItems: TJStringsObject;
    FChecks: array of Boolean;
    FIndex: Integer;
    function GetItemCount: Integer;
    procedure StringsOnChange(Sender: TObject);
  protected
    function DoGetChecked(Param: TJValueList): TJValue;
    function DoSetChecked(Param: TJValueList): TJValue;
    function DoExecute(Param: TJValueList): TJValue;
  public
    constructor Create(AEngine: TJBaseEngine; Param: TJValueList = nil; RegisteringFactory: Boolean = True); override;
    destructor Destroy; override;
  published
    property items: TJStringsObject read FItems;
    property count: Integer read GetItemCount;
    property index: Integer read FIndex;
  end;



procedure RegisterDMS(Engine: TJBaseEngine);


implementation

procedure RegisterDMS(Engine: TJBaseEngine);
begin
  Engine.ImportObject('CheckListBox',TJCheckListBox);
end;


{ TJCheckListBox }

constructor TJCheckListBox.Create(AEngine: TJBaseEngine;
  Param: TJValueList; RegisteringFactory: Boolean);
begin
  inherited;
  RegistName('CheckListBox');
  //\bho^
  RegistMethod('getChecked',DoGetChecked);
  RegistMethod('setChecked',DoSetChecked);
  RegistMethod('execute',DoExecute);
  //
  FItems := TJStringsObject.Create(FEngine,nil,False);
  FItems.IncRef;
  //CxgZbg
  FItems.Strings.OnChange := StringsOnChange;
  
  FIndex := -1;
end;

destructor TJCheckListBox.Destroy;
begin
  FItems.Strings.OnChange := nil;
  FItems.DecRef;
  inherited;
end;

function TJCheckListBox.DoExecute(Param: TJValueList): TJValue;
//s
var
  frm: TfrmCheckList;
  i,idx: Integer;
  lbl,capt: String;
  v: TJValue;
begin
  idx := -1;
  capt := '';
  lbl := '';
  //labelcaption
  if IsParam1(Param) then
    for i := 0 to Param.Count - 1 do
    begin
      v := Param[i];
      case i of
        0: capt := AsString(@v);
        1: lbl := AsString(@v);
        2: idx := AsInteger(@v);
      end;
    end;

{$IFNDEF CONSOLE}
  frm := TfrmCheckList.Create(Application.MainForm);
{$ELSE}
  frm := TfrmCheckList.Create(nil);
{$ENDIF}
  try
    frm.Caption := capt;
    frm.lblText.Caption := lbl;

    //Zbg
    frm.lbCheck.Items.Assign(FItems.Strings);
    frm.lbCheck.ItemIndex := idx;
    for i := 0 to Length(FChecks) - 1 do
      frm.lbCheck.Checked[i] := FChecks[i];

    if frm.ShowModal = IDOK then
    begin
      Result := BuildBool(True);
      //߂
      for i := 0 to frm.lbCheck.Items.Count - 1 do
        FChecks[i] := frm.lbCheck.Checked[i];
    end
    else
      Result := BuildBool(False);
    //Iڂ𔽉f
    FIndex := frm.lbCheck.ItemIndex;
  finally
    //frm.Release;
    frm.Free;
  end;
end;

function TJCheckListBox.DoGetChecked(Param: TJValueList): TJValue;
var
  v: TJValue;
  index: Integer;
begin
  if IsParam1(Param) then
  begin
    v := Param[0];
    index := AsInteger(@v);
    try
      Result := BuildBool(FChecks[index]);
    except
      raise EJThrow.Create(E_INDEX,'CheckListBox.getChecked Index Error');
    end;
  end
  else
    Result := BuildBool(False);
end;

function TJCheckListBox.DoSetChecked(Param: TJValueList): TJValue;
var
  v: TJValue;
  index: Integer;
begin
  Result := BuildObject(Self);
  if IsParam2(Param) then
  begin
    v := Param[0];
    index := AsInteger(@v);
    v := Param[1];
    try
      FChecks[index] := AsBool(@v);
    except
      raise EJThrow.Create(E_INDEX,'CheckListBox.setChecked Index Error');
    end;
  end;
end;

function TJCheckListBox.GetItemCount: Integer;
begin
  Result := FItems.Strings.Count;
end;

procedure TJCheckListBox.StringsOnChange(Sender: TObject);
begin
  //booleanzZbg
  SetLength(FChecks,FItems.Strings.Count);
end;

end.
