unit ecma_dynacall;

interface

uses
  Windows,Sysutils,Classes,ecma_type,dynamiccall,hashtable;

type
  //dynacall
  TJDynaCall = class(TJObject)
  private
    FModules: TIntegerHashtable;
    procedure HashtableOnFreeItem(Sender: TObject; P: PHashItem);
    function ValueListToMessageParams(const Param: TJValueList;
      var hWnd: HWND; var Msg: Cardinal; var wParam,lParam: Integer): Boolean;
    function DoSendMessage(Param: TJValueList): TJValue;
    function DoPostMessage(Param: TJValueList): TJValue;
    function DoMoveMemory(Param: TJValueList): TJValue;
    function DoFillMemory(Param: TJValueList): TJValue;
  protected
    function DoRegister(Param: TJValueList): TJValue;
    function ValueToMessageParam(P: PJValue): Integer;
    procedure RegistMethods; override;
  public
    constructor Create(AEngine: TJBaseEngine; Param: TJValueList = nil;
      RegisteringFactory: Boolean = True); override;
    destructor Destroy; override;
  end;

  TStructMemberType = (smtCharArray,
                       smtChar,
                       smtShort,smtLong,smtInt64,smtBool,
                       smtString,smtWideString,
                       smtFloat,smtDouble,
                       smtIDispatch,smtIUnknown);

  TStructMember = record
    mName: string;
    mType: TStructMemberType;
    mSize: Integer;
    mPos: Integer;
    _string: string;
    _widestring: WideString;
    //_idispatch: IDispatch;
    //_iunknown: IUnknown;
  end;

  TStructMemberArray = array of TStructMember;

  TJStruct = class(TJObject)
  private
    FStruct: string;
    FMembers: TStructMemberArray;

    function DoClear(Param: TJValueList): TJValue;
    function DoDefine(Param: TJValueList): TJValue;
    function DoSizeOf(Param: TJValueList): TJValue;
    function DoToString(Param: TJValueList): TJValue;
  protected
    function GetMemberIndex(const S: string; ArrayStyle: Boolean): Integer;
    function GetMemberValue(Index: Integer): TJValue;
    procedure SetMemberValue(Index: Integer; Value: TJValue);
    procedure RegistMethods; override;
  public
    constructor Create(AEngine: TJBaseEngine; Param: TJValueList = nil;
      RegisteringFactory: Boolean = True); override;
    destructor Destroy; override;
    function GetValue(S: String; ArrayStyle: Boolean; Param: TJValueList = nil): TJValue; override;
    procedure SetValue(S: String; Value: TJValue; ArrayStyle: Boolean; Param: TJValueList = nil); override;
    function ToString(Value: PJValue = nil): string; override;

    procedure Clear; override;
    procedure Define(Param: TJValueList);

    function GetItem(Index: Integer): TJValue; override;
    function GetCount: Integer; override;
    class function IsArray: Boolean; override;
    class function IsMakeGlobalInstance: Boolean; override;
  published
    property length: Integer read GetCount;
  end;

function IsStructObject(P: PJValue): Boolean;

procedure RegisterDMS(Engine: TJBaseEngine);


implementation

procedure RegisterDMS(Engine: TJBaseEngine);
begin
  Engine.ImportObject('DynaCall',TJDynaCall);
  Engine.ImportObject('Struct',TJStruct);
end;

function IsStructObject(P: PJValue): Boolean;
begin
  Result := IsObject(P) and (P^.vObject is TJStruct);
end;


{ TJDynaCall }

constructor TJDynaCall.Create(AEngine: TJBaseEngine;
  Param: TJValueList; RegisteringFactory: Boolean);
begin
  inherited;
  FModules := TIntegerHashtable.Create(13,True);
  FModules.OnFreeItem := HashtableOnFreeItem;

  RegistName('DynaCall');
end;

destructor TJDynaCall.Destroy;
begin
  FModules.Clear;
  FreeAndNil(FModules);
  inherited;
end;

function TJDynaCall.DoRegister(Param: TJValueList): TJValue;
//֐o^
var
  f: IJFunction;
  s1,s2,s3,lib,func: String;
  i: Integer;
  v: TJValue;
  module: HModule;
begin
  Result := BuildObject(Self);
  s1 := '';
  s2 := '';
  s3 := '';
  lib := '';
  func := '';

  if IsParam1(Param) then
  begin
    for i := 0 to Param.Count - 1 do
    begin
      v := Param[i];
      case i of
        0: lib := AsString(@v);
        1: func := AsString(@v);
        2: s1 := LowerCase(AsString(@v));
        3: s2 := LowerCase(AsString(@v));
        4: s3 := LowerCase(AsString(@v));
      end;
    end;

    //֐ȂΓo^
    if (func <> '') and (lib <> '') then
    begin
      EmptyFunction(f);
      f.Symbol := func;
      f.FuncType := ftDynaCall;
      f.vDynaCall^ := ParseDynaDeclare([s1,s2,s3]);

      //DLL`FbN
      if FModules.HasKey(lib) then
      begin
        //݂
        module := FModules[lib];
        //֐ǂݍ
        f.vDynaCall.ProcAddr := SearchProcAddress(module,func);
        //sO
        if not Assigned(f.vDynaCall.ProcAddr) then
          raise EJThrow.Create(E_DLL,func);
      end
      else begin
        //DLLǂݍ
        module := LoadLibrary(PChar(lib));
        //sƗO
        if module = 0 then
          raise EJThrow.Create(E_DLL,lib);

        f.vDynaCall.ProcAddr := SearchProcAddress(module,func);
        //sDLLėO
        if not Assigned(f.vDynaCall.ProcAddr) then
        begin
          FreeLibrary(module);
          raise EJThrow.Create(E_DLL,func);
        end
        else //DLLnbVɓ
          FModules[lib] := module
      end;

      inherited SetValue(func,BuildFunction(f),False);
    end
    else //O
      raise EJThrow.Create(E_DLL,'register error: ' + lib + ' ' + func);
  end
  else
    raise EJThrow.Create(E_DLL,'register error: ' + lib + ' ' + func);
end;

function TJDynaCall.ValueToMessageParam(P: PJValue): Integer;
// ValuewParam/lParamɕϊ
begin
  // ̏ꍇ̓|C^Ԃ
  if IsString(P) or IsStructObject(P) then
    Result := Integer(PChar(AsString(P)))
  else
    Result := AsInteger(P);
end;

function TJDynaCall.ValueListToMessageParams(const Param: TJValueList;
  var hWnd: HWND; var Msg: Cardinal; var wParam,lParam: Integer): Boolean;
// TJValueListSendMessagẽp[^𓾂
var
  v: TJValue;
  i: Integer;
begin
  hWnd := 0;
  Msg := 0;
  wParam := 0;
  lParam := 0;

  if IsParam2(Param) then
  begin
    for i := 0 to Param.Count - 1 do
    begin
      v := Param[i];
      case i of
        0: hWnd := AsInteger(@v);
        1: Msg := AsInteger(@v);
        2: wParam := ValueToMessageParam(@v);
        3: lParam := ValueToMessageParam(@v);
      else
        Break;
      end;
    end;
    Result := True;
  end
  else
    Result := False;
end;

function TJDynaCall.DoSendMessage(Param: TJValueList): TJValue;
// SendMessageA()
var
  h: HWND;
  m: Cardinal;
  w,l: Integer;
begin
  if ValueListToMessageParams(Param,h,m,w,l) then
    Result := BuildInteger(SendMessage(h,m,w,l))
  else
    Result := BuildInteger(0);
end;

function TJDynaCall.DoPostMessage(Param: TJValueList): TJValue;
// PostMessageA()
var
  h: HWND;
  m: Cardinal;
  w,l: Integer;
begin
  if ValueListToMessageParams(Param,h,m,w,l) then
    Result := BuildBool(PostMessage(h,m,w,l))
  else
    Result := BuildBool(False);
end;

//჌x֐
function TJDynaCall.DoMoveMemory(Param: TJValueList): TJValue;
// MoveMemory
var
  v: TJValue;
  dest,source: Pointer;
  len: DWORD;
begin
  EmptyValue(Result);

  if IsParam3(Param) then
  begin
    v := Param[0];
    dest := Pointer(ValueToMessageParam(@v));
    v := Param[1];
    source := Pointer(ValueToMessageParam(@v));
    v := Param[2];
    len := AsInteger(@v);

    Move(source^,dest^,len);
  end;
end;

function TJDynaCall.DoFillMemory(Param: TJValueList): TJValue;
// FillMemory
var
  v: TJValue;
  dest: Pointer;
  len: DWORD;
  fill: Char;
begin
  EmptyValue(Result);

  if IsParam2(Param) then
  begin
    v := Param[0];
    dest := Pointer(ValueToMessageParam(@v));
    v := Param[1];
    len := AsInteger(@v);

    if IsParam3(Param) then
    begin
      v := Param[2];
      fill := AsChar(@v);
    end
    else
      fill := #0; //ȗZeroMemory

    FillChar(dest^,len,fill);
  end;
end;


procedure TJDynaCall.HashtableOnFreeItem(Sender: TObject; P: PHashItem);
//DLL
begin
  FreeLibrary(P^.vInteger);
end;

procedure TJDynaCall.RegistMethods;
begin
  inherited;
  RegistMethod('register',DoRegister);
  RegistMethod('sendMessage',DoSendMessage);
  RegistMethod('postMessage',DoPostMessage);
  RegistMethod('copyMemory',DoMoveMemory);
  RegistMethod('moveMemory',DoMoveMemory);
  RegistMethod('fillMemory',DoFillMemory);
end;


{ TJStruct }

procedure TJStruct.Clear;
begin
  inherited;
  System.SetLength(FMembers,0);
  System.SetLength(FStruct,0);
end;

procedure TJStruct.Define(Param: TJValueList);
// \̂̒`
var
  v: TJValue;
  s: string;
  len,p,i: Integer;
begin
  if IsParam1(Param) then
  begin
    Clear;

    len := 0;
    SetLength(FMembers,Param.Count);

    for i := 0 to Param.Count - 1 do with FMembers[i] do
    begin
      v := Param[i];
      s := AsString(@v);
      p := AnsiPos(':',s);
      // : ΃o擾
      if p > 0 then
        mName := Trim(Copy(s,1,p - 1))
      else
        mName := '';
      //oȗƂ __index oƂ
      if mName = '' then
        mName := '__' + IntToStr(i);

      s := LowerCase(Trim(Copy(s,p + 1,MaxInt)));
      //^ȗƂ͗O
      if s = '' then
        raise EJThrow.Create(E_STRUCT,'need member type');

      mSize := StrToIntDef(s,0);
      if mSize > 0 then
        //lɕϊ\̂Ƃ͕z
        mType := smtCharArray
      //lɕϊłȂƂ͈ꕶڂŔf
      else begin
        case s[1] of
          'c':
          begin
            mType := smtChar;
            mSize := SizeOf(Char);
          end;
          't':
          begin
            mType := smtShort;
            mSize := SizeOf(Smallint);
          end;
          'l','p','h','u':
          begin
            mType := smtLong;
            mSize := SizeOf(Longint);
          end;
          'b':
          begin
            mType := smtBool;
            mSize := SizeOf(Longint);
          end;
          'i':
          begin
            mType := smtInt64;
            mSize := SizeOf(Int64);
          end;
          's':
          begin
            mType := smtString;
            mSize := SizeOf(PChar);
          end;
          'w':
          begin
            mType := smtWideString;
            mSize := SizeOf(PWideChar);
          end;
          'f':
          begin
            mType := smtFloat;
            mSize := SizeOf(Single);
          end;
          'd':
          begin
            mType := smtDouble;
            mSize := SizeOf(Double);
          end;
          {'a':
          begin
            mType := smtIDispatch;
            mSize := SizeOf(IDispatch);
          end;
          'k':
          begin
            mType := smtIUnknown;
            mSize := SizeOf(IUnknown);
          end;}
        else
          //Ă͂܂Ȃꍇ͗O
          raise EJThrow.Create(E_STRUCT,'member type error');
        end;//case
      end;//if

      mPos := len + 1; //1x[X̃ItZbg
      Inc(len,mSize);  //^̕\̂̃TCYg
      //vpeBƂēo^
      EmptyValue(v);
      RegistProperty(mName,v);
    end;//with(for)

    //\̃TCYm
    SetLength(FStruct,len);
    FillChar(FStruct[1],len,0); //0ŏ
  end
  else
    raise EJThrow.Create(E_STRUCT,'need member type');
end;


constructor TJStruct.Create(AEngine: TJBaseEngine; Param: TJValueList;
  RegisteringFactory: Boolean);
begin
  inherited;
  RegistName('Struct');

  //ȗɗOoȂ悤ɂ
  if IsParam1(Param) then
    Define(Param);
end;

destructor TJStruct.Destroy;
begin
  Clear;
  inherited;
end;

function TJStruct.DoClear(Param: TJValueList): TJValue;
begin
  Result := BuildObject(Self);
  Clear;
end;

function TJStruct.DoDefine(Param: TJValueList): TJValue;
begin
  Result := BuildObject(Self);
  Define(Param);
end;

function TJStruct.DoSizeOf(Param: TJValueList): TJValue;
//\̃TCY擾
begin
  Result := BuildInteger(System.Length(FStruct));
end;

function TJStruct.DoToString(Param: TJValueList): TJValue;
//\̂̏()
var
  i: Integer;
  s,t: string;
  v: TJValue;
begin
  s := '';

  for i := 0 to System.Length(FMembers) - 1 do
  begin
    case FMembers[i].mType of
      smtCharArray:
        t := 'char[' + IntToStr(FMembers[i].mSize) + ']';
      smtChar:
        t := 'char';
      smtShort:
        t := 'short';
      smtLong:
        t := 'long';
      smtBool:
        t := 'bool';
      smtInt64:
        t := 'int64';
      smtFloat:
        t := 'float';
      smtDouble:
        t := 'double';
      smtWideString:
        t := 'widestring';
      smtString:
        if GetValueImpl(FMembers[i].mName,v) and IsStructObject(@v) then
          t := 'struct'
        else
          t := 'string';
      smtIDispatch:
        t := 'idispatch';
      smtIUnknown:
        t := 'iunknown';
    else
      t := '';
    end;
    s := s + Format('%s : %s (%d)'#13#10,[FMembers[i].mName,t,FMembers[i].mSize]);
  end;

  s := s + StringOfChar('-',24) + Format(#13#10'%dmembers / %dbytes',
                                    [System.Length(FMembers),System.Length(FStruct)]);
  Result := BuildString(s);
end;


function TJStruct.GetMemberIndex(const S: string; ArrayStyle: Boolean): Integer;
// oIndex擾
var
  len,i: Integer;
begin
  Result := -1;

  len := System.Length(FMembers);
  if ArrayStyle then
  begin
    try
      i := StrToInt(S);
      if i < 0 then
        Inc(i,len);
      if (i >= 0) and (i < len) then
        Result := i;
    except
      Result := GetMemberIndex(S,False);
    end;
  end
  else begin
    for i := 0 to len - 1 do
      if S = FMembers[i].mName then
      begin
        Result := i;
        Break;
      end;
  end;
end;

function TJStruct.GetMemberValue(Index: Integer): TJValue;
// o̎(w)l擾
var
  p: Pointer;
  v: TJValue;
begin
  p := @FStruct[FMembers[Index].mPos];
  case FMembers[Index].mType of
    smtCharArray:
      Result := BuildString(PChar(p));
    smtChar:
      Result := BuildInteger(Ord(PChar(p)^));
    smtShort:
      Result := BuildInteger(PSmallint(p)^);
    smtLong:
      Result := BuildInteger(PLongint(p)^);
    smtBool:
      Result := BuildBool(PLongint(p)^ <> 0);
    smtInt64:
      Result := BuildDouble(PInt64(p)^);
    smtFloat:
      Result := BuildDouble(PSingle(p)^);
    smtDouble:
      Result := BuildDouble(PDouble(p)^);
    smtWideString:
      Result := BuildString(PPWideChar(p)^);
    smtString:
      //StructIuWFNgȂIuWFNgԂ
      if GetValueImpl(FMembers[Index].mName,v) and IsStructObject(@v) then
        Result := v
      else
        Result := BuildString(PPChar(p)^);
    {smtIDispatch:
      Result := BuildDispatch(FMembers[Index]._idispatch);
    smtIUnknown:
      Result := BuildDispatch(IDispatch(FMembers[Index]._iunknown));}
  else
    raise EJThrow.Create(E_STRUCT,'member type error');
  end;
end;

function TJStruct.GetValue(S: String; ArrayStyle: Boolean; Param: TJValueList): TJValue;
var
  i: Integer;
begin
  i := GetMemberIndex(S,ArrayStyle);
  if i < 0 then
    Result := inherited GetValue(S,ArrayStyle)
  else
    Result := GetMemberValue(i);
end;

procedure TJStruct.SetMemberValue(Index: Integer; Value: TJValue);
var
  tmp: string;
  c: Char;
  t: Smallint;
  l: Longint;
  i: Int64;
  s: PChar;
  w: PWideChar;
  f: Single;
  d: Double;
begin
  with FMembers[Index] do
  begin
    case mType of
      smtCharArray:
      begin
        if IsNull(@Value) or IsUndefined(@Value) then
          tmp := #0
        else
          tmp := AsString(@Value) + #0;

        if System.Length(tmp) > mSize then
          tmp := Copy(tmp,1,mSize - 1) + #0;

        Move(tmp[1],FStruct[mPos],System.Length(tmp));
      end;
      smtChar:
      begin
        c := AsChar(@Value);
        Move(c,FStruct[mPos],SizeOf(c));
      end;
      smtShort:
      begin
        t := Smallint(AsInteger(@Value));
        Move(t,FStruct[mPos],SizeOf(t));
      end;
      smtLong,smtBool:
      begin
        l := Longint(AsInteger(@Value));
        Move(l,FStruct[mPos],SizeOf(l));
      end;
      smtInt64:
      begin
        i := Round(AsDouble(@Value));
        Move(i,FStruct[mPos],SizeOf(i));
      end;
      smtString:
      begin
        _string := AsString(@Value);
        if IsNull(@Value) or IsUndefined(@Value) then
          s := nil
        else
          s := PChar(_string);
        Move(s,FStruct[mPos],SizeOf(s));
      end;
      smtWideString:
      begin
        _widestring := AsString(@Value);
        if IsNull(@Value) or IsUndefined(@Value) then
          w := nil
        else
          w := PWideChar(_widestring);
        Move(w,FStruct[mPos],SizeOf(w));
      end;
      smtFloat:
      begin
        f := AsSingle(@Value);
        Move(f,FStruct[mPos],SizeOf(f));
      end;
      smtDouble:
      begin
        d := AsDouble(@Value);
        Move(d,FStruct[mPos],SizeOf(d));
      end;
      {smtIDispatch:
      begin
        _idispatch := AsDispatch(@Value);
        Move(_idispatch,FStruct[mPos],SizeOf(IDispatch));
      end;
      smtIUnknown:
      begin
        _iunknown := IUnknown(AsDispatch(@Value));
        Move(_iunknown,FStruct[mPos],SizeOf(IUnknown));
      end;}
    else
      raise EJThrow.Create(E_STRUCT,'member type error');
    end;//case

    //IuWFNg̃oɂf
    if not SetValueImpl(mName,Value) then
      raise EJThrow.Create(E_STRUCT,'member not found');
  end;
end;

procedure TJStruct.SetValue(S: String; Value: TJValue; ArrayStyle: Boolean;
  Param: TJValueList);
var
  i: Integer;
begin
  i := GetMemberIndex(S,ArrayStyle);
  if i < 0 then
    inherited
  else
    SetMemberValue(i,Value);
end;

function TJStruct.ToString(Value: PJValue): string;
//\̂𕶎ƂĕԂ
begin
  Result := FStruct;
end;

function TJStruct.GetItem(Index: Integer): TJValue;
begin
  Result := GetMemberValue(Index);
end;

function TJStruct.GetCount: Integer;
begin
  Result := System.Length(FMembers);
end;

class function TJStruct.IsArray: Boolean;
begin
  Result := True;
end;

class function TJStruct.IsMakeGlobalInstance: Boolean;
begin
  Result := False;
end;

procedure TJStruct.RegistMethods;
begin
  inherited;
  RegistMethod('clear',DoClear);
  RegistMethod('define',DoDefine);
  RegistMethod('sizeOf',DoSizeOf);
  RegistMethod('toString',DoToString);
end;


end.
