
/*!
@file dkcBuffer.c
@auther d
@since 2004/3/xx
*/

#include "dkcBuffer.h"
#include "dkcStdio.h"


///obt@̈𓾂B
DKC_BUFFER* WINAPI dkcAllocBuffer(const void *data,size_t size){
	DKC_BUFFER *p;
	
	if(0==size) return NULL;

	p = dkcAllocate(sizeof(DKC_BUFFER));
	if(NULL==p) return NULL;
	

	p->mBuff = dkcAllocate(size);
	if(NULL==p->mBuff) goto Error;
	
	p->mSize = size;

	if(data){
		if(DKUTIL_FAILED(dkcBufferSet(p,data,size))){
			goto Error;
		}
	}else{
		
	}
	return p;
Error:
	dkcFree(&p);
	return NULL;
}

int WINAPI dkcFreeBuffer(DKC_BUFFER **ptr){
	if(NULL==ptr || NULL==*ptr) return edk_ArgumentException;
	dkcFree(&(*ptr)->mBuff);
	dkcFree(ptr);
	return edk_SUCCEEDED;
}



int WINAPI dkcBufferSet(DKC_BUFFER *ptr,const void *data,size_t size)
{
	//if(NULL==ptr) return edk_ArgumentException;//

	return dkc_memcpy(ptr->mBuff,ptr->mSize,data,size);
}
/*!

*/
int WINAPI dkcBufferGet(DKC_BUFFER *ptr,void *data,size_t size){
	//if(NULL==ptr) return edk_ArgumentException;//fast
	return dkc_memcpy(data,size,ptr->mBuff,ptr->mSize);
}

int WINAPI dkcBufferResize(DKC_BUFFER *ptr,size_t size)
{
	void *NewPtr;
	if(NULL==ptr || 0==size || NULL==ptr->mBuff) return edk_ArgumentException;
	if(DKUTIL_FAILED(dkcReallocate(&NewPtr,size,&ptr->mBuff))){
		return edk_FAILED;
	}

	ptr->mBuff = NewPtr;
	ptr->mSize = size;

	return edk_SUCCEEDED;
}



DKC_BUFFER* WINAPI dkcAllocBufferCopy(const DKC_BUFFER *ptr){
	dkcmNOT_ASSERT(NULL==ptr || NULL==ptr->mBuff);

	return dkcAllocBuffer(ptr->mBuff,ptr->mSize);
}
