/******************************************************************************
 *
 * Copyright (c) 2001	TOSHIYUKI ARAI. ALL RIGHTS RESERVED. 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 *  
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *	IconButton.cpp
 *
 *****************************************************************************/


#include <sol\ApplicationView.h>
#include <sol\IconButton.h>
#include "resource.h"


class MainView :public ApplicationView {
    IconButton iconButton;
    
    // Callback function to handle WM_COMMAND message.
    void  quit(Action& action) {
            // Call exit method of View to terminate this program. 
            exit(action);
    }

  public:
    // Constructor
    MainView(Application& applet, const char* name, Args& args)
        :ApplicationView(applet, name, args) 
    {
        Args ar;
		ar.set(XmNx, 10);
		ar.set(XmNy, 10);
		ar.set(XmNwidth, 32);
		ar.set(XmNheight,  32);
        ar.set(XmNxImageSize, 32);
        ar.set(XmNyImageSize, 32);
	
        ar.set(XmNimageName, IDI_ICON1);
        // Create a window of IconButton
        iconButton.create(this, "", ar);
        //add(iconButton);
        // Register the method quit of this class to the iconButton.
        // SOL++2000 frame work will call automatically the registered method
        // quit to the iconButton whenever it is pushed! 
        iconButton.addCallback(XmNactivateCallback, this, 
			(Callback)&MainView::quit, null); 
    }
};

// Program Entry Point.
void    Main(int argc, char** argv)
{
    const char* name = "MainView";
    // Create an instance of Application.
    Application applet(name, argc, argv);

    Args args;
    // Create an instance of HelloWorld.
    MainView mainv(applet, name, args);

    // Realize or show the buttonSample.
    mainv.realize();

    // Enter SOL++ event handling loop.
    applet.run();
}
