/******************************************************************************
 *
 * Copyright (c) 2001	TOSHIYUKI ARAI. ALL RIGHTS RESERVED. 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 *  
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *	ComboBox.cpp
 *
 *****************************************************************************/


#include <sol\ApplicationView.h>
#include <sol\ComboBox.h>

class MainView :public ApplicationView {
    ComboBox    drives;
    
    // Callback function to handle WM_COMMAND/CBN_SELCHANGE message.
    void  selChanged(Action& action) {
            // Do something
    }

    // Build a list of logical dirves into the drives.
    void buildDriveList()
    {
        char path[10];
        DWORD d = ::GetLogicalDrives();
        for(int i = 0; i<26; i++) {
            if(d & 1) {
                sprintf(path, "%c:", 'A'+i);
                drives.addString(path);
            }
            d = d >> 1;
        }
    }

  public:
    // Constructor
    MainView(Application& applet, const char* name, Args& args)
        :ApplicationView(applet, name, args) 
    {
        Args ar;
        ar.set(XmNwidth, 120);
        ar.set(XmNstyle, (ulong)CBS_DROPDOWNLIST);
        // Create a window of ComboBox
        drives.create(this, "", ar);
        buildDriveList();

        // Register the method selChanged of this class to the drives.
        drives.addCallback(XmNselChangeCallback, this, 
                            (Callback)&MainView::selChanged, null); 
    }
};

// Program Entry Point.
void    Main(int argc, char** argv)
{
    const char* name = "MainView";
    // Create an instance of Application.
    Application applet(name, argc, argv);

    Args args;
    // Create an instance of HelloWorld.
    MainView mainv(applet, name, args);

    // Realize or show the buttonSample.
    mainv.realize();

    // Enter SOL++ event handling loop.
    applet.run();
}
