/******************************************************************************
 *
 * Copyright (c) 1999	TOSHIYUKI ARAI. ALL RIGHTS RESERVED. 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 *  
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *	WideCharString.cpp
 *
 *****************************************************************************/

// SOL++2000

#include <sol\WideCharString.h>


UINT WideCharString::getLength(const wchar_t* string)
{
	UINT len = 0;
	if(string) {
		len = wcslen(string);
	}
	return len;
}


WideCharString::WideCharString(const wchar_t* string) 
	:WideCharArray(getLength(string)) 
{
	copy(0, string, getSize());
}


void WideCharString::append(const wchar_t* string) 
{
	int size = getSize();
    int len  = getLength(string);
    expand(len);
    copy(size, string, len);
}


wchar_t*  WideCharString::getString() 
{
	UINT size = getSize();
    wchar_t* temp = new wchar_t[size+1];
	if(temp) {
		wchar_t* ptr = getContents();
		for(UINT i = 0; i<size; i++) {
       		*(temp+i) = *(ptr+i);
		}
		*(temp+size) = NULL;
	}
    return temp;
}

