/******************************************************************************
 *
 * Copyright (c) 1999	TOSHIYUKI ARAI. ALL RIGHTS RESERVED. 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 *  
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *	URL.h
 *
 *****************************************************************************/

// SOL++2000

#include <sol\StringBuffer.h>

#include <sol\URL.h>


URL::URL(char* string)
:port(80)
{
	StringBuffer strBuffer;
	strBuffer.append(string);

	const char* ptr = strBuffer.getBuffer();

	// get protocol
	char* p = (char*) strstr(ptr, "://");
	if (p) { 	
		*p = Zero;
		protocol = ptr;
		ptr = p + 3;
	
		p = (char*)strstr(ptr, ":");
		if (p) {
			*p = Zero;
			host = ptr;
			char* por = ++p;
			char* sla = strstr(por, "/");
			if (sla) {
				*sla = Zero;
				path = ++sla;
			}
			port = atoi(por);
		} else {
			// no port
			port = 80;
		
			// get path
			p = (char*)strstr(ptr, "/");
			if (p) {
				*p = Zero;
				path = ++p;											
			}
			host = ptr;
		}
	}
}


const char* URL::getFileName()
{
	const char* host = getHost();
	const char* path = getPath();

	if (*host =='/') {
		host++;
	}

	//2001/03/11
	char buffer[1024];
	//

	if (strlen(host)) {
		sprintf(buffer, "%s:/%s", host, path);
	} else {
		sprintf(buffer, "%s", path);
	}
	int len = strlen(buffer);

	// 2001/03/11 
	//Checking a url parameter.
	char* q = strstr(buffer, "?");
	if (q) {
		*q = Zero;
	}
	//

	char* ptr = buffer;
	for (int i = 0; i<len; i++) {
		if (*ptr == '|') *ptr = ':';
		if (*ptr == '/') *ptr = '\\';
		ptr++;
	}
	fileName = buffer;

	return (const char*)fileName;
}

