/******************************************************************************
 *
 * Copyright (c) 1999	TOSHIYUKI ARAI. ALL RIGHTS RESERVED. 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 *  
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *	TreeView.cpp
 *
 *****************************************************************************/

// SOL++2000

#include <sol\TreeView.h>


TreeView::TreeView(View* parent, const char* name, Args& args)
	:Primitive(parent, name, 	
			args.set(XmNstyle, (ulong)(WS_TABSTOP|WS_BORDER))
			    .set(XmNpredefined, TRUE)
			    .set(XmNclassName, (ulong)WC_TREEVIEW))
{
	setValues(args);	//<added date="2000.02.13"/>
}



Boolean TreeView::create(View* parent, const char* name, Args& args)
{
	Boolean rc = Primitive::create(parent, name, 	
			args.set(XmNstyle, (ulong)(WS_TABSTOP|WS_BORDER))
			    .set(XmNpredefined, TRUE)
			    .set(XmNclassName, (ulong)WC_TREEVIEW));

	setValues(args);	
	return rc;
}

Arg* TreeView::getCallbackTable(int* num)
{
	static Arg table[] = {
	
	{XmNselChangingCallback,	TVN_SELCHANGING},
	{XmNselChangedCallback,		TVN_SELCHANGED},
 	{XmNgetDispInfoCallback,	TVN_GETDISPINFO},
	{XmNsetDispInfoCallback,	TVN_SETDISPINFO},
	{XmNitemExpandingCallback,	TVN_ITEMEXPANDING},
	{XmNitemExpandedCallback,	TVN_ITEMEXPANDED},

	{XmNbeginDragCallback,		TVN_BEGINDRAG},
	{XmNbeginRDragCallback,		TVN_BEGINRDRAG},
	{XmNdeleteItemCallback,		TVN_DELETEITEM},
 	{XmNbeginLabelEditCallback, TVN_BEGINLABELEDIT},
	{XmNendLabelEditCallback,	TVN_ENDLABELEDIT},
	{XmNkeyDownCallback,		TVN_KEYDOWN},
	};

	*num = XtNumber(table);
	return table; 
}

HTREEITEM TreeView::addItem(HTREEITEM parent, HTREEITEM after, TreeItem* treeItem)
{
	return addItem(parent, after, treeItem->text, 
				treeItem->imageId, treeItem->selImageId);

}
							
HTREEITEM TreeView::addItem(HTREEITEM parent, HTREEITEM after, char* text)
{
	TV_ITEM item;
	TV_INSERTSTRUCT insertStruct;
	memset(&item, 0, sizeof(TV_ITEM));
	memset(&insertStruct, 0, sizeof(TV_INSERTSTRUCT));
	item.mask = TVIF_TEXT;
	item.pszText = text;
	insertStruct.item = item;
	insertStruct.hInsertAfter = after;
	insertStruct.hParent = parent;
	return insertItem(&insertStruct);
}

HTREEITEM TreeView::addItem(HTREEITEM parent, HTREEITEM after, char* text, 
							int imageId, int selImageId)
{
	TV_ITEM item;
	memset(&item, 0, sizeof(TV_ITEM));
	item.mask       = TVIF_TEXT|TVIF_IMAGE|TVIF_SELECTEDIMAGE;
	item.pszText    = text;
	item.cchTextMax = strlen(text);
	item.iImage     = imageId;
	item.iSelectedImage = selImageId;

	TV_INSERTSTRUCT insertStruct;
	memset(&insertStruct, 0, sizeof(TV_INSERTSTRUCT));
	insertStruct.item = item;
	insertStruct.hInsertAfter = after;
	insertStruct.hParent = parent;
	return insertItem(&insertStruct);
}


void TreeView::expandChildren(HTREEITEM hItem, int flag)
{	
	if(hItem) {
		expand(hItem, flag);

		HTREEITEM child = getChild(hItem);
		while(child) {
			HTREEITEM sibling = getNextSibling(child);		
			expandChildren(child, flag);
			child = sibling;
		}
	}
}


void TreeView::sortAllChildren(HTREEITEM hItem)
{
	if(hItem) {
		sortChildren(hItem, 0);

		HTREEITEM child = getChild(hItem);
		while(child) {
			HTREEITEM sibling = getNextSibling(child);		
			sortAllChildren(child);
			child = sibling;
		}
	}
}
