/******************************************************************************
 *
 * Copyright (c) 1999	TOSHIYUKI ARAI. ALL RIGHTS RESERVED. 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 *  
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *	ToolBar.cpp
 *
 *****************************************************************************/

// SOL++2000

#include <sol\ToolBar.h>


TBBUTTON ToolBar::buttons[] =	{

{STD_FILENEW,  STD_FILENEW,  TBSTATE_ENABLED, TBSTYLE_BUTTON, 
		0,0, 0, 0},
{STD_FILEOPEN, STD_FILEOPEN, TBSTATE_ENABLED, TBSTYLE_BUTTON, 
		0,0,   0, 1},
{STD_FILESAVE, STD_FILESAVE, TBSTATE_ENABLED, TBSTYLE_BUTTON, 
		0,0,  0, 2},
{STD_PRINTPRE, STD_PRINTPRE,TBSTATE_ENABLED, TBSTYLE_BUTTON, 
		0,0, 0, 3},
{STD_PRINT,   STD_PRINT,TBSTATE_ENABLED, TBSTYLE_BUTTON, 
		0,0, 0, 4},
{ 0,	FALSE,   FALSE,           TBSTYLE_SEP,    
		0,0, 0,0},
{STD_CUT, STD_CUT,  TBSTATE_ENABLED, TBSTYLE_BUTTON, 
		0,0, 0, 5},
{STD_COPY, STD_COPY, TBSTATE_ENABLED, TBSTYLE_BUTTON, 
		0,0, 0, 6},
{STD_PASTE,	STD_PASTE,TBSTATE_ENABLED, TBSTYLE_BUTTON, 
		0,0, 0, 7},
{STD_UNDO, STD_UNDO,TBSTATE_ENABLED, TBSTYLE_BUTTON, 
		0,0,0, 8},
{STD_REDOW, STD_REDOW,TBSTATE_ENABLED, TBSTYLE_BUTTON, 
		0,0,0,9},
{STD_DELETE, STD_DELETE,TBSTATE_ENABLED, TBSTYLE_BUTTON, 
		0,0, 0,10},
{STD_FIND, STD_FIND,TBSTATE_ENABLED, TBSTYLE_BUTTON, 
		0,0,0,11},
{STD_REPLACE, STD_REPLACE,TBSTATE_ENABLED, TBSTYLE_BUTTON, 
		0,0,0,12},
{STD_PROPERTIES, STD_PROPERTIES,TBSTATE_ENABLED, TBSTYLE_BUTTON, 
		0,0,0,13},
{ 0,	FALSE,   FALSE,           TBSTYLE_SEP,    
		0,0,0, 0},
{STD_HELP, STD_HELP,TBSTATE_ENABLED, TBSTYLE_BUTTON, 
		0,0,0,14},
};


ToolBar::ToolBar(View* parent, const char* name, Args& args)
	:Primitive(parent, name,
			args.set(XmNpredefined, TRUE)
			    .set(XmNstyle, TBSTYLE_TOOLTIPS)
			    .set(XmNclassName, (ulong)TOOLBARCLASSNAME))
{
	send(TB_BUTTONSTRUCTSIZE, sizeof(TBBUTTON), 0);

	setValues(args);
}


Boolean ToolBar::create(View* parent, const char* name, Args& args)
{
	Boolean rc = Primitive::create(parent, name,
			args.set(XmNpredefined, TRUE)
			    .set(XmNstyle, TBSTYLE_TOOLTIPS)
			    .set(XmNclassName, (ulong)TOOLBARCLASSNAME));

	send(TB_BUTTONSTRUCTSIZE, sizeof(TBBUTTON), 0);

	setValues(args);

	return rc;
}


void ToolBar::setValues(Args& args)
{
//	Primitive::setValues(args);
	ulong val = args.get(XmNtoolBarBitmapID);
	TBADDBITMAP addbmp;	
	memset(&addbmp, 0, sizeof(TBADDBITMAP));

	if(val == IDB_STD_SMALL_COLOR || val ==IDB_STD_LARGE_COLOR) {
		addbmp.hInst = HINST_COMMCTRL;
		addbmp.nID   = (int)val;
		send(TB_ADDBITMAP, XtNumber(buttons)-2, (LPARAM)&addbmp);
		send(TB_ADDBUTTONS, XtNumber(buttons), (LPARAM)buttons);
	}
	else if(val) {
		addbmp.hInst = getInstanceHandle();
		ulong num = args.get(XmNnumBitmaps);
		addbmp.nID   = (int)val;	//val should be a bitmaphandle.
		send(TB_ADDBITMAP, num, (LPARAM)&addbmp);
	}
}


Arg* ToolBar::getCallbackTable(int* num)
{
	static Arg table[] = {
	{XmNgetButtonInfoCallback,	TBN_GETBUTTONINFO},
	{XmNbeginDragCallback,		TBN_BEGINDRAG},
	{XmNendDragCallback,		TBN_ENDDRAG},
	{XmNbeginAdjustCallback,	TBN_BEGINADJUST},
	{XmNendAdjustCallback,		TBN_ENDADJUST},
	{XmNresetCallback,			TBN_RESET},
	{XmNqueryInsertCallback,	TBN_QUERYINSERT},
	{XmNqueryDeleteCallback,	TBN_QUERYDELETE},
	{XmNtoolbarChangeCallback,	TBN_TOOLBARCHANGE},
	{XmNcustHelpCallback,		TBN_CUSTHELP},
	};
 
 	*num = XtNumber(table);
	return table;
}

int ToolBar::getHeight()
{
	RECT r;
	getWindowRect(&r);
	return r.bottom - r.top;
}

