/******************************************************************************
 *
 * Copyright (c) 1999	TOSHIYUKI ARAI. ALL RIGHTS RESERVED. 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 *  
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *	Thread.cpp
 *
 *****************************************************************************/

// SOL++2000

// 1999.09.24
#include <process.h>

#include <sol\Thread.h>
#include <sol\stdio.h>
#include <sol\InvalidHandleException.h>

typedef unsigned (__stdcall *LPTHREAD_PROC)(void*);

// default starting procedure

// This procedure starts when resume() or start() has been called
DWORD WINAPI Thread::procedure(DWORD dword) 
{
	Thread* thread = (Thread*)dword;
	if(thread) {
		// SOL++2000
		thread -> run();
	}
	return True;
}



Thread::Thread(DWORD stack,  void* param) 
{
	this -> param = param;
	// Create a suspended thread.
	DWORD flags = CREATE_SUSPENDED;

	handle = (HANDLE)_beginthreadex((void*)NULL, (unsigned)stack, 
				(LPTHREAD_PROC)Thread::procedure,
				(void*)this, flags, (unsigned*)&threadId);

/*	handle = ::CreateThread(NULL, stack, 
				(LPTHREAD_START_ROUTINE)Thread::procedure,
				(void*)this, flags, &threadId);
*/
  if(handle == NULL || handle == INVALID_HANDLE_VALUE) {
	  handle = NULL;
		throw InvalidHandleException("Failed to create a thread",
			GetLastError());
	}
}


void Thread::kill()
{
	if(handle) {
		close();
		DWORD id;
		while(getExitCode(&id)) {
			if(id == STILL_ACTIVE)
				continue;
			else
				break;
		}
	}
	handle = NULL;
}


// 1999.09.24
void Thread::exit(DWORD exitCode) 
{
	//::ExitThread(exitCode);
	_endthreadex(exitCode);
}
