/******************************************************************************
 *
 * Copyright (c) 1999	TOSHIYUKI ARAI. ALL RIGHTS RESERVED. 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 *  
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *	StringTokenizer.h
 *
 *****************************************************************************/

// SOL++2000

#ifndef _SOL_ANALYZER
#include <sol\Analyzer.h>
#endif
#ifndef _SOL_STRING
#include <sol\String.h>
#endif
#ifndef _SOL_STRINGBUFFER
#include <sol\StringBuffer.h>
#endif

#ifndef _SOL_STRINGTOKENIZER
#define _SOL_STRINGTOKENIZER

class StringTokenizer :public Analyzer {
	const char*	string;
	int  	num;
	char 	separator[5];
  protected:
	int	isSeparator(char x);
  public:
	StringTokenizer();
	StringTokenizer(const char* string);
	// 1999.08.07
	StringTokenizer(StringBuffer& buffer);
	StringTokenizer(String&  string);

	int 	addSeparator(char x);
	void 	clearSeparator();

	// 1999.08.07
	const char* getToken(String& token);
	const char* getToken(StringBuffer& token);

	const char*	getToken(char* token, int size);
	boolean	hasMoreToken();

	const char* getInteger(const char* line, int* value);
	const char*	getToken(const char* line, char* token, int size);
	int   	hexStringToInt(const char* word);
};

#endif

