/******************************************************************************
 *
 * Copyright (c) 1999	TOSHIYUKI ARAI. ALL RIGHTS RESERVED. 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 *  
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *	StringList.h
 *
 *****************************************************************************/

// SOL++2000
// 1999.09.03 Added two add method to take a reference or pointer to String.
// 1999.09.04 Added two add method to take a feference or pointer to StringList.

#ifndef _SOL_LINKEDLIST
#include <sol\LinkedList.h>
#endif
#ifndef _SOL_STRING
#include <sol\String.h>
#endif

#ifndef _SOL_STRINGLIST
#define _SOL_STRINGLIST

class StringList :public LinkedList {
  public:
	StringList() { }
	// 1999.09.03
	Boolean add(const String& string) {
			return LinkedList::addLast(new String(string));
	}
	// 1999.09.03
	Boolean add(const String* string) {
			return LinkedList::addLast(new String(string));
	}

	Boolean	add(const char* string) {
			return LinkedList::addLast(new String(string));   		
	}
	Boolean	addLast(const char* string) {
			return LinkedList::addLast(new String(string));   
	}
	Boolean	addFirst(const char* string) {
			return LinkedList::addFirst(new String(string));   
	}

	// 1999.09.04
	Boolean add(const StringList& list);
	// 1999.09.04
	Boolean add(const StringList* list);

	String*	getNth(int n) {
			return (String*)LinkedList::getNth(n);
	}
};

#endif

