/******************************************************************************
 *
 * Copyright (c) 1999	TOSHIYUKI ARAI. ALL RIGHTS RESERVED. 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 *  
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *	StringBuffer.cpp
 *
 *****************************************************************************/

// SOL++2000
// 2000/11/11

#include <sol\StringBuffer.h>

StringBuffer::StringBuffer(int s, int inc) 
	:size(s), increment(inc), buffer(null),
	position(0)
{ 
	buffer = new char[size+1];
	memset(buffer, 0, size+1);
}

StringBuffer::~StringBuffer()
{
	delete [] buffer;
}

void StringBuffer::clear()
{
	position = 0;
	delete [] buffer;
	size = 256; // 1999.07.26
	buffer = new char[size+1];
	memset(buffer, 0, size+1);
}


Boolean StringBuffer::append(char ch)
{	
	if (position >=size) {
		size += increment;
		char* temp = new char[size+1];
		if (temp == null) {
			return False;
		}
		memset(temp, 0, size+1);
		memcpy(temp, buffer, position);
		delete [] buffer;
		buffer = temp;
	}

	*(buffer+position) = ch;
	position++;
	*(buffer+position) = Zero;

	return True;
}


Boolean StringBuffer::append(const char* string)
{
	Boolean rc = True;
	if (string) {
		int len = strlen(string);
		for (int i = 0; i<len; i++) {
			rc = append(*string++);
		}
	}
	return rc;
}


//<added date="2000/11/10">
Boolean StringBuffer::append(int num)
{
	char integer[80];
	sprintf(integer, "%d", num);
	return append(integer);
}


Boolean StringBuffer::append(float num)
{
	char integer[80];
	sprintf(integer, "%f", num);
	return append(integer);
}


Boolean StringBuffer::append(String& string)
{
	return append((const char*)string);
}


String* StringBuffer::newString() 
{
	return new String(buffer);
}
//<added>


const char* StringBuffer::find(const char* string)
{
	const char* ptr = null;
	if (buffer && string) {
		ptr = strstr(buffer, string);
	}
	return string;
}
