/******************************************************************************
 *
 * Copyright (c) 1999	TOSHIYUKI ARAI. ALL RIGHTS RESERVED. 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 *  
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *	Static.cpp
 *
 *****************************************************************************/

// SOL++2000

#include <sol\Static.h>


Static::Static(View* parent, const char* name, Args& args)
	:Primitive(parent, name, 
			args.set(XmNpredefined, TRUE)
			    .set(XmNclassName, "Static"))
{
	ulong val;
	if (args.get(XmNwidth, &val)  == FALSE ||
	    args.get(XmNheight, &val) == FALSE) {
		const char*   label = name;
		if (args.get(XmNlabelString, &val))
			label = (char*)val;
		resize(label);
	}
}


Boolean Static::create(View* parent, const char* name, Args& args)
{
	Boolean rc = Primitive::create(parent, name, 
			args.set(XmNpredefined, TRUE)
			    .set(XmNclassName, "Static"));

	ulong val;
	if (args.get(XmNwidth, &val)  == FALSE ||
	    args.get(XmNheight, &val) == FALSE) {
		const char*   label = name;
		if (args.get(XmNlabelString, &val))
			label = (char*)val;
		resize(label);
	}
	return rc;
}

// 1999.08.13
void Static::getPreferredSize(Dimension& d)
{
	char label[256];
	label[0] = Zero;
	getText(label, sizeof(label));
	resize(label);
	int w, h;
	getSize(w, h);
	d.set(w, h);
}

