/******************************************************************************
 *
 * Copyright (c) 2000	TOSHIYUKI ARAI. ALL RIGHTS RESERVED. 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 *  
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *	TextSheet.cpp
 *
 *****************************************************************************/



#include "TextSheet.h"
#include <sol\PaintDC.h>
#include <sol\ClientDC.h>


TextSheet::TextSheet(View* parent, const char* label,  Args& args)
	:Primitive(parent, label, 
		args.set(XmNstyle, (ulong)WS_BORDER)
		    .set(XmNexStyle, (ulong)WS_EX_CLIENTEDGE))
{
	pos = 0;
	charWidth = 13;
	addEventHandler(WM_PAINT, this, (Handler)&TextSheet::paint, NULL);
}



Boolean TextSheet::create(View* parent, const char* label,  Args& args)
{
	Boolean rc = Primitive::create(parent, label, 
		args.set(XmNstyle, (ulong)WS_BORDER)
		    .set(XmNexStyle, (ulong)WS_EX_CLIENTEDGE));

	pos = 0;
	charWidth = 13;
	addEventHandler(WM_PAINT, this, (Handler)&TextSheet::paint, NULL);

	return rc;
}


void TextSheet::clear()
{
	pos = 0;

	for(int i = 0; i< size; i++) {
		buffer[i] = ' ';
	}
	update(NULL);
}


void TextSheet::putChar(int n, char ch)
{
    char buf[2];
	ClientDC cdc(this);

	if(n >= 0 && n<size) {
		pos++;
		buffer[n] = ch;
		sprintf(buf, "%c", ch);
		HFONT prev = cdc.select(getFont());
		cdc.textOut(10+n*charWidth, 4, buf, 1);
		cdc.select(prev);
	}
}


long TextSheet::paint(Event& event)
{
	char buf[2];
	PaintDC pdc(this);

	HFONT prev = pdc.select(getFont());

	for(int i = 0; i< pos; i++) {
		sprintf(buf,"%c", buffer[i]);
		pdc.textOut(10+i*charWidth, 4, buf, 1);
	}
	pdc.select(prev);

	return 1;
}


void TextSheet::setBuffer(char* buf, int len)
{
	buffer = buf;
	size = len;
}

