/******************************************************************************
 *
 * Copyright (c) 1999	TOSHIYUKI ARAI. ALL RIGHTS RESERVED. 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 *  
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *	Timer.cpp
 *
 *****************************************************************************/

// SOL++2000
// 2000.02.18

#include <sol\ApplicationView.h>
#include <sol\Font.h>
#include <sol\PaintDC.h>
#include <time.h>


class AppView :public ApplicationView {
	Font	      font;
	char	string[100];

	long	paint(Event& event) {
		time_t ntime;
		time(&ntime);
		sprintf(string,"%s", ctime(&ntime));
		string[strlen(string)-1] = Zero;
		PaintDC pdc(this);
		HFONT prev = (HFONT)pdc.select(&font);
		pdc.textOut(10, 10, string, strlen(string));
		pdc.select(prev);
		return 0;
	}

	long	timeout(Event& event) {
		invalidate((RECT*)null);
		return 0;
	}

  public:
	AppView(Application& applet, const char* name, Args& args) 
		:ApplicationView(applet, name, args)
	{
		Args ar;
		ar.set(XmNheight, (-12)*2);
		ar.set(XmNweight, (ulong) FW_BOLD);
		//ar.set(XmNfaceName, "Courier");
		font.create(ar);
		
		addEventHandler(WM_TIMER, this, (Handler)&AppView::timeout, null);
		addEventHandler(WM_PAINT, this, (Handler)&AppView::paint, null);
		
		setTimer(1, 1000, null);
	}

	~AppView() { 
		killTimer(1);
	}
};


void	Main(int argc, char** argv)
{
	const char* name = "Timer";
	Application applet(name, argc, argv);
	Args args;
	args.set(XmNwidth, 400);
	args.set(XmNheight, 80);
	AppView appView(applet, name, args);
	appView.realize();
	applet.run();
}
