/******************************************************************************
 *
 * Copyright (c) 1999	TOSHIYUKI ARAI. ALL RIGHTS RESERVED. 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 *  
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *	SplitPane.cpp
 *
 *****************************************************************************/

// SOL++2000
// 1999.09.23 Modified
// 2000.02.18


#include <sol\ApplicationView.h>
#include <sol\ScrolledText.h>
#include <sol\SplitPane.h>
#include <sol\FileListBox.h>

#define	ID_EXIT		11


class MainView :public ApplicationView {
	FileListBox  listbox;
	ScrolledText scrollt;
	SplitPane  panedw;
	void	select(Action& action);
  public:
	MainView(Application& appelt, const char* name, Args& args);
};


MainView::MainView(Application& applet, const char* name, Args& args)
	:ApplicationView(applet, name, args)
{
	Args ar;
	ar.set(XmNdirection, SplitPane::HORIZONTAL);
	panedw.create(this, "", ar);
	// 1999.09.23 
	add(panedw);

	ar.reset();
	ar.set(XmNstyle, (ulong)WS_BORDER|LBS_NOINTEGRALHEIGHT);
	listbox.create(&panedw, "", ar);

	char dir[128];
	::GetWindowsDirectory(dir, sizeof(dir));
	listbox.setup(dir, "*.ini",
				(ulong)DDL_READWRITE|DDL_READONLY|DDL_HIDDEN |\
				DDL_SYSTEM|DDL_ARCHIVE|DDL_DIRECTORY);

	listbox.addCallback(XmNselChangeCallback, this, 
		(Callback)&MainView::select, NULL);
	panedw.add(&listbox);

	ar.reset();
	ar.set(XmNstyle, (ulong)WS_BORDER);
	scrollt.create(&panedw, "", ar);
	panedw.add(&scrollt);
	addCallback(XmNmenuCallback, ID_EXIT,  this, 
		(Callback)&MainView::exit, NULL);

//	panedw -> setSashPosition(200);
}



void MainView::select(Action& action)
{
	// Got a selchange notification.
	char path[128];
	listbox.getPathName(path);
	scrollt.load(path);
}


// Sample Main
void	Main(int argc, char** argv)
{
	const char* appClass = "MultiPane";
	Application applet(appClass, argc, argv);

	Args args;
	MainView sample(applet, appClass, args);
	sample.realize();

	applet.run();
}

