/******************************************************************************
 *
 * Copyright (c) 1999	TOSHIYUKI ARAI. ALL RIGHTS RESERVED. 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 *  
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *	SolWebServer.h
 *
 *****************************************************************************/

// SOL++2000 Sample
// 1999.08.25 Updated.

#ifndef _SOL_APPLICATIONVIEW
#include <sol\ApplicationView.h>
#endif

#ifndef _SOL_SCROLLEDRICHTEXT
#include <sol\ScrolledRichText.h>
#endif
#ifndef _SOL_STATIC
#include <sol\Static.h>
#endif
#ifndef _SOL_FONT
#include <sol\Font.h>
#endif
#ifndef _SOL_THREAD
#include <sol\Thread.h>
#endif

#ifndef _SOL_FOLDERTREEDIALOG
#include <sol\FolderTreeDialog.h>
#endif

#ifndef _SOL_SOCKETSTREAM
#include <sol\SocketStream.h>
#endif

#ifndef _SOL_CRITICALSECTION
#include <sol\CriticalSection.h>
#endif

#ifndef _SOL_PROFILE
#include <sol\Profile.h>
#endif

#ifndef _SOL_STRING
#include <sol\String.h>
#endif

#ifndef _SOL_CONFIGDIALOG
#include "ConfigDialog.h"
#endif

#ifndef _SOL_FONT
#include <sol\Font.h>
#endif

#ifndef _SOL_SOLWEBSERVER
#define _SOL_SOLWEBSERVER

class HTTPCommunicator;

class SolWebServer :public ApplicationView {
	String				version;
	Font*				font;
    class HTTPListener*	thread;
	int					sizeArray[3];
	ScrolledRichText*	text;

	String			    docRoot;
	unsigned short		port;
	String				cgiRoot;

	Profile*			profile;
	ConfigDialog*		configDialog;
	void	start(Action& action);
	void	stop(Action& action);
	void	setup(Action& action);
	void	updateConfiguration(Action& action);
    void    clear(Action& action);
    void    terminate(Action& action);
	void	setProfile(const char* file);
	long	close(Event& event);
	long	size(Event& event);
public:
	SolWebServer(Application& applet, const char* name, Args& args);
	~SolWebServer();
    void    append(const char* string);
	void	printf(const char* format,...);

	unsigned short  getPort() { return port; }
	String&		getDocumentRoot() { return docRoot; }
	String&		getCGIRoot() { return cgiRoot; }
	const char*	getVersion() { return (const char*)version; }
};

#endif
