/******************************************************************************
 *
 * Copyright (c) 1999	TOSHIYUKI ARAI. ALL RIGHTS RESERVED. 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 *  
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *	HTTPCommunicator.h
 *
 *****************************************************************************/


#ifndef _SOL_THREAD
#include <sol\Thread.h>
#endif

#ifndef _SOL_STRINGBUFFER
#include <sol\StringBuffer.h>
#endif

#ifndef _SOL_SOLWEBSERVER
#include "SolWebServer.h"
#endif


#ifndef _SOL_HTTPCOMMUNICATOR
#define _SOL_HTTPCOMMUNICATOR


class HTTPCommunicator :public Thread {
	Boolean		  fileSendLoop;
	String		  docRoot;
	String		  cgiRoot;

    SocketStream* socket;
    StringBuffer  buffer;
    SolWebServer* webServer;
    Boolean		  sendResponse(const char* path);
	const char*	  getContentType(const char* path);
	// 1999.08.21 Added sendHeader method.
	Boolean		  sendHeader(const char* path);
public:
    HTTPCommunicator(SocketStream* sock, SolWebServer* viewer);
	~HTTPCommunicator();
    void	run();
	void	shutdown();
};

#endif
