/******************************************************************************
 *
 * Copyright (c) 1999	TOSHIYUKI ARAI. ALL RIGHTS RESERVED. 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 *  
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *	ConfigDialog.h
 *
 *****************************************************************************/


#ifndef _SOL_POPUPVIEW
#include <sol\PopupView.h>
#endif
#ifndef _SOL_STATIC
#include <sol\Static.h>
#endif
#ifndef _SOL_TEXTFIELD
#include <sol\TextField.h>
#endif

#ifndef _SOL_PUSHBUTTON
#include <sol\PushButton.h>
#endif
#ifndef _SOL_FONT
#include <sol\Font.h>
#endif

#ifndef _SOL_CONFIGDIALOG
#define _SOL_CONFIGDIALOG

class ConfigDialog :public PopupView {
	Static*		server;
	Static*		domain;
	Static*		address;

	Font*		font;
	TextField*	serverField;
	TextField*	domainField;
	TextField*	addressField;

	PushButton*	  ok;
	PushButton*	  cancel;

	long	size(Event& event);
public:
	ConfigDialog(View* parent, const char* label, Args& args);
	~ConfigDialog();
	void	setServer(const char* string) { serverField -> setText(string); }
	void	setUser(const char* string) { domainField -> setText(string); }
	void	setAddress(const char* string) { addressField -> setText(string); }

	void	getServer(char* buffer, int size) { 
		serverField ->getText(buffer, size); 
	}
	void	getUser(char* buffer, int size) {
			domainField ->getText(buffer, size);
	}
	void	getAddress(char* buffer, int size) {
			addressField ->getText(buffer, size);
	}
	
	void	addOkCallback(View* view, Callback callback);
};

#endif
