/******************************************************************************
 *
 * Copyright (c) 1999	TOSHIYUKI ARAI. ALL RIGHTS RESERVED. 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 *  
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *	ConfigDialog.cpp
 *
 *****************************************************************************/


#include "ConfigDialog.h"
#include <sol\ClientDC.h>


ConfigDialog::ConfigDialog(View* parent, const char* label, Args& args)
	:PopupView(parent, label, args)
{
	Args ar;
	ar.set(XmNheight, (-12));
	font = new Font(ar);
	
	ar.reset();
	server = new Static(this, "Server", ar);
	server -> setFont(font);


	ar.reset();
	serverField = new TextField(this, "", ar);
	serverField -> setFont(font);
	serverField -> limitText(256);

	ar.reset();
	domain = new Static(this, "Domain", ar);
	domain -> setFont(font);

	ar.reset();
	domainField = new TextField(this, "", ar);
	domainField -> setFont(font);

	ar.reset();
	address = new Static(this, "Sender-Email", ar);
	address -> setFont(font);

	ar.reset();
	addressField = new TextField(this, "", ar);
	addressField -> setFont(font);

	ar.reset();
	ar.set(XmNid, IDOK);
	ok  = new PushButton(this, "OK", ar);
	ok -> setFont(font);

	ar.reset();
	ar.set(XmNid, IDCANCEL);
	cancel = new PushButton(this, "Cancel", ar);
	cancel -> setFont(font);
	cancel -> addCallback(XmNactivateCallback, this, 
				(Callback)&ConfigDialog::popdown, NULL);
	resize();
}


ConfigDialog::~ConfigDialog()
{
	delete server;
	delete domain;
	delete address;
	delete font;
	delete serverField;
	delete domainField;
	delete addressField;

	delete ok;
	delete cancel;
}

long ConfigDialog::size(Event& event)
{
	int w, h;
	event.getSize(w, h);

	ClientDC cdc(this);
	HFONT prev = cdc.select(font);
	int h1 = cdc.getTextHeight() * 7/4;
	int fh = cdc.getTextHeight() + 8;
	cdc.select(prev);

	int w1 = (w - 40)/3;
	int ww, hh;
	address -> getSize(ww, hh);

	server -> reshape(10, 10, ww, fh);
	serverField  -> reshape(ww, 10, w-ww-10, fh);

	domain -> reshape(10, 10+h1+10, ww, fh);
	domainField -> reshape(ww, 10+h1+10, w-ww-10, fh);

	address -> reshape(10, 10+(h1+10)*2, ww, fh);
	addressField -> reshape(ww, 10+(h1+10)*2, w-ww-10, fh);

	ok     -> reshape(20, h-h1-10, w1, h1);
	cancel -> reshape(20+w1*2, h-h1-10, w1, h1);

	update(NULL);

	return NULL;
}

void ConfigDialog::addOkCallback(View* view, Callback callback)
{
	ok -> addCallback(XmNactivateCallback, view,
			callback, null);
}
