/******************************************************************************
 *
 * Copyright (c) 2000	TOSHIYUKI ARAI. ALL RIGHTS RESERVED. 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 *  
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *	ReplaceDialog.cpp
 *
 *****************************************************************************/

// Sample program to use ReplaceDialog class of SOL++2000.
// 2000.02.18

#include <sol\ApplicationView.h>
#include <sol\ScrolledText.h>
#include <sol\ReplaceDialog.h>
#include <sol\FileDialog.h>
#include "Resource.h"
#include <sol\Stdio.h>


class TextEditor :public ApplicationView {
	UINT		findMsg;
	ScrolledText	text;
	FileDialog	fileDialog;
	ReplaceDialog	replaceDialog;
	long	search(Event& event);

	void	replace(Action& action);
	void	open(Action& action);
  public:
	TextEditor(Application& applet, const char* name, Args& args);
};



long TextEditor::search(Event& event) 
{
	Args ar;
	char* find = null;
	char* replace = null;
	ulong  flags;
	ar.set(XmNflags, (void*)&flags);
	ar.set(XmNfindString, (char**)&find);
	ar.set(XmNreplaceString, (char**)&replace);
	replaceDialog.getValues(ar);

	if (flags & FR_DIALOGTERM) { // Cancel button
		Printf("closing\r\n");
		return 0L;
	}

	if (flags & FR_FINDNEXT) { // find next
		Printf("find next\r\n");
	}

	if (flags & FR_REPLACE) { // replace and find next
		Printf("replace and find next\r\n");
	}

	if (flags & FR_REPLACEALL) { // replace all
		Printf("replace all\r\n");
	}

	Printf("findString    = %s\r\n", (char*)find);
	Printf("replaceString = %s\r\n", (char*)replace);

	return 0L;
}


void TextEditor::replace(Action& action)
{
	if(!replaceDialog.isWindow()) {
		// Popup the replaceDialog
		replaceDialog.replace("", "");
	}
}


TextEditor::TextEditor(Application& applet, const char* name, Args& args)
	:ApplicationView(applet, name, args) 
{
	Args ar;
	ar.set(XmNnoHideSel, True);
	text.create(this, "", ar);
	add(text);

	findMsg = RegisterWindowMessage(FINDMSGSTRING);

	ar.reset();
	replaceDialog.create(this, NULL, ar);

	ar.reset();
	fileDialog.create(this, NULL, ar);

	addCallback(XmNmenuCallback, ID_OPEN, this,
		(Callback)&TextEditor::open, NULL);
	addCallback(XmNmenuCallback, ID_REPLACE, this,
		(Callback)&TextEditor::replace, NULL);

	addCallback(XmNmenuCallback, ID_EXIT, this,
		(Callback)&TextEditor::exit, NULL);

	addEventHandler(findMsg, this,
		(Handler)&TextEditor::search, NULL);
}


void TextEditor::open(Action& action)
{
	if(fileDialog.open()) {
		char* name = fileDialog.getFileName();
		text.load(name);
	}
}


// Sample Main
void	Main(int argc, char** argv)
{
	const char* appClass = "TextEditor";
	Application applet(appClass, argc, argv);

	Args args;
	TextEditor editor(applet, appClass, args);
	editor.realize();

	applet.run();
}

