/******************************************************************************
 *
 * Copyright (c) 1999	TOSHIYUKI ARAI. ALL RIGHTS RESERVED. 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 *  
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *	ProgramList.cpp
 *
 *****************************************************************************/

// SOL++2000
// 2000.02.18


#include <sol\ApplicationView.h>
#include <sol\ListBox.h>


class ProgramList :public ApplicationView {
	ListBox listbox;
	void	exec(Action& action);
  public:
	ProgramList(Application& applet, const char* name, Args& args);
};


void ProgramList::exec(Action& action)
{
	char buff[256];
	listbox.getCurText(buff);
	::WinExec(buff, SW_SHOWNORMAL);
}

ProgramList::ProgramList(Application& applet, const char* name, Args& args)
	:ApplicationView(applet, name, args)
{
	Args ar;
	ar.set(XmNstyle, (ulong)WS_VSCROLL|LBS_SORT|LBS_NOINTEGRALHEIGHT);
	listbox.create(this, "", ar);
	add(listbox);

	char buffer[256];
	::GetWindowsDirectory(buffer, sizeof(buffer));
	strcat(buffer, "\\*.EXE");

	// List up all executable files in the Windows directory.
	listbox.findFiles(buffer);

	// Add callback exec to run a selected program.
	listbox.addCallback(XmNdefaultActionCallback, this,
		(Callback)&ProgramList::exec,  NULL);
}

void	Main(int argc, char** argv)
{
	const char* name = "ProgramList";
	Application applet(name, argc, argv);
	Args args;
	ProgramList programList(applet, name, args);
	programList.realize();
	applet.run();
}

