/******************************************************************************
 *
 * Copyright (c) 2000	TOSHIYUKI ARAI. ALL RIGHTS RESERVED. 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer.
 *  
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *	ProcessList.cpp
 *
 *****************************************************************************/


// SOL++2000

#include <sol\ApplicationView.h>
#include <sol\ListView.h>
#include <sol\Profile.h>
#include <sol\Font.h>
#include <sol\Stdio.h>
#include <sol\StringList.h>

#include <sol\ProcessInfo.h>
#include <sol\ProcessList.h>


class ProcessListView :public ApplicationView {
	Profile		profile;
	Font		font;
	ListView	listView;
	ProcessList	plist;

	long	close(Event& event);
	void	listUp();

  public:
	ProcessListView(Application& applet, const char* name, Args& args);

};


ProcessListView::ProcessListView(Application& applet, const char* name, Args& args)
	:ApplicationView(applet, name, args)
{
	Args ar;

	int fontSize = -14;
	if(GetSystemMetrics(SM_CXSCREEN) <= 1024 &&
			   GetSystemMetrics(SM_CYSCREEN) <= 768) {
		fontSize = -12;
	}
	ar.reset();
	ar.set(XmNheight, fontSize);
//	ar.set(XmNfaceName, "COURIER");
	font.create(ar);

	ar.reset();
	ar.set(XmNexStyle, (ulong)WS_EX_CLIENTEDGE);
	ar.set(XmNstyle, (ulong)LVS_REPORT);
	listView.create(this, "", ar);

	listView.setFont(&font);

	StringList list;
	list.add(new String("Process                  "));
	list.add(new String("PID             "));
	listView.setColumn(&list);

	// Add sctext to the default layout manager.
	add(listView);

	addEventHandler(WM_CLOSE, this, (Handler)&ProcessListView::close, NULL);

	restorePlacement();

	listUp();
}


long ProcessListView::close(Event& event)
{
	savePlacement();
	return defaultProc(event);
}


void ProcessListView::listUp() 
{
	plist.listUp();


	ListEntry* ptr = plist.getEntry();
	while (ptr) {
		ProcessInfo* info = (ProcessInfo*)ptr->getObject();
		int n = 0;
		if (info) {
				char id[80];
				sprintf(id, "%08X", info->getProcessId());

				StringList list;
				list.add(new String(info->getName()));
				list.add(new String(id));
				listView.insertLine(n, &list);
				n++;
		}
		ptr = ptr ->getNext();
	}
		
}


// ProcessListView Main
void	Main(int argc, char** argv)
{
	const char* appClass = "ProcessListView";
	Application applet(appClass, argc, argv);
		
	Args args;
	args.set(XmNclassName, appClass);
	ProcessListView listView(applet, appClass, args);
	listView.realize();
	applet.run();
}
